/*------------------------------------------------------------------------------*
 * File Name: CustomColumnFilterDlg.cpp		 									*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Zech 08/09/2012 ORG-6255-S6 CHANGE_CUSTOM_FILTER_DLG_TO_MULTI_PANE_DLG		*
 *	Zech 08/10/2012 ORG-6255-S4 SUPPORT_SELECT_IF_TRUE_IN_COLUMN_FILTER			*
 *	Zech 08/09/2012 ORG-6255-P2 LIST_SAVED_FORMULAS_IN_CUSTOM_FILTER_DLG_FIRST_TIME_OPEN
 *	Zech 08/20/2012 ORG-6589-S1 SHOW_FUNC_NAME_IN_CUSTOM_DATA_FILTER_DB_TITLE	*
 *	Zech 08/24/2012 ORG-6255-P5 SHOW_BOTTOM_PANE_WHEN_LOAD_CUSTOM_DATA_FILTER_HAS_PRESCRIPT
 *	Zech 08/28/2012 ORG-6255-P6 PROHIBIT_SOME_GUI_WHEN_CUSTOM_DLG_OPENED		*
 *	EJP 2012-10-03 ORG-7041 NEW_TRIG_FUNC_CATEGORY								*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
#include "DialogEx.h"
#include "FunctionsMenu.h"
#include "CustomColumnFilterDlg.h"
////////////////////////////////////////////////////////////////////////////////////

//#pragma labtalk(0) // to disable OC functions for LT calling.

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.


////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.

#define STR_CUSTOM_COLUMN_FILTER_FUNC_MENU_FAVORITES_SECTION_TEXT				"TEXT Functions Menu Favorites"
#define STR_CUSTOM_COLUMN_FILTER_FUNC_MENU_FAVORITES_SECTION_NUM				"NUM Functions Menu Favorites"
#define STR_CUSTOM_COLUMN_FILTER_FUNC_MENU_FAVORITES_SECTION_DATETIME			"DATATIME Functions Menu Favorites"

#define STR_NUMERIC_DATA_FILTER_FORMULA_SECTION		"Numeric Data Filter Formula"
#define STR_TEXT_DATA_FILTER_FORMULA_SECTION		"Text Data Filter Formula"
#define STR_DATETIME_DATA_FILTER_FORMULA_SECTION	"Datetime Data Filter Formula"

#define STR_COLUMN_QUERY_FAVORITE_LIST_SETTING_FILE	okutil_get_origin_path(ORIGIN_PATH_USER) + STR_ORIGIN_INI_FILE_NAME
#define STR_DATA_FILTER_FORMULA_PREFIX				"DataFilterFormula"

#define STR_EMPTY	(_L("Empty"))

//////////////////////////////////////////////////////////////////////////
// CustomColumnFilterMenu

CustomColumnFilterMenu::CustomColumnFilterMenu(HMENU& hMenu, int nFormat) : Menu(hMenu)
{
	m_infoFavorites.nBeginID = IDC_LOAD_COLUMN_QUERY_FORMULA;
	m_infoFavorites.nEmptyID = IDC_COL_FILTER_CUSTOM_LOAD_EMPTY;
	m_infoFavorites.nMaxSize = MAX_COLUMN_QUERY_FORMULA_IN_MENU;
	m_infoFavorites.vsItems.RemoveAll();

	m_infoRecFormula.nBeginID = IDC_RECENT_COLUMN_QUERY_FORMULA;
	m_infoRecFormula.nEmptyID = IDC_COL_FILTER_CUSTOM_RECENT_FORMULA;
	m_infoRecFormula.nMaxSize = MAX_COLUMN_QUERY_FORMULA_IN_MENU;
	m_infoRecFormula.vsItems.RemoveAll();

	m_infoSample.nBeginID = IDC_LOAD_COLUMN_QUERY_FORMULA_SAMPLE;
	m_infoSample.nEmptyID = IDC_COL_FILTER_CUSTOM_LOAD_SAMPLES_EMPTY;
	m_infoSample.nMaxSize = MAX_SAMPLE_COLUMN_QUERY_FORMULA_IN_MENU;
	m_infoSample.vsItems.RemoveAll();
}

CustomColumnFilterMenu::~CustomColumnFilterMenu()
{
}

BOOL	CustomColumnFilterMenu::AddItemToList(CustomColumnFilterMRUType nType, const string& strItem)
{
	MRUMenuInfo* pInfo = GetInfoPtr(nType);
	if (pInfo)
		return AddItemToMRUMenu(strItem, *pInfo);
	else
		return FALSE;
}

BOOL	CustomColumnFilterMenu::ClearList(CustomColumnFilterMRUType nType)
{
	MRUMenuInfo* pInfo = GetInfoPtr(nType);
	if (pInfo)
		return ClearMRUMenu(*pInfo);
	else
		return FALSE;
}

BOOL	CustomColumnFilterMenu::SetList(CustomColumnFilterMRUType nType, const vector<string>& vsItems)
{
	MRUMenuInfo* pInfo = GetInfoPtr(nType);
	if (pInfo)
		return SetMRUMenu(*pInfo, vsItems);
	else
		return FALSE;
}

void	CustomColumnFilterMenu::GetList(CustomColumnFilterMRUType nType, vector<string>& vsItems)
{
	MRUMenuInfo* pInfo = GetInfoPtr(nType);
	if (pInfo)
		vsItems = pInfo->vsItems;
	else
		vsItems.RemoveAll();
}

MRUMenuInfo*	CustomColumnFilterMenu::GetInfoPtr(CustomColumnFilterMRUType nType)
{
	MRUMenuInfo* pInfo;
	switch (nType)
	{
	case CCFMRUT_SAMPLE:
		pInfo = &m_infoSample;
		break;
	case CCFMRUT_FAVORITE:
		pInfo = &m_infoFavorites;
		break;
	case CCFMRUT_RECENT:
		pInfo = &m_infoRecFormula;
		break;
	default:
		ASSERT(FALSE);
		pInfo = NULL;
	}

	return pInfo;
}

BOOL	CustomColumnFilterMenu::ClearMRUMenu(MRUMenuInfo& infoMRU)
{
	int nSize = min(infoMRU.vsItems.GetSize(), (int)infoMRU.nMaxSize);
	if (nSize)
	{
		InsertMenu(infoMRU.nBeginID, MF_STRING, infoMRU.nEmptyID, STR_EMPTY);

		for (int ii = 0; ii < nSize; ++ii)
			RemoveMenu(infoMRU.nBeginID+ii, MF_STRING);
	}

	return TRUE;
}

BOOL	CustomColumnFilterMenu::SetMRUMenu(MRUMenuInfo& infoMRU, vector<string>& vsItems)
{
	ClearMRUMenu(infoMRU);

	int nSize = min(vsItems.GetSize(), (int)infoMRU.nMaxSize);
	infoMRU.vsItems = vsItems;
	for (int ii = 0; ii < nSize; ++ii)
		InsertMenu(infoMRU.nEmptyID, MF_STRING, infoMRU.nBeginID+ii, vsItems[ii]);

	if (nSize)
		RemoveMenu(infoMRU.nEmptyID, MF_STRING);
	
	return TRUE;
}

BOOL	CustomColumnFilterMenu::AddItemToMRUMenu(const string& strItem, MRUMenuInfo& infoMRU)
{
	vector<string> vsItems;

	// Ensure that we should not directly edit infoMRU.vsItems
	vsItems = infoMRU.vsItems;
	UpdateMRUArray(strItem, vsItems);

	SetMRUMenu(infoMRU, vsItems);
	
	return TRUE;
}

void	CustomColumnFilterMenu::UpdateMRUArray(const string& strNew, vector<string>& vsArr)
{
	int nPos = vsArr.Find(strNew);
	if (nPos != -1)
		vsArr.RemoveAt(nPos);

	vsArr.InsertAt(0, strNew);
}
//////////////////////////////////////////////////////////////////////////
// CustomColumnFilterDlg

/// Zech 08/09/2012 ORG-6255-S6 CHANGE_CUSTOM_FILTER_DLG_TO_MULTI_PANE_DLG
//CustomColumnFilterDlg::CustomColumnFilterDlg(Column& col) : ResizeDialog(IDD_COL_FILTER_CUSTOM_DLG, "ODlg8")
CustomColumnFilterDlg::CustomColumnFilterDlg(Column& col) : MultiPaneDlg(IDD_COL_FILTER_CUSTOM_DLG, "ODlg8")
/// END CHANGE_CUSTOM_FILTER_DLG_TO_MULTI_PANE_DLG
{
	m_col = col;
	m_nFormat = col.GetFilterFormat();
	switch (m_nFormat)
	{
	case COLUMN_FILTER_FORMAT_NUMERIC:
		m_strFavFunc = STR_CUSTOM_COLUMN_FILTER_FUNC_MENU_FAVORITES_SECTION_NUM;
		break;
	case COLUMN_FILTER_FORMAT_TEXT:
		m_strFavFunc = STR_CUSTOM_COLUMN_FILTER_FUNC_MENU_FAVORITES_SECTION_TEXT;
		break;
	case COLUMN_FILTER_FORMAT_DATE_TIME:
		m_strFavFunc = STR_CUSTOM_COLUMN_FILTER_FUNC_MENU_FAVORITES_SECTION_DATETIME;
		break;
	default:
		ASSERT(FALSE);
		break;
	}
	
	m_pDlgMenu = NULL;
}

CustomColumnFilterDlg::~CustomColumnFilterDlg()
{
	okutil_enable_origin_gui(TRUE);		/// Zech 08/28/2012 ORG-6255-P6 PROHIBIT_SOME_GUI_WHEN_CUSTOM_DLG_OPENED
	SaveRecentFormuaList();
	if (m_pDlgMenu)
		delete m_pDlgMenu;
}

BOOL	CustomColumnFilterDlg::OnInitDialog()
{
	/// Zech 08/09/2012 ORG-6255-S6 CHANGE_CUSTOM_FILTER_DLG_TO_MULTI_PANE_DLG
	//ResizeDialog::OnInitDialog();
	/// END CHANGE_CUSTOM_FILTER_DLG_TO_MULTI_PANE_DLG

	m_edCommand	= GetItem(IDC_EDIT_COMMAND);
	m_edPrecript = GetItem(IDC_EDIT_BRFORE_QUERY);
	m_edThisCol = GetItem(IDC_EDIT_REPRESENT_VAR);
	m_btnApply = GetItem(IDC_APPLY);
	
	/// Zech 08/09/2012 ORG-6255-S6 CHANGE_CUSTOM_FILTER_DLG_TO_MULTI_PANE_DLG
	vector<string>  vstrTipsUpDown;
	vstrTipsUpDown.SetSize(2);
	vstrTipsUpDown[0] = _L("Show Scripts");
	vstrTipsUpDown[1] = _L("Hide Scripts");	

	MultiPaneDlg::OnInitDialog(IDC_EDIT_COMMAND, IDC_SHOW_BOTTOM, IDC_EDIT_BRFORE_QUERY, vstrTipsUpDown, _L("Custom Filter"), 0, NULL, false, NULL, MULTIPANEDLGINIT_RESET_PANE_SIZE_IF_TOO_SMALL);
	SetResizePaneByResizingEdge(true);
	if (!IsSubPaneShown())
	{
		vector<uint> vnSubPaneControls;
		GetBottomPaneSubControls(vnSubPaneControls);
		ShowControls(vnSubPaneControls, false);
	}
	/// END CHANGE_CUSTOM_FILTER_DLG_TO_MULTI_PANE_DLG
	
	vector<string> vsTips;
	BitmapRadioButton btnFunc = GetItem(IDC_BUTTON_FUNC);
	btnFunc.Init(1, IDB_DROP_DOWN_UP, 16, vsTips);
	BitmapRadioButton btnFunc2 = GetItem(IDC_BUTTON_FUNC2);
	btnFunc2.Init(1, IDB_DROP_DOWN_UP, 16, vsTips);

	HWND 	hWnd = GetSafeHwnd();
	HMENU 	hMenu = GetMenu(hWnd);
	m_pDlgMenu = new CustomColumnFilterMenu(hMenu, m_nFormat);

	SetColumnFormat(m_nFormat);
	ConstructMenu();
	InitFilterXCtrls();
	InitHintCtrls();
	InitFormulaData();

	LoadCurrent();

	return TRUE;
}

BOOL	CustomColumnFilterDlg::OnReady()
{
	SetInitReady();

	return TRUE;
}

#define _DLG_GAP									5	

BOOL 	CustomColumnFilterDlg::OnDlgResize(int nType, int cx, int cy)
{
	if(!IsInitReady())
		return FALSE;

	MoveControlsHelper clCacheWndPosHelper(this);

	/// Zech 08/09/2012 ORG-6255-S6 CHANGE_CUSTOM_FILTER_DLG_TO_MULTI_PANE_DLG	
	/*
		uint nButtonIDs[] = {IDC_APPLY, IDCANCEL, IDOK, 0};

	ArrangeMainItemAndControls(nButtonIDs, IDC_EDIT_BRFORE_QUERY, NULL, false);

	int 	nGap	= _DLG_GAP;

	RECT 	rrFunc, rrCmd, rrBefore, rrOK, rrExp1, rrExp2, rrTextBefore;
	Control	cCmd, cBefore;
	GetControlClientRect(IDC_BUTTON_FUNC,		rrFunc);
	GetControlClientRect(IDC_EDIT_COMMAND,		rrCmd, 		&cCmd);
	GetControlClientRect(IDC_EDIT_BRFORE_QUERY,	rrBefore, 	&cBefore);
	GetControlClientRect(IDC_STATIC_EXP_TIPS_1, rrExp1);
	GetControlClientRect(IDC_STATIC_EXP_TIPS_2, rrExp2);
	GetControlClientRect(IDC_TEXT_BEFORE_QUERY, rrTextBefore);
	GetControlClientRect(IDOK,					rrOK);

	int 	nDx		= cx - nGap - rrFunc.right;
	int		nSpace	= rrOK.top - rrCmd.top;
	int		nNewHeight	= (nSpace - RECT_HEIGHT(rrExp1) - RECT_HEIGHT(rrExp2) - RECT_HEIGHT(rrTextBefore) - nGap * 5) / 2;

	vector<uint> vnIDs = {IDC_BUTTON_FUNC, IDC_BUTTON_FUNC2, 0};	
	MoveControls(vnIDs, nDx, 0);

	vnIDs.SetSize(0);
	vnIDs.Add(IDC_STATIC_EXP_TIPS_1);
	vnIDs.Add(IDC_STATIC_EXP_TIPS_2);
	vnIDs.Add(IDC_CUSTOM_COL_FILTER_HINT);
	vnIDs.Add(IDC_TEXT_BEFORE_QUERY);
	vnIDs.Add(0);

	int		nDy			= nNewHeight - RECT_HEIGHT(rrCmd);
	MoveControls(vnIDs, 0, nDy);	

	rrCmd.right	= cx - nGap * 2 - RECT_WIDTH(rrFunc);
	rrCmd.bottom= rrCmd.top + nNewHeight;
	MoveControl(cCmd, rrCmd);

	rrBefore.right	= cx - nGap * 2 - RECT_WIDTH(rrFunc);
	rrBefore.bottom	= cy - nGap * 2 - RECT_HEIGHT(rrOK);
	rrBefore.top 	= rrBefore.bottom - nNewHeight;
	MoveControl(cBefore, rrBefore);	

	Control cFunc2;
	RECT 	rrFunc2;
	GetControlClientRect(IDC_BUTTON_FUNC2, rrFunc2, &cFunc2);
	rrFunc2.bottom	= rrBefore.top + RECT_HEIGHT(rrFunc2);
	rrFunc2.top 	= rrBefore.top;
	MoveControl(cFunc2, rrFunc2);
	*/
	RECT 	rrShowBottom;
	GetControlClientRect(IDC_SHOW_BOTTOM,		rrShowBottom);
	/// Zech 08/10/2012 ORG-6255-S4 SUPPORT_SELECT_IF_TRUE_IN_COLUMN_FILTER	
	//vector<uint> vnBtns = {IDC_APPLY, IDCANCEL, IDOK, 0};
	vector<uint> vnBtns = {IDC_APPLY, IDCANCEL, IDOK, IDC_TEST_BTN, 0};
	/// END SUPPORT_SELECT_IF_TRUE_IN_COLUMN_FILTER
	MultiPaneDlg::OnDlgResize(vnBtns, cx, cy, false);
	
	int 	nGap	= _DLG_GAP;

	RECT 	rrFunc, rrExp2;//, rrCmd, , rrExp1, rrExp2, rrTextBefore;
	GetControlClientRect(IDC_BUTTON_FUNC,		rrFunc);
	GetControlClientRect(IDC_SHOW_BOTTOM,		rrShowBottom);
	GetControlClientRect(IDC_STATIC_EXP_TIPS_2,	rrExp2);
	int		nDx		= cx - nGap - rrFunc.right, 
			nMainPaneDy		= rrShowBottom.top - nGap - rrExp2.bottom;

	vector<uint> vndxIDs = {IDC_BUTTON_FUNC, IDC_BUTTON_FUNC2, 0};	
	MoveControls(vndxIDs, nDx, 0);

	vector<uint> vnMainPaneDyIDs = {IDC_CUSTOM_COL_FILTER_HINT, IDC_STATIC_EXP_TIPS_1, IDC_STATIC_EXP_TIPS_2, 0};
	MoveControls(vnMainPaneDyIDs, 0, nMainPaneDy);

	RECT	rrCmd, rrHint;
	Control	cCmd;
	GetControlClientRect(IDC_EDIT_COMMAND,		rrCmd, 		&cCmd);
	GetControlClientRect(IDC_CUSTOM_COL_FILTER_HINT,		rrHint);
	GetControlClientRect(IDC_BUTTON_FUNC,					rrFunc);
	rrCmd.bottom	= rrHint.top - nGap;
	rrCmd.right		= rrFunc.left - nGap;
	MoveControl(cCmd, rrCmd);

	// Ensure its position is correct so that there won't be any problem when open sub pane
	RECT rSubPane;
	GetSubPaneRect(rSubPane, cx, cy);
	ResizeSubPaneControls(rSubPane);
	/// END CHANGE_CUSTOM_FILTER_DLG_TO_MULTI_PANE_DLG
	return TRUE;
}

/// Zech 08/09/2012 ORG-6255-S6 CHANGE_CUSTOM_FILTER_DLG_TO_MULTI_PANE_DLG
BOOL	CustomColumnFilterDlg::OnShowBottomPane(Control cntrl)
{
	BOOL bRet = MultiPaneDlg::OnShowBottomPane(cntrl);
	//MoveControl(cBefore, rBefore);

	RECT rSubPane, rClient;
	GetClientRect(&rClient);
	int cx = RECT_WIDTH(rClient),
		cy = RECT_HEIGHT(rClient);

	GetSubPaneRect(rSubPane, cx, cy);
	ResizeSubPaneControls(rSubPane);

	return bRet;
}
/// END CHANGE_CUSTOM_FILTER_DLG_TO_MULTI_PANE_DLG

BOOL	CustomColumnFilterDlg::OnFuncButtonClick(Control ctrl)
{
	RECT rrButton;

	int nResID = GetDlgCtrlID( ctrl.GetSafeHwnd() );
	GetControlClientRect(nResID, rrButton);
	ClientToScreen(&rrButton);

	string strText = PopupFunctionMenu(rrButton.right, rrButton.top);
	if (strText.IsEmpty())
		return TRUE;

	if(IDC_BUTTON_FUNC2 == nResID)
		InsertFunction(m_edPrecript, strText);
	else
		InsertFunction(m_edCommand, strText);

	return TRUE;
}

/// Zech 08/10/2012 ORG-6255-S4 SUPPORT_SELECT_IF_TRUE_IN_COLUMN_FILTER
BOOL	CustomColumnFilterDlg::OnTestButtonclick(Control ctrl)
{
	m_data.lpcszCommand  = m_edCommand.Text;
	m_data.lpcszPrescript = m_edPrecript.Text;
	
	ColumnUpdateFilterCondition condition;
	condition.nCol = m_col.GetIndex();
	condition.nType = COLUMN_FILTER_TYPE_COMMAND;
	condition.pData = &m_data;
	condition.lpcszThisCol = m_edThisCol.Text;

	Worksheet	wks;
	m_col.GetParent(wks);
	wks.RunFilter(QUERY_FILTER_ACT_SELECT_MATCHED, 0, -1, false, 0, &condition);
	
	return TRUE;
}
/// END SUPPORT_SELECT_IF_TRUE_IN_COLUMN_FILTER

BOOL	CustomColumnFilterDlg::OnOK()
{
	OnApply(m_btnApply);
	return SendMessage(WM_CLOSE);
}

BOOL	CustomColumnFilterDlg::OnApply(Control ctrl)
{
	m_data.lpcszCommand  = m_edCommand.Text;
	m_data.lpcszPrescript = m_edPrecript.Text;

	UndoBlock		ub;
	if (m_col.SetFilter((int)COLUMN_FILTER_TYPE_COMMAND, (LPVOID)&m_data, TRUE))
	{
		if (!m_edThisCol.Text.IsEmpty())
			m_col.SetFilterThisCol(m_edThisCol.Text);

		if (!m_col.IsFilterDisabled())
		{
			Worksheet	wks;
			m_col.GetParent(wks);
			wks.RunFilter(QUERY_FILTER_ACT_HIDE_NOT_MATCHED, 0, -1, true);
		}
	}

	return TRUE;
}

BOOL	CustomColumnFilterDlg::OnLoadSample(int nID)
{
	return LoadFormula(nID, false);
}

BOOL	CustomColumnFilterDlg::OnLoadFavoritesFormula(int nID)
{
	return LoadFormula(nID, true);
}

BOOL	CustomColumnFilterDlg::OnLoadRecentFormula(int nID)
{
	// Load user's saved formula first, if failed, try to load sample formula
	return LoadFormula(nID, true) || LoadFormula(nID, false);
}

BOOL	CustomColumnFilterDlg::OnSaveFormula()
{
	if (m_strCurFormulaName.IsEmpty())
		return OnSaveFormulaAs();
	
	if(IDNO == MessageBox(GetSafeHwnd(), _L("Do you want to overwrite")+" "+ m_strCurFormulaName +_L("?"), _L("Attention!"), MB_YESNO))
		return FALSE;

	string strFormula = DlgToFormula();
	okutil_write_file_section(okutil_get_origin_path(ORIGIN_PATH_USER) + m_strFile, m_strCurFormulaName, strFormula);
	return TRUE;
}

BOOL	CustomColumnFilterDlg::OnSaveFormulaAs()
{
	vector<string> vsKeyNames;

	okutil_get_file_sections(okutil_get_origin_path(ORIGIN_PATH_USER) + m_strFile, &vsKeyNames);//STR_FAVORITE_FORMULA_FILE///jasmine 08/28/06 SHARE_DLG_WITH_MAT
	string strNameList;
	strNameList.SetTokens(vsKeyNames, '|');
	if(!strNameList.IsEmpty())
		strNameList.Insert(0,"|");

	//get name to save
	string strName;
	GETN_TREE(trSaveAs)
	GETN_AUTO_SAVE_BRANCH_OPEN(1)
	GETN_STR(Name, _L("Data Filter Name"), "")
	if(!strNameList.IsEmpty())
	{
		GETN_STR_COMBO(strNameList)
		_tmpSubNode.strVal = m_strCurFormulaName;
	}

	Window Wnd = GetWindow();
	if(!Wnd || !GetNBox(trSaveAs, _L("Save Data Filter As..."), _L("Input name for new data filter"), NULL, NULL, Wnd.GetSafeHwnd()))
		return FALSE;

	strName	= trSaveAs.Name.strVal;
	strName.TrimLeft();	strName.TrimRight();
	if(strName.IsEmpty())
		return FALSE;
	int nIndex = vsKeyNames.Find(strName);
	if(-1 < nIndex && IDNO == MessageBox(GetSafeHwnd(), _L("Do you want to overwrite")+" "+ vsKeyNames[nIndex] +_L("?"), _L("Attention!"), MB_YESNO) )
		return FALSE;

	//save in ini file
	string strFormula = DlgToFormula();
	okutil_write_file_section(okutil_get_origin_path(ORIGIN_PATH_USER) + m_strFile, strName, strFormula);
	if (!m_pDlgMenu->AddItemToList(CCFMRUT_FAVORITE, strName) || !m_pDlgMenu->AddItemToList(CCFMRUT_RECENT, strName))
		return FALSE;

	m_strCurFormulaName = strName;
	/// Zech 08/20/2012 ORG-6589-S1 SHOW_FUNC_NAME_IN_CUSTOM_DATA_FILTER_DB_TITLE
	UpdateDialogTitle();
	/// END SHOW_FUNC_NAME_IN_CUSTOM_DATA_FILTER_DB_TITLE
	return TRUE;
}

/// Zech 08/28/2012 ORG-6255-P6 PROHIBIT_SOME_GUI_WHEN_CUSTOM_DLG_OPENED
void	CustomColumnFilterDlg::OnAfterRollup(BOOL bClose)
{
	ResizeDialog::OnAfterRollup(bClose);
	okutil_enable_origin_gui(!bClose);
}
/// END PROHIBIT_SOME_GUI_WHEN_CUSTOM_DLG_OPENED

string	CustomColumnFilterDlg::PopupFunctionMenu(int x, int y)
{
	if (m_pMenu == NULL)
		return "";

	int		nCmd;
	m_pMenu->TrackPopupMenu(TPM_NOTIFY, x, y, GetSafeHwnd(), &nCmd);

	if(0 == nCmd)
		return "";

	string strFunc =  m_pMenu->GetFunctionString(nCmd);
	m_pMenu->UpdateFuncHistoryList(m_pMenu->GetMenuString(nCmd));
	return strFunc;
}

BOOL	CustomColumnFilterDlg::ConstructMenu()
{
	HINSTANCE hInst = (HINSTANCE) okutil_load_dll(ORIGINC_SOURCE_PATH_ORIGINLAB + "ODlg8.dll");	
	if ( NULL == hInst )
		return FALSE;

	BOOL	bOK = m_menu.Load(hInst, IDR_COL_FILTER_FUNCTION, 0);
	FreeLibrary(hInst);
	if ( !bOK )
		return FALSE;

	vector<uint> vnCategoryIDs;
	GetCheckMenuCategoryIDs(m_menu, vnCategoryIDs);	

	HMENU hMenu = m_menu.GetSafeHmenu();

	m_pMenu = new CustomColFilterFuncMenu(hMenu, m_strFavFunc, vnCategoryIDs);	
	m_pMenu->SetGetLTFunctionOption(OC_SKIP_SYS_WITHOUT_CAT);
	m_pMenu->Construct();
	return TRUE;
}

int		CustomColumnFilterDlg::GetCheckMenuCategoryIDs(Menu& menu, vector<uint>& vncatagoryIDs)
{
	switch (m_nFormat)
	{
	case COLUMN_FILTER_FORMAT_NUMERIC:
		{
			/// EJP 2012-10-03 ORG-7041 NEW_TRIG_FUNC_CATEGORY
			///m_menu.RemoveMenu(2, MF_BYPOSITION);//Date and Time
			m_menu.RemoveMenu(3, MF_BYPOSITION);//Date and Time
			/// end NEW_TRIG_FUNC_CATEGORY
			m_menu.RemoveMenu(0, MF_BYPOSITION);//String

			vector<uint> vnCategoris = {
				IDC_FUNCTION_MENU_MATH, 
				IDC_FUNCTION_MENU_TRIG, /// EJP 2012-10-03 ORG-7041 NEW_TRIG_FUNC_CATEGORY
				IDC_FUNCTION_MENU_STATS, 

				IDC_FUNCTION_MENU_CDF,
				IDC_FUNCTION_MENU_PDF,
				IDC_FUNCTION_MENU_INV,

				IDC_FUNCTION_MENU_FIT_FUNC,
				IDC_FUNCTION_MENU_USER_DEFINED,
				IDC_FUNCTION_MENU_FAVORITE
			};

			vncatagoryIDs = vnCategoris;
			break;
		}
	case COLUMN_FILTER_FORMAT_TEXT:
		{
			/// EJP 2012-10-05 ORG-7041 NEW_TRIG_FUNC_CATEGORY
			///m_menu.RemoveMenu(5, MF_BYPOSITION);//Fitting Functions
			///m_menu.RemoveMenu(4, MF_BYPOSITION);//Distributions
			///m_menu.RemoveMenu(3, MF_BYPOSITION);//Statistics
			///m_menu.RemoveMenu(2, MF_BYPOSITION);//Date and Time
			m_menu.RemoveMenu(6, MF_BYPOSITION);//Fitting Functions
			m_menu.RemoveMenu(5, MF_BYPOSITION);//Distributions
			m_menu.RemoveMenu(4, MF_BYPOSITION);//Statistics
			m_menu.RemoveMenu(3, MF_BYPOSITION);//Date and Time
			m_menu.RemoveMenu(2, MF_BYPOSITION);//Trigonometric
			/// end NEW_TRIG_FUNC_CATEGORY
			m_menu.RemoveMenu(1, MF_BYPOSITION);//Math

			vector<uint> vnCategoris = {
				IDC_FUNCTION_MENU_TEXT, 
				IDC_FUNCTION_MENU_USER_DEFINED,
				IDC_FUNCTION_MENU_FAVORITE
			};

			vncatagoryIDs = vnCategoris;
			break;
		}
	case COLUMN_FILTER_FORMAT_DATE_TIME:
		{
			/// EJP 2012-10-05 ORG-7041 NEW_TRIG_FUNC_CATEGORY
			///m_menu.RemoveMenu(5, MF_BYPOSITION);//Fitting Functions
			///m_menu.RemoveMenu(4, MF_BYPOSITION);//Distributions
			///m_menu.RemoveMenu(3, MF_BYPOSITION);//Statistics
			m_menu.RemoveMenu(6, MF_BYPOSITION);//Fitting Functions
			m_menu.RemoveMenu(5, MF_BYPOSITION);//Distributions
			m_menu.RemoveMenu(4, MF_BYPOSITION);//Statistics
			m_menu.RemoveMenu(2, MF_BYPOSITION);//Trigonometric
			/// end NEW_TRIG_FUNC_CATEGORY
			m_menu.RemoveMenu(1, MF_BYPOSITION);//Math
			m_menu.RemoveMenu(0, MF_BYPOSITION);//String
			

			vector<uint> vnCategoris = {
				IDC_FUNCTION_MENU_DATE_TIME, 
				IDC_FUNCTION_MENU_USER_DEFINED,
				IDC_FUNCTION_MENU_FAVORITE
			};

			vncatagoryIDs = vnCategoris;
			break;			
		}
	default:
		ASSERT(FALSE);
		return 0;
	}
	
	return vncatagoryIDs.GetSize();
}

BOOL	CustomColumnFilterDlg::LoadCurrent()
{
	m_edCommand.Text.Empty();
	m_edPrecript.Text.Empty();

	LPVOID	pData;
	int		nType;
	if (m_col.GetFilter(nType, &pData))
	{
		string strThisCol = m_col.GetFilterThisCol(), strCommand, strPrescript;
		if (m_col.GetFilterQueryInfo(&strCommand, &strPrescript, nType, pData, strThisCol))
		{
			m_edThisCol.Text = strThisCol;
			m_edCommand.Text = strCommand;
			m_edPrecript.Text = strPrescript;
			return TRUE;
		}
		else
			return FALSE;
	}

	return FALSE;
}

BOOL	CustomColumnFilterDlg::LoadFormula(int nID, bool bUser)
{
	string strFormulaFile = (!bUser
						? okutil_get_origin_path(ORIGIN_PATH_SYSTEM)							
						: okutil_get_origin_path(ORIGIN_PATH_USER)) 
						+ m_strFile;
	if ( !strFormulaFile.IsFile() )
		strFormulaFile = okutil_get_origin_path(ORIGIN_PATH_GROUP) + m_strFile;

	string strName, strFormula;
	m_pDlgMenu->GetMenuString(nID, strName, MF_STRING);
	okutil_ampersand_string_for_display(&strName, FALSE);
	int nRet = okutil_read_file_section(strFormulaFile, strName, &strFormula, NULL);	
	if(nRet<= 0)
		return FALSE;

	if (FormulaToDlg(strFormula))
	{
		m_strCurFormulaName = strName;
		/// Zech 08/20/2012 ORG-6589-S1 SHOW_FUNC_NAME_IN_CUSTOM_DATA_FILTER_DB_TITLE
		UpdateDialogTitle();
		/// END SHOW_FUNC_NAME_IN_CUSTOM_DATA_FILTER_DB_TITLE
		m_pDlgMenu->AddItemToList(CCFMRUT_RECENT, strName);
		return TRUE;
	}
	else	
		return FALSE;
}

void	CustomColumnFilterDlg::InitHintCtrls()
{
	Control ctrlHint = GetItem(IDC_CUSTOM_COL_FILTER_HINT),
			ctrlExp = GetItem(IDC_STATIC_EXP_TIPS_2);

	switch (m_nFormat)
	{
	case COLUMN_FILTER_FORMAT_NUMERIC:
		//ctrlHint.Text = "\"0/0\"\tMissing Value";
		ctrlExp.Text.Format("%s >= 100 or abs(%s) = 2", STR_COLUMN_FILTER_THIS_COLUMN, STR_COLUMN_FILTER_THIS_COLUMN);
		break;
	case COLUMN_FILTER_FORMAT_TEXT:
		ctrlHint.Text = "\"*\" matches any substring\n\"?\" matches any character";
		ctrlExp.Text.Format("%s LIKE \"a*\" and %s NOT LIKE \"?b*\"", STR_COLUMN_FILTER_THIS_COLUMN, STR_COLUMN_FILTER_THIS_COLUMN);
		break;
	case COLUMN_FILTER_FORMAT_DATE_TIME:
		ctrlHint.Text.Empty();
		ctrlExp.Text.Format("Year(%s) = 2012 and (Month(%s) = 7 or Month(%s) = 8)", STR_COLUMN_FILTER_THIS_COLUMN, STR_COLUMN_FILTER_THIS_COLUMN, STR_COLUMN_FILTER_THIS_COLUMN);
		break;
	default:
		ASSERT(FALSE);
		break;
	}
}

#define		STR_LABEL_FORMAT_VAR_TO_REPRESENT_COL		(_L("Variable to represent %s"))
void	CustomColumnFilterDlg::InitFilterXCtrls()
{
	Control ctrlCol = GetItem(IDC_TEXT_REPRESENT_VAR);
	string 	strLongName = m_col.GetLongName(), strCol, strColName;
	strColName = strLongName.IsEmpty() ? m_col.GetName() : strLongName;
	strCol.Format("Col(%s)", strColName);
	ctrlCol.Text.Format(STR_LABEL_FORMAT_VAR_TO_REPRESENT_COL, strCol);

	Edit	edFilterX = GetItem(IDC_EDIT_REPRESENT_VAR);
	int		nGap = _DLG_GAP;
	RECT 	rrCol, rrFilterX;
	GetClientRect(ctrlCol, rrCol);
	GetClientRect(edFilterX, rrFilterX);
	
	// Sometimes GetMinClientTrackWidth is less than GetMinClientWidth
	int		nCtrlColMaxWidth = GetMinClientWidth() - nGap * 3 - RECT_WIDTH(rrFilterX),
			nCtrlColTextWidth, nWidth;
	ctrlCol.Measure(ctrlCol.Text, &nCtrlColTextWidth, true);
	
	if (nCtrlColTextWidth > nCtrlColMaxWidth)
	{
		ctrlCol.SetToolTip(strCol);
		strCol.Format("Col(%s)", strColName.Left(10) + "...");
		ctrlCol.Text.Format(STR_LABEL_FORMAT_VAR_TO_REPRESENT_COL, strCol);
		ctrlCol.Measure(ctrlCol.Text, &nCtrlColTextWidth, true);
	}

	nWidth = nCtrlColTextWidth + 10;
	rrCol.right = rrCol.left + nWidth;
	MoveControl(ctrlCol, rrCol);
	rrFilterX.right = rrCol.right + nGap + RECT_WIDTH(rrFilterX);
	rrFilterX.left = rrCol.right + nGap;
	MoveControl(edFilterX, rrFilterX);

	edFilterX.Text = m_col.GetFilterThisCol();
}

void	CustomColumnFilterDlg::InitFormulaData()
{
	m_strCurFormulaName.Empty();
	/// Zech 08/20/2012 ORG-6589-S1 SHOW_FUNC_NAME_IN_CUSTOM_DATA_FILTER_DB_TITLE
	UpdateDialogTitle();
	/// END SHOW_FUNC_NAME_IN_CUSTOM_DATA_FILTER_DB_TITLE	
}

void	CustomColumnFilterDlg::InsertFunction(Edit& ed, string& strText)
{
	string strSel = ed.GetSelText();
	bool bStrRet = (strText.GetLength() > 0 && strText[strText.GetLength() - 1] == '$');

	int nLeftBracketPos = strText.Find('(');
	int nRightBracketPos = strText.Find(')');

	bool bFunctionStr = true;
	bool bParentheses = bFunctionStr && nLeftBracketPos >= 0 && nRightBracketPos > nLeftBracketPos;
	if(bParentheses)
	{
		string strTmp = strText.Mid(nLeftBracketPos + 1, nRightBracketPos - nLeftBracketPos - 1);
		strTmp.Remove(',');				// only
		strTmp.TrimLeft();
		strTmp.TrimRight();
		bParentheses = strTmp.IsEmpty();
	}

	if(bParentheses)
	{
		int nSpaceIndex = strText.Find(' ');
		int nParenIndex = strText.Find('(');
		if(nSpaceIndex > 0 && nSpaceIndex < nParenIndex)	// space before (
		{
			int nLength = strText.GetLength() - nSpaceIndex - 1;		// length after the space
			strText = strText.Right(nLength);
			strText.TrimLeft();
		}

		nParenIndex = strText.ReverseFind(')');
		if(nParenIndex > 0)
			strText.Insert(nParenIndex, strSel);
	}

	ed.ReplaceSel(strText, true);

	if(bParentheses && strSel.IsEmpty())
	{
		long nBegin, nEnd;
		ed.GetSel(nBegin, nEnd);
		nBegin -= bStrRet ? 2 : 1;
		ed.SetSel(nBegin, nBegin);
	}

	SetFocus(ed.GetSafeHwnd());
}

int		CustomColumnFilterDlg::GetMinClientWidth()
{
	return 550;
}

int		CustomColumnFilterDlg::GetMinClientTrackWidth()
{
	return max(GetMinClientWidth(), MultiPaneDlg::GetMinClientTrackWidth());
}

/// Zech 08/09/2012 ORG-6255-S6 CHANGE_CUSTOM_FILTER_DLG_TO_MULTI_PANE_DLG
int		CustomColumnFilterDlg::GetBottomPaneSubControls(vector<uint>& vnCntrls)
{
	vector<uint> vnIDs = {IDC_EDIT_BRFORE_QUERY, IDC_TEXT_BEFORE_QUERY, IDC_BUTTON_FUNC2, 0};
	vnCntrls = vnIDs;
	return vnCntrls.GetSize();
}

int		CustomColumnFilterDlg::GetMinClientTrackHeight()
{
	if( !IsBottomPaneShown() )
	{			
		return GetMinTopPaneHeight();
	}
	else
	{
		RECT rrOK;
		GetControlClientRect(IDOK, rrOK); 
		return GetMinTopPaneHeight() + GetMinBottomPaneHeight() + GetControlGap()*2 + RECT_HEIGHT(rrOK);
	}
}

// virtual
void	CustomColumnFilterDlg::GetBoundaryPositionBetweenPanes(int &nx, int &ny, int cx, int cy)
{
	RECT rr;
	if(GetControlClientRect(IDC_SHOW_BOTTOM, rr))
	{
		ny = rr.bottom + GetControlGap();
		if (IsBottomPaneShown())
			ny = min(ny, cy - GetControlGap() - GetMinBottomPaneHeight());
		ny = max(ny, GetMinTopPaneHeight() + GetControlGap());
	}
}

// virtual
void	CustomColumnFilterDlg::ResizeMainPaneControls(RECT rr, bool bRight = false)
{
	rr.bottom = max(rr.bottom, rr.top +GetMinTopPaneHeight());
	MultiPaneDlg::ResizeMainPaneControls(rr, bRight);
}

// virtual
void	CustomColumnFilterDlg::ResizeSubPaneControls(RECT rr)
{
	RECT rDown;
	GetControlClientRect(IDC_SHOW_BOTTOM, rDown);
	rr.top = rDown.bottom + GetControlGap();

	int		nGap = _DLG_GAP;
	RECT	rBefore, rFunc2, rTextBefore;
	Control	cBefore;
	GetControlClientRect(IDC_EDIT_BRFORE_QUERY,	rBefore, 	&cBefore);
	GetControlClientRect(IDC_TEXT_BEFORE_QUERY,				rTextBefore);
	GetControlClientRect(IDC_BUTTON_FUNC2,					rFunc2);

	int	nTextDy = rr.top - rTextBefore.top;
	vector<uint> vnTextIDs = {IDC_TEXT_BEFORE_QUERY, 0};
	MoveControls(vnTextIDs, 0, nTextDy);

	GetControlClientRect(IDC_TEXT_BEFORE_QUERY,				rTextBefore);
	int nFunc2Dx = rr.right - nGap - rFunc2.right,
		nFunc2Dy = rTextBefore.bottom + nGap - rFunc2.top;
	vector<uint> vFunc2IDs = {IDC_BUTTON_FUNC2, 0};
	MoveControls(vFunc2IDs, nFunc2Dx, 0);
	MoveControls(vFunc2IDs, 0, nFunc2Dy);

	GetControlClientRect(IDC_TEXT_BEFORE_QUERY,				rTextBefore);
	GetControlClientRect(IDC_BUTTON_FUNC2,					rFunc2);
	rBefore.top = rTextBefore.bottom + nGap;
	rBefore.right = rFunc2.left - nGap;
	rBefore.bottom = rr.bottom - nGap;
	MoveControl(cBefore, rBefore);

}

// virtual
int		CustomColumnFilterDlg::UpdateBottomPaneSubControls()
{
	vector<uint> vnSubpaneIDs;
	GetBottomPaneSubControls(vnSubpaneIDs);
	ShowControls(vnSubpaneIDs, IsSubPaneShown());
	
	return 0;
}
/// END CHANGE_CUSTOM_FILTER_DLG_TO_MULTI_PANE_DLG

string	CustomColumnFilterDlg::DlgToFormula()
{
	string	strThisCol = m_edThisCol.Text,
			strCommand = m_edCommand.Text,
			strPrescript = m_edPrecript.Text,
			strRet;
	strThisCol.TrimLeft();strThisCol.TrimRight();
	strCommand.TrimLeft();strCommand.TrimRight();
	strPrescript.TrimLeft();strPrescript.TrimRight();

	strRet.Format("%s%s%s", strThisCol, STR_COL_FORMULAR_SEPARATOR, strCommand);
	if(!strPrescript.IsEmpty())
	{
		strRet += STR_COL_FORMULAR_SEPARATOR;
		strRet += strPrescript;
	}

	return strRet;
}

BOOL	CustomColumnFilterDlg::FormulaToDlg(LPCSTR lpcszFormula)
{
	string strFormula(lpcszFormula);
	vector<string> vsFormula;
	int nSize = str_separate(lpcszFormula, STR_COL_FORMULAR_SEPARATOR, vsFormula);

	if (nSize >= 2)	// ThisCol and Command is necessary
	{
		m_edThisCol.Text = vsFormula[0];
		m_edCommand.Text = vsFormula[1];

		m_edPrecript.Text.Empty();

		bool bHasPrescript = false;				/// Zech 08/24/2012 ORG-6255-P5 SHOW_BOTTOM_PANE_WHEN_LOAD_CUSTOM_DATA_FILTER_HAS_PRESCRIPT
		
		for (int ii = 2; ii < nSize; ++ii)
		{
			bHasPrescript = true;			/// Zech 08/24/2012 ORG-6255-P5 SHOW_BOTTOM_PANE_WHEN_LOAD_CUSTOM_DATA_FILTER_HAS_PRESCRIPT
			m_edPrecript.Text += vsFormula[ii];
			if (nSize - 1 != ii)
				m_edPrecript.Text += ";\n";
		}

		/// Zech 08/24/2012 ORG-6255-P5 SHOW_BOTTOM_PANE_WHEN_LOAD_CUSTOM_DATA_FILTER_HAS_PRESCRIPT
		if (bHasPrescript && !IsBottomPaneShown())
			ShowBottomPane(true);
		/// END SHOW_BOTTOM_PANE_WHEN_LOAD_CUSTOM_DATA_FILTER_HAS_PRESCRIPT
	}
	else
		return FALSE;

	return TRUE;
}

/// Zech 08/20/2012 ORG-6589-S1 SHOW_FUNC_NAME_IN_CUSTOM_DATA_FILTER_DB_TITLE
void	CustomColumnFilterDlg::UpdateDialogTitle()
{
	string str = _L("Custom Data Filter");
	if (!m_strCurFormulaName.IsEmpty())
		str += " - " + m_strCurFormulaName;

	Text = str;
}
/// END SHOW_FUNC_NAME_IN_CUSTOM_DATA_FILTER_DB_TITLE

BOOL	CustomColumnFilterDlg::SetColumnFormat(int nFormat)
{
	if ((	COLUMN_FILTER_FORMAT_NUMERIC	== nFormat
		||	COLUMN_FILTER_FORMAT_TEXT		== nFormat
		||	COLUMN_FILTER_FORMAT_DATE_TIME	== nFormat )
		)
	{
		SaveRecentFormuaList();
		m_nFormat = nFormat;
		switch(m_nFormat)
		{
		case COLUMN_FILTER_FORMAT_NUMERIC:
			m_strFile					= STR_TXT_FILENAME_FAVORITE_NUMERIC_FORMULA;
			m_strSectionRecentFormula	= STR_NUMERIC_DATA_FILTER_FORMULA_SECTION;
			break;
		case COLUMN_FILTER_FORMAT_TEXT:
			m_strFile					= STR_TXT_FILENAME_FAVORITE_TEXT_FORMULA;
			m_strSectionRecentFormula	= STR_TEXT_DATA_FILTER_FORMULA_SECTION;
			break;
		case COLUMN_FILTER_FORMAT_DATE_TIME:
			m_strFile					= STR_TXT_FILENAME_FAVORITE_DATETIME_FORMULA;
			m_strSectionRecentFormula	= STR_DATETIME_DATA_FILTER_FORMULA_SECTION;
			break;
		default:
			ASSERT(FALSE);
			break;
		}

		LoadRecentFormulaList();
		LoadSampleFormulaList();
		LoadFavoritesFormulaList();
		return TRUE;
	}
	else
		return FALSE;
}

/// Zech 08/09/2012 ORG-6255-P2 LIST_SAVED_FORMULAS_IN_CUSTOM_FILTER_DLG_FIRST_TIME_OPEN
void	CustomColumnFilterDlg::LoadFavoritesFormulaList()
{
	string strFormula = okutil_get_origin_path(ORIGIN_PATH_USER) + m_strFile;
	if ( !strFormula.IsFile() )
	{
		string	strGroupFolder = okutil_get_origin_path(ORIGIN_PATH_GROUP);
		if ( !strGroupFolder.IsEmpty() )
			strFormula = strGroupFolder + m_strFile;
	}

	if ( strFormula.IsFile() )
	{
		m_pDlgMenu->ClearList(CCFMRUT_FAVORITE);

		vector<string> vsFormulaNames;
		okutil_get_file_sections(strFormula, &vsFormulaNames);

		m_pDlgMenu->SetList(CCFMRUT_FAVORITE, vsFormulaNames);
	}
}
/// END LIST_SAVED_FORMULAS_IN_CUSTOM_FILTER_DLG_FIRST_TIME_OPEN

void	CustomColumnFilterDlg::SaveRecentFormuaList()
{
	INIFile iniFile(STR_COLUMN_QUERY_FAVORITE_LIST_SETTING_FILE);

	update_ini_line(iniFile, m_strSectionRecentFormula, NULL, NULL );

	vector<string> vsItems;
	m_pDlgMenu->GetList(CCFMRUT_RECENT, vsItems);
	int nSize = vsItems.GetSize();
	for (int ii = 0; ii < nSize; ++ii)
	{
		update_ini_line(iniFile, m_strSectionRecentFormula, STR_DATA_FILTER_FORMULA_PREFIX+(string)ii, vsItems[ii]);
	}
}

void	CustomColumnFilterDlg::LoadRecentFormulaList()
{
	INIFile iniFile(STR_COLUMN_QUERY_FAVORITE_LIST_SETTING_FILE);

	vector<string> vsKeyNames, vsFormulaNames;
	m_pDlgMenu->ClearList(CCFMRUT_RECENT);

	iniFile.GetKeyNames(vsKeyNames, m_strSectionRecentFormula);
	int nSize = vsKeyNames.GetSize();
	for (int ii = 0; ii < nSize; ++ii)
		vsFormulaNames.Add(iniFile.ReadString(m_strSectionRecentFormula, vsKeyNames[ii]));

	m_pDlgMenu->SetList(CCFMRUT_RECENT, vsFormulaNames);
}

void	CustomColumnFilterDlg::LoadSampleFormulaList()
{
	string strFormula = okutil_get_origin_path(ORIGIN_PATH_SYSTEM) + m_strFile;

	if ( strFormula.IsFile() )
	{
		m_pDlgMenu->ClearList(CCFMRUT_SAMPLE);

		vector<string> vsFormulaNames;
		okutil_get_file_sections(strFormula, &vsFormulaNames);

		m_pDlgMenu->SetList(CCFMRUT_SAMPLE, vsFormulaNames);
	}
}

int		CustomColumnFilterDlg::DoModalEx(HWND hParent /*= NULL*/)
{
	InitMsgMap();
	/// Zech 08/09/2012 ORG-6255-S6 CHANGE_CUSTOM_FILTER_DLG_TO_MULTI_PANE_DLG
	//int nRet = ResizeDialog::DoModal(hParent);
	int nRet = MultiPaneDlg::DoModal(hParent);
	/// END CHANGE_CUSTOM_FILTER_DLG_TO_MULTI_PANE_DLG
	
	return nRet;
}
