/*------------------------------------------------------------------------------*
 * File Name: CustomColFilterTimeDlg.h 											*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Jasmine 07/18/2012 ORG-6255-S1 SEPARATE_DATE_TIME_CLASS						*
 *	Jasmine 07/18/2012 ORG-5851-S3 ADD_DATE_TIME_FILTER_HINTS					*
 *------------------------------------------------------------------------------*/
 
#define STR_FUNCTIONS_MENU_FAVORITES_SECTION_DATATIME			"DATATIME Functions Menu Favorites"


enum{
	FILTER_COL_NORMAL_DATE_TIME_DATA = 0,
	FILTER_COL_ONLY_DATE_DATA,
	FILTER_COL_ONLY_TIME_DATA,
};


class ColFilterDateTimeDlg : public ColFilterBaseDlg
{
public:
	ColFilterDateTimeDlg() : ColFilterBaseDlg(IDD_COL_FILTER_DATETIME_DLG) 
	{
		m_ColData = FILTER_COL_NORMAL_DATE_TIME_DATA;
		m_strFavFunc = STR_FUNCTIONS_MENU_FAVORITES_SECTION_DATATIME;			///Tony 06/15/2012 ORG-5985-P2 FIX_ALL_RECENT_FUNC_LIST_IN_DIFF_TYPE
	}	
	~ColFilterDateTimeDlg() {}
	
	//virtual
	int		GetDataObjType() { return CUSTOM_COLUMN_FILTER_OBJECT_TIME; }
	//virtual 
	string	GetDlgTitle(bool bAdv);
	
	//virtual 
	BOOL	OnApply(Control ctrl);

EVENTS_BEGIN
	ON_FILTER_DLG_BASIC_EVENTS
	ON_CBN_SELCHANGE(IDC_COMBO_CONDITION_1, OnMethodChange)
	ON_CBN_SELCHANGE(IDC_COMBO_CONDITION_2, OnMethodChange)
	ON_USER_MSG(WM_USER_DATETIMCHANGE, 		OnDateTimeCtrlChange) 
	ON_GRID_AFTER_EDIT(IDC_MONTH_LIST1, 	OnAfterEditCheckList)
	ON_GRID_AFTER_EDIT(IDC_MONTH_LIST2, 	OnAfterEditCheckList)
	ON_BN_CLICKED(IDC_RADIO_ADD,  			OnControlChange)
	ON_BN_CLICKED(IDC_RADIO_OR,  			OnControlChange)
EVENTS_END
	
protected:
	//virtual 
	BOOL 	OnInitPage();
	BOOL 	OnMethodChange(Control ctrl);
	LRESULT OnDateTimeCtrlChange(WPARAM wParam, LPARAM lParam);
	void	OnAfterEditCheckList(Control flxControl, int nRow, int nCol){Control junk; OnControlChange(junk);}
	
protected:		
	//virtual 
	int		GetCheckMenuCategoryIDs(Menu& menu, vector<uint>& vncatagoryIDs);
	
	//virtual 
	void 	GetSimpleControls(vector<uint>& vnIDs);
	
	//virtual 
	void 	GetAdvControls(vector<uint>& vnIDs);
	
	//virtual 
	void	GetSimpleGroupRect(RECT &rectGroup);	
	
	//virtual 
	void	GetAdvGroupRect(RECT &rectGroup);
	
	//virtual 
	BOOL 	EnableCtrlsByComboSel(ComboBox& combo);		///Jasmine 07/18/2012 ORG-5851-S4 DISABLE_CONDITION_CTRLS_WHEN_COMBO_IS_EMPTY

	//virtual 
	void	InitFilterControls();
	
	//virtual 
	void	ConstructQueryString();		///Jasmine 05/16/2012 ORG-5668-S1 CONSTRUCT_QUERY_STRING_FROM_SIMPLE_MODE
	
	///Jasmine 07/18/2012 ORG-6252-P1 HIDE_NAVIGATE_BTNS
#ifndef _ALLOW_NAVIGATE_TO_OTHER_COL
	//virtual
	int		GetMinClientWidth();
#endif 
	///End HIDE_NAVIGATE_BTNS
	
	///Jasmine 05/09/2012 ORG-4862-S6 MAKE_COLFILTER_DLG_RESIZABLE	
	//virtual
	void	OnDlgResize(int nType, int nRight, int nBottom);	
	///End MAKE_COLFILTER_DLG_RESIZABLE
	
	///Jasmine 07/18/2012 ORG-5851-S3 ADD_DATE_TIME_FILTER_HINTS
	//virtual
	int		GetQueryTipsIDs(vector<uint>& vnIDs);
	///End ADD_DATE_TIME_FILTER_HINTS
	
private:
	///Jasmine 05/10/2012 ORG-4862-P4 CAREFULLY_USE_FILTER_DATA_STRUCT_LPCSTR
	//bool 	GUIToCondition(int nComboSel, double dDate, double dTime, GridCheckListControl* pGridList, CustomColumnFilterConditionData& conditionData);
	bool 	GUIToCondition(int nComboSel, double dDate, double dTime, GridCheckListControl* pGridList, int& nObjType, int& nFormulaType, string& strValue, double& dValue, DWORD& dwOption);
	///End CAREFULLY_USE_FILTER_DATA_STRUCT_LPCSTR
	bool	conditionToGUI(CustomColumnFilterConditionData& conditionData, ComboBox& cmbFormula, DateTimeCtrl* pDateCtrl, DateTimeCtrl* pTimeCtrl, GridCheckListControl* pGridList);
	bool	changeGUIbyMethod(Control ctrl, LPCSTR lpczValue = NULL);
	void	updateDataTimeCtrlFormatByFilterCol(const Column& colFilter);
	/// Zech 06/28/2012 ORG-5638-P12 FIX_CONSTRCT_COL_FILTER_QUERY_DATA
	void	InitQueryData();
	bool	UpdateQueryData(bool& bHasAnyCondition);
	/// END FIX_CONSTRCT_COL_FILTER_QUERY_DATA
private:	
	CustomColumnFilterData			m_data;
	int								m_ColData;
	string							m_strDataTimeFmt;			///Jasmine 03/23/2012 ORG-5638-P6 REDUNDANT_DATE_TIME_DATA_DISTURB_COMPARISON
	
	ComboBox						m_cmbCondition1;
	DateTimeCtrl					m_DateCtrl1;
	DateTimeCtrl					m_TimeCtrl1;
	GridCheckListControl			m_gridList1;
	
	ComboBox						m_cmbCondition2;
	DateTimeCtrl					m_DateCtrl2;
	DateTimeCtrl					m_TimeCtrl2;
	GridCheckListControl			m_gridList2;
	
	/// Zech 06/28/2012 ORG-5638-P12 FIX_CONSTRCT_COL_FILTER_QUERY_DATA
	string			m_strValue1;
	string			m_strValue2;
	/// END FIX_CONSTRCT_COL_FILTER_QUERY_DATA
};

/***********************************************************************
*********************  ColFilterDateTimeDlg Begin  *********************
************************************************************************/	
enum{
	CUSTOMCOLFILTER_DATE_TIME_LIST_NONE				= 0,
	
	CUSTOMCOLFILTER_DATE_TIME_LIST_BEGIN,				
	CUSTOMCOLFILTER_DATE_TIME_LIST_IS				= CUSTOMCOLFILTER_DATE_TIME_LIST_BEGIN,
	CUSTOMCOLFILTER_DATE_TIME_LIST_IS_NOT,
	CUSTOMCOLFILTER_DATE_TIME_LIST_AFTER,
	CUSTOMCOLFILTER_DATE_TIME_LIST_ON_OR_AFTER,
	CUSTOMCOLFILTER_DATE_TIME_LIST_BEFORE,
	CUSTOMCOLFILTER_DATE_TIME_LIST_ON_OR_BEFORE,	
	CUSTOMCOLFILTER_DATE_TIME_LIST_MONTH_IS,
	CUSTOMCOLFILTER_DATE_TIME_LIST_DAY_OF_WEEK_IS,	
	CUSTOMCOLFILTER_DATE_TIME_LIST_END,
};

#define _SMALL_DATA_TIME							0

//virtual 
string	ColFilterDateTimeDlg::GetDlgTitle(bool bAdv)
{
	string strTitle;
	strTitle.Format(ColFilterBaseDlg::GetDlgTitle(bAdv), bAdv? _L("Advanced Date Time") : _L("Simple Date Time"));
	return strTitle;
}

BOOL	ColFilterDateTimeDlg::OnInitPage()
{	
	m_cmbCondition1	= GetItem(IDC_COMBO_CONDITION_1);
	
	m_gridList1.Init(IDC_MONTH_LIST1, *this);
	
	m_cmbCondition2	= GetItem(IDC_COMBO_CONDITION_2);
	
	m_gridList2.Init(IDC_MONTH_LIST2, *this);
	
	
	
	Control ctrlTemp= GetItem(IDC_DATE_PICKER1);
	m_DateCtrl1.SetDateTimeStyle(TRUE);
	m_DateCtrl1.CreateControl(ctrlTemp.GetSafeHwnd());
	
	ctrlTemp		= GetItem(IDC_TIME_PICKER1);
	m_TimeCtrl1.SetDateTimeStyle(FALSE);
	m_TimeCtrl1.CreateControl(ctrlTemp.GetSafeHwnd());
	
	ctrlTemp		= GetItem(IDC_DATE_PICKER2);
	m_DateCtrl2.SetDateTimeStyle(TRUE);
	m_DateCtrl2.CreateControl(ctrlTemp.GetSafeHwnd());
	
	ctrlTemp		= GetItem(IDC_TIME_PICKER2);
	m_TimeCtrl2.SetDateTimeStyle(FALSE);
	m_TimeCtrl2.CreateControl(ctrlTemp.GetSafeHwnd());
	
	
	
	CheckRadioButton(IDC_RADIO_ADD, IDC_RADIO_OR, IDC_RADIO_ADD);	
	
	ColFilterBaseDlg::OnInitPage();
	
	///Jasmine 07/18/2012 ORG-5851-S3 ADD_DATE_TIME_FILTER_HINTS
	Control cTip = GetItem(IDC_STATIC_EXP_TIPS_2);
	if(cTip)
	{
		cTip.Text.Format("    Year(%s) = 2012 and (Month(%s) = 7 or Month(%s) = 8)", STR_COLUMN_FILTER_THIS_COLUMN, STR_COLUMN_FILTER_THIS_COLUMN, STR_COLUMN_FILTER_THIS_COLUMN);
		///End EQUAL_SIGN_IS_FULL_MATCH_WHILE_LIKE_IS_WILDCAST_COMPARISON
	}
	///End ADD_DATE_TIME_FILTER_HINTS
	
	return TRUE;
}

/// Zech 06/28/2012 ORG-5638-P12 FIX_CONSTRCT_COL_FILTER_QUERY_DATA
/*
///Jasmine 05/16/2012 ORG-5668-S1 CONSTRUCT_QUERY_STRING_FROM_SIMPLE_MODE
#define _DATETIME_DLG_FILL_M_DATA							\
	int 	nObjType1, nFormulaType1;						\
	string 	strValue1;										\
	double 	dValue1;										\
	DWORD	dwOption1;										\
	bool bHasCondition1 = GUIToCondition(m_cmbCondition1.GetCurSel(), m_DateCtrl1.GetValue(), m_TimeCtrl1.GetValue(), &m_gridList1, nObjType1, nFormulaType1, strValue1, dValue1, dwOption1);	\
	m_data.cond[0].nObjType			= nObjType1;			\
	m_data.cond[0].nFormulaType		= nFormulaType1;		\
	m_data.cond[0].lpcszValue		= strValue1;			\
	m_data.cond[0].dValue			= dValue1;				\
	m_data.cond[0].dwOption			= dwOption1;			\
															\
	int 	nObjType2, nFormulaType2, ii = bHasCondition1? 1 : 0; \
	string 	strValue2;										\
	double 	dValue2;										\
	DWORD	dwOption2;										\
	bool bHasCondition2 = GUIToCondition(m_cmbCondition2.GetCurSel(), m_DateCtrl2.GetValue(), m_TimeCtrl2.GetValue(), &m_gridList2, nObjType2, nFormulaType2, strValue2, dValue2, dwOption2);	\
	m_data.cond[ii].nObjType		= nObjType2;			\
	m_data.cond[ii].nFormulaType	= nFormulaType2;		\
	m_data.cond[ii].lpcszValue		= strValue2;			\
	m_data.cond[ii].dValue			= dValue2;				\
	m_data.cond[ii].dwOption		= dwOption2;			\
															\	
	int nRadioChecked = GetCheckedRadioButton(IDC_RADIO_ADD, IDC_RADIO_OR);	\
	if( bHasCondition1 && bHasCondition2 && 0 != nRadioChecked )			\
		m_data.nLogic = nRadioChecked - IDC_RADIO_ADD;						\
	else																	\
		m_data.nLogic = -1;
	
///End CONSTRUCT_QUERY_STRING_FROM_SIMPLE_MODE
*/
void	ColFilterDateTimeDlg::InitQueryData()
{
	m_data.nLogic = CUSTOM_COLUMN_FILTER_LOGIC_ALL_AND;		// By default
	for (int ii = 0; ii < CUSTOM_COLUMN_FILTER_CONDITION_NUM; ++ii)
		m_data.cond[ii].nObjType = CUSTOM_COLUMN_FILTER_OBJECT_NONE;
}

bool	ColFilterDateTimeDlg::UpdateQueryData(bool& bHasAnyCondition)
{
	InitQueryData();
	
	int 	nObjType1, nFormulaType1;
	double 	dValue1;
	DWORD	dwOption1;
	bool bHasCondition1 = GUIToCondition(m_cmbCondition1.GetCurSel(), m_DateCtrl1.GetValue(), m_TimeCtrl1.GetValue(), &m_gridList1, nObjType1, nFormulaType1, m_strValue1, dValue1, dwOption1);
	m_data.cond[0].nObjType			= nObjType1;
	m_data.cond[0].nFormulaType		= nFormulaType1;
	m_data.cond[0].lpcszValue		= m_strValue1;
	m_data.cond[0].dValue			= dValue1;
	m_data.cond[0].dwOption			= dwOption1;
	
	int 	nObjType2, nFormulaType2, ii = bHasCondition1? 1 : 0;
	string 	&strValue2 = 1 == ii ? m_strValue2 : m_strValue1;
	double 	dValue2;
	DWORD	dwOption2;
	bool bHasCondition2 = GUIToCondition(m_cmbCondition2.GetCurSel(), m_DateCtrl2.GetValue(), m_TimeCtrl2.GetValue(), &m_gridList2, nObjType2, nFormulaType2, strValue2, dValue2, dwOption2);
	m_data.cond[ii].nObjType		= nObjType2;
	m_data.cond[ii].nFormulaType	= nFormulaType2;
	m_data.cond[ii].lpcszValue		= strValue2;
	m_data.cond[ii].dValue			= dValue2;
	m_data.cond[ii].dwOption		= dwOption2;
	
	int nRadioChecked = GetCheckedRadioButton(IDC_RADIO_ADD, IDC_RADIO_OR);
	if( bHasCondition1 && bHasCondition2 && 0 != nRadioChecked )
		m_data.nLogic = nRadioChecked - IDC_RADIO_ADD;
	
	bHasAnyCondition = bHasCondition1 || bHasCondition2;
	return TRUE;
}
/// END FIX_CONSTRCT_COL_FILTER_QUERY_DATA

//virtual
BOOL	ColFilterDateTimeDlg::OnApply(Control ctrl)
{
	if( ColFilterBaseDlg::OnApply(ctrl) )
		return TRUE;
	
	if( isApplied() )
		return TRUE;

	UndoBlock 	block;			///Jasmine 05/22/2012 ORG-5524-P1 UNDO_SETFILTER_AND_RUNUFILTER_IN_ONE_TIME
	BOOL 		bRet = FALSE;
	
	/// Zech 06/28/2012 ORG-5638-P12 FIX_CONSTRCT_COL_FILTER_QUERY_DATA
	/*
	_DATETIME_DLG_FILL_M_DATA	///Jasmine 05/16/2012 ORG-5668-S1 CONSTRUCT_QUERY_STRING_FROM_SIMPLE_MODE
	
	if( !bHasCondition1 && !bHasCondition2 )
	*/
	bool	bHasAnyCondition;
	UpdateQueryData(bHasAnyCondition);
	if(!bHasAnyCondition)
	/// END FIX_CONSTRCT_COL_FILTER_QUERY_DATA
		m_pHolder->m_col.ResetFilter(FALSE);
	else
		m_pHolder->m_col.SetFilter((int)COLUMN_FILTER_TYPE_CUSTOM, (LPVOID)&m_data, TRUE);
	
	Worksheet wks;
	m_pHolder->m_col.GetParent(wks);
	if( wks )
	{
		/// Zech 06/08/2012 ORG-5154-P6 SHOULD_NOT_REAPPLY_WHEN_FILTER_DISABLED
		if (!m_pHolder->m_col.IsFilterDisabled())
		/// END SHOULD_NOT_REAPPLY_WHEN_FILTER_DISABLED
			wks.RunFilter(0, 0, -1, true);//wks.RunFilter();		///Jasmine 05/22/2012 ORG-5524-P1 UNDO_SETFILTER_AND_RUNUFILTER_IN_ONE_TIME
		
		onAfterApply();
		bRet = TRUE;
	}
	
	return bRet;
}

///Jasmine 05/16/2012 ORG-5668-S1 CONSTRUCT_QUERY_STRING_FROM_SIMPLE_MODE
//virtual 
void	ColFilterDateTimeDlg::ConstructQueryString()
{
	/// Zech 06/28/2012 ORG-5638-P12 FIX_CONSTRCT_COL_FILTER_QUERY_DATA
	/*
	_DATETIME_DLG_FILL_M_DATA
	
	if(bHasCondition1 || bHasCondition2)
	*/
	bool	bHasAnyCondition;
	UpdateQueryData(bHasAnyCondition);
	if(bHasAnyCondition)
	/// END FIX_CONSTRCT_COL_FILTER_QUERY_DATA
	{
		/// Zech 07/12/2012 ORG-6205-P1 BETTER_SUPPORT_ON_COLUMN_FILTER_PRESCRIPT
		//m_pHolder->m_col.GetFilterQueryString(strQuery, (int)COLUMN_FILTER_TYPE_CUSTOM, (LPVOID)&m_data, m_strSpecVar);
#ifdef __DATETIME_COLUMN_FILTER_SUPPORT_ADVANCED_CONVERTION__
		string 	strQuery, strBeforeScript;		
		m_pHolder->m_col.GetFilterQueryInfo(&strQuery, &strBeforeScript, (int)COLUMN_FILTER_TYPE_CUSTOM, (LPVOID)&m_data, m_strSpecVar);
		/// END BETTER_SUPPORT_ON_COLUMN_FILTER_PRESCRIPT
		int 	nLen = strQuery.GetLength();
		if(nLen > MAX_BUFFER_SIZE) 
		{ 
			warning_msg_box(CFERR_CHECK_LIST_TOO_LONG_TO_DISPLAY_IN_ADVANCED_MODE, false); 
			return; 
		} 
		
		m_edCommand.Text = strQuery;
		/// Zech 07/12/2012 ORG-6205-P1 BETTER_SUPPORT_ON_COLUMN_FILTER_PRESCRIPT
		m_edBeforeScript.Text = strBeforeScript;
#else
		warning_msg_box(OWARNING_NO_SUPPORT_CVT_DATE_TIME_COL_FILTER_DATA_TO_QUERY_STR, false);
#endif //__DATETIME_COLUMN_FILTER_SUPPORT_ADVANCED_CONVERTION__
		/// END BETTER_SUPPORT_ON_COLUMN_FILTER_PRESCRIPT
	}
	else
		m_edCommand.Text = "";
}
///End CONSTRUCT_QUERY_STRING_FROM_SIMPLE_MODE

BOOL	ColFilterDateTimeDlg::OnMethodChange(Control ctrl)
{
	///Jasmine 05/21/2012 ORG-5638-S1 ERROR_CHECK_FOR_EMPTY_COMBO_ITEM
	//return changeGUIbyMethod(ctrl) && OnControlChange(ctrl);
	OnComboChange(ctrl);
	return changeGUIbyMethod(ctrl);
	///End ERROR_CHECK_FOR_EMPTY_COMBO_ITEM
}

LRESULT	ColFilterDateTimeDlg::OnDateTimeCtrlChange(WPARAM wParam, LPARAM lParam)
{
	//out_str("OnDateTimeCtrlChange");
	vector<int> 	vnDataTimeCtrls = {IDC_DATE_PICKER1, IDC_DATE_PICKER2, IDC_TIME_PICKER1, IDC_TIME_PICKER2};
	vector<uint>	vnIndex;
	if(vnDataTimeCtrls.Find(vnIndex, (int)wParam) > 0)
	{
		Control junk;
		OnControlChange(junk);
	}
	
	return 0;
}

//virtual 
int		ColFilterDateTimeDlg::GetCheckMenuCategoryIDs(Menu& menu, vector<uint>& vncatagoryIDs)
{	
	m_menu.RemoveMenu(5, MF_BYPOSITION);//Fitting Functions
	m_menu.RemoveMenu(4, MF_BYPOSITION);//Distributions
	m_menu.RemoveMenu(3, MF_BYPOSITION);//Statistics
	m_menu.RemoveMenu(1, MF_BYPOSITION);//Math
	m_menu.RemoveMenu(0, MF_BYPOSITION);//String
	
	vector<uint> vnCategoris = {
		IDC_FUNCTION_MENU_DATE_TIME, 
		IDC_FUNCTION_MENU_USER_DEFINED,
		IDC_FUNCTION_MENU_FAVORITE
	};
	
	vncatagoryIDs = vnCategoris;
	return vncatagoryIDs.GetSize();
}
	
//virtual 
void 	ColFilterDateTimeDlg::GetSimpleControls(vector<uint>& vnIDs)
{	
	bool bAdv 		= m_btnAdv.Check;
	
	vector<uint> vn = {IDC_COMBO_CONDITION_1};
	
	if(bAdv)
	{
		vn.Add(IDC_MONTH_LIST1);
		vn.Add(IDC_DATE_PICKER1); 	vn.Add(IDC_TIME_PICKER1);
	}
	else
	{
		if( CUSTOMCOLFILTER_DATE_TIME_LIST_MONTH_IS == m_cmbCondition1.GetCurSel() 
			|| CUSTOMCOLFILTER_DATE_TIME_LIST_DAY_OF_WEEK_IS == m_cmbCondition1.GetCurSel() )
			vn.Add(IDC_MONTH_LIST1);
		else
		{
			vn.Add(IDC_DATE_PICKER1); 	vn.Add(IDC_TIME_PICKER1);
		}
	}
	
	vn.Add(IDC_RADIO_ADD); 			vn.Add(IDC_RADIO_OR); 
	vn.Add(IDC_COMBO_CONDITION_2);
	
	if(bAdv)
	{
		vn.Add(IDC_MONTH_LIST2);
		vn.Add(IDC_DATE_PICKER2); 	vn.Add(IDC_TIME_PICKER2);
	}
	else
	{
		if( CUSTOMCOLFILTER_DATE_TIME_LIST_MONTH_IS == m_cmbCondition2.GetCurSel() 
			|| CUSTOMCOLFILTER_DATE_TIME_LIST_DAY_OF_WEEK_IS == m_cmbCondition2.GetCurSel() )
			vn.Add(IDC_MONTH_LIST2);
		else
		{
			vn.Add(IDC_DATE_PICKER2); 	vn.Add(IDC_TIME_PICKER2);
		}
	}
	
	vn.Add(0);
	vnIDs = vn;	
}

//virtual 
void 	ColFilterDateTimeDlg::GetAdvControls(vector<uint>& vnIDs)
{
	vector<uint> vn = {
		IDC_TEXT_QUERY, 				///Jasmine 05/15/2012 ORG-5668-S5 USE_QUERY_FOR_SIMPLE_AND_ADVANCED_MODE
		IDC_EDIT_COMMAND,
		IDC_BUTTON_FUNC,
		///Jasmine 07/18/2012 ORG-5851-S3 ADD_DATE_TIME_FILTER_HINTS
		IDC_STATIC_EXP_TIPS_1,
		IDC_STATIC_EXP_TIPS_2,
		///End ADD_DATE_TIME_FILTER_HINTS
		///Jasmine 05/15/2012 ORG-5668-S3 ADD_BEFORE_QUERY_SCRIPT
		IDC_TEXT_BEFORE_QUERY,
		IDC_EDIT_BRFORE_QUERY, 	
		///End ADD_BEFORE_QUERY_SCRIPT
		IDC_BUTTON_FUNC2,				///Jasmine 07/10/2012 ORG-6178-P2 ADD_FUNC_MENU_FOR_BEFORE_SCRIPT
		0
	};
	vnIDs = vn;
}

//virtual 
void	ColFilterDateTimeDlg::GetSimpleGroupRect(RECT &rectGroup)
{
	RECT rrTopLeft, rrBottomRight;
	GetControlClientRect(IDC_COMBO_CONDITION_1,	rrTopLeft);
	GetControlClientRect(IDC_MONTH_LIST2, 		rrBottomRight);
	
	rectGroup.left 		= rrTopLeft.left;
	rectGroup.top 		= rrTopLeft.top;
	rectGroup.bottom 	= rrBottomRight.bottom;
	rectGroup.right 	= rrBottomRight.right;	
}

//virtual 
void	ColFilterDateTimeDlg::GetAdvGroupRect(RECT &rectGroup)
{
	RECT rrCommand, rrRightBtn, rrBeforeScript, rrQuery;
	GetControlClientRect(IDC_EDIT_COMMAND, 	rrCommand);
	GetControlClientRect(IDC_BUTTON_FUNC, 	rrRightBtn);
	GetControlClientRect(IDC_TEXT_QUERY, 	rrQuery);				///Jasmine 05/15/2012 ORG-5668-S5 USE_QUERY_FOR_SIMPLE_AND_ADVANCED_MODE
	GetControlClientRect(IDC_EDIT_BRFORE_QUERY, rrBeforeScript);	///Jasmine 05/15/2012 ORG-5668-S3 ADD_BEFORE_QUERY_SCRIPT
	
	
	rectGroup.left 		= rrCommand.left;
	rectGroup.top 		= rrQuery.top;//rrCommand.top;				///Jasmine 05/15/2012 ORG-5668-S5 USE_QUERY_FOR_SIMPLE_AND_ADVANCED_MODE
	rectGroup.bottom 	= rrBeforeScript.bottom;//rrCommand.bottom;	///Jasmine 05/15/2012 ORG-5668-S3 ADD_BEFORE_QUERY_SCRIPT
	rectGroup.right 	= rrRightBtn.right;	
}

///Jasmine 07/18/2012 ORG-5851-S4 DISABLE_CONDITION_CTRLS_WHEN_COMBO_IS_EMPTY
//virtual 
BOOL 	ColFilterDateTimeDlg::EnableCtrlsByComboSel(ComboBox& combo)
{
	int nResID 	= GetDlgCtrlID( combo.GetSafeHwnd() );
	int nID1		=(IDC_COMBO_CONDITION_2 == nResID)? IDC_DATE_PICKER2 : IDC_DATE_PICKER1;
	int nID2		=(IDC_COMBO_CONDITION_2 == nResID)? IDC_TIME_PICKER2 : IDC_TIME_PICKER1;
	GetItem(nID1).Enable = GetItem(nID2).Enable = combo.GetCurSel() != 0;
	return TRUE;
}
///End DISABLE_CONDITION_CTRLS_WHEN_COMBO_IS_EMPTY

//virtual 
void	ColFilterDateTimeDlg::InitFilterControls()
{	
	ColFilterBaseDlg::InitFilterControls();
	
	OnComboChange(m_cmbCondition1);
	OnComboChange(m_cmbCondition2);
	
	if( !m_pHolder->m_col )
		return;
	
	updateDataTimeCtrlFormatByFilterCol(m_pHolder->m_col);
	
	LPVOID data;
	int nType;
	if( !m_pHolder->m_col.GetFilter(nType, &data) 
		|| COLUMN_FILTER_TYPE_CUSTOM != nType)			///Jasmine 06/05/2012 ADVANCED_MODE_SHOULD_ALSO_INIT_SIMPLE_MODE_CTRLS
	{
		m_cmbCondition1.SetCurSel(CUSTOMCOLFILTER_DATE_TIME_LIST_BEGIN);
		m_cmbCondition2.SetCurSel(CUSTOMCOLFILTER_DATE_TIME_LIST_NONE);
		changeGUIbyMethod(m_cmbCondition1);
		changeGUIbyMethod(m_cmbCondition2);
		return;// no filter	
	}
	///Jasmine 06/05/2012 ADVANCED_MODE_SHOULD_ALSO_INIT_SIMPLE_MODE_CTRLS
	//if(COLUMN_FILTER_TYPE_CUSTOM == nType))
	else
	///End ADVANCED_MODE_SHOULD_ALSO_INIT_SIMPLE_MODE_CTRLS
	{
		CustomColumnFilterData* pdata = (CustomColumnFilterData*)data;
		m_data = *pdata;			
		
		conditionToGUI(m_data.cond[0], m_cmbCondition1, &m_DateCtrl1, &m_TimeCtrl1, &m_gridList1);
		conditionToGUI(m_data.cond[1], m_cmbCondition2, &m_DateCtrl2, &m_TimeCtrl2, &m_gridList2);
		
		// And or Or radios
		//CheckRadioButton(IDC_RADIO_ADD, IDC_RADIO_OR, IDC_RADIO_ADD + m_data.nLogic);
		int nIDCheckButton = IDC_RADIO_ADD;
		switch(m_data.nLogic)
		{		
		case CUSTOM_COLUMN_FILTER_LOGIC_ALL_OR:
			nIDCheckButton = IDC_RADIO_OR;
			break;		
		//case CUSTOM_COLUMN_FILTER_LOGIC_ALL_AND:
		default:
			break;			
		}
		CheckRadioButton(IDC_RADIO_ADD, IDC_RADIO_OR, nIDCheckButton);
		
		OnComboChange(m_cmbCondition1);		///Jasmine 05/21/2012 ORG-5638-S1 ERROR_CHECK_FOR_EMPTY_COMBO_ITEM
	}	
}

///Jasmine 03/23/2012 ORG-5638-P6 REDUNDANT_DATE_TIME_DATA_DISTURB_COMPARISON
#define _RESET_HIDDEN_DATETIME_DATA(_CHAR, _ST, _VAL)	\
		nFind = m_strDataTimeFmt.Find(_CHAR);			\
		if(nFind < 0){ _ST = _VAL; /*out_str(_CHAR);*/}	
///End REDUNDANT_DATE_TIME_DATA_DISTURB_COMPARISON

///Jasmine 05/10/2012 ORG-4862-P4 CAREFULLY_USE_FILTER_DATA_STRUCT_LPCSTR
//bool 	ColFilterDateTimeDlg::GUIToCondition(int nComboSel, double dDate, double dTime, GridCheckListControl* pGridList, CustomColumnFilterConditionData& conditionData)
bool 	ColFilterDateTimeDlg::GUIToCondition(int nComboSel, double dDate, double dTime, GridCheckListControl* pGridList, 
											int& nObjType, int& nFormulaType, string& strValue, double& dValue, DWORD& dwOption)
///End CAREFULLY_USE_FILTER_DATA_STRUCT_LPCSTR
{
	if(	CUSTOMCOLFILTER_DATE_TIME_LIST_MONTH_IS == nComboSel
		|| CUSTOMCOLFILTER_DATE_TIME_LIST_DAY_OF_WEEK_IS == nComboSel)
	{
		bool bMonth = CUSTOMCOLFILTER_DATE_TIME_LIST_MONTH_IS == nComboSel;
		nObjType 		= bMonth? CUSTOM_COLUMN_FILTER_OBJECT_MONTH : CUSTOM_COLUMN_FILTER_OBJECT_DAY_OF_WEEK;		
		nFormulaType 	= bMonth? CUSTOM_COLUMN_FILTER_FORMULA_MONTH_IS : CUSTOM_COLUMN_FILTER_FORMULA_DAY_OF_WEEK_IS;
		
		vector<string>	vsFilter;
		vector<int>		vnCheck;
		vector			vIndex;
		int nSize = pGridList->GetCheckList(vsFilter, vnCheck);
		vIndex.Data(0, nSize-1);
		if(bMonth)vIndex += 1;
		vIndex /= vnCheck;
		vIndex.Trim();
		int nRet = vIndex.GetSize();
		if(nRet < 1 || nRet >= nSize)
		{
			nObjType 	= CUSTOM_COLUMN_FILTER_OBJECT_NONE;	
			nFormulaType= CUSTOM_COLUMN_FILTER_FORMULA_NONE;
			strValue	= "";
			dValue		= 0;
			dwOption	= 0;
			return false;
		}
		vsFilter.SetSize(0);
		okutil_convert_double_vector_to_string_vector(&vIndex, &vsFilter, nRet);
		strValue.SetTokens(vsFilter, _STR_CHECK_LIST_SEP);		
		dwOption	= 0;
		
		return true;
	}
	else if( nComboSel < CUSTOMCOLFILTER_DATE_TIME_LIST_BEGIN || nComboSel > CUSTOMCOLFILTER_DATE_TIME_LIST_END )
	{
		nObjType 	= CUSTOM_COLUMN_FILTER_OBJECT_NONE;	
		nFormulaType= CUSTOM_COLUMN_FILTER_FORMULA_NONE;
		strValue	= "";
		dValue		= 0;
		dwOption	= 0;
		return false;
	}
	
	dwOption 		= CUSTOM_COLUMN_FILTER_OPTION_USING_DOUBLE;		///Jasmine 05/08/2012 ORG-5638-P1 FIX_CUSTOM_COLUMN_FILTER_WHEN_DATA_CONDITION_USE_DOUBLE
	nObjType 		= FILTER_COL_ONLY_TIME_DATA == m_ColData ? CUSTOM_COLUMN_FILTER_OBJECT_TIME : CUSTOM_COLUMN_FILTER_OBJECT_DATE;
	nFormulaType 	= nComboSel - CUSTOMCOLFILTER_DATE_TIME_LIST_BEGIN + (FILTER_COL_ONLY_TIME_DATA == m_ColData ? CUSTOM_COLUMN_FILTER_FORMULA_TIME_BEGIN : CUSTOM_COLUMN_FILTER_FORMULA_DATE_BEGIN);
	double date 	= floor(dDate), time = dTime - floor(dTime);
	dValue 			= (FILTER_COL_ONLY_TIME_DATA == m_ColData ? 0 : date) + (FILTER_COL_ONLY_DATE_DATA == m_ColData ? 0 : time);	
	//printf("date = %s\ntime = %s\n%d+%d:dValue = %s\n", ftoa(date), ftoa(time), (int)(FILTER_COL_ONLY_TIME_DATA != m_ColData), (int)(FILTER_COL_ONLY_DATE_DATA != m_ColData), ftoa(dValue));//debug
	///Jasmine 03/23/2012 ORG-5638-P6 REDUNDANT_DATE_TIME_DATA_DISTURB_COMPARISON
	if( !m_strDataTimeFmt.IsEmpty() )
	{
		SYSTEMTIME st;
		if( JulianDateToSystemTime(&dValue, &st) )
		{
			//---test
			//out_int("wYear = ", (int)st.wYear); out_int("wMonth = ", (int)st.wMonth); out_int("wDayOfWeek = ", (int)st.wDayOfWeek); out_int("wDay = ", (int)st.wDay);
			//out_int("wHour = ", (int)st.wHour); out_int("wMinute = ",(int)st.wMinute);out_int("wSecond = ", (int)st.wSecond); out_int("wMilliseconds = ", (int)st.wMilliseconds);
			//---
			
			int nFind;
			if(FILTER_COL_NORMAL_DATE_TIME_DATA == m_ColData || FILTER_COL_ONLY_DATE_DATA == m_ColData)
			{
				_RESET_HIDDEN_DATETIME_DATA("y", 	st.wYear, 	0)
				_RESET_HIDDEN_DATETIME_DATA("M", 	st.wMonth, 	1)	///Jasmine 06/01/2012 ORG-5851-P1 SYSTEM_TIME_RULE
				
				//d & dd are day of month while ddd & dddd are day of week
				string strBackup = m_strDataTimeFmt;				
				_RESET_HIDDEN_DATETIME_DATA("ddd",	st.wDayOfWeek, 1)
				m_strDataTimeFmt.Replace("dddd", "");	
				m_strDataTimeFmt.Replace("ddd",  "");				
				_RESET_HIDDEN_DATETIME_DATA("d",	st.wDay, 	1)				
				m_strDataTimeFmt = strBackup;
			}
			
			if(FILTER_COL_NORMAL_DATE_TIME_DATA == m_ColData || FILTER_COL_ONLY_TIME_DATA == m_ColData)
			{
				if(m_strDataTimeFmt.Find("h", 0, FALSE) < 0)
				{
					_RESET_HIDDEN_DATETIME_DATA("h", st.wHour, 	0)
					_RESET_HIDDEN_DATETIME_DATA("H", st.wHour, 	0)
				}
				_RESET_HIDDEN_DATETIME_DATA("m", st.wMinute, 	0)
				_RESET_HIDDEN_DATETIME_DATA("s", st.wSecond, 	0)
				_RESET_HIDDEN_DATETIME_DATA("#", st.wMilliseconds, 0)
			}
			
			SystemTimeToJulianDate(&dValue, &st); 
			//test
			//out_double("dValue = ", dValue);	
			//SYSTEMTIME st2;
			//JulianDateToSystemTime(&dValue, &st2);
		}
	}
	///End REDUNDANT_DATE_TIME_DATA_DISTURB_COMPARISON
	
	
	return true;
}

bool	ColFilterDateTimeDlg::conditionToGUI(CustomColumnFilterConditionData& conditionData, ComboBox& cmbFormula, DateTimeCtrl* pDateCtrl, DateTimeCtrl* pTimeCtrl, GridCheckListControl* pGridList)
{		
	///Jasmine 05/29/2012 ORG-5638-P9 FILTER_DATA_AND_COMBO_SHOULD_BE_EMPTY_IN_CONSISTENCE
	cmbFormula.SetCurSel(CUSTOMCOLFILTER_DATE_TIME_LIST_NONE);
	///End FILTER_DATA_AND_COMBO_SHOULD_BE_EMPTY_IN_CONSISTENCE

	int nObjType 		= conditionData.nObjType;	
	int nFormulaType	= conditionData.nFormulaType;	
	
	switch(nObjType)
	{
	case CUSTOM_COLUMN_FILTER_OBJECT_TIME:
	case CUSTOM_COLUMN_FILTER_OBJECT_DATE:
		int nComboSel = nFormulaType - (CUSTOM_COLUMN_FILTER_OBJECT_DATE == nObjType? CUSTOM_COLUMN_FILTER_FORMULA_DATE_BEGIN : CUSTOM_COLUMN_FILTER_FORMULA_TIME_BEGIN) + CUSTOMCOLFILTER_DATE_TIME_LIST_BEGIN;
		if( nComboSel >= CUSTOMCOLFILTER_DATE_TIME_LIST_BEGIN && nComboSel < CUSTOMCOLFILTER_DATE_TIME_LIST_END )		
		{
			cmbFormula.SetCurSel(nComboSel);
			changeGUIbyMethod(cmbFormula, "");
			
			//double dDate = floor(conditionData.dValue);		
			//double dTime = conditionData.dValue - dDate;	
			//printf("dValue = %s\ndDate = %s\ndTime = %s\n", ftoa(conditionData.dValue), ftoa(dDate), ftoa(dTime));//debug
			pDateCtrl->SetValue(conditionData.dValue);	
			pTimeCtrl->SetValue(conditionData.dValue);
		}
		break;	
		
	case CUSTOM_COLUMN_FILTER_OBJECT_MONTH:
		//if( nFormulaType >= CUSTOM_COLUMN_FILTER_FORMULA_MONTH_BEGIN && nFormulaType <= CUSTOM_COLUMN_FILTER_FORMULA_MONTH_END )		
		if(CUSTOM_COLUMN_FILTER_FORMULA_MONTH_IS == nFormulaType)
		{
			cmbFormula.SetCurSel(CUSTOMCOLFILTER_DATE_TIME_LIST_MONTH_IS);
			changeGUIbyMethod(cmbFormula, conditionData.lpcszValue);
		}
		break;
		
	case CUSTOM_COLUMN_FILTER_OBJECT_DAY_OF_WEEK:
		//if( nFormulaType >= CUSTOM_COLUMN_FILTER_FORMULA_DAY_OF_WEEK_BEGIN && nFormulaType <= CUSTOM_COLUMN_FILTER_FORMULA_DAY_OF_WEEK_END )		
		if(CUSTOM_COLUMN_FILTER_FORMULA_DAY_OF_WEEK_IS == nFormulaType)
		{
			cmbFormula.SetCurSel(CUSTOMCOLFILTER_DATE_TIME_LIST_DAY_OF_WEEK_IS);
			changeGUIbyMethod(cmbFormula, conditionData.lpcszValue);
		}
		break;
		
	default://CUSTOM_COLUMN_FILTER_OBJECT_NONE
		cmbFormula.SetCurSel(CUSTOMCOLFILTER_DATE_TIME_LIST_NONE);
		return changeGUIbyMethod(cmbFormula);
	}
	
	 return true;	
}
	
bool	ColFilterDateTimeDlg::changeGUIbyMethod(Control ctrl, LPCSTR lpczValue/* = NULL*/)
{
	int 		nResID 	= GetDlgCtrlID( ctrl.GetSafeHwnd() );
	ComboBox 	box 	= GetItem(nResID);
	Control		ctrlDate, ctrlTime;
	GridCheckListControl* pGrid = NULL;
	if(IDC_COMBO_CONDITION_1 == nResID)
	{
		ctrlDate 	= GetItem(IDC_DATE_PICKER1);	ctrlTime = GetItem(IDC_TIME_PICKER1);
		pGrid 		= &m_gridList1;
	}
	else if( IDC_COMBO_CONDITION_2 == nResID)
	{
		ctrlDate 	= GetItem(IDC_DATE_PICKER2);	ctrlTime = GetItem(IDC_TIME_PICKER2);
		pGrid 		= &m_gridList2;
	}
	else
	{
		return TRUE;
	}
	
	bool			bCheckList = false;
	vector<string>	vsList;
	if(CUSTOMCOLFILTER_DATE_TIME_LIST_DAY_OF_WEEK_IS == box.GetCurSel())
	{
		bCheckList = true;
		
		vsList.SetSize(7);
		int nDay = 0;
		vsList[nDay++] = _L("Sunday");		vsList[nDay++] = _L("Monday");	vsList[nDay++] = _L("Tuesday");		vsList[nDay++] = _L("Wednesday");	
		vsList[nDay++] = _L("Thursday");	vsList[nDay++] = _L("Friday");	vsList[nDay++] = _L("Saturday");		
	}
	else if(CUSTOMCOLFILTER_DATE_TIME_LIST_MONTH_IS == box.GetCurSel())
	{
		bCheckList = true;
		
		vsList.SetSize(12);
		int nMonth = 0;
		vsList[nMonth++] = _L("January");	vsList[nMonth++] = _L("February");	vsList[nMonth++] = _L("March");
		vsList[nMonth++] = _L("April");		vsList[nMonth++] = _L("May");		vsList[nMonth++] = _L("June");
		vsList[nMonth++] = _L("July");		vsList[nMonth++] = _L("August");	vsList[nMonth++] = _L("September");
		vsList[nMonth++] = _L("October");	vsList[nMonth++] = _L("November");	vsList[nMonth++] = _L("December");
	}
	
	ctrlDate.Visible = ctrlTime.Visible = !bCheckList;
	
	if(pGrid != NULL)
	{    
		pGrid->SetVisible(bCheckList);
			
		if(bCheckList)
		{
			vector<int> vnChecks( vsList.GetSize() );
			vnChecks = 0;
			
			if(lpczValue != NULL && lstrlen(lpczValue) > 0)
			{
				vector<string>	vsTokens;
				vector<uint> 	vIndex;  
				okutil_get_tokens(lpczValue, &vsTokens, _STR_CHECK_LIST_SEP, NULL);  
				convert_string_vector_to_uint_vector(vsTokens, vIndex);
				if(CUSTOMCOLFILTER_DATE_TIME_LIST_MONTH_IS == box.GetCurSel())
					vIndex -= 1;				
				int nRet = vnChecks.Replace(vIndex, 1);      
			}
			
			pGrid->Update(vsList, vnChecks);
		}
	}
	
	return TRUE;
}

void 	ColFilterDateTimeDlg::updateDataTimeCtrlFormatByFilterCol(const Column& colFilter)
{
	bool	bForDateTimePicker = true;
	string 	strDispFmt, strDateDispFmt = "MM/dd/yyyy", strTimeDispFmt = "HH:mm:ss";
	int 	nLTFormat = get_lt_datetime_display_format(colFilter, strDispFmt, bForDateTimePicker);
	//printf("nLTFormat = %d, bForDateTimePicker = %d, strDispFmt = %s\n", nLTFormat, (int)bForDateTimePicker, strDispFmt);//test
	if(bForDateTimePicker)
	{
		if(LT_FORMAT_TIME  == nLTFormat)
		{
			strTimeDispFmt = strDispFmt;
		}
		else if(LT_FORMAT_DATE == nLTFormat)
		{
			vector<string> vsTimeKey = {"H", "h", "m", "s", "#"};
			int nFind = -1;
			for(int ii = 0; ii < vsTimeKey.GetSize(); ii++)
			{
				nFind = strDispFmt.Find( vsTimeKey[ii] );
				if(nFind >= 0)
					break;
			}
			if(nFind >= 0)
			{
				if(nFind > 0) strDateDispFmt = strDispFmt.Left(nFind);				
				strTimeDispFmt = strDispFmt.Mid(nFind);
			}
			else
			{
				strDateDispFmt = strDispFmt;
			}
		}
		m_DateCtrl1.SetDisplayFormat(strDateDispFmt);	m_TimeCtrl1.SetDisplayFormat(strTimeDispFmt);
		m_DateCtrl2.SetDisplayFormat(strDateDispFmt);	m_TimeCtrl2.SetDisplayFormat(strTimeDispFmt);
		m_strDataTimeFmt = strDateDispFmt + " " + strTimeDispFmt;			///Jasmine 03/23/2012 ORG-5638-P6 REDUNDANT_DATE_TIME_DATA_DISTURB_COMPARISON
		//out_str(m_strDataTimeFmt);//test
	}
	///Jasmine 03/23/2012 ORG-5638-P6 REDUNDANT_DATE_TIME_DATA_DISTURB_COMPARISON
	else
	{
		m_strDataTimeFmt = "";
	}
	///End REDUNDANT_DATE_TIME_DATA_DISTURB_COMPARISON
	
	Dataset dsFilterCol(colFilter);
	vector	vData, vI, vD;
	vData 	= dsFilterCol;
	vI 		= floor(vData);
	vD 		= vData - vI;
	m_ColData = FILTER_COL_NORMAL_DATE_TIME_DATA;
	if(max(vI) <= _SMALL_DATA_TIME) 
		m_ColData = FILTER_COL_ONLY_TIME_DATA;
	if(max(vD) <= _SMALL_DATA_TIME) 
		m_ColData = FILTER_COL_ONLY_DATE_DATA;
	m_DateCtrl1.Enable = m_DateCtrl2.Enable = FILTER_COL_NORMAL_DATE_TIME_DATA == m_ColData || FILTER_COL_ONLY_DATE_DATA == m_ColData;
	m_TimeCtrl1.Enable = m_TimeCtrl2.Enable = FILTER_COL_NORMAL_DATE_TIME_DATA == m_ColData || FILTER_COL_ONLY_TIME_DATA == m_ColData;
	if(!m_TimeCtrl1.Enable)
	{
		m_TimeCtrl1.SetValue(2456070); m_TimeCtrl2.SetValue(2456070);//no time data
	}
}

///Jasmine 07/18/2012 ORG-6252-P1 HIDE_NAVIGATE_BTNS
#ifndef _ALLOW_NAVIGATE_TO_OTHER_COL
//virtual 
int		ColFilterDateTimeDlg::GetMinClientWidth()
{	
	RECT rr;
	GetControlClientRect(IDC_DATE_PICKER1, rr);
	return rr.right + _DLG_GAP*4;
}
#endif //_ALLOW_NAVIGATE_TO_OTHER_COL
///End HIDE_NAVIGATE_BTNS

///Jasmine 05/09/2012 ORG-4862-S6 MAKE_COLFILTER_DLG_RESIZABLE	
//virtual
void	ColFilterDateTimeDlg::OnDlgResize(int nType, int nRight, int nBottom)
{
	bool bAdv = m_btnAdv.Check;
	if(bAdv)
	{
		ColFilterBaseDlg::OnDlgResize(nType, nRight, nBottom);
		return;
	}
	
	MoveControlsHelper clCacheWndPosHelper(this);
	
	RECT 	rrAdv;
	GetControlClientRect(IDC_CHECK_ADVANCED,	rrAdv);
	
	int		nDx	= nRight - _DLG_GAP - rrAdv.right;
	int		nDy = nBottom - _DLG_GAP - rrAdv.bottom;	
	
	vector<uint> vnIDs = {IDC_CHECK_ADVANCED, 0};
	MoveControls(vnIDs, nDx, nDy);
	
	///Jasmine 06/01/2012 ORG-5851-S2 SHOW_ALL_MONTH_ITEMS	
	RECT 	rrList1, rrList2, rrCombo;
	Control	cList1, cList2;
	GetControlClientRect(IDC_MONTH_LIST1,		rrList1, &cList1);
	GetControlClientRect(IDC_COMBO_CONDITION_2,	rrCombo);
	
	int nNewHeight = (nBottom - rrList1.top - _DLG_GAP * 3 - RECT_HEIGHT(rrAdv)) * 0.5;
	rrList1.bottom = rrList1.top + nNewHeight;
	MoveControl(cList1, rrList1);	
	
	vector<uint> vnIDs2 = {	IDC_RADIO_ADD, IDC_RADIO_OR, 
							IDC_COMBO_CONDITION_2, IDC_DATE_PICKER2, IDC_TIME_PICKER2, 
							IDC_MONTH_LIST2, 0};
	MoveControls(vnIDs2, 0, rrList1.bottom + _DLG_GAP - rrCombo.top);	
	
	GetControlClientRect(IDC_MONTH_LIST2,		rrList2, &cList2);
	rrList2.bottom = rrList2.top + nNewHeight;
	MoveControl(cList2, rrList2);	
	///End SHOW_ALL_MONTH_ITEMS	
}
///End MAKE_COLFILTER_DLG_RESIZABLE

///Jasmine 07/18/2012 ORG-5851-S3 ADD_DATE_TIME_FILTER_HINTS
//virtual 
int		ColFilterDateTimeDlg::GetQueryTipsIDs(vector<uint>& vnIDs)
{
	vector<uint> vnTemp = {	IDC_STATIC_EXP_TIPS_1, 		IDC_STATIC_EXP_TIPS_2, 		
							IDC_TEXT_BEFORE_QUERY, 		0};
	vnIDs = vnTemp;
	return vnIDs.GetSize();
}
///End ADD_DATE_TIME_FILTER_HINTS

/***********************************************************************
**********************  ColFilterDateTimeDlg End  **********************
************************************************************************/
