/*------------------------------------------------------------------------------*
 * File Name: CustomColFilterDlg.h 												*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Tony 06/15/2012 ORG-5985-P2 FIX_ALL_RECENT_FUNC_LIST_IN_DIFF_TYPE			*
 *	Zech 06/28/2012 ORG-5638-P12 FIX_CONSTRCT_COL_FILTER_QUERY_DATA				*
 *------------------------------------------------------------------------------*/

///------ Tony 06/15/2012 ORG-5985-P2 FIX_ALL_RECENT_FUNC_LIST_IN_DIFF_TYPE
#define STR_FUNCTIONS_MENU_FAVORITES_SECTION_TEXT				"TEXT Functions Menu Favorites"
#define STR_FUNCTIONS_MENU_FAVORITES_SECTION_NUM				"NUM Functions Menu Favorites"
///------ FIX_ALL_RECENT_FUNC_LIST_IN_DIFF_TYPE

enum{ CHECK_ALL_TRUE = 0, CHECK_ALL_FALSE, CHECK_ALL_INVERSE }; 
class GridCheckListControl : public GridControl
{
private:
	int		m_nCols;
	int		m_nVarCol;
	int		m_nCheckCol;
	
public:
	void	Init(int nID, WndContainer& dlg, bool bCheckOnLeft = true, bool bFixRow = false);
	void	Update(const vector<string>& vsVariables, const vector<int>& vnChecks);
	int		GetCheckList(vector<string>& vsVariables, vector<int>& vnChecks);
	bool	CheckAll(int nCheckType);
	
	void	OnBeforeEditCheckList(int nRow, int nCol, BOOL* pCancel);
};


#define	WM_COLFILTERDLG_USER_MSG_RESIZE_DLG			0x2000
#define _DLG_GAP									5		///Jasmine 05/09/2012 ORG-4862-S6 MAKE_COLFILTER_DLG_RESIZABLE
#define	_STR_CHECK_LIST_SEP							COLUMN_FILTER_CHECK_LIST_SEP


class ColFilterPlaceHolder;
class ColFilterBaseDlg : public PropertyPage
{
public:
	ColFilterBaseDlg(int nID) : PropertyPage(nID){ m_pHolder = NULL; }		
	void 	InitPage(int nID, ColFilterPlaceHolder* pHolder, WndContainer& dlg);
	
	virtual BOOL 	OnInitPage();
	virtual BOOL 	OnActivatePage();
	
	virtual int		GetDataObjType() { ASSERT(false); return -1; }		
	virtual string	GetDlgTitle(bool bAdv){return _L("Custom Filter (%s)");}
	
	bool 	GetControlClientRect(uint nID, RECT& r1, Control* pCntrl = NULL);
	bool 	GetClientRect(Control& cc, RECT& rr);
	void 	MoveControls(uint nIDs[], int nDx, int nDy);
	void 	MoveControl(Control& cc, RECT& rr) {cc.MoveWindow(&rr);}
	void 	ShowControls(const vector<uint>& vn, bool bShow = true);
	int		GetBottomControl();
	///Jasmine 05/09/2012 ORG-4862-S6 MAKE_COLFILTER_DLG_RESIZABLE
	virtual int		GetMinClientWidth();		///Jasmne 07/11/2012 ORG-6178-P1 GET_MIN_TRACK_WIDTH_ON_RIGHTMOST_CTRL
	int		TotalHeight(uint nIDs[]);
	void	Resize(int nType, int nRight, int nBottom);			
	virtual void	OnDlgResize(int nType, int nRight, int nBottom);
	virtual int		GetQueryTipsIDs(vector<uint>& vnIDs);
	///End MAKE_COLFILTER_DLG_RESIZABLE

	virtual BOOL	OnApply(Control ctrl);
	
	virtual void	CheckEnableApplyBtn(){return;}				///Jasmine 05/09/2012 ORG-4862-P4 OPEN_CUSTOM_FILTER_DLG_FROM_CHECK_LIST_MORE_SHOULD_UPDATE_DIALOG_CHECK_LIST
	
protected:
	bool	isApplied(){return m_wndParent.GetDlgItem(IDC_APPLY).Enable == false;}
	void 	onAfterApply(){ m_wndParent.GetDlgItem(IDC_APPLY).Enable = false; }
	void 	onAfterChange(){ m_wndParent.GetDlgItem(IDC_APPLY).Enable = true; }
	
	BOOL 	OnVarKillFocus(Control ctrl);				/*Jasmine 05/15/2012 ORG-5668-S2 SPECIFY_VARIABLE_TO_REPRECENT_CURRENT_COL*/
	BOOL	OnAdvButtonCheck(Control ctrl);
	
	BOOL	OnFuncButtonClick(Control ctrl);
	void	InsertFunction(Edit & ed, string & strText);
	string	PopupFunctionMenu(int x, int y);
	BOOL	ConstructMenu();
	virtual int		GetCheckMenuCategoryIDs(Menu& menu, vector<uint>& vncatagoryIDs){ ASSERT(false); return 0;}
		
	BOOL	OnComboChange(Control ctrl);			///Jasmine 05/21/2012 ORG-5638-S1 ERROR_CHECK_FOR_EMPTY_COMBO_ITEM
	virtual BOOL EnableCtrlsByComboSel(ComboBox& combo){ASSERT(0); return FALSE;}	///Jasmine 07/18/2012 ORG-5851-S4 DISABLE_CONDITION_CTRLS_WHEN_COMBO_IS_EMPTY
	
	BOOL	OnFirstColButtonClick(Control ctrl);
	BOOL	OnPreviousColButtonClick(Control ctrl);
	BOOL	OnNextColButtonClick(Control ctrl);
	BOOL	OnLastColButtonClick(Control ctrl);
	bool 	HasPreviousObject();
	bool 	HasNextObject();
	
	virtual BOOL	OnControlChange(Control ctrl);
	
	void	InitCtrlValue();
	void 	InitColInfo();	
	void	ShowHideControls();
	void	ResizeDlgToFitControls();	
	
	virtual void	InitFilterControls();	
	virtual void 	GetSimpleControls(vector<uint>& vnIDs) { ASSERT(false); }
	virtual void 	GetAdvControls(vector<uint>& vnIDs) { ASSERT(false); }
	virtual void	GetSimpleGroupRect(RECT &rectGroup) { ASSERT(false); }
	virtual void	GetAdvGroupRect(RECT &rectGroup) { ASSERT(false); }
	
	virtual void	ConstructQueryString(){ ASSERT(false); }		///Jasmine 05/16/2012 ORG-5668-S1 CONSTRUCT_QUERY_STRING_FROM_SIMPLE_MODE
	
private:		
	bool	gotoCol(int nCol);
	void	moveAdvControls();	
	
protected:
	ColFilterPlaceHolder*			m_pHolder;
	
	CommandColumnFilterData			m_cmddata;
	
	string							m_strFavFunc;		///Tony 06/15/2012 ORG-5985-P2 FIX_ALL_RECENT_FUNC_LIST_IN_DIFF_TYPE
	string							m_strSpecVar;		///Jasmine 05/15/2012 ORG-5668-S2 SPECIFY_VARIABLE_TO_REPRECENT_CURRENT_COL
	
	Window							m_wndParent;
	Button							m_btnAdv;
	Edit							m_edCommand;
	Edit							m_edBeforeScript;	///Jasmine 05/15/2012 ORG-5668-S3 ADD_BEFORE_QUERY_SCRIPT
	CustomColFilterFuncMenu*		m_pMenu;
	Menu							m_menu;
	
	bool							m_bEnable;			///Jasmine 05/21/2012 ORG-5638-S1 ERROR_CHECK_FOR_EMPTY_COMBO_ITEM
	
private:
	Button*							m_pbtnApply;	
};


#define		ON_FILTER_DLG_BASIC_EVENTS 									\
			PAGE_ON_INIT(OnInitPage) 									\
			PAGE_ON_ACTIVE(OnActivatePage) 								\
			ON_BN_CLICKED(IDC_CHECK_ADVANCED, 	OnAdvButtonCheck)		\
			ON_BN_CLICKED(IDC_BUTTON_FUNC, 		OnFuncButtonClick)		\
			ON_BN_CLICKED(IDC_BUTTON_FUNC2, 	OnFuncButtonClick)		\
			ON_BN_CLICKED(IDC_BUTTON_FIRST, 	OnFirstColButtonClick)	\		
			ON_BN_CLICKED(IDC_BUTTON_PREVIOUS, 	OnPreviousColButtonClick)	\
			ON_BN_CLICKED(IDC_BUTTON_NEXT, 		OnNextColButtonClick)	\	
			ON_BN_CLICKED(IDC_BUTTON_LAST, 		OnLastColButtonClick)	\
			ON_EN_CHANGE(IDC_EDIT_COMMAND, 		OnControlChange)		\
			ON_EN_CHANGE(IDC_EDIT_BRFORE_QUERY, OnControlChange)		\	
			ON_EN_KILLFOCUS(IDC_EDIT_REPRESENT_VAR, OnVarKillFocus)	
			
			

			
class ColFilterNumericDlg : public ColFilterBaseDlg
{
public:
	///------ Tony 06/15/2012 ORG-5985-P2 FIX_ALL_RECENT_FUNC_LIST_IN_DIFF_TYPE
	//ColFilterNumericDlg() : ColFilterBaseDlg(IDD_COL_FILTER_NUMERIC_DLG) {}	
	ColFilterNumericDlg() : ColFilterBaseDlg(IDD_COL_FILTER_NUMERIC_DLG) { m_strFavFunc = STR_FUNCTIONS_MENU_FAVORITES_SECTION_NUM; }	
	///------ FIX_ALL_RECENT_FUNC_LIST_IN_DIFF_TYPE
	~ColFilterNumericDlg() {}
	
	//virtual
	int		GetDataObjType() { return CUSTOM_COLUMN_FILTER_OBJECT_NUMERIC; }
	//virtual 
	string	GetDlgTitle(bool bAdv);
	
	//virtual
	BOOL	OnApply(Control ctrl);
	
EVENTS_BEGIN
	ON_FILTER_DLG_BASIC_EVENTS
	ON_BN_CLICKED(IDC_CHECK_ABS_VALUE_1, 	OnControlChange)
	ON_BN_CLICKED(IDC_CHECK_ABS_VALUE_2, 	OnControlChange)
	ON_CBN_SELCHANGE(IDC_COMBO_CONDITION_1, OnComboChange)//OnControlChange		///Jasmine 05/21/2012 ORG-5638-S1 ERROR_CHECK_FOR_EMPTY_COMBO_ITEM
	ON_CBN_SELCHANGE(IDC_COMBO_CONDITION_2, OnComboChange)//OnControlChange		///Jasmine 05/21/2012 ORG-5638-S1 ERROR_CHECK_FOR_EMPTY_COMBO_ITEM
	ON_EN_CHANGE(IDC_COMBO_VALUE_1, 		OnControlChange)
	ON_EN_CHANGE(IDC_COMBO_VALUE_2, 		OnControlChange)
	ON_BN_CLICKED(IDC_RADIO_ADD,  			OnControlChange)
	ON_BN_CLICKED(IDC_RADIO_OR,  			OnControlChange)
EVENTS_END

protected:
	//virtual 
	BOOL 	OnInitPage();
	
protected:	
	//virtual 
	int		GetCheckMenuCategoryIDs(Menu& menu, vector<uint>& vncatagoryIDs);		
	//virtual 
	void 	GetSimpleControls(vector<uint>& vnIDs);
	
	//virtual 
	void 	GetAdvControls(vector<uint>& vnIDs);
	
	//virtual 
	void	GetSimpleGroupRect(RECT &rectGroup);	
	
	//virtual 
	void	GetAdvGroupRect(RECT &rectGroup);
	
	//virtual 
	BOOL 	EnableCtrlsByComboSel(ComboBox& combo);	///Jasmine 07/18/2012 ORG-5851-S4 DISABLE_CONDITION_CTRLS_WHEN_COMBO_IS_EMPTY
	
	//virtual 
	void	InitFilterControls();
	
	//virtual 
	void	ConstructQueryString();		///Jasmine 05/16/2012 ORG-5668-S1 CONSTRUCT_QUERY_STRING_FROM_SIMPLE_MODE
	
	///Jasmine 07/18/2012 ORG-6252-P1 HIDE_NAVIGATE_BTNS
#ifndef _ALLOW_NAVIGATE_TO_OTHER_COL
	//virtual
	int		GetMinClientWidth();
#endif 
	///End HIDE_NAVIGATE_BTNS
	
	///Jasmine 05/09/2012 ORG-4862-S6 MAKE_COLFILTER_DLG_RESIZABLE	
	//virtual
	void	OnDlgResize(int nType, int nRight, int nBottom);	
	//virtual 
	int		GetQueryTipsIDs(vector<uint>& vnIDs);
	///End MAKE_COLFILTER_DLG_RESIZABLE
	
private:	
	bool	clearGUI();
	bool	conditionToGUI(CustomColumnFilterConditionData &conditionData, ComboBox& cmbFormula, Edit& edValue, Button& checkAbs);
	///Jasmine 05/10/2012 ORG-4862-P4 CAREFULLY_USE_FILTER_DATA_STRUCT_LPCSTR
	//bool 	GUIToCondition(int nFormula, LPCSTR lpcszVal, bool bUsingAbs, CustomColumnFilterConditionData& conditionData);	
	bool 	GUIToCondition(int nFormula, LPCSTR lpcszVal, bool bUsingAbs, int& nObjType, int& nFormulaType, string& strValue, DWORD& dwOption);
	///End CAREFULLY_USE_FILTER_DATA_STRUCT_LPCSTR
	/// Zech 06/28/2012 ORG-5638-P12 FIX_CONSTRCT_COL_FILTER_QUERY_DATA	
	void	InitQueryData();
	bool	UpdateQueryData(bool& bHasAnyCondition);
	/// END FIX_CONSTRCT_COL_FILTER_QUERY_DATA
private:
	CustomColumnFilterData	m_data;
	
	ComboBox		m_cmbCondition1;
	ComboBox		m_cmbCondition2;
	Edit			m_edValue1;
	Edit			m_edValue2;
	Button			m_checkAbs1;
	Button			m_checkAbs2;
	/// Zech 06/28/2012 ORG-5638-P12 FIX_CONSTRCT_COL_FILTER_QUERY_DATA
	string			m_strValue1;
	string			m_strValue2;
	/// END FIX_CONSTRCT_COL_FILTER_QUERY_DATA
};

class ColFilterTextDlg : public ColFilterBaseDlg
{
public:
	ColFilterTextDlg() : ColFilterBaseDlg(IDD_COL_FILTER_TEXT_DLG) 
	{
		m_nRetGetDistinctValues	= COLDISTINCTVALUE_OK;
		m_strInputCheckList 	= STR_UNASSIGNED;			///Jasmine 05/09/2012 ORG-4862-P4 OPEN_CUSTOM_FILTER_DLG_FROM_CHECK_LIST_MORE_SHOULD_UPDATE_DIALOG_CHECK_LIST
		m_strFavFunc = STR_FUNCTIONS_MENU_FAVORITES_SECTION_TEXT;			///Tony 06/15/2012 ORG-5985-P2 FIX_ALL_RECENT_FUNC_LIST_IN_DIFF_TYPE
	}	
	~ColFilterTextDlg() {}
	//virtual
	int		GetDataObjType() { return CUSTOM_COLUMN_FILTER_OBJECT_STRING; }	
	//virtual 
	string	GetDlgTitle(bool bAdv);
	
	//virtual 
	BOOL	OnApply(Control ctrl);
	
	//virtual 
	void	CheckEnableApplyBtn();				///Jasmine 05/09/2012 ORG-4862-P4 OPEN_CUSTOM_FILTER_DLG_FROM_CHECK_LIST_MORE_SHOULD_UPDATE_DIALOG_CHECK_LIST
	
EVENTS_BEGIN
	ON_FILTER_DLG_BASIC_EVENTS
	ON_BN_CLICKED(IDC_BUTTON_CHECK_ALL, 	OnCheckAll)
	ON_BN_CLICKED(IDC_BUTTON_TOGGLE_ALL, 	OnCheckAll)
	ON_BN_CLICKED(IDC_BUTTON_CLEAR_ALL, 	OnCheckAll)
	ON_GRID_BEFORE_EDIT(IDC_LIST, 	OnBeforeEditCheckList)
	ON_GRID_AFTER_EDIT(IDC_LIST, 	OnAfterEditCheckList)
EVENTS_END
	
protected:
	//virtual 
	BOOL 	OnInitPage();
	BOOL	OnCheckAll(Control ctrl);
	void	OnBeforeEditCheckList(Control flxControl, int nRow, int nCol, BOOL* pCancel);
	void	OnAfterEditCheckList(Control flxControl, int nRow, int nCol);
	
protected:	
	//virtual 
	int		GetCheckMenuCategoryIDs(Menu& menu, vector<uint>& vncatagoryIDs);

	//virtual 
	void 	GetSimpleControls(vector<uint>& vnIDs);
	
	//virtual 
	void 	GetAdvControls(vector<uint>& vnIDs);
	
	//virtual 
	void	GetSimpleGroupRect(RECT &rectGroup);	
	
	//virtual 
	void	GetAdvGroupRect(RECT &rectGroup);	
	
	//virtual 
	void	InitFilterControls();
	
	//virtual 
	void	ConstructQueryString();		///Jasmine 05/16/2012 ORG-5668-S1 CONSTRUCT_QUERY_STRING_FROM_SIMPLE_MODE
	
	///Jasmine 07/18/2012 ORG-6252-P1 HIDE_NAVIGATE_BTNS
#ifndef _ALLOW_NAVIGATE_TO_OTHER_COL
	//virtual
	int		GetMinClientWidth();
#endif 
	///End HIDE_NAVIGATE_BTNS
	
	///Jasmine 05/09/2012 ORG-4862-S6 MAKE_COLFILTER_DLG_RESIZABLE	
	//virtual
	void	OnDlgResize(int nType, int nRight, int nBottom);	
	//virtual 
	int		GetQueryTipsIDs(vector<uint>& vnIDs);
	///End MAKE_COLFILTER_DLG_RESIZABLE
	
private:
	bool	GUIToCondition(string& strValue);//bool	GUIToCondition(CheckListColumnFilterData& conditionData);	///Jasmine 05/10/2012 ORG-4862-P4 CAREFULLY_USE_FILTER_DATA_STRUCT_LPCSTR
	void 	UpdateOccurrencesText();		///Jasmine 05/15/2012 ORG-4862-S8 COLUMN_DISTINCT_VALUES_NEED_COUNT
	
private:
	CheckListColumnFilterData		m_data;
	GridCheckListControl			m_gridDistinctValues;
	int								m_nRetGetDistinctValues;
	
	string							m_strInputCheckList;		///Jasmine 05/09/2012 ORG-4862-P4 OPEN_CUSTOM_FILTER_DLG_FROM_CHECK_LIST_MORE_SHOULD_UPDATE_DIALOG_CHECK_LIST
};

class ColFilterPlaceHolder : public WizardSheet
{
private:
	///Jasmine 07/18/2012 ORG-6255-S1 SEPARATE_DATE_TIME_CLASS
	ColFilterBaseDlg*				m_pColFilterNumericPage;//ColFilterNumericDlg 			m_ColFilterNumericPage;	
	ColFilterBaseDlg*				m_pColFilterTextPage;//ColFilterTextDlg 				m_ColFilterTextPage;
	ColFilterBaseDlg*				m_pColFilterDateTimePage;//ColFilterDateTimeDlg 			m_ColFilterDateTimePage;
	///End SEPARATE_DATE_TIME_CLASS
	
public:
	CustomFilterDlgData				m_DataStruct;					///Jasmine 05/09/2012 ORG-4862-P4 OPEN_CUSTOM_FILTER_DLG_FROM_CHECK_LIST_MORE_SHOULD_UPDATE_DIALOG_CHECK_LIST
	
	///Jasmine 05/09/2012 ORG-4862-S6 MAKE_COLFILTER_DLG_RESIZABLE
	int								m_right;
	int								m_bottom;
	///End MAKE_COLFILTER_DLG_RESIZABLE
	
	Column							m_col;
	Worksheet						m_wks;
	
public:
	ColFilterPlaceHolder();
	~ColFilterPlaceHolder(){}
	
	void 	InitMaps(WndContainer& wnd, int nObjType = COLUMN_FILTER_FORMAT_NUMERIC);
	
	void	SetActivePageByCol();
};

class ColFilterDlg : public ResizeDialog
{
public:	
	///Jasmine 05/09/2012 ORG-4862-P4 OPEN_CUSTOM_FILTER_DLG_FROM_CHECK_LIST_MORE_SHOULD_UPDATE_DIALOG_CHECK_LIST
	//ColFilterDlg(Column& col, int nObjType = COLUMN_FILTER_FORMAT_NUMERIC) : ResizeDialog(IDD_COL_FILTER_FRAME, "ODlg8") 
	ColFilterDlg(Column& col, int nObjType = COLUMN_FILTER_FORMAT_NUMERIC, CustomFilterDlgData* pData = NULL) : ResizeDialog(IDD_COL_FILTER_FRAME, "ODlg8") 
	///End OPEN_CUSTOM_FILTER_DLG_FROM_CHECK_LIST_MORE_SHOULD_UPDATE_DIALOG_CHECK_LIST
	{	
		m_nFirstPageType	= nObjType;
		m_pPlaceHolder 		= new ColFilterPlaceHolder();
		///Jasmine 05/09/2012 ORG-4862-P4 OPEN_CUSTOM_FILTER_DLG_FROM_CHECK_LIST_MORE_SHOULD_UPDATE_DIALOG_CHECK_LIST
		if(pData != NULL)
		{
			m_pPlaceHolder->m_DataStruct = *pData;
		}
		///End OPEN_CUSTOM_FILTER_DLG_FROM_CHECK_LIST_MORE_SHOULD_UPDATE_DIALOG_CHECK_LIST
		AttachCol(col);		
	}		
	
	~ColFilterDlg(){ NICE_SAFE_REMOVAL(m_pPlaceHolder); }	

	void 	AttachCol(Column& col);	
	
	BOOL 	CreateEx(HWND hWndParent = NULL);
	int 	DoModalEx(HWND hParent);
protected:
EVENTS_BEGIN
	ON_INIT(OnInitDialog)	
	ON_READY(OnReady)
	///Jasmine 05/09/2012 ORG-4862-S6 MAKE_COLFILTER_DLG_RESIZABLE
	ON_SIZE(OnDlgResize)
	ON_GETMINMAXINFO(OnMinMaxInfo)
	///End MAKE_COLFILTER_DLG_RESIZABLE
	ON_OK(OnOK)				
	ON_BN_CLICKED(IDC_APPLY, OnApply)	
	
	ON_CHANGE_LAYER( OnActiveLayerChange )			
	ON_CHANGE_PAGE( OnActivePageChange )			
	ON_CHANGE_SELECTION( OnSelectionChange )						
	
	ON_USER_MSG(WM_COLFILTERDLG_USER_MSG_RESIZE_DLG, ResizeDlgToControlBottom)
EVENTS_END
	
	BOOL	OnInitDialog();
	BOOL	OnReady();
	///Jasmine 05/09/2012 ORG-4862-S6 MAKE_COLFILTER_DLG_RESIZABLE
	BOOL 	OnDlgResize(int nType, int cx, int cy);		
	void	OnMinMaxInfo(MINMAXINFO* lpMMI);
	int 	GetMinClientTrackWidth();		///Jasmne 07/11/2012 ORG-6178-P1 GET_MIN_TRACK_WIDTH_ON_RIGHTMOST_CTRL
	///End MAKE_COLFILTER_DLG_RESIZABLE
	BOOL	OnOK();
	BOOL	OnApply(Control ctrl);
	
	BOOL 	OnActiveLayerChange();
	BOOL 	OnActivePageChange();
	BOOL 	OnSelectionChange();
	
	BOOL	GetActiveLayer();
	BOOL 	IsDataObjectChanged(const Layer& layer);
	
	BOOL	ResizeDlgToControlBottom(WPARAM wParam, LPARAM lParam);
	
private:		
	bool 	createDataObject();
	
private:
	ColFilterPlaceHolder* 		m_pPlaceHolder;
	
	Button						m_btnApply;
	
	int							m_nFirstPageType;
};
