/*------------------------------------------------------------------------------*
 * File Name: CustomColFilterDlg.cpp 											*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Jasmine 05/08/2012 ORG-5640-P1 ON_ACTIVE_PAGE_EVENT_NOT_REFRESH_WELL		*
 *	Jasmine 05/08/2012 ORG-5638-P1 FIX_CUSTOM_COLUMN_FILTER_WHEN_DATA_CONDITION_USE_DOUBLE
 *	Jasmine 05/08/2012 ORG-5638-P2 ADD_EMPTY_ITEM_TO_COMBO_TO_DISABLE_SECOND_CONDITION 
 *	Jasmine 05/09/2012 ORG-4862-S6 MAKE_COLFILTER_DLG_RESIZABLE					*
 *	Jasmine 05/10/2012 ORG-5525-P4 WE_SHOULD_ALLOW_USER_TO_HIDE_ALL_VALUES		*
 *	Jasmine 05/10/2012 ORG-4862-P4 CAREFULLY_USE_FILTER_DATA_STRUCT_LPCSTR		*
 *	Jasmine 05/15/2012 ORG-5668-S2 SPECIFY_VARIABLE_TO_REPRECENT_CURRENT_COL	*
 *	Jasmine 05/15/2012 ORG-5668-S3 ADD_BEFORE_QUERY_SCRIPT						*
 *	Jasmine 05/15/2012 ORG-5668-S5 USE_QUERY_FOR_SIMPLE_AND_ADVANCED_MODE		*
 *	Jasmine 05/15/2012 ORG-4862-S8 COLUMN_DISTINCT_VALUES_NEED_COUNT			*
 *	Jasmine 05/16/2012 ORG-5668-S1 CONSTRUCT_QUERY_STRING_FROM_SIMPLE_MODE		*
 *	Jasmine 05/21/2012 ORG-5638-S1 ERROR_CHECK_FOR_EMPTY_COMBO_ITEM				*
 *	Jasmine 05/22/2012 ORG-5524-P1 UNDO_SETFILTER_AND_RUNUFILTER_IN_ONE_TIME	*
 *	Jasmine 03/23/2012 ORG-5638-P6 REDUNDANT_DATE_TIME_DATA_DISTURB_COMPARISON	*
 *	Jasmine 05/29/2012 ORG-5638-P9 FILTER_DATA_AND_COMBO_SHOULD_BE_EMPTY_IN_CONSISTENCE
 *	Jasmine 06/01/2012 ORG-5851-S2 SHOW_ALL_MONTH_ITEMS							*
 *	Jasmine 06/01/2012 ORG-5851-P1 SYSTEM_TIME_RULE								*
 *	Jasmine 06/05/2012 ADVANCED_MODE_SHOULD_ALSO_INIT_SIMPLE_MODE_CTRLS			*
 *	Zech 06/08/2012 ORG-5154-P6 SHOULD_NOT_REAPPLY_WHEN_FILTER_DISABLED			*
 *	Jasmine 06/14/2012 ORG-5668-P7 MOVE_LONG_LNAME_TO_TOOLTIP					*
 *	Tony 06/15/2012 ORG-5985-P1 FIX_RECENT_USE_FUNCTION_EXPRESSION				*
 *	Tony 06/15/2012 ORG-5985-P2 FIX_ALL_RECENT_FUNC_LIST_IN_DIFF_TYPE			*
 *	Zech 06/28/2012 ORG-5638-P12 FIX_CONSTRCT_COL_FILTER_QUERY_DATA				*
 *	Tony 07/2/2012 ORG-2792-P3 FIX_INSERT_WRONG_FAVOURITE_FUNCITON				*
 *	Jasmine 07/10/2012 ORG-6178-P2 ADD_FUNC_MENU_FOR_BEFORE_SCRIPT				*
 *	Zech 07/12/2012 ORG-6205-P1 BETTER_SUPPORT_ON_COLUMN_FILTER_PRESCRIPT		*
 *	Jasmine 07/18/2012 ORG-6252-P1 HIDE_NAVIGATE_BTNS							*
 *	Jasmine 07/18/2012 ORG-6255-S1 SEPARATE_DATE_TIME_CLASS						*
 *	Zech 07/24/2012 ORG-6266-S1 NEW_COLUMN_FILTER_DLGS							*
 *	EJP 2012-10-03 ORG-7041 NEW_TRIG_FUNC_CATEGORY								*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////

//#pragma labtalk(0) // to disable OC functions for LT calling.

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include "DialogEx.h"
#include "FunctionsMenu.h"
#include "CustomColFilterDlg.h"
#include "CustomColFilterTimeDlg.h"		///Jasmine 07/18/2012 ORG-6255-S1 SEPARATE_DATE_TIME_CLASS
/// Zech 07/24/2012 ORG-6266-S1 NEW_COLUMN_FILTER_DLGS
#include "SimpleColumnFilterDlg.h"		
#include "CustomColumnFilterDlg.h"
/// ENDNEW_COLUMN_FILTER_DLGS

#define 	CHAR_WILD				'*'

#ifdef OPEN_COL_FILTER_MODALLESS_DLG
static 		ColFilterDlg* 			s_pFilterDlg;
#endif //OPEN_COL_FILTER_MODALLESS_DLG

////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.

/***********************************************************************
*********************  GridCheckListControl Begin  *********************
************************************************************************/
void 	GridCheckListControl::Init(int nID, WndContainer& dlg, bool bCheckOnLeft/* = true*/, bool bFixRow/* = false*/)
{
	m_nCols 	= 2;
	if(bCheckOnLeft)
	{
		m_nVarCol 	= 1;
		m_nCheckCol	= 0;
	}
	else
	{
		m_nVarCol 	= 0;
		m_nCheckCol	= 1;
	}
	
	GridControl::Init(nID, dlg);
	SetupRowsCols(bFixRow? 1 : 0, 0,  -1, m_nCols);
	
	SetColDataType(m_nVarCol, 		flexDTString);
	SetColAlignment(m_nVarCol, 		flexAlignLeftCenter);
	
	SetColDataType(m_nCheckCol, 	flexDTBoolean);
	SetColAlignment(m_nCheckCol, 	flexAlignLeftCenter);
}

void 	GridCheckListControl::Update(const vector<string>& vsVariables, const vector<int>& vnChecks)
{
	ClearAll();
	int nRows = vsVariables.GetSize();
	SetRows(nRows);
	
	vector<string> 	vsCheck;	
	convert_int_vector_to_string_vector(vnChecks, vsCheck);
	
	m_flx.SetTableValue(&vsVariables, 	nRows, 				1, 	m_flx.FixedRows, 	m_nVarCol, 		false);
	m_flx.SetTableValue(&vsCheck, 		vsCheck.GetSize(), 	1, 	m_flx.FixedRows, 	m_nCheckCol, 	false);
	
	ResizeCols();
}

int		GridCheckListControl::GetCheckList(vector<string>& vsVariables, vector<int>& vnChecks)
{
	vsVariables.SetSize(0);
	GetColValues(m_nVarCol, vsVariables, m_flx.FixedRows);
	
	vector<string> vsChecks;
	GetColValues(m_nCheckCol, vsChecks, m_flx.FixedRows);
	
	vnChecks.SetSize(0);
	int nSize = convert_string_vector_to_int_vector(vsChecks, vnChecks);
	return nSize;
}

bool 	GridCheckListControl::CheckAll(int nCheckType)
{
	vector<int> 	vnOldChecks, vnChecks;
	vector<string> 	vsOldChecks, vsChecks;
	GetColValues(m_nCheckCol, vsOldChecks, m_flx.FixedRows);
	convert_string_vector_to_int_vector(vsOldChecks, vnOldChecks);
	
	bool bChange = false;
	switch(nCheckType)
	{
	case CHECK_ALL_TRUE:
	case CHECK_ALL_FALSE:
		int nCount = GetNumRows();
		vnChecks.SetSize(nCount);
		
		int nSum;
		vnOldChecks.Sum(nSum);
		if(CHECK_ALL_TRUE == nCheckType)
		{
			vnChecks 	= 1;
			bChange		= nCount != nSum;
		}
		else
		{
			vnChecks 	= 0;
			bChange		= 0 != nSum;
		}
		
		break;
		
	case CHECK_ALL_INVERSE:
		vnChecks = !vnOldChecks;
		bChange = true;
		break;
		
	default:
		return bChange;
	}
	
	convert_int_vector_to_string_vector(vnChecks, vsChecks);     	
	int nSize = vsChecks.GetSize();
	if(nSize > 0)
		m_flx.SetTableValue(&vsChecks, nSize, 1, m_flx.FixedRows, m_nCheckCol, false);
	else
		ASSERT(0);
	
	return bChange;
}

void	GridCheckListControl::OnBeforeEditCheckList(int nRow, int nCol, BOOL* pCancel)
{
	if ( m_nCheckCol != nCol && pCancel )
	{
		*pCancel = TRUE;
	}
}

/***********************************************************************
**********************  GridCheckListControl End  **********************
************************************************************************/


/***********************************************************************
***********************  ColFilterBaseDlg Begin  ***********************
************************************************************************/
void ColFilterBaseDlg::InitPage(int nID, ColFilterPlaceHolder* pHolder, WndContainer& dlg)
{
	SetID(nID);
	m_pHolder = pHolder;
			
	Window wTemp(dlg.GetSafeHwnd());
	m_wndParent = wTemp;
}

virtual BOOL 	ColFilterBaseDlg::OnInitPage()
{	
	///Jasmine 07/18/2012 ORG-6252-P1 HIDE_NAVIGATE_BTNS
#ifndef _ALLOW_NAVIGATE_TO_OTHER_COL
	GetItem(IDC_BUTTON_FIRST).Visible	=
	GetItem(IDC_BUTTON_PREVIOUS).Visible= 
	GetItem(IDC_BUTTON_NEXT).Visible 	= 
	GetItem(IDC_BUTTON_LAST).Visible 	= FALSE;
#endif //_ALLOW_NAVIGATE_TO_OTHER_COL
	///End HIDE_NAVIGATE_BTNS
	
	m_btnAdv 	= GetItem(IDC_CHECK_ADVANCED);
	m_edCommand	= GetItem(IDC_EDIT_COMMAND);
	m_edBeforeScript = GetItem(IDC_EDIT_BRFORE_QUERY);	///Jasmine 05/15/2012 ORG-5668-S3 ADD_BEFORE_QUERY_SCRIPT
	
	///Jasmine 07/10/2012 ORG-6178-P2 ADD_FUNC_MENU_FOR_BEFORE_SCRIPT
	vector<string> vsTips;
	BitmapRadioButton btnFunc = GetItem(IDC_BUTTON_FUNC);
	btnFunc.Init(1, IDB_DROP_DOWN_UP, 16, vsTips);
	BitmapRadioButton btnFunc2 = GetItem(IDC_BUTTON_FUNC2);
	btnFunc2.Init(1, IDB_DROP_DOWN_UP, 16, vsTips);
	///End ADD_FUNC_MENU_FOR_BEFORE_SCRIPT
	ConstructMenu();
	
	return TRUE;
}
//#include <Profiler.h>
virtual BOOL 	ColFilterBaseDlg::OnActivatePage()
{
	//Profiler junk;
	InitCtrlValue();
	
	m_wndParent.Text = GetDlgTitle(m_btnAdv.Check);
	
	return TRUE;
}

bool 	ColFilterBaseDlg::GetControlClientRect(uint nID, RECT& r1, Control* pCntrl/* = NULL*/)
{
	Control btn;
	if(NULL == pCntrl)
		pCntrl = &btn;
		
	*pCntrl = GetItem(nID);
	if(*pCntrl)
	{
		GetClientRect(*pCntrl, r1);		
		return true;
	}
	return false;
}

bool 	ColFilterBaseDlg::GetClientRect(Control& cc, RECT& rr)
{
	if(cc)
	{
		cc.GetWindowRect(&rr);
		ScreenToClient(&rr);
		return true;
	}
	return false;
}
	
void 	ColFilterBaseDlg::MoveControls(uint nIDs[], int nDx, int nDy)
{
	int ii = 0;
	while(nIDs[ii] > 0)
	{
		RECT r1;
		Control btn;
		if(GetControlClientRect(nIDs[ii], r1, &btn))
		{
			OffsetRect(&r1, nDx, nDy);
			MoveControl(btn, r1); 
		}
		ii++;
	}
}

void 	ColFilterBaseDlg::ShowControls(const vector<uint>& vn, bool bShow/* = true*/)
{
	for(int ii = 0; ii < vn.GetSize(); ii++)
	{
		if(vn[ii])
		{
			Control btn = GetItem(vn[ii]);
			if(btn)
				btn.Visible = bShow;
		}
	}
}

int		ColFilterBaseDlg::GetBottomControl()
{
	RECT rrAdv;
	m_btnAdv.GetWindowRect(&rrAdv);	
	return rrAdv.bottom;
}

virtual BOOL	ColFilterBaseDlg::OnApply(Control ctrl)
{
	if(m_btnAdv.Check)
	{
		if( isApplied() )
			return TRUE;
			
		string strCommand = m_edCommand.Text; strCommand.TrimLeft(); strCommand.TrimRight();
		///Jasmine 07/17/2012 ORG-6244-P3 KEEP_PRESCRIPT_NO_MATTER_COMMAND_EMPTY_OR_NOT
		//if( strCommand.IsEmpty() )
		//{
			//onAfterApply();
			//return TRUE;
		//}
		///End KEEP_PRESCRIPT_NO_MATTER_COMMAND_EMPTY_OR_NOT
		string strPreScript = m_edBeforeScript.Text; strPreScript.TrimLeft(); strPreScript.TrimRight();	///Jasmine 05/15/2012 ORG-5668-S3 ADD_BEFORE_QUERY_SCRIPT
		///Jasmine 07/17/2012 ORG-6244-P3 KEEP_PRESCRIPT_NO_MATTER_COMMAND_EMPTY_OR_NOT
		if( strCommand.IsEmpty() && strPreScript.IsEmpty() )
		{
			onAfterApply();
			return TRUE;
		}
		///End KEEP_PRESCRIPT_NO_MATTER_COMMAND_EMPTY_OR_NOT
		m_cmddata.lpcszCommand 		= strCommand;
		m_cmddata.lpcszPrescript 	= strPreScript;				///Jasmine 05/15/2012 ORG-5668-S3 ADD_BEFORE_QUERY_SCRIPT
		
		UndoBlock 	block;			///Jasmine 05/22/2012 ORG-5524-P1 UNDO_SETFILTER_AND_RUNUFILTER_IN_ONE_TIME
		
		BOOL bRet = m_pHolder->m_col.SetFilter((int)COLUMN_FILTER_TYPE_COMMAND, (LPVOID)&m_cmddata, TRUE);
		
		///Jasmine 05/15/2012 ORG-5668-S2 SPECIFY_VARIABLE_TO_REPRECENT_CURRENT_COL
		m_pHolder->m_col.SetFilterThisCol(m_strSpecVar);
		///End SPECIFY_VARIABLE_TO_REPRECENT_CURRENT_COL
		
		Worksheet wks;
		m_pHolder->m_col.GetParent(wks);
		if( wks )
		{
			/// Zech 06/08/2012 ORG-5154-P6 SHOULD_NOT_REAPPLY_WHEN_FILTER_DISABLED
			if (!m_pHolder->m_col.IsFilterDisabled())
			/// END SHOULD_NOT_REAPPLY_WHEN_FILTER_DISABLED
				int nRet = wks.RunFilter(0, 0, -1, true);//int nRet = wks.RunFilter();	///Jasmine 05/22/2012 ORG-5524-P1 UNDO_SETFILTER_AND_RUNUFILTER_IN_ONE_TIME
			
			onAfterApply();
		}
		else
			bRet = FALSE;
		
		return bRet;
	}
	
	return FALSE;
}

///Jasmine 05/09/2012 ORG-4862-S6 MAKE_COLFILTER_DLG_RESIZABLE
///Jasmne 07/11/2012 ORG-6178-P1 GET_MIN_TRACK_WIDTH_ON_RIGHTMOST_CTRL
virtual int		ColFilterBaseDlg::GetMinClientWidth()
{
	///Jasmine 07/18/2012 ORG-6252-P1 HIDE_NAVIGATE_BTNS
#ifdef _ALLOW_NAVIGATE_TO_OTHER_COL
	RECT rr;
	GetControlClientRect(IDC_BUTTON_LAST, rr);
	return rr.right + _DLG_GAP*4;
#else
	return 550;
#endif //_ALLOW_NAVIGATE_TO_OTHER_COL
	///End HIDE_NAVIGATE_BTNS
}
///End GET_MIN_TRACK_WIDTH_ON_RIGHTMOST_CTRL
int		ColFilterBaseDlg::TotalHeight(uint nIDs[])
{
	int ii = 0, nTop = 0, nBottom = 0;
	while(nIDs[ii] > 0)
	{
		RECT r1;
		if(GetControlClientRect(nIDs[ii], r1))
		{
			if(0 == ii)
			{
				nTop 	= r1.top;
				nBottom	= r1.bottom;
			}
			else
			{
				if(r1.top < nTop)
					nTop = r1.top;
				
				if(r1.bottom > nBottom)
					nBottom = r1.bottom;
			}
		}
		ii++;
	}
	
	int nHeight = nBottom - nTop;
	return nHeight > 0? nHeight : 0;
}

void	ColFilterBaseDlg::Resize(int nType, int nRight, int nBottom)
{
	RECT rrFramp;
	rrFramp.right 	= nRight;
	rrFramp.bottom 	= nBottom;
	ScreenToClient(&rrFramp);
	
	m_pHolder->m_right 	= rrFramp.right;
	m_pHolder->m_bottom = rrFramp.bottom;
	OnDlgResize(nType, m_pHolder->m_right, m_pHolder->m_bottom);	
}

virtual void	ColFilterBaseDlg::OnDlgResize(int nType, int nRight, int nBottom)
{
	bool bAdv = m_btnAdv.Check;
	if(!bAdv)
		return;
	
	MoveControlsHelper clCacheWndPosHelper(this);
	
	RECT 	rrFunc, rrAdv, rrCmd, rrBefore;
	Control	cCmd, cBefore;
	GetControlClientRect(IDC_BUTTON_FUNC,		rrFunc);
	GetControlClientRect(IDC_CHECK_ADVANCED,	rrAdv);
	GetControlClientRect(IDC_EDIT_COMMAND,		rrCmd, 		&cCmd);
	GetControlClientRect(IDC_EDIT_BRFORE_QUERY,	rrBefore, 	&cBefore);
	
	int 	nGap	= _DLG_GAP;
	int 	nDx		= nRight - nGap - rrFunc.right;
	
	vector<uint> vnIDs = {IDC_BUTTON_FUNC, IDC_BUTTON_FUNC2, 0};	
	MoveControls(vnIDs, nDx, 0);
	
	GetQueryTipsIDs(vnIDs);
	int		nTipsHeight	= TotalHeight(vnIDs);
	int 	nNewHeight 	= (nBottom - nGap * 4 - RECT_HEIGHT(rrAdv) - nTipsHeight - rrCmd.top) * 0.5;
	int		nDy			= nNewHeight - RECT_HEIGHT(rrCmd);
	MoveControls(vnIDs, 0, nDy);
	
	nDx	= nRight - nGap - rrAdv.right;
	nDy = nBottom - nGap - rrAdv.bottom;
	vnIDs.SetSize(0);
	vnIDs.Add(IDC_CHECK_ADVANCED);
	vnIDs.Add(0);
	MoveControls(vnIDs, nDx, nDy);
	
	rrCmd.right	= nRight - nGap * 2 - RECT_WIDTH(rrFunc);
	rrCmd.bottom= rrCmd.top + nNewHeight;
	MoveControl(cCmd, rrCmd);	
	
	rrBefore.right	= nRight - nGap * 2 - RECT_WIDTH(rrFunc);
	rrBefore.bottom	= nBottom - nGap * 2 - RECT_HEIGHT(rrAdv);
	rrBefore.top 	= rrBefore.bottom - nNewHeight;
	MoveControl(cBefore, rrBefore);	
	
	///Jasmine 07/10/2012 ORG-6178-P2 ADD_FUNC_MENU_FOR_BEFORE_SCRIPT
	Control cFunc2;
	RECT 	rrFunc2;
	GetControlClientRect(IDC_BUTTON_FUNC2, rrFunc2, &cFunc2);
	rrFunc2.bottom	= rrBefore.top + RECT_HEIGHT(rrFunc2);
	rrFunc2.top 	= rrBefore.top;
	MoveControl(cFunc2, rrFunc2);	
	///End ADD_FUNC_MENU_FOR_BEFORE_SCRIPT
}

virtual int		ColFilterBaseDlg::GetQueryTipsIDs(vector<uint>& vnIDs)
{
	vector<uint> vnTemp = {IDC_TEXT_BEFORE_QUERY, 0};
	vnIDs = vnTemp;
	return vnIDs.GetSize();
}
///End MAKE_COLFILTER_DLG_RESIZABLE

///Jasmine 05/15/2012 ORG-5668-S2 SPECIFY_VARIABLE_TO_REPRECENT_CURRENT_COL
BOOL	ColFilterBaseDlg::OnVarKillFocus(Control ctrl)
{
	m_strSpecVar.TrimLeft(); m_strSpecVar.TrimRight();
	if( m_strSpecVar.IsEmpty() )
		m_strSpecVar = STR_COLUMN_FILTER_THIS_COLUMN;
	
	Control ctrlVar = GetItem(IDC_EDIT_REPRESENT_VAR);
	if(!ctrlVar)
		return FALSE;
	
	string strTemp = ctrlVar.Text;
	strTemp.TrimLeft(); strTemp.TrimRight();
	if( strTemp.IsEmpty() )
	{
		ctrlVar.Text = m_strSpecVar;		
		return OnControlChange(ctrl);
	}
	
	if(strTemp.Compare(m_strSpecVar) != 0)
	{
		m_strSpecVar = strTemp;	
		return OnControlChange(ctrl);
	}
	
	return TRUE;
}
///End SPECIFY_VARIABLE_TO_REPRECENT_CURRENT_COL

BOOL	ColFilterBaseDlg::OnAdvButtonCheck(Control ctrl)
{
	InitColInfo();	
	ShowHideControls();	
	///Jasmine 05/09/2012 ORG-4862-S6 MAKE_COLFILTER_DLG_RESIZABLE
	//ResizeDlgToFitControls();
	if(m_pHolder->m_right >  0 && m_pHolder->m_bottom > 0)
		OnDlgResize(0, m_pHolder->m_right, m_pHolder->m_bottom);
	///End MAKE_COLFILTER_DLG_RESIZABLE
	
	m_wndParent.Text = GetDlgTitle(m_btnAdv.Check);
	
	///Jasmine 05/16/2012 ORG-5668-S1 CONSTRUCT_QUERY_STRING_FROM_SIMPLE_MODE
	bool bAdv = m_btnAdv.Check;	
	if(bAdv)
	{
		ConstructQueryString();
		m_bEnable = true;			///Jasmine 05/21/2012 ORG-5638-S1 ERROR_CHECK_FOR_EMPTY_COMBO_ITEM
		OnControlChange(ctrl);
	}
	///Jasmine 05/21/2012 ORG-5638-S1 ERROR_CHECK_FOR_EMPTY_COMBO_ITEM
	else
	{
		Control ctrl = GetItem(IDC_COMBO_CONDITION_1);
		OnComboChange(ctrl);	
	}
	///End ERROR_CHECK_FOR_EMPTY_COMBO_ITEM
	///End CONSTRUCT_QUERY_STRING_FROM_SIMPLE_MODE
	
	return TRUE;
}

BOOL	ColFilterBaseDlg::OnFuncButtonClick(Control ctrl)
{
	RECT rrButton;
	///Jasmine 07/10/2012 ORG-6178-P2 ADD_FUNC_MENU_FOR_BEFORE_SCRIPT
	//GetControlClientRect(IDC_BUTTON_FUNC, rrButton);
	int nResID = GetDlgCtrlID( ctrl.GetSafeHwnd() );
	GetControlClientRect(nResID, rrButton);
	///ADD_FUNC_MENU_FOR_BEFORE_SCRIPT
	ClientToScreen(&rrButton);
	
	string strText = PopupFunctionMenu(rrButton.right, rrButton.top);
	if (strText.IsEmpty())
		return TRUE;
	
	///Jasmine 07/10/2012 ORG-6178-P3 INSERT_FUNC_TO_BEFORE_SCRIPT
	if(IDC_BUTTON_FUNC2 == nResID)
		InsertFunction(m_edBeforeScript, strText);
	else
	///End INSERT_FUNC_TO_BEFORE_SCRIPT
		InsertFunction(m_edCommand, strText);
	
	return TRUE;
}

void	ColFilterBaseDlg::InsertFunction(Edit & ed, string & strText)
{
	string strSel = ed.GetSelText();
	bool bStrRet = (strText.GetLength() > 0 && strText[strText.GetLength() - 1] == '$');
	
	int nLeftBracketPos = strText.Find('(');
	int nRightBracketPos = strText.Find(')');
	
	bool bFunctionStr = true;
	bool bParentheses = bFunctionStr && nLeftBracketPos >= 0 && nRightBracketPos > nLeftBracketPos;
	if(bParentheses)
	{
		string strTmp = strText.Mid(nLeftBracketPos + 1, nRightBracketPos - nLeftBracketPos - 1);
		strTmp.Remove(',');				// only
		strTmp.TrimLeft();
		strTmp.TrimRight();
		bParentheses = strTmp.IsEmpty();
	}
	
	if(bParentheses)
	{
		int nSpaceIndex = strText.Find(' ');
		int nParenIndex = strText.Find('(');
		if(nSpaceIndex > 0 && nSpaceIndex < nParenIndex)	// space before (
		{
			int nLength = strText.GetLength() - nSpaceIndex - 1;		// length after the space
			strText = strText.Right(nLength);
			strText.TrimLeft();
		}
		
		nParenIndex = strText.ReverseFind(')');		// the last ')'
		if(nParenIndex > 0)
			strText.Insert(nParenIndex, strSel);
	}
	
	ed.ReplaceSel(strText, true);
	
	if(bParentheses && strSel.IsEmpty())
	{
		long nBegin, nEnd;
		ed.GetSel(nBegin, nEnd);
		nBegin -= bStrRet ? 2 : 1;
		ed.SetSel(nBegin, nBegin);
	}
	
	SetFocus(ed.GetSafeHwnd());
	
	//m_pMenu->UpdateFuncHistoryList(strText);			///Tony 06/15/2012 ORG-5985-P1 FIX_RECENT_USE_FUNCTION_EXPRESSION	
}

string	ColFilterBaseDlg::PopupFunctionMenu(int x, int y)
{
	if (m_pMenu == NULL)
		return "";
	
	int		nCmd;			
	
	m_pMenu->TrackPopupMenu(TPM_NOTIFY, x, y, GetSafeHwnd(), &nCmd);
	///------ Tony 06/15/2012 ORG-5985-P2 FIX_ADVANCED_COLUMN_FILTER_FAVOURITE_MENU
	if(0 == nCmd)
		return "";
	//m_pMenu->UpdateFuncHistoryList(m_pMenu->GetMenuString(nCmd));			///------ Tony 07/2/2012 ORG-2792-P3 FIX_INSERT_WRONG_FAVOURITE_FUNCITON
	///------ FIX_ADVANCED_COLUMN_FILTER_FAVOURITE_MENU	
	///Sophy 7/23/2012 ORG-6260-P3 REDUNDENT_FITTING_FUNCTION_SHOW_IN_RECENT_USED_POPUP
	//return m_pMenu->GetFunctionString(nCmd);
	string strFunc =  m_pMenu->GetFunctionString(nCmd);
	m_pMenu->UpdateFuncHistoryList(m_pMenu->GetMenuString(nCmd));
	return strFunc;
	///end REDUNDENT_FITTING_FUNCTION_SHOW_IN_RECENT_USED_POPUP
}

BOOL	ColFilterBaseDlg::ConstructMenu()
{
	HINSTANCE hInst = (HINSTANCE) okutil_load_dll(ORIGINC_SOURCE_PATH_ORIGINLAB + "ODlg8.dll");	
	if ( NULL == hInst )
		return FALSE;

	BOOL	bOK = m_menu.Load(hInst, IDR_COL_FILTER_FUNCTION, 0);
	FreeLibrary(hInst);
	if ( !bOK )
		return FALSE;

	vector<uint> vnCategoryIDs;
	GetCheckMenuCategoryIDs(m_menu, vnCategoryIDs);	
	
	HMENU hMenu = m_menu.GetSafeHmenu();
	
	///------ Tony 06/15/2012 ORG-5985-P2 FIX_ALL_RECENT_FUNC_LIST_IN_DIFF_TYPE
	//m_pMenu = new CustomColFilterFuncMenu(hMenu, vnCategoryIDs);	
	m_pMenu = new CustomColFilterFuncMenu(hMenu, m_strFavFunc, vnCategoryIDs);	
	///------ FIX_ALL_RECENT_FUNC_LIST_IN_DIFF_TYPE
	m_pMenu->SetGetLTFunctionOption(OC_SKIP_SYS_WITHOUT_CAT);	///Sophy 7/19/2012 ORG-6260-S1 MORE_CHECKING_ON_SCAN_USER_DEFINED_FUNCTION_FOR_SCV_MENU
	m_pMenu->Construct();
	return TRUE;
}

///Jasmine 05/21/2012 ORG-5638-S1 ERROR_CHECK_FOR_EMPTY_COMBO_ITEM
BOOL	ColFilterBaseDlg::OnComboChange(Control ctrl)
{
	m_bEnable = true;
	OnControlChange(ctrl);
	
	ComboBox combo(ctrl);
	if(!combo)
		return FALSE;
	EnableCtrlsByComboSel(combo);	///Jasmine 07/18/2012 ORG-5851-S4 DISABLE_CONDITION_CTRLS_WHEN_COMBO_IS_EMPTY
	
	if(combo.GetCurSel() != 0)
		return TRUE;
	
	bool 	bEmpty 	= true;
	int 	nResID 	= GetDlgCtrlID( ctrl.GetSafeHwnd() );
	int		nID		= IDC_COMBO_CONDITION_1 == nResID? IDC_COMBO_CONDITION_2 : IDC_COMBO_CONDITION_1;
	
	ComboBox cb = GetItem(nID);
	if(cb && cb.GetCurSel() != 0)
		bEmpty = false;
	
	if(bEmpty)
	{
		warning_msg_box(_L("Please specify at least 1 query condition."), true/*false*/, 'W');
		m_bEnable = false;
		OnControlChange(ctrl);
	}
	
	return TRUE;
}
///End ERROR_CHECK_FOR_EMPTY_COMBO_ITEM

BOOL	ColFilterBaseDlg::OnFirstColButtonClick(Control ctrl)
{	
	return gotoCol(0);
}

BOOL	ColFilterBaseDlg::OnPreviousColButtonClick(Control ctrl)
{	
	return gotoCol(m_pHolder->m_col.GetIndex() - 1);
}

BOOL	ColFilterBaseDlg::OnNextColButtonClick(Control ctrl)
{	
	return gotoCol(m_pHolder->m_col.GetIndex() + 1);	
}

BOOL	ColFilterBaseDlg::OnLastColButtonClick(Control ctrl)
{	
	return gotoCol(m_pHolder->m_wks.Columns.Count() - 1);
}

bool 	ColFilterBaseDlg::HasPreviousObject()
{
	if(!m_pHolder->m_col)
		return false;
	
	if(0 != m_pHolder->m_col.GetIndex())
		return true;
	
	return false;
}
bool 	ColFilterBaseDlg::HasNextObject()
{
	if(!m_pHolder->m_col)
		return false;
	
	if(m_pHolder->m_wks.Columns.Count()-1 != m_pHolder->m_col.GetIndex())
		return true;
	
	return false;
}

bool 	ColFilterBaseDlg::gotoCol(int nCol)
{
	Column col(m_pHolder->m_wks, nCol);
	if( !col )
		return false;
	
	//m_col = col; //do this in OnSelectionChange
	vector<int> vR1(1), vR2(1), vC1(1), vC2(1);
	vR1[0] = 0;
	vR2[0] = -1;
	vC1[0] = vC2[0] = col.GetIndex();
	if( m_pHolder->m_wks.SetSelectedRange(vR1, vC1, vR2, vC2) )
	{
		return true;
	}
	return false;
}

///Jasmine 05/21/2012 ORG-5638-S1 ERROR_CHECK_FOR_EMPTY_COMBO_ITEM
virtual BOOL	ColFilterBaseDlg::OnControlChange(Control ctrl)
{ 
	m_wndParent.GetDlgItem(IDC_APPLY).Enable = m_bEnable;
	m_wndParent.GetDlgItem(IDOK).Enable = m_bEnable;
	return TRUE; 
}
///End ERROR_CHECK_FOR_EMPTY_COMBO_ITEM

virtual void 	ColFilterBaseDlg::InitCtrlValue()
{	
	InitFilterControls();//m_btnAdv.Check is set so should be run firstly
	
	InitColInfo();	
	
	ShowHideControls();
	moveAdvControls();
	///Jasmine 05/09/2012 ORG-4862-S6 MAKE_COLFILTER_DLG_RESIZABLE
	//ResizeDlgToFitControls();
	if(m_pHolder->m_right >  0 && m_pHolder->m_bottom > 0)
		OnDlgResize(0, m_pHolder->m_right, m_pHolder->m_bottom);
	///End MAKE_COLFILTER_DLG_RESIZABLE
	
	///Jasmine 07/18/2012 ORG-6252-P1 HIDE_NAVIGATE_BTNS
#ifdef _ALLOW_NAVIGATE_TO_OTHER_COL
	GetItem(IDC_BUTTON_FIRST).Enable 	= HasPreviousObject();
	GetItem(IDC_BUTTON_PREVIOUS).Enable	= HasPreviousObject();
	GetItem(IDC_BUTTON_NEXT).Enable 	= HasNextObject();
	GetItem(IDC_BUTTON_LAST).Enable 	= HasNextObject();	
#endif //_ALLOW_NAVIGATE_TO_OTHER_COL
	///End HIDE_NAVIGATE_BTNS
	
	m_wndParent.GetDlgItem(IDC_APPLY).Enable 	= false;
	m_wndParent.GetDlgItem(IDOK).Enable 		= m_bEnable;
}

void 	ColFilterBaseDlg::InitColInfo()
{	
	bool bAdv = m_btnAdv.Check;	
	Control ctrlCol = GetItem(IDC_TEXT_REPRESENT_VAR);	//IDC_COL_LABEL	///Jasmine 05/15/2012 ORG-5668-S2 SPECIFY_VARIABLE_TO_REPRECENT_CURRENT_COL
	if( !ctrlCol )
		return;
	///Jasmine 06/14/2012 ORG-5668-P7 MOVE_LONG_LNAME_TO_TOOLTIP
	ctrlCol.SetToolTip(NULL);
	string strColName, strLongName, strLabel;	
	///End MOVE_LONG_LNAME_TO_TOOLTIP
	///Jasmine 05/15/2012 ORG-5668-S5 USE_QUERY_FOR_SIMPLE_AND_ADVANCED_MODE
	//if(!bAdv)
		//ctrlCol.Text = _L("Condition");
	//else
	ctrlCol.Visible = bAdv;
	///End USE_QUERY_FOR_SIMPLE_AND_ADVANCED_MODE
	if ( bAdv )
	{
		// update static Text according to column name
		if( m_pHolder->m_col )
		{
			strLongName = m_pHolder->m_col.GetLongName();
			if( strLongName.IsEmpty() )
			{		
				strColName = m_pHolder->m_col.GetName();	///Jasmine 06/14/2012 ORG-5668-P7 MOVE_LONG_LNAME_TO_TOOLTIP
				strLabel.Format("Col(%s)", m_pHolder->m_col.GetName());
			}
			else
			{
				strColName = strLongName;	///Jasmine 06/14/2012 ORG-5668-P7 MOVE_LONG_LNAME_TO_TOOLTIP
				strLabel.Format("Col(\"%s\")", strLongName);
			}	
			//ctrlCol.Text = strLabel;
		}
		else
		{
			strLabel = "Col(?)";//ctrlCol.Text = "Col(?)"; // for column not ready
		}
		///Jasmine 05/15/2012 ORG-5668-S2 SPECIFY_VARIABLE_TO_REPRECENT_CURRENT_COL
		strLabel.Format(_L("Variable to represent %s"), strLabel);
		ctrlCol.Text = strLabel;
		///End SPECIFY_VARIABLE_TO_REPRECENT_CURRENT_COL
	}
	
	// resize col label and seprator controls according to the long of col label	
	RECT rrCol;
	GetClientRect(ctrlCol, rrCol);	

	int nWidth;
	ctrlCol.Measure(ctrlCol.Text, &nWidth, true);
	///Jasmine 06/14/2012 ORG-5668-P7 MOVE_LONG_LNAME_TO_TOOLTIP
	//rrCol.right = rrCol.left + nWidth;
	//MoveControl(ctrlCol, rrCol);	
	//ctrlCol.Invalidate();		///Jasmine 05/08/2012 ORG-5640-P1 ON_ACTIVE_PAGE_EVENT_NOT_REFRESH_WELL
	nWidth += 10;	//spare place 
	///End MOVE_LONG_LNAME_TO_TOOLTIP
	
	///Jasmine 05/15/2012 ORG-5668-S2 SPECIFY_VARIABLE_TO_REPRECENT_CURRENT_COL
	Control ctrlVar = GetItem(IDC_EDIT_REPRESENT_VAR);
	if( !ctrlVar )
		return;
	
	int 	nGap= _DLG_GAP;
	RECT 	rrVar, rrBtn;
	GetClientRect(ctrlVar, rrVar);	
	///Jasmine 06/14/2012 ORG-5668-P7 MOVE_LONG_LNAME_TO_TOOLTIP
	///Jasmine 07/18/2012 ORG-6252-P1 HIDE_NAVIGATE_BTNS
#ifdef _ALLOW_NAVIGATE_TO_OTHER_COL
	GetControlClientRect(IDC_BUTTON_FIRST, rrBtn);
	int nMaxWidth = rrBtn.left - nGap * 2 - RECT_WIDTH(rrVar) - rrCol.left;
#else
	int nMaxWidth = GetMinClientWidth() - nGap * 2 - RECT_WIDTH(rrVar) - rrCol.left;
#endif //_ALLOW_NAVIGATE_TO_OTHER_COL
	///End HIDE_NAVIGATE_BTNS
	if(nWidth > nMaxWidth && bAdv)
	{		
		strLabel.Format(strLongName.IsEmpty()? "Col(%s)" : "Col(\"%s\")", strColName);
		ctrlCol.SetToolTip(strLabel);
		
		strLabel.Format(strLongName.IsEmpty()? "Col(%s)" : "Col(\"%s\")", strColName.Left(10) + "...");//hard code char number
		strLabel.Format(_L("Variable to represent %s"), strLabel);
		ctrlCol.Text = strLabel;
		ctrlCol.Measure(ctrlCol.Text, &nWidth, true);
		nWidth += 10;
	}
	rrCol.right = rrCol.left + nWidth;
	MoveControl(ctrlCol, rrCol);	
	ctrlCol.Invalidate();		///Jasmine 05/08/2012 ORG-5640-P1 ON_ACTIVE_PAGE_EVENT_NOT_REFRESH_WELL
	///End MOVE_LONG_LNAME_TO_TOOLTIP
	rrVar.right	= rrCol.right + nGap + RECT_WIDTH(rrVar);
	rrVar.left 	= rrCol.right + nGap;
	MoveControl(ctrlVar, rrVar);	
	ctrlVar.Invalidate();
	
	OnVarKillFocus(ctrlVar);
	///End SPECIFY_VARIABLE_TO_REPRECENT_CURRENT_COL
}

void	ColFilterBaseDlg::ShowHideControls()
{
	bool bAdv = m_btnAdv.Check;
	
	vector<uint> vnSimpelIDs, vnAdvIDs;
	GetSimpleControls(vnSimpelIDs);
	GetAdvControls(vnAdvIDs);
	
	ShowControls(vnSimpelIDs, !bAdv);
	ShowControls(vnAdvIDs, bAdv);
	
	///Jasmine 05/15/2012 ORG-5668-S2 SPECIFY_VARIABLE_TO_REPRECENT_CURRENT_COL
	GetItem(IDC_EDIT_REPRESENT_VAR).Visible = bAdv;
	///End SPECIFY_VARIABLE_TO_REPRECENT_CURRENT_COL
}

void	ColFilterBaseDlg::ResizeDlgToFitControls()
{	
	bool bAdv = m_btnAdv.Check;
	
	RECT rrGroup;
	if( bAdv )
		GetAdvGroupRect(rrGroup);
	else
		GetSimpleGroupRect(rrGroup);
	int nGap = 7;
	
	RECT rrAdvCheck;
	GetControlClientRect(IDC_CHECK_ADVANCED, rrAdvCheck);
	int nY = rrGroup.bottom + nGap - rrAdvCheck.top;		
	vector<uint> vnIDs = {IDC_CHECK_ADVANCED, 0}
	MoveControls(vnIDs, 0, nY);		
	
	///Jasmine 05/09/2012 ORG-4862-S6 MAKE_COLFILTER_DLG_RESIZABLE
	//if(m_pHolder->bReady)
	//{	
		//RECT rrAdv;
		//m_btnAdv.GetWindowRect(&rrAdv);		
		//
		//if(m_wndParent)
			//m_wndParent.PostMessage(WM_COLFILTERDLG_USER_MSG_RESIZE_DLG, rrAdv.bottom);
	//}
	///End MAKE_COLFILTER_DLG_RESIZABLE
}

virtual void	ColFilterBaseDlg::InitFilterControls()
{
	m_bEnable = true;	///Jasmine 05/21/2012 ORG-5638-S1 ERROR_CHECK_FOR_EMPTY_COMBO_ITEM
	
	m_btnAdv.Check 		= false;
	m_edCommand.Text 	= "";
	m_edBeforeScript.Text = "";	///Jasmine 05/15/2012 ORG-5668-S3 ADD_BEFORE_QUERY_SCRIPT
	
	if( !m_pHolder->m_col )
		return;
	
	LPVOID 	data;
	int 	nType;
	bool 	bFilter = m_pHolder->m_col.GetFilter(nType, &data);
	if(bFilter && COLUMN_FILTER_TYPE_COMMAND == nType)
	{
		m_btnAdv.Check = true;
		
		CommandColumnFilterData* pdata 	= (CommandColumnFilterData*)data;
		m_cmddata						= *pdata;					
		m_edCommand.Text 				= m_cmddata.lpcszCommand;
		m_edBeforeScript.Text 			= m_cmddata.lpcszPrescript;	///Jasmine 05/15/2012 ORG-5668-S3 ADD_BEFORE_QUERY_SCRIPT
		GetItem(IDC_EDIT_REPRESENT_VAR).Text = m_strSpecVar = m_pHolder->m_col.GetFilterThisCol();		///Jasmine 05/15/2012 ORG-5668-S2 SPECIFY_VARIABLE_TO_REPRECENT_CURRENT_COL
	}
}

void 	ColFilterBaseDlg::moveAdvControls()
{
	vector<uint> vnSimpleIDs, vnAdvIDs;	
	GetSimpleControls(vnSimpleIDs);
	GetAdvControls(vnAdvIDs);
	
	// move advanced controls to simple control place
	if( vnSimpleIDs.GetSize() > 0 && vnAdvIDs.GetSize() > 0 )
	{
		RECT rr1, rr2;
		GetControlClientRect(vnSimpleIDs[0], rr1);
		GetControlClientRect(vnAdvIDs[0], rr2);
		int nY = rr1.top - rr2.top;
		
		int nn = 0;
		while( vnAdvIDs[nn] > 0 )
		{
			RECT rr;
			Control ctrl;
			GetControlClientRect(vnAdvIDs[nn], rr, &ctrl);
			int nHeight = RECT_HEIGHT(rr);
			rr.top += nY;
			rr.bottom = rr.top + nHeight;
			MoveControl(ctrl, rr);
			
			nn++;
		}
	}
	
}

/***********************************************************************
**************************  ColFilterBaseDlg End  **************************
************************************************************************/


/***********************************************************************
*********************  ColFilterNumericDlg Begin  **********************
************************************************************************/
///Jasmine 05/08/2012 ORG-5638-P2 ADD_EMPTY_ITEM_TO_COMBO_TO_DISABLE_SECOND_CONDITION
enum{
	CUSTOMCOLFILTER_NUMERIC_LIST_NONE				= 0,
	
	CUSTOMCOLFILTER_NUMERIC_LIST_BEGIN,		
	CUSTOMCOLFILTER_NUMERIC_LIST_EQUAL				= CUSTOMCOLFILTER_NUMERIC_LIST_BEGIN,
	CUSTOMCOLFILTER_NUMERIC_LIST_NOT_EQUAL,
	CUSTOMCOLFILTER_NUMERIC_LIST_LARGER,
	CUSTOMCOLFILTER_NUMERIC_LIST_LARGER_OR_EQUAL,
	CUSTOMCOLFILTER_NUMERIC_LIST_LESS,
	CUSTOMCOLFILTER_NUMERIC_LIST_LESS_OR_EUQAL,
	CUSTOMCOLFILTER_NUMERIC_LIST_END,	
};
///End ADD_EMPTY_ITEM_TO_COMBO_TO_DISABLE_SECOND_CONDITION
	
BOOL	ColFilterNumericDlg::OnInitPage()
{	
	m_cmbCondition1 = GetItem(IDC_COMBO_CONDITION_1);
	m_cmbCondition2 = GetItem(IDC_COMBO_CONDITION_2);
	m_edValue1 		= GetItem(IDC_COMBO_VALUE_1);
	m_edValue2 		= GetItem(IDC_COMBO_VALUE_2);
	m_checkAbs1 	= GetItem(IDC_CHECK_ABS_VALUE_1);
	m_checkAbs2 	= GetItem(IDC_CHECK_ABS_VALUE_2);
	CheckRadioButton(IDC_RADIO_ADD, IDC_RADIO_OR, IDC_RADIO_ADD);	
	
	ColFilterBaseDlg::OnInitPage();
	
	Control cTip = GetItem(IDC_STATIC_EXP_TIPS_2);
	if(cTip)
	{
		cTip.Text.Format("    %s >= 100 or abs(%s) = 2", STR_COLUMN_FILTER_THIS_COLUMN, STR_COLUMN_FILTER_THIS_COLUMN);
	};
		
	return TRUE;
}

//virtual 
string	ColFilterNumericDlg::GetDlgTitle(bool bAdv)
{
	string strTitle;
	strTitle.Format(ColFilterBaseDlg::GetDlgTitle(bAdv), bAdv? _L("Advanced Numeric") : _L("Simple Numeric"));
	return strTitle;
}

//virtual 
int		ColFilterNumericDlg::GetCheckMenuCategoryIDs(Menu& menu, vector<uint>& vncatagoryIDs)
{
	/// EJP 2012-10-03 ORG-7041 NEW_TRIG_FUNC_CATEGORY
	///m_menu.RemoveMenu(2, MF_BYPOSITION);//Date and Time
	m_menu.RemoveMenu(3, MF_BYPOSITION);//Date and Time
	/// end NEW_TRIG_FUNC_CATEGORY
	m_menu.RemoveMenu(0, MF_BYPOSITION);//String
	
	vector<uint> vnCategoris = {
		IDC_FUNCTION_MENU_MATH, 
		IDC_FUNCTION_MENU_TRIG, /// EJP 2012-10-03 ORG-7041 NEW_TRIG_FUNC_CATEGORY
		IDC_FUNCTION_MENU_STATS, 
		
		IDC_FUNCTION_MENU_CDF,
		IDC_FUNCTION_MENU_PDF,
		IDC_FUNCTION_MENU_INV,
		
		IDC_FUNCTION_MENU_FIT_FUNC,
		IDC_FUNCTION_MENU_USER_DEFINED,
		IDC_FUNCTION_MENU_FAVORITE
	};
	
	vncatagoryIDs = vnCategoris;
	return vncatagoryIDs.GetSize();
}

//virtual 
void 	ColFilterNumericDlg::GetSimpleControls(vector<uint>& vnIDs)
{
	vector<uint> vn = {
		IDC_CHECK_ABS_VALUE_1,
		IDC_COMBO_CONDITION_1,
		IDC_COMBO_VALUE_1,
		IDC_RADIO_ADD,
		IDC_RADIO_OR,
		IDC_CHECK_ABS_VALUE_2,
		IDC_COMBO_CONDITION_2,
		IDC_COMBO_VALUE_2,
		0
	};
	vnIDs = vn;	
}

//virtual 
void 	ColFilterNumericDlg::GetAdvControls(vector<uint>& vnIDs)
{
	vector<uint> vn = {
		IDC_TEXT_QUERY, 					///Jasmine 05/15/2012 ORG-5668-S5 USE_QUERY_FOR_SIMPLE_AND_ADVANCED_MODE
		IDC_EDIT_COMMAND,
		IDC_BUTTON_FUNC,
		IDC_STATIC_VALUE_TIPS_1,
		IDC_STATIC_EXP_TIPS_1,
		IDC_STATIC_EXP_TIPS_2,
		///Jasmine 05/15/2012 ORG-5668-S3 ADD_BEFORE_QUERY_SCRIPT
		IDC_TEXT_BEFORE_QUERY,
		IDC_EDIT_BRFORE_QUERY,		
		///End ADD_BEFORE_QUERY_SCRIPT
		IDC_BUTTON_FUNC2,					///Jasmine 07/10/2012 ORG-6178-P2 ADD_FUNC_MENU_FOR_BEFORE_SCRIPT
		0
	};
	vnIDs = vn;
}
	
//virtual
void	ColFilterNumericDlg::GetSimpleGroupRect(RECT &rectGroup)
{
	RECT rrAbsCheck1, rrCombo2;
	GetControlClientRect(IDC_CHECK_ABS_VALUE_1,	rrAbsCheck1);
	GetControlClientRect(IDC_COMBO_VALUE_2, 	rrCombo2);
	
	rectGroup.left 		= rrAbsCheck1.left;
	rectGroup.top 		= rrAbsCheck1.top;
	rectGroup.bottom 	= rrCombo2.bottom;
	rectGroup.right 	= rrCombo2.right;	
}

//virtual
void	ColFilterNumericDlg::GetAdvGroupRect(RECT &rectGroup)
{
	RECT rrQuery, rrCommand, rrBeforeScript/*rrBottomTips*/, rrRightBtn;
	GetControlClientRect(IDC_EDIT_COMMAND, 			rrCommand);
	GetControlClientRect(IDC_TEXT_QUERY, 			rrQuery);			///Jasmine 05/15/2012 ORG-5668-S5 USE_QUERY_FOR_SIMPLE_AND_ADVANCED_MODE
	GetControlClientRect(IDC_EDIT_BRFORE_QUERY, 	rrBeforeScript);//GetControlClientRect(IDC_STATIC_VALUE_TIPS_3, 	rrBottomTips);///Jasmine 05/15/2012 ORG-5668-S3 ADD_BEFORE_QUERY_SCRIPT
	GetControlClientRect(IDC_BUTTON_FUNC, 			rrRightBtn);
	
	rectGroup.left 		= rrCommand.left;
	rectGroup.top 		= rrQuery.top;//rrCommand.top;					///Jasmine 05/15/2012 ORG-5668-S5 USE_QUERY_FOR_SIMPLE_AND_ADVANCED_MODE
	rectGroup.bottom 	= rrBeforeScript.bottom;//rrBottomTips.bottom;	///Jasmine 05/15/2012 ORG-5668-S3 ADD_BEFORE_QUERY_SCRIPT
	rectGroup.right 	= rrRightBtn.right;	
}

///Jasmine 07/18/2012 ORG-5851-S4 DISABLE_CONDITION_CTRLS_WHEN_COMBO_IS_EMPTY
//virtual 
BOOL 	ColFilterNumericDlg::EnableCtrlsByComboSel(ComboBox& combo)
{
	int nResID 	= GetDlgCtrlID( combo.GetSafeHwnd() );
	int nID		=(IDC_COMBO_CONDITION_2 == nResID)? IDC_COMBO_VALUE_2 : IDC_COMBO_VALUE_1;
	GetItem(nID).Enable = combo.GetCurSel() != 0;
	return TRUE;
}
///End DISABLE_CONDITION_CTRLS_WHEN_COMBO_IS_EMPTY

//virtual 
void	ColFilterNumericDlg::InitFilterControls()
{
	ColFilterBaseDlg::InitFilterControls();
	
	OnComboChange(m_cmbCondition1);
	OnComboChange(m_cmbCondition2);
	
	if( !m_pHolder->m_col )
		return;
	
	LPVOID data;
	int nType;
	if( !m_pHolder->m_col.GetFilter(nType, &data) 
		|| COLUMN_FILTER_TYPE_CUSTOM != nType)			///Jasmine 06/05/2012 ADVANCED_MODE_SHOULD_ALSO_INIT_SIMPLE_MODE_CTRLS
	{
		clearGUI();
		return;// no filter	
	}
	///Jasmine 06/05/2012 ADVANCED_MODE_SHOULD_ALSO_INIT_SIMPLE_MODE_CTRLS
	//if(COLUMN_FILTER_TYPE_CUSTOM == nType)
	else
	//End ADVANCED_MODE_SHOULD_ALSO_INIT_SIMPLE_MODE_CTRLS
	{
		CustomColumnFilterData* pdata = (CustomColumnFilterData*)data;
		m_data = *pdata;			
		
		conditionToGUI(m_data.cond[0], m_cmbCondition1, m_edValue1, m_checkAbs1);		
		conditionToGUI(m_data.cond[1], m_cmbCondition2, m_edValue2, m_checkAbs2);
		
		// And or Or radios
		//CheckRadioButton(IDC_RADIO_ADD, IDC_RADIO_OR, IDC_RADIO_ADD + m_data.nLogic);
		int nIDCheckButton = IDC_RADIO_ADD;
		switch(m_data.nLogic)
		{		
		case CUSTOM_COLUMN_FILTER_LOGIC_ALL_OR:
			nIDCheckButton = IDC_RADIO_OR;
			break;		
		//case CUSTOM_COLUMN_FILTER_LOGIC_ALL_AND:
		default:
			break;			
		}
		CheckRadioButton(IDC_RADIO_ADD, IDC_RADIO_OR, nIDCheckButton);
		
		OnComboChange(m_cmbCondition1);		///Jasmine 05/21/2012 ORG-5638-S1 ERROR_CHECK_FOR_EMPTY_COMBO_ITEM
	}
	
}

bool	ColFilterNumericDlg::clearGUI()
{	
	m_checkAbs1.Check 	= false;
	m_cmbCondition1.SetCurSel(CUSTOMCOLFILTER_NUMERIC_LIST_EQUAL);
	m_edValue1.Text 	= "";
	
	m_checkAbs2.Check	= false;
	m_cmbCondition2.SetCurSel(CUSTOMCOLFILTER_NUMERIC_LIST_NONE);
	m_edValue2.Text 	= "";
	
	//---these are done in ColFilterBaseDlg::InitFilterControls();
	//m_btnAdv.Check 		= false;
	//m_edCommand.Text 	= "";
	//m_edBeforeScript.Text = "";	///Jasmine 05/15/2012 ORG-5668-S3 ADD_BEFORE_QUERY_SCRIPT
	//---End 
	
	CheckRadioButton(IDC_RADIO_ADD, IDC_RADIO_OR, IDC_RADIO_ADD);
	
	return true;
}

bool	ColFilterNumericDlg::conditionToGUI(CustomColumnFilterConditionData &conditionData, ComboBox& cmbFormula, Edit& edValue, Button& checkAbs)
{
	cmbFormula.SetCurSel(CUSTOMCOLFILTER_NUMERIC_LIST_NONE);
	edValue.Text 		= "";;
	checkAbs.Check 		= false; 
	
	int nObjType = conditionData.nObjType;	
	if( nObjType != CUSTOM_COLUMN_FILTER_OBJECT_NUMERIC )
		return false;
	
	int nFormulaType = conditionData.nFormulaType;	
	if( nFormulaType >= CUSTOM_COLUMN_FILTER_FORMULA_NUMERIC_BEGIN && nFormulaType <= CUSTOM_COLUMN_FILTER_FORMULA_NUMERIC_END )		
	{
		int nFormulaCombo 	= nFormulaType - CUSTOM_COLUMN_FILTER_FORMULA_NUMERIC_BEGIN + CUSTOMCOLFILTER_NUMERIC_LIST_BEGIN;
		string strValCombo 	= conditionData.lpcszValue;
		bool bAbsChecked 	= conditionData.dwOption & CUSTOM_COLUMN_FILTER_OPTION_ABS;
		
		cmbFormula.SetCurSel(nFormulaCombo);
		edValue.Text 		= strValCombo;
		checkAbs.Check 		= bAbsChecked; 
		return true;
	}	
	
	return false;
}

///Jasmine 05/10/2012 ORG-4862-P4 CAREFULLY_USE_FILTER_DATA_STRUCT_LPCSTR
//bool 	ColFilterNumericDlg::GUIToCondition(int nFormula, LPCSTR lpcszVal, bool bUsingAbs, CustomColumnFilterConditionData& conditionData)
bool 	ColFilterNumericDlg::GUIToCondition(int nFormula, LPCSTR lpcszVal, bool bUsingAbs, 
											int& nObjType, int& nFormulaType, string& strValue, DWORD& dwOption)
///End CAREFULLY_USE_FILTER_DATA_STRUCT_LPCSTR
{
	if(	nFormula < CUSTOMCOLFILTER_NUMERIC_LIST_BEGIN 
		|| nFormula > CUSTOMCOLFILTER_NUMERIC_LIST_END
		|| lstrlen(lpcszVal) <= 0)
	{
		nObjType 	= CUSTOM_COLUMN_FILTER_OBJECT_NONE;		
		nFormulaType= CUSTOM_COLUMN_FILTER_FORMULA_NONE;
		strValue	= "";
		dwOption	= 0;
		return false;
	}
	
	nObjType 		= CUSTOM_COLUMN_FILTER_OBJECT_NUMERIC;		
	nFormulaType 	= nFormula - CUSTOMCOLFILTER_NUMERIC_LIST_BEGIN + CUSTOM_COLUMN_FILTER_FORMULA_NUMERIC_BEGIN;
	strValue 		= lpcszVal;
	dwOption 		= bUsingAbs ? CUSTOM_COLUMN_FILTER_OPTION_ABS : 0;
	return true;
}

/// Zech 06/28/2012 ORG-5638-P12 FIX_CONSTRCT_COL_FILTER_QUERY_DATA
/*
///Jasmine 05/16/2012 ORG-5668-S1 CONSTRUCT_QUERY_STRING_FROM_SIMPLE_MODE	
#define _NUMERIC_DLG_FILL_M_DATA						\
	int 	nObjType1, nFormulaType1;					\
	string 	strValue1;									\
	DWORD 	dwOption1;									\
	bool 	bHasCondition1 		= GUIToCondition(m_cmbCondition1.GetCurSel(), m_edValue1.Text, m_checkAbs1.Check, nObjType1, nFormulaType1, strValue1, dwOption1);	\
	m_data.cond[0].nObjType 	= nObjType1;			\
	m_data.cond[0].nFormulaType	= nFormulaType1;		\
	m_data.cond[0].lpcszValue	= strValue1;			\
	m_data.cond[0].dwOption		= dwOption1;			\
														\
	int 	nObjType2, nFormulaType2, ii = bHasCondition1? 1 : 0; \
	string 	strValue2;									\
	DWORD 	dwOption2;									\
	bool 	bHasCondition2 		= GUIToCondition(m_cmbCondition2.GetCurSel(), m_edValue2.Text, m_checkAbs2.Check, nObjType2, nFormulaType2, strValue2, dwOption2);	\
	m_data.cond[ii].nObjType 	= nObjType2;			\
	m_data.cond[ii].nFormulaType= nFormulaType2;		\
	m_data.cond[ii].lpcszValue	= strValue2;			\
	m_data.cond[ii].dwOption	= dwOption2;			\
														\	
	int nRadioChecked = GetCheckedRadioButton(IDC_RADIO_ADD, IDC_RADIO_OR);		\
	if( bHasCondition1 && bHasCondition2 && 0 != nRadioChecked )				\
		m_data.nLogic = nRadioChecked - IDC_RADIO_ADD;							\
	else																		\
		m_data.nLogic = -1;			
	
///End CONSTRUCT_QUERY_STRING_FROM_SIMPLE_MODE
*/
void	ColFilterNumericDlg::InitQueryData()
{
	m_data.nLogic = CUSTOM_COLUMN_FILTER_LOGIC_ALL_AND;		// By default
	for (int ii = 0; ii < CUSTOM_COLUMN_FILTER_CONDITION_NUM; ++ii)
		m_data.cond[ii].nObjType = CUSTOM_COLUMN_FILTER_OBJECT_NONE;
}

bool	ColFilterNumericDlg::UpdateQueryData(bool& bHasAnyCondition)
{
	InitQueryData();
	
	int 	nObjType1, nFormulaType1;
	DWORD 	dwOption1;
	bool 	bHasCondition1 		= GUIToCondition(m_cmbCondition1.GetCurSel(), m_edValue1.Text, m_checkAbs1.Check, nObjType1, nFormulaType1, m_strValue1, dwOption1);
	m_data.cond[0].nObjType 	= nObjType1;
	m_data.cond[0].nFormulaType	= nFormulaType1;
	m_data.cond[0].lpcszValue	= m_strValue1;
	m_data.cond[0].dwOption		= dwOption1;
	
	int 	nObjType2, nFormulaType2, ii = bHasCondition1? 1 : 0;
	string	&strValue2 = 1 == ii ? m_strValue2 : m_strValue1;
	DWORD 	dwOption2;
	bool 	bHasCondition2 		= GUIToCondition(m_cmbCondition2.GetCurSel(), m_edValue2.Text, m_checkAbs2.Check, nObjType2, nFormulaType2, strValue2, dwOption2);
	m_data.cond[ii].nObjType 	= nObjType2;
	m_data.cond[ii].nFormulaType= nFormulaType2;
	m_data.cond[ii].lpcszValue	= strValue2;
	m_data.cond[ii].dwOption	= dwOption2;
	
	int nRadioChecked = GetCheckedRadioButton(IDC_RADIO_ADD, IDC_RADIO_OR);
	if( 0 != nRadioChecked )
		m_data.nLogic = nRadioChecked - IDC_RADIO_ADD;
	
	bHasAnyCondition = bHasCondition1 || bHasCondition2;
	return TRUE;
}
/// END FIX_CONSTRCT_COL_FILTER_QUERY_DATA

BOOL	ColFilterNumericDlg::OnApply(Control ctrl)
{		
	if( ColFilterBaseDlg::OnApply(ctrl) )
		return TRUE;
	
	if( isApplied() )
		return TRUE;
	
	UndoBlock 	block;			///Jasmine 05/22/2012 ORG-5524-P1 UNDO_SETFILTER_AND_RUNUFILTER_IN_ONE_TIME
	BOOL 		bRet = FALSE;
	
	/// Zech 06/28/2012 ORG-5638-P12 FIX_CONSTRCT_COL_FILTER_QUERY_DATA
	/*
	_NUMERIC_DLG_FILL_M_DATA	///Jasmine 05/16/2012 ORG-5668-S1 CONSTRUCT_QUERY_STRING_FROM_SIMPLE_MODE		
	
	if( !bHasCondition1 && !bHasCondition2 )
	*/
	bool		bHasAnyCondition;
	UpdateQueryData(bHasAnyCondition);
	if(!bHasAnyCondition)
	/// END FIX_CONSTRCT_COL_FILTER_QUERY_DATA
		m_pHolder->m_col.ResetFilter(FALSE);
	else
		m_pHolder->m_col.SetFilter((int)COLUMN_FILTER_TYPE_CUSTOM, (LPVOID)&m_data, TRUE);
	
	Worksheet wks;
	m_pHolder->m_col.GetParent(wks);
	if( wks )
	{
		/// Zech 06/08/2012 ORG-5154-P6 SHOULD_NOT_REAPPLY_WHEN_FILTER_DISABLED
		if (!m_pHolder->m_col.IsFilterDisabled())
		/// END SHOULD_NOT_REAPPLY_WHEN_FILTER_DISABLED
			wks.RunFilter(0, 0, -1, true);//wks.RunFilter();	///Jasmine 05/22/2012 ORG-5524-P1 UNDO_SETFILTER_AND_RUNUFILTER_IN_ONE_TIME
		
		onAfterApply();
		bRet = TRUE;
	}
	
	return bRet;
}

///Jasmine 05/16/2012 ORG-5668-S1 CONSTRUCT_QUERY_STRING_FROM_SIMPLE_MODE
//virtual 
void	ColFilterNumericDlg::ConstructQueryString()
{
	/// Zech 06/28/2012 ORG-5638-P12 FIX_CONSTRCT_COL_FILTER_QUERY_DATA
	/*
	_NUMERIC_DLG_FILL_M_DATA	
	
	if(bHasCondition1 || bHasCondition2)
	*/
	bool		bHasAnyCondition;
	UpdateQueryData(bHasAnyCondition);
	if(bHasAnyCondition)
	/// END FIX_CONSTRCT_COL_FILTER_QUERY_DATA
	{
		/// Zech 07/12/2012 ORG-6205-P1 BETTER_SUPPORT_ON_COLUMN_FILTER_PRESCRIPT
		//m_pHolder->m_col.GetFilterQueryString(strQuery, (int)COLUMN_FILTER_TYPE_CUSTOM, (LPVOID)&m_data, m_strSpecVar);
		string 	strQuery, strBeforeScript;
		m_pHolder->m_col.GetFilterQueryInfo(&strQuery, &strBeforeScript, (int)COLUMN_FILTER_TYPE_CUSTOM, (LPVOID)&m_data, m_strSpecVar);
		/// END BETTER_SUPPORT_ON_COLUMN_FILTER_PRESCRIPT
		
		int 	nLen = strQuery.GetLength();
		if(nLen > MAX_BUFFER_SIZE) 
		{ 
			warning_msg_box(CFERR_CHECK_LIST_TOO_LONG_TO_DISPLAY_IN_ADVANCED_MODE, false); 
			return; 
		} 
		
		m_edCommand.Text = strQuery;
		/// Zech 07/12/2012 ORG-6205-P1 BETTER_SUPPORT_ON_COLUMN_FILTER_PRESCRIPT
		m_edBeforeScript.Text = strBeforeScript;
		/// END BETTER_SUPPORT_ON_COLUMN_FILTER_PRESCRIPT
	}
	else
		m_edCommand.Text = "";
}
///End CONSTRUCT_QUERY_STRING_FROM_SIMPLE_MODE

///Jasmine 07/18/2012 ORG-6252-P1 HIDE_NAVIGATE_BTNS
#ifndef _ALLOW_NAVIGATE_TO_OTHER_COL
//virtual 
int		ColFilterNumericDlg::GetMinClientWidth()
{	
	RECT rr;
	GetControlClientRect(IDC_COMBO_VALUE_1, rr);
	return rr.right + _DLG_GAP*4;
}
#endif //_ALLOW_NAVIGATE_TO_OTHER_COL
///End HIDE_NAVIGATE_BTNS

///Jasmine 05/09/2012 ORG-4862-S6 MAKE_COLFILTER_DLG_RESIZABLE	
//virtual
void	ColFilterNumericDlg::OnDlgResize(int nType, int nRight, int nBottom)
{
	bool bAdv = m_btnAdv.Check;
	if(bAdv)
	{
		ColFilterBaseDlg::OnDlgResize(nType, nRight, nBottom);
		return;
	}
	
	MoveControlsHelper clCacheWndPosHelper(this);
	
	RECT 	rrAdv;
	GetControlClientRect(IDC_CHECK_ADVANCED,	rrAdv);
	
	int		nDx	= nRight - _DLG_GAP - rrAdv.right;
	int		nDy = nBottom - _DLG_GAP - rrAdv.bottom;
	
	vector<uint> vnIDs = {IDC_CHECK_ADVANCED, 0};
	MoveControls(vnIDs, nDx, nDy);	
}

//virtual 
int		ColFilterNumericDlg::GetQueryTipsIDs(vector<uint>& vnIDs)
{
	vector<uint> vnTemp = {	IDC_STATIC_VALUE_TIPS_1, IDC_STATIC_EXP_TIPS_1,	IDC_STATIC_EXP_TIPS_2, IDC_TEXT_BEFORE_QUERY, 0};
	vnIDs = vnTemp;
	return vnIDs.GetSize();
}
///End MAKE_COLFILTER_DLG_RESIZABLE
	
/***********************************************************************
***********************  ColFilterNumericDlg End  **********************
************************************************************************/

	
/***********************************************************************
***********************  ColFilterTextDlg Begin  ***********************
************************************************************************/
#define CHECK_LIST_COUNT_COL			2	///Jasmine 05/15/2012 ORG-4862-S8 COLUMN_DISTINCT_VALUES_NEED_COUNT
BOOL	ColFilterTextDlg::OnInitPage()
{		
	///Jasmine 05/09/2012 ORG-4862-P4 OPEN_CUSTOM_FILTER_DLG_FROM_CHECK_LIST_MORE_SHOULD_UPDATE_DIALOG_CHECK_LIST
	if(m_pHolder->m_DataStruct.lpcszCheckList != NULL)
		m_strInputCheckList = m_pHolder->m_DataStruct.lpcszCheckList;
	///End OPEN_CUSTOM_FILTER_DLG_FROM_CHECK_LIST_MORE_SHOULD_UPDATE_DIALOG_CHECK_LIST
	
	m_gridDistinctValues.Init(IDC_LIST, *this, true, true);
	m_gridDistinctValues.SetExplorerBar(flexExSortShow);
	
	///Jasmine 05/15/2012 ORG-4862-S8 COLUMN_DISTINCT_VALUES_NEED_COUNT
	string strColHeaders = " |" + _L("Entry|Count");
	m_gridDistinctValues.SetColHeader(strColHeaders);
	m_gridDistinctValues.SetColAlignment(CHECK_LIST_COUNT_COL, flexAlignLeftCenter);
	///End COLUMN_DISTINCT_VALUES_NEED_COUNT
	
	ColFilterBaseDlg::OnInitPage();
	
	Control cTip = GetItem(IDC_STATIC_EXP_TIPS_2);
	if(cTip)
	{
		///Jasmine 05/21/2012 ORG-5142-P1 EQUAL_SIGN_IS_FULL_MATCH_WHILE_LIKE_IS_WILDCAST_COMPARISON
		//cTip.Text.Format("%s == \"a*\" && %s != \"?b*\"", STR_COLUMN_FILTER_THIS_COLUMN, STR_COLUMN_FILTER_THIS_COLUMN);
		cTip.Text.Format("    %s LIKE \"a*\" and %s NOT LIKE \"?b*\"", STR_COLUMN_FILTER_THIS_COLUMN, STR_COLUMN_FILTER_THIS_COLUMN);
		///End EQUAL_SIGN_IS_FULL_MATCH_WHILE_LIKE_IS_WILDCAST_COMPARISON
	}
	
	return TRUE;
}

//virtual 
string	ColFilterTextDlg::GetDlgTitle(bool bAdv)
{
	string strTitle;
	strTitle.Format(ColFilterBaseDlg::GetDlgTitle(bAdv), bAdv? _L("Advanced Text") : _L("Simple Text"));
	return strTitle;
}

BOOL	ColFilterTextDlg::OnApply(Control ctrl)
{
	if( ColFilterBaseDlg::OnApply(ctrl) )
		return TRUE;
	
	if( isApplied() )
		return TRUE;
	
	UndoBlock 	block;			///Jasmine 05/22/2012 ORG-5524-P1 UNDO_SETFILTER_AND_RUNUFILTER_IN_ONE_TIME
	BOOL 		bRet = FALSE;
	
	///Jasmine 05/10/2012 ORG-4862-P4 CAREFULLY_USE_FILTER_DATA_STRUCT_LPCSTR
	//if( !GUIToCondition(m_data) )
	string strValue;
	if( !GUIToCondition(strValue) )
	///End CAREFULLY_USE_FILTER_DATA_STRUCT_LPCSTR
	{
		m_pHolder->m_col.ResetFilter(FALSE);
	}
	else
	{
		m_data.lpcszValues = strValue;		///Jasmine 05/10/2012 ORG-4862-P4 CAREFULLY_USE_FILTER_DATA_STRUCT_LPCSTR
		m_pHolder->m_col.SetFilter((int)COLUMN_FILTER_TYPE_CHECK_LIST, (LPVOID)&m_data, TRUE);
	}
	
	Worksheet wks;
	m_pHolder->m_col.GetParent(wks);
	if( wks )
	{
		/// Zech 06/08/2012 ORG-5154-P6 SHOULD_NOT_REAPPLY_WHEN_FILTER_DISABLED
		if (!m_pHolder->m_col.IsFilterDisabled())
		/// END SHOULD_NOT_REAPPLY_WHEN_FILTER_DISABLED
			wks.RunFilter(0, 0, -1, true);//wks.RunFilter();	///Jasmine 05/22/2012 ORG-5524-P1 UNDO_SETFILTER_AND_RUNUFILTER_IN_ONE_TIME
		
		onAfterApply();
		bRet = TRUE;
	}
	
	return bRet;
}

///Jasmine 05/10/2012 ORG-4862-P4 CAREFULLY_USE_FILTER_DATA_STRUCT_LPCSTR
//bool	ColFilterTextDlg::GUIToCondition(CheckListColumnFilterData& conditionData)
bool	ColFilterTextDlg::GUIToCondition(string& strValue)
///End CAREFULLY_USE_FILTER_DATA_STRUCT_LPCSTR
{		
	vector<string>	vsFilter, vsRet;
	vector<int>		vnCheck;
	vector 			vIndex;
	int nSize = m_gridDistinctValues.GetCheckList(vsFilter, vnCheck);	
	vIndex.Data(0, nSize-1);
	vIndex /= vnCheck;
	vIndex.Trim();
	
	vector<uint> 	vnIndex;
	vnIndex = vIndex;
	vsFilter.GetSubVector(vsRet, vnIndex);	
	int nRet = vsRet.GetSize();
	///Jasmine 05/10/2012 ORG-5525-P4 WE_SHOULD_ALLOW_USER_TO_HIDE_ALL_VALUES
	//if(nRet < 1 || nRet >= nSize)
	if(nRet == 0)
	{
		strValue = "";//conditionData.lpcszValues = "";	///Jasmine 05/10/2012 ORG-4862-P4 CAREFULLY_USE_FILTER_DATA_STRUCT_LPCSTR
		return true;
	}
	if(nRet < 0 || nRet >= nSize)
	///End WE_SHOULD_ALLOW_USER_TO_HIDE_ALL_VALUES
		return false;
	
	///Jasmine 05/02/2012 ORG-4862-S1 ADD_BLANK_AND_MISSING_INTO_FILTER_CHECK_LIST
	//conditionData.lpcszValues = str_combine(vsRet, _STR_CHECK_LIST_SEP);		
	string strTemp;
	strTemp.SetTokens(vsRet, _STR_CHECK_LIST_SEP);		
	strTemp.Replace(STR_BLANK_OR_MISSING, "");
	if( strTemp.IsEmpty() )strTemp.Format("%c", _STR_CHECK_LIST_SEP);
	strValue = strTemp;//conditionData.lpcszValues = strTemp;			///Jasmine 05/10/2012 ORG-4862-P4 CAREFULLY_USE_FILTER_DATA_STRUCT_LPCSTR
	///End ADD_BLANK_AND_MISSING_INTO_FILTER_CHECK_LIST
	return true;
}

///Jasmine 05/16/2012 ORG-5668-S1 CONSTRUCT_QUERY_STRING_FROM_SIMPLE_MODE
//virtual 
void	ColFilterTextDlg::ConstructQueryString()
{
	string strValue;
	if( GUIToCondition(strValue) )
	{
		m_data.lpcszValues = strValue;	
		
		/// Zech 07/12/2012 ORG-6205-P1 BETTER_SUPPORT_ON_COLUMN_FILTER_PRESCRIPT
		//m_pHolder->m_col.GetFilterQueryString(strQuery, (int)COLUMN_FILTER_TYPE_CHECK_LIST, (LPVOID)&m_data, m_strSpecVar);
		string 	strQuery, strBeforeScript;		
		m_pHolder->m_col.GetFilterQueryInfo(&strQuery, &strBeforeScript, (int)COLUMN_FILTER_TYPE_CHECK_LIST, (LPVOID)&m_data, m_strSpecVar);
		/// END BETTER_SUPPORT_ON_COLUMN_FILTER_PRESCRIPT
		int 	nLen = strQuery.GetLength();
		if(nLen > MAX_BUFFER_SIZE) 
		{ 
			warning_msg_box(CFERR_CHECK_LIST_TOO_LONG_TO_DISPLAY_IN_ADVANCED_MODE, false); 
			return; 
		} 
		
		m_edCommand.Text = strQuery;
		/// Zech 07/12/2012 ORG-6205-P1 BETTER_SUPPORT_ON_COLUMN_FILTER_PRESCRIPT
		m_edBeforeScript.Text = strBeforeScript;
		/// END BETTER_SUPPORT_ON_COLUMN_FILTER_PRESCRIPT
	}
	else
		m_edCommand.Text = "";
}
///End CONSTRUCT_QUERY_STRING_FROM_SIMPLE_MODE

BOOL	ColFilterTextDlg::OnCheckAll(Control ctrl)
{
	int nResID = GetDlgCtrlID( ctrl.GetSafeHwnd() ), nCheckType;
	if(IDC_BUTTON_CHECK_ALL 		== nResID)
		nCheckType = CHECK_ALL_TRUE;
	else if(IDC_BUTTON_TOGGLE_ALL 	== nResID)
		nCheckType = CHECK_ALL_INVERSE;
	else if(IDC_BUTTON_CLEAR_ALL 	== nResID)
		nCheckType = CHECK_ALL_FALSE;
	else
		nCheckType = -1;
	
	if(	-1 != nCheckType
		&& m_gridDistinctValues.CheckAll(nCheckType) )
	{
		UpdateOccurrencesText();	///Jasmine 05/15/2012 ORG-4862-S8 COLUMN_DISTINCT_VALUES_NEED_COUNT
		Control junk;
		OnControlChange(junk);
	}
	
	return TRUE;
}

void	ColFilterTextDlg::OnBeforeEditCheckList(Control flxControl, int nRow, int nCol, BOOL* pCancel)
{
	m_gridDistinctValues.OnBeforeEditCheckList(nRow, nCol, pCancel);
}

///Jasmine 05/15/2012 ORG-4862-S8 COLUMN_DISTINCT_VALUES_NEED_COUNT
void	ColFilterTextDlg::OnAfterEditCheckList(Control flxControl, int nRow, int nCol)
{	
	UpdateOccurrencesText();
	Control junk; 
	OnControlChange(junk);
}

void 	ColFilterTextDlg::UpdateOccurrencesText()
{
	Control ctrl = GetItem(IDC_TEXT_OCCURRENCE);
	if(!ctrl)
		return;
	
	vector<string>	vsFilter, vsCounts;
	vector<int>		vnCheck, vnCount;
	vector			vTemp;
	int nSize = m_gridDistinctValues.GetCheckList(vsFilter, vnCheck);	
	
	m_gridDistinctValues.GetColValues(CHECK_LIST_COUNT_COL, vsCounts, m_gridDistinctValues.GetRowOffset());	
	convert_string_vector_to_int_vector(vsCounts, vnCount);
	vTemp = vnCount;
	vTemp /= vnCheck;
	vTemp.Trim();
	vnCount = vTemp;
	
	int nSum;
	vnCount.Sum(nSum);
	
	string strText;
	strText.Format(_L("Occurrences of checked entries: %d"), nSum);
	ctrl.Text = strText;
}
///End COLUMN_DISTINCT_VALUES_NEED_COUNT

//virtual 
int		ColFilterTextDlg::GetCheckMenuCategoryIDs(Menu& menu, vector<uint>& vncatagoryIDs)
{	
	/// EJP 2012-10-08 ORG-7041 NEW_TRIG_FUNC_CATEGORY
	///m_menu.RemoveMenu(5, MF_BYPOSITION);//Fitting Functions
	///m_menu.RemoveMenu(4, MF_BYPOSITION);//Distributions
	///m_menu.RemoveMenu(3, MF_BYPOSITION);//Statistics
	///m_menu.RemoveMenu(2, MF_BYPOSITION);//Date and Time
	m_menu.RemoveMenu(6, MF_BYPOSITION);//Fitting Functions
	m_menu.RemoveMenu(5, MF_BYPOSITION);//Distributions
	m_menu.RemoveMenu(4, MF_BYPOSITION);//Statistics
	m_menu.RemoveMenu(3, MF_BYPOSITION);//Date and Time
	m_menu.RemoveMenu(2, MF_BYPOSITION);//Trigonometric
	/// end NEW_TRIG_FUNC_CATEGORY
	m_menu.RemoveMenu(1, MF_BYPOSITION);//Math
	
	vector<uint> vnCategoris = {
		IDC_FUNCTION_MENU_TEXT, 
		IDC_FUNCTION_MENU_USER_DEFINED,
		IDC_FUNCTION_MENU_FAVORITE
	};
	
	vncatagoryIDs = vnCategoris;
	return vncatagoryIDs.GetSize();
}

//virtual 
void 	ColFilterTextDlg::GetSimpleControls(vector<uint>& vnIDs)
{
	vector<uint> vn = {
		IDC_TEXT_OCCURRENCE,
		IDC_LIST,
		IDC_BUTTON_CHECK_ALL,
		IDC_BUTTON_TOGGLE_ALL,
		IDC_BUTTON_CLEAR_ALL
	};
	
	if(m_btnAdv.Check)
		vn.Add(IDC_STATIC_EXCEED_TIPS);
	else if(COLDISTINCTVALUE_MAX_REACHED == m_nRetGetDistinctValues)
		vn.Add(IDC_STATIC_EXCEED_TIPS);
	
	vn.Add(0);
	vnIDs = vn;	
}

//virtual 
void 	ColFilterTextDlg::GetAdvControls(vector<uint>& vnIDs)
{
	vector<uint> vn = {
		IDC_TEXT_QUERY, 					///Jasmine 05/15/2012 ORG-5668-S5 USE_QUERY_FOR_SIMPLE_AND_ADVANCED_MODE
		IDC_EDIT_COMMAND,
		IDC_BUTTON_FUNC,
		IDC_STATIC_STR_MATCH_TIPS,
		IDC_STATIC_CHAR_MATCH_TIPS,
		IDC_STATIC_EXP_TIPS_1,
		IDC_STATIC_EXP_TIPS_2,
		///Jasmine 05/15/2012 ORG-5668-S3 ADD_BEFORE_QUERY_SCRIPT
		IDC_TEXT_BEFORE_QUERY,
		IDC_EDIT_BRFORE_QUERY, 		
		///End ADD_BEFORE_QUERY_SCRIPT
		IDC_BUTTON_FUNC2,					///Jasmine 07/10/2012 ORG-6178-P2 ADD_FUNC_MENU_FOR_BEFORE_SCRIPT
		0
	};
	vnIDs = vn;
}

//virtual
void	ColFilterTextDlg::GetSimpleGroupRect(RECT &rectGroup)
{
	RECT rrList, rrBtn, rrTip, rrText;
	GetControlClientRect(IDC_TEXT_OCCURRENCE,	rrText);				///Jasmine 05/15/2012 ORG-4862-S8 COLUMN_DISTINCT_VALUES_NEED_COUNT
	GetControlClientRect(IDC_LIST, 				rrList);
	GetControlClientRect(IDC_BUTTON_CHECK_ALL, 	rrBtn);
	GetControlClientRect(IDC_STATIC_EXCEED_TIPS, rrTip);
	
	rectGroup.left 		= rrList.left;
	rectGroup.top 		= rrText.top;//rrList.top;						///Jasmine 05/15/2012 ORG-4862-S8 COLUMN_DISTINCT_VALUES_NEED_COUNT
	rectGroup.bottom 	= rrTip.bottom;
	rectGroup.right 	= rrBtn.right;			
}

//virtual
void	ColFilterTextDlg::GetAdvGroupRect(RECT &rectGroup)
{
	RECT rrQuery, rrCommand, rrBtn, rrBeforeScript;//rrLastTips;		///Jasmine 05/15/2012 ORG-5668-S3 ADD_BEFORE_QUERY_SCRIPT
	GetControlClientRect(IDC_EDIT_COMMAND, 				rrCommand);
	GetControlClientRect(IDC_BUTTON_FUNC, 				rrBtn);
	GetControlClientRect(IDC_TEXT_QUERY, 				rrQuery);		///Jasmine 05/15/2012 ORG-5668-S5 USE_QUERY_FOR_SIMPLE_AND_ADVANCED_MODE
	GetControlClientRect(IDC_EDIT_BRFORE_QUERY, 		rrBeforeScript);//GetControlClientRect(IDC_STATIC_CHAR_MATCH_TIPS, 	rrLastTips);	///Jasmine 05/15/2012 ORG-5668-S3 ADD_BEFORE_QUERY_SCRIPT
	
	rectGroup.left 		= rrCommand.left;
	rectGroup.top 		= rrQuery.top;//rrCommand.top;					///Jasmine 05/15/2012 ORG-5668-S5 USE_QUERY_FOR_SIMPLE_AND_ADVANCED_MODE
	rectGroup.bottom 	= rrBeforeScript.bottom;//rrLastTips.bottom;	///Jasmine 05/15/2012 ORG-5668-S3 ADD_BEFORE_QUERY_SCRIPT
	rectGroup.right 	= rrBtn.right;			
}

///Jasmine 05/09/2012 ORG-4862-P4 OPEN_CUSTOM_FILTER_DLG_FROM_CHECK_LIST_MORE_SHOULD_UPDATE_DIALOG_CHECK_LIST
//virtual 
void 	ColFilterTextDlg::CheckEnableApplyBtn()
{
	if(okutil_cvt_str_to_predefined_type(m_strInputCheckList) != PDS_UNASSIGNED)
	{		
		m_strInputCheckList = STR_UNASSIGNED;
		Control junk;
		OnControlChange(junk);
	}
}
///End OPEN_CUSTOM_FILTER_DLG_FROM_CHECK_LIST_MORE_SHOULD_UPDATE_DIALOG_CHECK_LIST

//virtual 
void	ColFilterTextDlg::InitFilterControls()
{
	ColFilterBaseDlg::InitFilterControls();
	
	if( !m_pHolder->m_col )
		return;
	
	LPVOID 	data;
	int 	nType;
	bool 	bFilter = m_pHolder->m_col.GetFilter(nType, &data);
	
	vector<string> 	vsFilterData;
	int				nData = 0;
	///Jasmine 05/09/2012 ORG-4862-P4 OPEN_CUSTOM_FILTER_DLG_FROM_CHECK_LIST_MORE_SHOULD_UPDATE_DIALOG_CHECK_LIST
	if(okutil_cvt_str_to_predefined_type(m_strInputCheckList) != PDS_UNASSIGNED)
	{
		nData	= okutil_get_tokens(m_strInputCheckList, &vsFilterData, _STR_CHECK_LIST_SEP, NULL);
	}
	///End OPEN_CUSTOM_FILTER_DLG_FROM_CHECK_LIST_MORE_SHOULD_UPDATE_DIALOG_CHECK_LIST
	else if(bFilter && COLUMN_FILTER_TYPE_CHECK_LIST == nType)
	{
		CheckListColumnFilterData* pdata = (CheckListColumnFilterData*)data;
		m_data	= *pdata;					
		nData	= okutil_get_tokens(m_data.lpcszValues, &vsFilterData, _STR_CHECK_LIST_SEP, NULL);
	}
	else
	{
		int nRet = m_pHolder->m_col.GetDistinctValues(vsFilterData, NULL, /*bOnlyGetShownValues*/true);
		nData 	= vsFilterData.GetSize();
	}
		
	vector<string> 	vsDistinctValuse;
	vector<uint> 	vnCounts;				///Jasmine 05/15/2012 ORG-4862-S8 COLUMN_DISTINCT_VALUES_NEED_COUNT
	m_nRetGetDistinctValues = m_pHolder->m_col.GetDistinctValues(vsDistinctValuse, &vnCounts, /*bOnlyGetShownValues*/false);
	Control ctrText = GetItem(IDC_STATIC_EXCEED_TIPS);
	if(ctrText) ctrText.Visible = COLDISTINCTVALUE_MAX_REACHED == m_nRetGetDistinctValues; 
	int nSize = vsDistinctValuse.GetSize();	
	
	vector<int>		vnCheck(nSize);
	vnCheck			= 0;
	for(int nn = 0; nn < nSize; nn++)
	{
		int nFind = nData <= 0? -1 : vsFilterData.Find( vsDistinctValuse[nn] );
		if(nFind >= 0)
		{
			vnCheck[nn] = 1;
			vsFilterData.RemoveAt(nFind);
			nData--;
		}
	}
	
	///Jasmine 05/02/2012 ORG-4862-S1 ADD_BLANK_AND_MISSING_INTO_FILTER_CHECK_LIST
	int nBlank = vsDistinctValuse.Find("");
	if(nBlank >= 0)
		vsDistinctValuse[nBlank] = STR_BLANK_OR_MISSING;
	///End ADD_BLANK_AND_MISSING_INTO_FILTER_CHECK_LIST
	
	m_gridDistinctValues.Update(vsDistinctValuse, vnCheck);
	
	///Jasmine 05/15/2012 ORG-4862-S8 COLUMN_DISTINCT_VALUES_NEED_COUNT
	vector<string> vsCounts;
	convert_uint_vector_to_string_vector(vnCounts, vsCounts);
	m_gridDistinctValues.SetCells(vsCounts, CHECK_LIST_COUNT_COL, true);
	///End COLUMN_DISTINCT_VALUES_NEED_COUNT
	
	UpdateOccurrencesText();
}

///Jasmine 07/18/2012 ORG-6252-P1 HIDE_NAVIGATE_BTNS
#ifndef _ALLOW_NAVIGATE_TO_OTHER_COL
//virtual 
int		ColFilterTextDlg::GetMinClientWidth()
{	
	return 550;
}
#endif //_ALLOW_NAVIGATE_TO_OTHER_COL
///End HIDE_NAVIGATE_BTNS

///Jasmine 05/09/2012 ORG-4862-S6 MAKE_COLFILTER_DLG_RESIZABLE
void	ColFilterTextDlg::OnDlgResize(int nType, int nRight, int nBottom)
{
	bool bAdv = m_btnAdv.Check;
	if(bAdv)
	{
		ColFilterBaseDlg::OnDlgResize(nType, nRight, nBottom);
		return;
	}
	
	MoveControlsHelper clCacheWndPosHelper(this);
	
	RECT 	rrCheckAll, rrAdv, rrHints, rrList;
	Control	cList;
	GetControlClientRect(IDC_BUTTON_CHECK_ALL,	rrCheckAll);
	GetControlClientRect(IDC_CHECK_ADVANCED,	rrAdv);
	GetControlClientRect(IDC_STATIC_EXCEED_TIPS, rrHints);
	GetControlClientRect(IDC_LIST, 				rrList, &cList);
	
	int 	nGap = _DLG_GAP;
	int 	nDx	= nRight - nGap - rrCheckAll.right;
	
	vector<uint> vnIDs = {IDC_BUTTON_CHECK_ALL, IDC_BUTTON_TOGGLE_ALL, IDC_BUTTON_CLEAR_ALL, 0};	
	MoveControls(vnIDs, nDx, 0);
	
	int		nDy = nBottom - nGap * 2 - RECT_HEIGHT(rrAdv) - rrHints.bottom;	
	vnIDs.SetSize(0);
	vnIDs.Add(IDC_STATIC_EXCEED_TIPS);
	vnIDs.Add(0);
	MoveControls(vnIDs, 0, nDy);
	
	nDx	= nRight - nGap - rrAdv.right;
	nDy = nBottom - nGap - rrAdv.bottom;	
	vnIDs.SetSize(0);
	vnIDs.Add(IDC_CHECK_ADVANCED);
	vnIDs.Add(0);
	MoveControls(vnIDs, nDx, nDy);
	
	rrList.right 	= nRight	- nGap * 2 - RECT_WIDTH(rrCheckAll);
	rrList.bottom 	= nBottom 	- nGap * 3 - RECT_HEIGHT(rrAdv) - RECT_HEIGHT(rrHints);
	MoveControl(cList, rrList);	
}

//virtual 
int		ColFilterTextDlg::GetQueryTipsIDs(vector<uint>& vnIDs)
{
	vector<uint> vnTemp = {	IDC_STATIC_STR_MATCH_TIPS,	IDC_STATIC_CHAR_MATCH_TIPS, 
							IDC_STATIC_EXP_TIPS_1, 		IDC_STATIC_EXP_TIPS_2, 		
							IDC_TEXT_BEFORE_QUERY, 		0};
	vnIDs = vnTemp;
	return vnIDs.GetSize();
}
///End MAKE_COLFILTER_DLG_RESIZABLE

/***********************************************************************
************************  ColFilterTextDlg End  ************************
************************************************************************/

/***********************************************************************
*********************  ColFilterPlaceHolder Begin  *********************
************************************************************************/
ColFilterPlaceHolder::ColFilterPlaceHolder()
{
	///Jasmine 05/09/2012 ORG-4862-S6 MAKE_COLFILTER_DLG_RESIZABLE	
	m_right	= -1;
	m_bottom= -1;
	///End MAKE_COLFILTER_DLG_RESIZABLE
}
	
void 	ColFilterPlaceHolder::InitMaps(WndContainer& wnd, int nObjType/* = COLUMN_FILTER_FORMAT_NUMERIC*/)
{
	///Jasmine 07/18/2012 ORG-6255-S1 SEPARATE_DATE_TIME_CLASS
	m_pColFilterNumericPage 	= new ColFilterNumericDlg();
	m_pColFilterTextPage		= new ColFilterTextDlg();
	m_pColFilterDateTimePage	= new ColFilterDateTimeDlg();
	
	m_pColFilterNumericPage->InitPage(IDD_COL_FILTER_NUMERIC_DLG, this, wnd);	//m_ColFilterNumericPage
	m_pColFilterTextPage->InitPage(IDD_COL_FILTER_TEXT_DLG, this, wnd);	//m_ColFilterTextPage
	m_pColFilterDateTimePage->InitPage(IDD_COL_FILTER_DATETIME_DLG, this, wnd);//m_ColFilterDateTimePage
	
	switch(nObjType)
	{
	case COLUMN_FILTER_FORMAT_NUMERIC:
		AddPage(*m_pColFilterNumericPage);//m_ColFilterNumericPage
		break;
		
	case COLUMN_FILTER_FORMAT_TEXT:		
		AddPage(*m_pColFilterTextPage);//m_ColFilterTextPage
		break;
		
	case COLUMN_FILTER_FORMAT_DATE_TIME:
		AddPage(*m_pColFilterDateTimePage);//m_ColFilterDateTimePage
		break;
		
	default:
		break;
	}
	
	if(COLUMN_FILTER_FORMAT_NUMERIC != nObjType)
		AddPage(*m_pColFilterNumericPage);//m_ColFilterNumericPage
	if(COLUMN_FILTER_FORMAT_TEXT != nObjType)	
		AddPage(*m_pColFilterTextPage);//m_ColFilterTextPage
	if(COLUMN_FILTER_FORMAT_DATE_TIME != nObjType)
		AddPage(*m_pColFilterDateTimePage);//m_ColFilterDateTimePage
	
	ColFilterNumericDlg* 	p1 = (ColFilterNumericDlg*)m_pColFilterNumericPage;
	p1->InitMsgMap();
	ColFilterTextDlg* 		p2 = (ColFilterTextDlg*)m_pColFilterTextPage;
	p2->InitMsgMap();	
	ColFilterDateTimeDlg* 	p3 = (ColFilterDateTimeDlg*)m_pColFilterDateTimePage;
	p3->InitMsgMap();	
	///End SEPARATE_DATE_TIME_CLASS
}

void	ColFilterPlaceHolder::SetActivePageByCol()
{
	BOOL bRet;
	///Jasmine 05/30/2012 ORG-5819-S1 IMPROVE_METHODS_TO_GET_COLUMN_FILTER_FORMAT
	//int nFormat = m_col.GetFormat();
	//switch(nFormat)
	//{
	//case OKCOLTYPE_NUMERIC:
		//bRet = SetActivePage( m_ColFilterNumericPage );
		//break;
	//case OKCOLTYPE_TEXT:
		//bRet = SetActivePage( m_ColFilterTextPage );
		//break;
//
	//case OKCOLTYPE_TIME:
	//case OKCOLTYPE_DATE:
	//case OKCOLTYPE_MONTH:
	//case OKCOLTYPE_WEEKDAY:
		//bRet = SetActivePage( m_ColFilterDateTimePage );
		//break;
//
	//case OKCOLTYPE_TEXT_NUMERIC:
		//DatasetObject dobj(m_col);
		//int nn = dobj.PercentText();
		//
		//double dTHSysVar = 0;
		//if( !LT_get_var("@CATH",&dTHSysVar) )
			//LT_get_var("@TH",&dTHSysVar);
		//
		//if(nn >= dTHSysVar)
			//bRet = SetActivePage( m_ColFilterTextPage );
		//else
			//bRet = SetActivePage( m_ColFilterNumericPage );
		//
		//break;
		//
	//default:
		//break;
	//}
	switch( m_col.GetFilterFormat() )
	{
	case COLUMN_FILTER_FORMAT_NUMERIC:
		bRet = SetActivePage( *m_pColFilterNumericPage );//m_ColFilterNumericPage
		break;
	case COLUMN_FILTER_FORMAT_TEXT:
		bRet = SetActivePage( *m_pColFilterTextPage );//m_ColFilterTextPage
		break;
	case COLUMN_FILTER_FORMAT_DATE_TIME:
		bRet = SetActivePage( *m_pColFilterDateTimePage );//m_ColFilterDateTimePage
		break;
	default:
		break;
	}
	///End IMPROVE_METHODS_TO_GET_COLUMN_FILTER_FORMAT
}

/***********************************************************************
**********************  ColFilterPlaceHolder End  **********************
************************************************************************/

/***********************************************************************
*************************  ColFilterDlg begin  *************************
************************************************************************/
void 	ColFilterDlg::AttachCol(Column& col)
{
	m_pPlaceHolder->m_col = col;
	if( col )
		col.GetParent(m_pPlaceHolder->m_wks);
}
	
BOOL 	ColFilterDlg::CreateEx(HWND hWndParent/* = NULL*/)
{
	InitMsgMap();		
	bool bRet = ResizeDialog::Create(hWndParent, 0);	
	Visible = true;
	return bRet;
}

int 	ColFilterDlg::DoModalEx(HWND hParent)
{
	InitMsgMap();		
	int nRet = ResizeDialog::DoModal(hParent);//, DLG_TITLE_TO_HAVE_PAGE_NAME);
	
	return nRet;
}

BOOL	ColFilterDlg::OnInitDialog()
{
	m_pPlaceHolder->InitMaps(*this, m_nFirstPageType);
	m_pPlaceHolder->Create(IDC_FRAME, *this);
	
	ResizeDialog::OnInitDialog();
	
	m_btnApply 	= GetItem(IDC_APPLY);
	m_btnApply.Text = _L("Apply");
	GetItem(IDCANCEL).Text = _L("Cancel");
	return TRUE;
}

BOOL	ColFilterDlg::OnReady()
{
	//out_str("Onready");
	int	nActive = m_pPlaceHolder->GetActiveIndex();
	ColFilterBaseDlg* pPage = m_pPlaceHolder->GetPage(nActive);
	if(pPage)
	{
		//ResizeDlgToControlBottom(pPage->GetBottomControl(), 0);	///Jasmine 05/09/2012 ORG-4862-S6 MAKE_COLFILTER_DLG_RESIZABLE
		pPage->CheckEnableApplyBtn();				///Jasmine 05/09/2012 ORG-4862-P4 OPEN_CUSTOM_FILTER_DLG_FROM_CHECK_LIST_MORE_SHOULD_UPDATE_DIALOG_CHECK_LIST
	}
	
	///Jasmine 05/09/2012 ORG-4862-S6 MAKE_COLFILTER_DLG_RESIZABLE
	SetInitReady();
	///End MAKE_COLFILTER_DLG_RESIZABLE
	
	return TRUE;
}

///Jasmine 05/09/2012 ORG-4862-S6 MAKE_COLFILTER_DLG_RESIZABLE
BOOL 	ColFilterDlg::OnDlgResize(int nType, int cx, int cy)
{
	if(!IsInitReady())
		return FALSE;
	
	MoveControlsHelper clCacheWndPosHelper(this);
	
	uint nButtonIDs[] = {IDC_APPLY, IDCANCEL, IDOK, 0};
	ArrangeMainItemAndControls(nButtonIDs, IDC_FRAME, NULL, false);
	
	RECT 	rFrame;
	Control	cFrame;
	GetControlClientRect(IDC_FRAME, rFrame, cFrame);
	rFrame.right = cx;
	MoveControl(cFrame, rFrame);
	
	cFrame.GetWindowRect(&rFrame);	
	int	nActive = m_pPlaceHolder->GetActiveIndex();
	ColFilterBaseDlg* pPage = m_pPlaceHolder->GetPage(nActive);
	if(pPage)
		pPage->Resize(nType, rFrame.right, rFrame.bottom);
	
	return TRUE;
}

void	ColFilterDlg::OnMinMaxInfo(MINMAXINFO* lpMMI)
{
	lpMMI->ptMinTrackSize.x = GetMinTrackWidth();//450	///Jasmne 07/11/2012 ORG-6178-P1 GET_MIN_TRACK_WIDTH_ON_RIGHTMOST_CTRL
	lpMMI->ptMinTrackSize.y = IsRolledup() ? 0 : 350;//GetMinTrackHeight());
	
	lpMMI->ptMaxTrackSize.x = 1070;
	lpMMI->ptMaxTrackSize.y = 900;
}
///Jasmne 07/11/2012 ORG-6178-P1 GET_MIN_TRACK_WIDTH_ON_RIGHTMOST_CTRL
int 	ColFilterDlg::GetMinClientTrackWidth()
{
	int nMinWidth = 550;
	
	int	nActive = m_pPlaceHolder->GetActiveIndex();
	ColFilterBaseDlg* pPage = m_pPlaceHolder->GetPage(nActive);
	if(pPage)
		nMinWidth = pPage->GetMinClientWidth();
	
	return nMinWidth;
}
///End GET_MIN_TRACK_WIDTH_ON_RIGHTMOST_CTRL
///End MAKE_COLFILTER_DLG_RESIZABLE

BOOL	ColFilterDlg::OnOK()
{
	OnApply(m_btnApply);
	return SendMessage(WM_CLOSE);
}

BOOL	ColFilterDlg::OnApply(Control ctrl)
{
	int	nActive = m_pPlaceHolder->GetActiveIndex();
	ColFilterBaseDlg* pPage = m_pPlaceHolder->GetPage(nActive);
	if(pPage)
		return pPage->OnApply(ctrl);
	
	return TRUE;
}

//---Jasmine 03/28/2012 follow Set Values dialog, ColMatValues.c
BOOL 	ColFilterDlg::OnActiveLayerChange()
{	
	GetActiveLayer();
	
	OnSelectionChange();
	return true;
}

BOOL 	ColFilterDlg::OnActivePageChange()
{
	OnActiveLayerChange();
	return true;
}

BOOL 	ColFilterDlg::OnSelectionChange()
{
	if( m_pPlaceHolder->m_col && IsDataObjectChanged( Project.ActiveLayer() ) )
	{
		if(m_pPlaceHolder->m_col)
			OnApply(m_btnApply);
	}	

	GetActiveLayer();
	createDataObject();

	m_pPlaceHolder->SetActivePageByCol();
	
	return TRUE;
}

BOOL 	ColFilterDlg::GetActiveLayer()
{
	Worksheet wks = Project.ActiveLayer();
	if(!wks)
	{
		error_report("Fail to get active layer");
		return false;
	}
	
	m_pPlaceHolder->m_wks = wks;

	return true;
}

BOOL	ColFilterDlg::IsDataObjectChanged(const Layer& layer)
{
	ASSERT( layer );
	Worksheet	wks( layer );
	if( !is_same_layer( wks, m_pPlaceHolder->m_wks ) )
		return true;
	
	vector<int>	vnSelIndex;
	wks.GetSelectedColumns( vnSelIndex );
	if( vnSelIndex.GetSize() < 1 )
		return false;
	//vnSelIndex has only one data since SetValue Dialog only allow on column selected
	Column col = wks.Columns( vnSelIndex[0] );
	ASSERT( col );
	if( col.GetIndex() != m_pPlaceHolder->m_col.GetIndex() )
		return true;
	
	return false;
}

static bool _is_wks_sel_valid(Layer& lay, bool bAllowLabel = false, LPCSTR lpcszDebugFrom = NULL)
{
	Worksheet wks(lay);
	if(!wks)
		return false;
	
	int nSelection = 0;
	if ( bAllowLabel )
	{
		int nBeginRow, nEndRow, nBeginCol, nEndCol;
		nSelection = wks.GetSelectedRange(nBeginRow, nBeginCol, nEndRow, nEndCol);
		if ( (WKS_SEL_ONE_COL | WKS_SEL_DISCONTIGUOUS | WKS_SEL_COLUMN | WKS_SEL_EDIT | WKS_SEL_LABEL) & nSelection )
			return true;
	}
	vector<int> vnR1, vnC1, vnR2, vnC2;
	nSelection = wks.GetSelectedRange(vnR1, vnC1, vnR2, vnC2);
	if ( nSelection > 0 )
	{
		if ( bAllowLabel )
			return true;
		else if ( vnC1.GetSize() == 1 && (vnC1[0] - vnC2[0] == 0) ) //set column value not allow select label and only allow select one column as valid range,
			return true;
	}
	
	return false;
}

bool 	ColFilterDlg::createDataObject()
{
	if(m_pPlaceHolder->m_col)
		m_pPlaceHolder->m_col.Detach();
	
	if(_is_wks_sel_valid(m_pPlaceHolder->m_wks))
	{
		vector<int> vnSelCols, vnSelRows;
		vector<int> vnC1, vnR1, vnC2, vnR2;
		int nSelection = m_pPlaceHolder->m_wks.GetSelectedRange(vnR1, vnC1, vnR2, vnC2);			
		if ( nSelection == WKS_SEL_EDIT ) //allow only one region selected
		{
			vnSelCols.Data(vnC1[0], vnC2[0], 1);
			if ( vnR2[0] >= 0 )
			{
				vnSelRows.Add(vnR1[0] + 1);
				vnSelRows.Add(vnR2[0] + 1)
			}
		}
		
		//int nSelectionWay = DATAOB_COL_SEL_CONTIGUOUS;
		//SetRange(vnSelRows, vnSelCols, nSelectionWay);
		
		if ( 0 < vnSelCols.GetSize() )
			m_pPlaceHolder->m_col.Attach(m_pPlaceHolder->m_wks, vnSelCols[0]);
	}
	
	return m_pPlaceHolder->m_col.IsValid();
}
//---

BOOL	ColFilterDlg::ResizeDlgToControlBottom(WPARAM wParam, LPARAM lParam)
{
	int 	nGap = _DLG_GAP;
	
	RECT 	rrBottom;	
	rrBottom.bottom = (int)wParam;		
	ScreenToClient(&rrBottom);	
	
	RECT 	rFrame;
	Control	cFrame;
	GetControlClientRect(IDC_FRAME, rFrame, cFrame);
	rFrame.bottom = rrBottom.bottom + nGap;
	MoveControl(cFrame, rFrame);
	
	vector<uint> 	vnIDs 	= {IDC_APPLY, IDCANCEL, IDOK, 0}
	int 			nBottom	= ArrangeControlsRightLeft(vnIDs, rFrame.right, rFrame.bottom + nGap, nGap);
    
	RECT rrDlg;
	GetWindowRect(&rrDlg);
    ScreenToClient(&rrDlg);
	rrDlg.bottom = nBottom + 2 * nGap;	
	ClientToScreen(&rrDlg);		
    MoveWindow(&rrDlg);
    
    return TRUE;
}

/***********************************************************************
**************************  ColFilterDlg End  **************************
************************************************************************/

void OpenColFilterDlg(int nCol, CustomFilterDlgData* pData)
{
	Worksheet wks = Project.ActiveLayer();
	if( !wks )
		return;
	
	Column col(wks, nCol);
	if( !col )
		return;	

	int nObjType = col.GetFilterFormat();

#ifdef OPEN_COL_FILTER_MODALLESS_DLG
	if( NULL != s_pFilterDlg )
	{		
		delete s_pFilterDlg;
		s_pFilterDlg = NULL;			
	}
	
	if( NULL == s_pFilterDlg )
	{
		s_pFilterDlg = CreateFilterDlgPointer(col, nObjType);		
	}
	
#else //OPEN_COL_FILTER_MODALLESS_DLG

	///Jasmine 05/09/2012 ORG-4862-P4 OPEN_CUSTOM_FILTER_DLG_FROM_CHECK_LIST_MORE_SHOULD_UPDATE_DIALOG_CHECK_LIST
	//ColFilterDlg myDlg(col, nObjType);
	ColFilterDlg myDlg(col, nObjType, pData);
	///End OPEN_CUSTOM_FILTER_DLG_FROM_CHECK_LIST_MORE_SHOULD_UPDATE_DIALOG_CHECK_LIST
	myDlg.DoModalEx(GetWindow());
	
#endif //OPEN_COL_FILTER_MODALLESS_DLG
}

ColFilterDlg* CreateFilterDlgPointer(Column& col, int nObjType)
{	
	ColFilterDlg* pDlg = new ColFilterDlg(col, nObjType);
	pDlg->CreateEx(GetWindow());
	return pDlg;	
}
	

int		CustomColFilterDlg(int nMsg, ODWP dwCntrl/* = 0*/, LPVOID lpData/* = NULL*/)
{
	int nCol = dwCntrl;
	
	///Jasmine 05/09/2012 ORG-4862-P4 OPEN_CUSTOM_FILTER_DLG_FROM_CHECK_LIST_MORE_SHOULD_UPDATE_DIALOG_CHECK_LIST
	//OpenColFilterDlg(nCol, nObjType);
	/// Zech 07/24/2012 ORG-6266-S1 NEW_COLUMN_FILTER_DLGS
	/*
	CustomFilterDlgData* pData = (CustomFilterDlgData*)lpData;
	OpenColFilterDlg(nCol, pData);
	*/
	CustomFilterDlgData* pData = (CustomFilterDlgData*)lpData;
	Worksheet 	wks = Project.ActiveLayer();
	Column		col(wks, nCol);
	int			nFormat = col.GetFilterFormat(),
				nEntry = pData->nEntry;
	
	switch(nEntry)
	{
	case ColumnFilterMenuEntry_Equal:
	case ColumnFilterMenuEntry_LessThan:
	case ColumnFilterMenuEntry_GreaterThan:
		if (COLUMN_FILTER_FORMAT_NUMERIC == nFormat)
		{
			SimpleColumnFilterNumericGeneralDlg dlg(col, nEntry);
			dlg.DoDlg();
		}
		else if (COLUMN_FILTER_FORMAT_DATE_TIME == nFormat)
		{
			SimpleColumnFilterDateTimeGeneralDlg dlg(col, nEntry);
			dlg.DoDlg();
		}
		
		break;
	case ColumnFilterMenuEntry_Between:

		if (COLUMN_FILTER_FORMAT_NUMERIC == nFormat)
		{
			SimpleColumnFilterNumericBetweenDlg dlg(col);
			dlg.DoDlg();
		}
		else if (COLUMN_FILTER_FORMAT_DATE_TIME == nFormat)
		{
			SimpleColumnFilterDateTimeBetweenDlg dlg(col);
			dlg.DoDlg();
		}
			
		break;
	case ColumnFilterMenuEntry_TopN:
	case ColumnFilterMenuEntry_BottomN:
		ASSERT(COLUMN_FILTER_FORMAT_NUMERIC == nFormat);
		
		{
			SimpleColumnFilterNumericTopNBottomNDlg dlg(col, nEntry);
			dlg.DoDlg();
		}
		
		break;
	case ColumnFilterMenuEntry_Custom:
		if (COLUMN_FILTER_FORMAT_TEXT == nFormat)
			OpenColFilterDlg(nCol, pData);
		else
		{
			CustomColumnFilterDlg dlg(col);
			dlg.DoModalEx();
		}
		
		break;
	default:
		ASSERT(FALSE);
		return -1;
	}
	/// END NEW_COLUMN_FILTER_DLGS	
	///End OPEN_CUSTOM_FILTER_DLG_FROM_CHECK_LIST_MORE_SHOULD_UPDATE_DIALOG_CHECK_LIST
	return 0;
}
