 /*-----------------------------------------------------------------------------*
 * File Name: ColumnBrowser.c		 											*
 * Creation: Jasmine 04/20/06													*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Jasmine 09/07/06 CHANGE_GRID_LIST_TO_COLUMN_LIST_BASE						*
 * Jasmine 09/25/06 SHARE_COL_BROWSER_WITH_MAT									*
 * Jasmine 03/27/06 DLG_RESIZE_PAINT_MESS										*
 * Jake 04/18/07 SHOW_MUTIL_SELETION_FOR_BROWSE									*
 * Jake 04/19/07 DEBUG_FOR_WCOL													*
 * Folger 05/14/07 ADD_COMMENTS_TO_COLUMN_BROWSER								*
 * Kenny 04/27/2009 QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH	*
 *	Folger 06/02/09 ADJUST_BETTER_DIALOG_SIZE_AND_COLUMN_LIST_WIDTH				*
 *	Folger 11/10/2011 ADD_F1_HELP_FOR_COLUMN_LIST_BROWSER						*
 *	Folger 12/21/2011 ORG-4312-S2 COLUMN_STR_FROM_BROWSER_SHOULD_CHECK_PREFER_LONG_NAME
 *------------------------------------------------------------------------------*/
#include "DialogEx.h"
#include "ColumnList.h"///Jasmine 09/07/06 CHANGE_GRID_LIST_TO_COLUMN_LIST_BASE

class ColumnBrowserDlg : public ResizeDialog
{
public :
	///Jasmine 09/25/06 SHARE_COL_BROWSER_WITH_MAT
	//ColumnBrowserDlg(bool bShortName = true, LPCSTR lpcszWks = NULL) : ResizeDialog(IDD_COL_LIST_DLG, "ODlg8") 
	ColumnBrowserDlg(int nType, bool bShortName = true, LPCSTR lpcszWks = NULL
		, BOOL bPreferLongName = TRUE		///------ Folger 12/21/2011 ORG-4312-S2 COLUMN_STR_FROM_BROWSER_SHOULD_CHECK_PREFER_LONG_NAME
		) : ResizeDialog(IDD_COL_LIST_DLG, "ODlg8") 
	{
		m_nType = nType;
		m_bShortName = bShortName;
		m_strWks = lpcszWks;
		m_bPreferLongName = bPreferLongName;		///------ Folger 12/21/2011 ORG-4312-S2 COLUMN_STR_FROM_BROWSER_SHOULD_CHECK_PREFER_LONG_NAME
	}	
	///End SHARE_COL_BROWSER_WITH_MAT
	int  DoModal(HWND hParent = NULL) 
	{
		InitMsgMap();
		int nRet = ResizeDialog::DoModal(hParent);
		
		return nRet;
	}
	/*
	int Create(HWND hParent=NULL) //call from CB, etc
	{
		InitMsgMap();
		int nRet = ResizeDialog::Create(hParent);
		Visible=true;	
		return nRet;
	}*/
protected:
EVENTS_BEGIN
	ON_INIT( OnInitDialog )
	ON_SIZE(OnDlgResize)
	ON_OK(OnOk)
	ON_GRID_DBLCLICK(IDC_COL_LIST_GRID, OnDblClickToClose)
	ON_DESTROY(OnDestroy)	///Kenny 04/27/2009 QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
	//ON_BN_CLICKED(IDC_OPEN_PB_BUTTON, OnOpenPB)//temporarily unused
	//ON_EN_KILLFOCUS(IDC_SHEET_EDIT, OnWksStringChanged)//temporarily unused
	
	ON_RESTORESIZE(OnRestoreSize)		///------ Folger 06/02/09 ADJUST_BETTER_DIALOG_SIZE_AND_COLUMN_LIST_WIDTH

	///------ Folger 11/10/2011 ADD_F1_HELP_FOR_COLUMN_LIST_BROWSER
	ON_HELPINFO(OnHelp)
	///------ End ADD_F1_HELP_FOR_COLUMN_LIST_BROWSER
	
EVENTS_END

	///------ Folger 11/10/2011 ADD_F1_HELP_FOR_COLUMN_LIST_BROWSER
	BOOL OnHelp(int &nHelpID, int nIdCtrlFocus)
	{
		nHelpID = IDD_COLUMN_LIST_BROWSER_DLG;
		return TRUE;
	}
	///------ End ADD_F1_HELP_FOR_COLUMN_LIST_BROWSERy
	
	bool 	OnInitDialog()
	{
		ResizeDialog::OnInitDialog(IDC_COL_LIST_GRID);
		///Jasmine 09/25/06 SHARE_COL_BROWSER_WITH_MAT
		/*
		///Jasmine 09/07/06 CHANGE_GRID_LIST_TO_COLUMN_LIST_BASE
		m_ColList.Init(IDC_COL_LIST_GRID, *this, _L("Column Browser"));//false, true, NULL, *this);
		Worksheet wks;		
		if(!m_ColList.GetWorksheet(wks))
			return false;
		foreach(Column col in wks.Columns)
			m_ColList.AddRow(col.GetIndex());
			
		//ShowCol: Short Name, Long Name, Formula, Plot Designation and Format
		vector<uint> vnIndex = {COL_PROPERTIES_INDEX,
								COL_PROPERTIES_SHORT_NAME, 
								COL_PROPERTIES_LONG_NAME, 
								COL_PROPERTIES_FORMULA, 
								COL_PROPERTIES_PLOT_DESIGNATION,
								COL_PROPERTIES_FORMAT};
		m_ColList.SetShowCols(vnIndex);
		
		m_strSelCol = "";
		m_strWks = wks_get_book_sheet_name(wks);
		m_editWks = GetItem(IDC_SHEET_EDIT);	
		m_editWks.Text = m_strWks;
		*/
		string strClass, strBrowser;
		switch(m_nType)
		{
		case EXIST_MATRIX:
			strClass = "MatObjListBase";
			strBrowser = _L("Matrix Object Browser");
			break;
		case EXIST_WKS:
			strClass = "ColumnListBase";
			strBrowser = _L("Column Browser");
			break;
		default:
			return error_report("type not supported");
		}
		ColMatListBase& ColMatList = (ColMatListBase&) Project.FindClass(strClass);
		m_pList = &ColMatList;
		m_pList->Init(IDC_COL_LIST_GRID, *this, strBrowser, m_strWks);
		Text = strBrowser;
		switch(m_nType)
		{
		case EXIST_MATRIX:
			MatrixLayer ml;
			if(!m_pList->GetActiveSheet(ml))
				return false;
			foreach(MatrixObject mo in ml.MatrixObjects)
				m_pList->AddRow(mo.GetIndex());
			break;
		case EXIST_WKS:
			Worksheet wks;		
			if(!m_pList->GetActiveSheet(wks))
				return false;
			foreach(Column col in wks.Columns)
				m_pList->AddRow(col.GetIndex());				
			vector<uint> vnIndex = {COL_PROPERTIES_INDEX,
									COL_PROPERTIES_SHORT_NAME, 
									COL_PROPERTIES_LONG_NAME, 
									COL_PROPERTIES_COMMENT,		///Folger 05/14/07 ADD_COMMENTS_TO_COLUMN_BROWSER
									COL_PROPERTIES_FORMULA, 
									COL_PROPERTIES_PLOT_DESIGNATION,
									COL_PROPERTIES_FORMAT};
			m_pList->SetShowCols(vnIndex);
			break;
		default:
			return error_report("type not supported");
		}				
		//m_strSelCol = "";//----Jake 04/18/07 SHOW_MUTIL_SELETION_FOR_BROWSE
		///End SHARE_COL_BROWSER_WITH_MAT
		
		m_pList->ResizeCols();		///------ Folger 06/02/09 ADJUST_BETTER_DIALOG_SIZE_AND_COLUMN_LIST_WIDTH
		
		//stretch to top
		Button btnTop = GetItem(IDC_OPEN_PB_BUTTON);
		Control ctrl = GetItem(IDC_COL_LIST_GRID);
		RECT rTop, rBottom;
		GetClientRect(btnTop, rTop);
		GetClientRect(ctrl, rBottom);
		StretchControlHeight(IDC_COL_LIST_GRID, rBottom.left, rTop.top, rBottom.bottom);
		return true;
	}
	
	///------ Folger 06/02/09 ADJUST_BETTER_DIALOG_SIZE_AND_COLUMN_LIST_WIDTH
	#define		STR_DIALOG_NAME		"ColumnBrowser"
	BOOL	OnRestoreSize(ODWP dwSizeInfo)
	{
		void * p = (void*)dwSizeInfo;
		DLGSIZEINFO *pSz = (DLGSIZEINFO*)p;
	
		lstrcpyn(pSz->szDialogName, STR_DIALOG_NAME, MAXLINE);
			
		SIZE sz;
		GetDlgOptimalSize(sz);
		pSz->top = -1;
		pSz->left = - 1;
		pSz->width = 400;
		pSz->height = 180;
		return TRUE;
	}
	///------ End ADJUST_BETTER_DIALOG_SIZE_AND_COLUMN_LIST_WIDTH
	
	BOOL 	OnDlgResize(int nType, int cx, int cy)
	{
		MoveControlsHelper	_temp(this);	///Jasmine 03/27/06 DLG_RESIZE_PAINT_MESS
 		vector<uint> nBtns = {IDCANCEL, IDOK, 0};
		ArrangeMainItemAndControls(nBtns, IDC_COL_LIST_GRID, NULL, false);
		
		//not allow selecting other layer's column now
		//RECT rTab;
		//GetClientRect(m_editWks, rTab);
		//int nEdge = GetControlGap();
		//vector<uint> vnLayerSpecifyGroup = {IDC_LAYER_LABEL, IDC_SHEET_EDIT, IDC_OPEN_PB_BUTTON};
		//ArrangeControlsLeftRight(vnLayerSpecifyGroup, nEdge, nEdge, rTab.right, IDC_SHEET_EDIT);
		
		return TRUE;
	}
	bool 	OnOk()
	{
		getSelColName();
		return true;
	
	}
	bool 	OnDblClickToClose(Control ctrl)
	{
		getSelColName();
		PostMessage( WM_CLOSE );
		return true;
	}
	/*	//temporarily unused
	void 	OnOpenPB(Control ctrl)
	{
		string strPath = "Originlab\\ProjectBrowser.c", strNewWks;
		FUNC_STR_DWORD_HWND pfn = Project.FindFunction("ProjectBrowseSheet", strPath);
		if(!pfn || !pfn(strNewWks, 0, GetSafeHwnd()))
			return;
		if(!strNewWks.CompareNoCase(m_strWks))
			return;
		m_strWks = strNewWks;
		//update control
		m_editWks.Text = m_strWks;
		
		Worksheet wks(m_strWks);
		//if(wks.IsValid()) update m_ColList
		//doing...	
	}
	BOOL 	OnWksStringChanged(Control cntrl)
	{
		string strNew = m_editWks.Text;
		if( !strNew.CompareNoCase(m_strWks) )
			return FALSE;
		m_strWks = strNew;
		//update m_ColList
		return TRUE;
	}	
	*/
	///Kenny 04/27/2009 QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
	BOOL OnDestroy()
	{
		m_pList->OnDestroy();
		return TRUE;
	}
	///End QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
private:
	bool getSelColName()
	{
		vector<uint>	vnSelRows;
		int nRow = m_pList->GetSelection(vnSelRows);//m_ColList.GetSelectedRow();///Jasmine 09/25/06 SHARE_COL_BROWSER_WITH_MAT
		if(nRow < 0)
		{
			//m_strSelCol = "";//----Jake 04/18/07 SHOW_MUTIL_SELETION_FOR_BROWSE
			return true;
		}
		///Jasmine 09/25/06 SHARE_COL_BROWSER_WITH_MAT
		/*
		string strName = m_ColList.GetCell(nRow, COL_PROPERTIES_LONG_NAME);
		if(strName.IsEmpty())
			strName = m_ColList.GetCell(nRow, COL_PROPERTIES_SHORT_NAME);
		*/
		//string strName = m_pList->GetName(nRow);
		///End SHARE_COL_BROWSER_WITH_MAT
		//m_strSelCol = m_bShortName? strName : (string)nRow;
		//----Jake 04/18/07 SHOW_MUTIL_SELETION_FOR_BROWSE
		for(int ii=0;ii<nRow;ii++)
		{
			///------ Folger 12/21/2011 ORG-4312-S2 COLUMN_STR_FROM_BROWSER_SHOULD_CHECK_PREFER_LONG_NAME
			//string strName = m_bShortName? m_pList->GetName(vnSelRows[ii]) : (string)vnSelRows[ii];
			string strName = m_bShortName? m_pList->GetName(vnSelRows[ii], m_bPreferLongName) : (string)vnSelRows[ii];
			///------ End COLUMN_STR_FROM_BROWSER_SHOULD_CHECK_PREFER_LONG_NAME
			m_vsSelCol.Add(strName);
		}
		//----end
		return true;
	}
public:
	string GetSelectedColumn()
	{
		string strSelCol;
		//if(m_strSelCol.IsEmpty())
		if(m_vsSelCol.GetSize() == 0)
			return "";
		///Jasmine 09/25/06 SHARE_COL_BROWSER_WITH_MAT
		string strPrefix;
		switch(m_nType)
		{
		case EXIST_MATRIX:
			strPrefix = " Mat(";
			break;
		default:
		case EXIST_WKS:
			//----Jake 04/19/07 DEBUG_FOR_WCOL
			if(m_bShortName)
				strPrefix = " Col(";
			else
				strPrefix = " WCol(";
			//----end DEBUG_FOR_WCOL
			break;
		}
		//----Jake 04/18/07 SHOW_MUTIL_SELETION_FOR_BROWSE
		//return "Col(" + m_strSelCol + ")";
		for(int ii = 0; ii < m_vsSelCol.GetSize(); ii++)
			strSelCol += (strPrefix + m_vsSelCol[ii] + ")");
		///End SHARE_COL_BROWSER_WITH_MAT
		//----end SHOW_MUTIL_SELETION_FOR_BROWSE
		return strSelCol;
	}
private:
	Edit			m_editWks;
	///Jasmine 09/25/06 SHARE_COL_BROWSER_WITH_MAT
	//ColumnListBase	m_ColList;//TreeEditControl	///Jasmine 09/07/06 CHANGE_GRID_LIST_TO_COLUMN_LIST_BASE
	ColMatListBase*	m_pList;
	///End SHARE_COL_BROWSER_WITH_MAT
	string 			m_strWks;
//	vector<uint>	vnSelRows;//----Jake 04/18/07 SHOW_MUTIL_SELETION_FOR_BROWSE
	//string			m_strSelCol;
	vector<string> 	m_vsSelCol;//----Jake 04/18/07 SHOW_MUTIL_SELETION_FOR_BROWSE
	bool			m_bShortName;
	int 			m_nType;

	BOOL			m_bPreferLongName;		///------ Folger 12/21/2011 ORG-4312-S2 COLUMN_STR_FROM_BROWSER_SHOULD_CHECK_PREFER_LONG_NAME
};
///Jasmine 09/03/08 ACTIVE_LAYER_IS_NOT_CURRENT_LAYER_IF_SLECTION_NOT_GOOD
///Jasmine 09/25/06 SHARE_COL_BROWSER_WITH_MAT
//BOOL OpenColumnBrowser(string& strSel, bool bShortName = true, HWND hWnd = NULL)//: Col(A);, false : Col(1)
BOOL OpenColumnBrowser(string& strSel, int nType, bool bShortName = true, HWND hWnd = NULL, LPCSTR lpcszWks = NULL
					   , BOOL bPreferLongName = TRUE		///------ Folger 12/21/2011 ORG-4312-S2 COLUMN_STR_FROM_BROWSER_SHOULD_CHECK_PREFER_LONG_NAME
					   )//: Col(A);, false : Col(1)
{
	///------ Folger 12/21/2011 ORG-4312-S2 COLUMN_STR_FROM_BROWSER_SHOULD_CHECK_PREFER_LONG_NAME
	//ColumnBrowserDlg MyDlg(nType, bShortName, lpcszWks);//(bShortName);
	ColumnBrowserDlg MyDlg(nType, bShortName, lpcszWks, bPreferLongName);
	///------ End COLUMN_STR_FROM_BROWSER_SHOULD_CHECK_PREFER_LONG_NAME
///End SHARE_COL_BROWSER_WITH_MAT
///End ACTIVE_LAYER_IS_NOT_CURRENT_LAYER_IF_SLECTION_NOT_GOOD
	Window winDlg(hWnd);
	HWND hParent = GetWindow();
	if(winDlg)
		hParent = hWnd;			
	int nRet = MyDlg.DoModal(hParent);
	
	strSel = MyDlg.GetSelectedColumn();
	return !strSel.IsEmpty();
}