/*------------------------------------------------------------------------------*
 * File Name:ANOVAOneWayRM.h													*
 * Creation:  																	*
 * Purpose:One Way ANOVA Repeated Measure operation							 	*
 * Copyright (c) Originlab Corp. 2006											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	ML 10/20/2005 ANOVA_INPUT_DATA_TO_DATARANGE									*
 *	ML 10/25/2005 MUST_CLEAN_UP_CACHED_STUFF									*
 *  Jim 3/8/06 ADD_TABLE_FOOTNOTE												*
 *	Echo 2/7/07 ADD_ERROR_REPORT												*
 *	Arvin 10/17/07 CLEAN_ANOVA_TOOLS_CODE										*
 *	Arvin 02/14/08 QA70-11094 SUPPORT_PLOT_MULTI_FITTED_CURVES_IN_ONE_GRAPH_IN_LR_PR_AND_FITNL
 *	ML 4/27/2012 PREVENT_MULTIPLE_INCLUSION_O8dlg_h								*
 *	Folger 06/06/2012 ORG-5906-P1 NORMALITY_TEST_TOO_SLOW_FOR_LARGE_DATA		*
 *------------------------------------------------------------------------------*/

/// ML 4/27/2012 PREVENT_MULTIPLE_INCLUSION_O8dlg_h
//#include <o8dlg.h>
/// end PREVENT_MULTIPLE_INCLUSION_O8dlg_h
#ifndef _ANOVAONEWAY_RM_H
#define	_ANOVAONEWAY_RM_H
class OC_REGISTERED ANOVAOneWayRM : public ANOVARMReportOperation
{
///Echo 2/7/07 ADD_ERROR_REPORT
public:
	PEVENT_GETN GetNewEventFunction();
///end ADD_ERROR_REPORT

	///Arvin 06/29/07 v8.652 XOP_NEED_SUPPORT_NLFIT
	///Arvin 10/17/07 CLEAN_ANOVA_TOOLS_CODE
	/*
	int OnInitOperationTreeFromOCLT(TreeNode &trOp, TreeNode& trOCLT, bool bInitTree = true)
	{
		int nRet;
		TreeNode trOutGUI = trOCLT.GetNode("GUI");
		TreeNode trInputData = trOutGUI.InputData;
		if(!trInputData)
			return OP_INVALID_INPUT_DATA_NODE;
		
		if(ANOVA_INDEXED_DATA == trInputData.Use)
		{
			nRet = okutil_anova_switch_to_indexed_data(&trInputData, false, true);			
		}
		else
		{
			 nRet = okutil_anova_switch_to_raw_data(&trInputData, false, true);
		}
		
		return nRet;
	}
	*/
	///end CLEAN_ANOVA_TOOLS_CODE
	///END XOP_NEED_SUPPORT_NLFIT
protected:	
	virtual void 	ConstructOutputTable(TreeNode& trOperation);
	int     ExtractIndexedData(TreeNode &trOp, DataRange& dr, matrix& mData, int& nSizeSubject, int& nSizeFactor, int& nSizeFactor2 = NULL);
	bool	CalcOneData(TreeNode &trOp, int nSizeSubject, int nSizeFactor, int& nSizeFactor2 = NULL);
	string 	GetClassName();
	/// Iris 05/21/2007 v8.0622 NEED_REPORT_PLOTS_IN_RM_ONE_WAY
	//virtual
	int 	ConstructGraphNumber();
	///Arvin 02/14/08 QA70-11094 SUPPORT_PLOT_MULTI_FITTED_CURVES_IN_ONE_GRAPH_IN_LR_PR_AND_FITNL
	//DWORD   GetOutputOptions();
	DWORD   GetOutputOptions(const TreeNode& trOp);
	///end SUPPORT_PLOT_MULTI_FITTED_CURVES_IN_ONE_GRAPH_IN_LR_PR_AND_FITNL
	int		GetNumberLayersInOneGraph(TreeNode& trOp, int nGraphIndex);
	int 	GetResultCurvesID();
	void 	FilterStatsGUI(TreeNode& trOp);
	///end NEED_REPORT_PLOTS_IN_RM_ONE_WAY
	///Cheney 2007-9-28 MODIFY_TITLE_AS_MAX_SAID
	//virtual
	string	GetDlgDescription(int nOption);
	///end MODIFY_TITLE_AS_MAX_SAID
	///Cheney 2007-10-25 ANOVA_TOOLS_HANDLE_AUTO_WRONG
	//virtual
	bool GetAnovaToolsOption(bool bRow, int& nOption);
	///end ANOVA_TOOLS_HANDLE_AUTO_WRONG
	
	//virtual
	// fisher 11/16/2007 ADD_MAP_ID_TO_CHM
	int GetHelpID()	{return IDD_XF_AnovaOneWayRM;}
	
	//virtual
	string 	GetResultBookName(TreeNode& trGUI);

	///------ Folger 06/06/2012 ORG-5906-P1 NORMALITY_TEST_TOO_SLOW_FOR_LARGE_DATA
	virtual void GetCalcMoment(TreeNode& trOp, DescStatOptions& opMoments);
	///------ End NORMALITY_TEST_TOO_SLOW_FOR_LARGE_DATA
};

#endif //_ANOVAONEWAY_RM_H
