/*------------------------------------------------------------------------------*
 * File Name:ANOVAOneWay.h														*
 * Creation:  																	*
 * Purpose: OriginC header file for declaration of  One Way ANOVA operation 	*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	ML 10/20/2005 ANOVA_INPUT_DATA_TO_DATARANGE									*
 *	ML 10/25/2005 MUST_CLEAN_UP_CACHED_STUFF									*
 *  Jim 3/8/06 ADD_TABLE_FOOTNOTE												*
 *	CPY 8/11/06 REMOVE_RM_TO_AVOID_LOAD_PROBLEM									*
 *	Echo 1/31/07 ADD_ERROR_REPORT												*
 *	Arvin 10/17/07 CLEAN_ANOVA_TOOLS_CODE										*
 *	Fisher 11/16/07 ADD_MAP_ID_TO_CHM											* 
 *	Arvin 02/14/08 QA70-11094 SUPPORT_PLOT_MULTI_FITTED_CURVES_IN_ONE_GRAPH_IN_LR_PR_AND_FITNL
 *	Hong 09/04/09 QA80-14258 HISTOGRAM_NEED_SPECIAL_HINT_FOR_DOING_NLFITTING	*
 *	Jacky 07/22/10 ORG-102 USER_CAN_SET_SIGNIFICANCE_LEVEL 						*
 *	Folger 06/06/2012 ORG-5906-P1 NORMALITY_TEST_TOO_SLOW_FOR_LARGE_DATA		*
 *------------------------------------------------------------------------------*/
 
#include <o8dlg.h>

#ifndef _ANOVAONEWAY_H
#define	_ANOVAONEWAY_H
class OC_REGISTERED ANOVAOneWay : public ANOVAReportOperation
{
	
/////Jim 3/8/06 v8.0372 ADD_TABLE_FOOTNOTE
//public:
	//ANOVAOneWay();
/////END ADD_TABLE_FOOTNOTE

///Echo 1/31/07 ADD_ERROR_REPORT
public:
	PEVENT_GETN GetNewEventFunction();
///END ADD_ERROR_REPORT
	///Arvin 06/29/07 v8.652 XOP_NEED_SUPPORT_NLFIT
	///Arvin 10/17/07 CLEAN_ANOVA_TOOLS_CODE
	/*
	int OnInitOperationTreeFromOCLT(TreeNode &trOp, TreeNode& trOCLT, bool bInitTree = true)
	{
		int nRet;
		TreeNode trOutGUI = trOCLT.GetNode("GUI");
		TreeNode trInputData = trOutGUI.InputData;
		if(!trInputData)
			return OP_INVALID_INPUT_DATA_NODE;
		
		if(ANOVA_INDEXED_DATA == trInputData.Use)
		{
			nRet = okutil_anova_switch_to_indexed_data(&trInputData, false, false);			
		}
		else
		{
			 nRet = okutil_anova_switch_to_raw_data(&trInputData, false, false);
		}
		
		return nRet;
	}
	*/
	///end CLEAN_ANOVA_TOOLS_CODE
	///END XOP_NEED_SUPPORT_NLFIT
protected:	

	// virtual 
	// fisher 11/16/2007 ADD_MAP_ID_TO_CHM
	int GetHelpID()
	{
		return IDD_XF_ANOVAOneWay;
	}
	
	//BOOL 			Construct(TreeNode& trOperation, int nOption);  /// Iris 12/27/05 CONSTRUCT_RM_BASE_CLASS
	///Arvin 02/14/08 QA70-11094 SUPPORT_PLOT_MULTI_FITTED_CURVES_IN_ONE_GRAPH_IN_LR_PR_AND_FITNL
	//DWORD			GetOutputOptions();
	DWORD			GetOutputOptions(const TreeNode& trOp);
	///end SUPPORT_PLOT_MULTI_FITTED_CURVES_IN_ONE_GRAPH_IN_LR_PR_AND_FITNL
	//virtual
	int 			ConstructGraphNumber();
	//virtual
	int				GetNumberLayersInOneGraph(TreeNode& trOp, int nGraphIndex);

	/// Iris 3/21/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME, want GUI tree as input in DescStats::GetResultSheetName
	//string 			GetResultSheetName(); 
	string 			GetResultSheetName(TreeNode& trGUI);
	///end ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
	string 			GetResultBookName(TreeNode& trGUI);

	/// Iris 05/21/2007 v8.0622 NEED_REPORT_PLOTS_IN_RM_ONE_WAY
	//string 			GetGraphTemplate(int nGraphIndex);
	//virtual int		ReportGetPicureIndexFromDataIndex(int nGraphIndex, int nDataIndex);
	//virtual int		ReportGetPlotTypeFromGraphIndex(int nGraphIndex);
	///end NEED_REPORT_PLOTS_IN_RM_ONE_WAY
	void 			UpdateReportingTables(TreeNode &trOperation, int nTotalNumData, int nExeMode);	
	/// Iris 05/21/2007 v8.0622 NEED_REPORT_PLOTS_IN_RM_ONE_WAY
	//string			GetResultCurveSheetName(TreeNode& trOperation, int nIndex = 0, int nOption = OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET);	
	//bool 			IsOutputSeparateResultCurveSheet(const TreeNode& trOp);
	///end NEED_REPORT_PLOTS_IN_RM_ONE_WAY
	
	//virtual
	BOOL			CalcOneData(TreeNode &trOp, int index, int nTotalNumData, const vector<int> &vFactorSizes,
		const vector<string> &vstrFactors, vector &vData, vector &vDummy, matrix &mDummy, vector &vWeights, 
		DWORD dwPlotObjUID, int nRowColIndex, const vector<int>& vintRowsInSource = NULL);
	
	/// Hong 09/04/09 QA80-14258 HISTOGRAM_NEED_SPECIAL_HINT_FOR_DOING_NLFITTING
	//virtual bool	InitFromSelection(TreeNode &trOperation);
	virtual int		InitFromSelection(TreeNode &trOperation);
	/// end HISTOGRAM_NEED_SPECIAL_HINT_FOR_DOING_NLFITTING
	/// ML 10/20/2005 ANOVA_INPUT_DATA_TO_DATARANGE
	// virtual
	//int				GetDRTreeOption(TreeNode &trOperation); /// Iris 12/27/05 CONSTRUCT_RM_BASE_CLASS, move to base class
	/// end ANOVA_INPUT_DATA_TO_DATARANGE
	/// ML 10/25/2005 MUST_CLEAN_UP_CACHED_STUFF
	// virtual
	void				OnAfterCalculations(TreeNode& trOp);
	/// end MUST_CLEAN_UP_CACHED_STUFF
	
	/// Iris 05/21/2007 v8.0622 NEED_REPORT_PLOTS_IN_RM_ONE_WAY
	//bool 			GetCustomGraphTypeName(string& strName, int nIndex = 0);
	//string 			GetResultCurveBookName(TreeNode& trOperation, int nDataIndex = 0, int nOption = -1, bool bSeparateSheetForDataset = false);
	//uint			GetResultCurveTableID(TreeNode& trOp, int nDataIndex, int nTotalNumData, int nGraphIndex);
	//bool 			IsGraphTableInsertBackToSourceType(int nGraphIndex);
	//int    			GetTotalNumPictureForOneGraphType(TreeNode& trOp, int nGraphIndex = -1);
	//string 			GetReportGraphLabel(TreeNode& trOp, int nGraphIndex, int nPicRow, int nPicCol);	
	///end NEED_REPORT_PLOTS_IN_RM_ONE_WAY
	int 			GetResultCurvesID();
	int				GetGroupSize(TreeNode& trOp);
	string 			GetClassName();
	///Arvin 06/15/07 WRONG_HISTOGRAM_AND_BOXCHART_PLOTS_WHILE_DATA_HAVE_FACTORS
	uint GetResultCurveTableID(TreeNode& trOp, int nDataIndex, int nTotalNumData = -1, int nGraphIndex = 0);
	///end WRONG_HISTOGRAM_AND_BOXCHART_PLOTS_WHILE_DATA_HAVE_FACTORS
	///Cheney 2007-9-28 MODIFY_TITLE_AS_MAX_SAID
	//virtual
	string			GetDlgDescription(int nOption);
	///end MODIFY_TITLE_AS_MAX_SAID
	///Cheney 2007-10-25 ANOVA_TOOLS_HANDLE_AUTO_WRONG
	//virtual
	bool GetAnovaToolsOption(bool bRow, int& nOption);
	///end ANOVA_TOOLS_HANDLE_AUTO_WRONG
	//--- Jacky 07/22/10 ORG-102 USER_CAN_SET_SIGNIFICANCE_LEVEL 	
	double GetAlphaValue();
	//--- end USER_CAN_SET_SIGNIFICANCE_LEVEL

	///------ Folger 06/06/2012 ORG-5906-P1 NORMALITY_TEST_TOO_SLOW_FOR_LARGE_DATA
	virtual void GetCalcMoment(TreeNode& trOp, DescStatOptions& opMoments);
	///------ End NORMALITY_TEST_TOO_SLOW_FOR_LARGE_DATA

private:
	BOOL			addANOVAs(TreeNode &trOp,  const int iLevels, const vector<int>& vIndex, 
						ANOVADescStats* pstDescStats, uint nSizeDescStat,
						ANOVAStats& TotalStats, RegANOVA& ANOVATable);	
	BOOL			getInputDataTotalSize(const ANOVADescStats* pstDescStats, int nSizeDescStat, int& nTotalSize);
	void			addOneANOVASet(TreeNode &trOneSet, LPCSTR lpcszName, LPCSTR lpcszLabel, int nID, const RegANOVA& ANOVATable, int nANOVARow);
	void			addANOVAFootnote(TreeNode &trOneSet);	///Jim 3/8/06 v8.0372 ADD_TABLE_FOOTNOTE
	BOOL			addOverallANOVA(TreeNode &trOp, RegANOVA&	ANOVATable);
	void    		addFitStatsTableHeaderLabel(TreeNode &trRow);
	BOOL			addFitStats(TreeNode &trOp, ANOVAStats& TotalStats);
	BOOL    		addOneMeanComparisonResult(TreeNode &trOp, int nIntervalType, ANOVADescStats* pstDescStats, RegANOVA& ANOVATable, const int iLevels);
	///Arvin 10/17/07 CLEAN_ANOVA_TOOLS_CODE
	//bool 			addMeanComparisonFootnote(TreeNode &trOp); 	///Jim 3/8/06 v8.0372 ADD_TABLE_FOOTNOTE
	///end CLEAN_ANOVA_TOOLS_CODE
	void			addMeanComparisonResults(TreeNode &trOp, ANOVADescStats* pstDescStats, RegANOVA& ANOVATable, const int iLevels);
	void			addOneEqualVariTest(TreeNode &trOp, int nIntervalType, const vector& vData, const int iLevels, const vector<int>& vIndex);
	void 			addEqualVariTestResult(TreeNode &trOp, const int iLevels, const vector<int>& vIndex);
	void    		addPowersResult(TreeNode& trOp, ANOVADescStats* pstDescStats, int nSizeDescStat, RegANOVA ANOVATable);
	///Arvin 10/17/07 CLEAN_ANOVA_TOOLS_CODE
	//bool			addPowers(TreeNode& trOp, bool bIsAtucalPower, ANOVADescStats* pstDescStats, int nSizeDescStat, RegANOVA ANOVATable);						
	bool			updateOnePowerTable(TreeNode& trOp, int iPower, ANOVADescStats* pstDescStats, int nSizeDescStat, RegANOVA ANOVATable);
	///end CLEAN_ANOVA_TOOLS_CODE

	/// Iris 05/21/2007 v8.0622 NEED_REPORT_PLOTS_IN_RM_ONE_WAY
	//void 			addMeansWksTable(TreeNode& trOp, int nGraphIndex, string strTable, int nID, 
	//					const vector<string>& vsNames, const vector<string>& vsLabels, bool bIsSD = true);						
	//void 			addBarDataTable(TreeNode& trOp);
	//void 			addMeansSDWksTable(TreeNode& trOp);
	//void			addMeansSEWksTable(TreeNode& trOp);
	//void			addMeansDiffWksTable(TreeNode& trOp);
	//bool			addOneMeansDiffWksTable(TreeNode& trOp, int iType, int index);	
	//void 			addNodeToMeanWksTable(TreeNode& trTable, vector<string> vsNames, vector<string> vsLabels, int nBaseID);
	//bool 			getDescStatsValues(TreeNode& trOp, vector& vMeans = NULL, vector& vSD = NULL, vector& vSE = NULL);
	//int				getMeanDiffTableNumber(TreeNode& trOp);
	///end NEED_REPORT_PLOTS_IN_RM_ONE_WAY
	///Arvin 10/17/07 CLEAN_ANOVA_TOOLS_CODE
	/*
	void 			addErrorRowToTable(TreeNode& trTable, string strError, int nID);
	void 			addErrInfoANOVA(TreeNode& trOp, int nErr);
	void 			addErrInfoMeanComparison(TreeNode& trTable, int nID, int nErr);
	void 			addErrInfoEqualVariTest(TreeNode& trTable, int nID, int nErr);
	void   			addErrInfoPowers(TreeNode& trTable, int nID, int nErr);
	*/
	///end CLEAN_ANOVA_TOOLS_CODE
	bool			addReportTables(TreeNode &trOp, int iLevels, vector &vWeights);
	/// Iris 05/21/2007 v8.0622 NEED_REPORT_PLOTS_IN_RM_ONE_WAY
	//void			addReportDataTablesAndGraphNodes(TreeNode &trOp, int nTotalNumData, string strLabel);
	///end NEED_REPORT_PLOTS_IN_RM_ONE_WAY
	
	//int 			ide_footnote;	///Jim 3/8/06 v8.0372 ADD_TABLE_FOOTNOTE
};



#endif //_ANOVAONEWAY_H
