/*------------------------------------------------------------------------------*
 *	File Name: 	labstr.h     													*
 *	Purpose:	basic string and date/time definitions		   					*
 *   	Date:		1/1/92														* 
 *  	Copyright Microcal Software Inc. 1992-1995								*
 *	Modification log															*
 *	CPY v3.782 added this header												*
 *	CPY v3.782 DATE_INC_BUG 4/16/95, change LABUTIL_date2str to use				*
 *		NULL lpOutput for management calls										*
 *	CPY v3.782 CHAR_POSITION 4/17/95, add LABUTIL_strchr const					*
 *	CPY v3.782 HH_MM_SS_DDD LABUTIL_time2str add NULL buffer for cntrl info		*
 *		 and settings															*
 *	CPY v3.783 DATE_DIALOG_BUG 4/26/95, need to move ADD_TIME bit and give		*
 *		more space to data format bits to differentiate between 1/1/91 and		*
 *		Mon																		*
 *	CPY v3.8	5/30/95, CPP, add C++ support									*
 *	CPY v3.8 6/1/95 STRLIST, need to check already defined						*
 *	EJP v3.8 6-6-95 GETFILESEC, added LABUTIL_GetFileSection prototype			*
 *	EJP v3.8 7-5-95 GETMEMSEC, add GetSection, ...Entry, ...Ptr prototypes		*
 *	EJP v3.8 8-4-95 GETSET_CURR_FILE add prototype for exported function.		*
 *	EJP v3.821 09-06-95 GET_PATH, add msg parameter to prototype.				*
 *	CPY v3.85 11/7/95 DATE_INC_ERR
 *	CPY v3.98 11/14/95 ROUND_QUARTER, inc=year, minor=quarter still has problem
 *	ML 5/1/96 PUT_IT_INTO_LABUTIL_SO_THAT_EVERYBODY_CAN_USE_IT					*
 *	CPY v4.11 6/26/96 ADD_FUNC_PROTOTYPE										*
 *	EJP v4.13 07-25-96 HUGE_KEYWORD_OBSOLETE_IN_32BIT
 *	CPY v4.133 9/16/96 CLEAN_UP_AFTER_JLIU_ANU_FILE_OPEN_BUG_32					*
 *	CPY b1666 v4.93 2/22/97 HALF_WIDTH_J_CHARACTERS								*
 *  YN  v4.94 2/28/97  MOVED_ERR_SIGN_TO_OUTIL.DLL								*
 *	ANU	v4.94 3/06/97 B1794	CHANGED_OPENFILE_TO_CREATEFILE						*
 *  JLIU v4.979  5/2/97 GET_TEXT_WITH_LEAD_SPACE								*
 *  JLIU 4.998 t7/14/97 b2480 READ_DATE_TIME_MODIFY								*
 *	ML 10/27/97 UNIFIED_STRING_MANIPULATION_MBCS								*
 *	RB 6/24/98 t3594 v6.0125 DATE_TIME_CUSTOM_FORMAT							*
 *	CPY v6.0130 b4228 9/25/98 PLOT_A_SUPPORT_MORE_THAN_10_NUMBERS				*
 *	RB 11/16/98 t4121 v6.0138 CURRENT_DATE_IN_CUSTOM_FORMAT_IN_DIALOG			*
 *	RB 3/16/99 t3668 v6.0174 MONTH_DAY_FORMAT_WRONG_INTERPRETATION_IN_JAPANESE	*
 *	EJP 03-23-99 v6.0176 t5005 IMPLEMENT_ABILITY_TO_RESET_CUSTOM_DATE_FORMATS	*
 *------------------------------------------------------------------------------*/      

///CPY v3.8	5/30/95, CPP, add C++ support
#ifndef	_LABSTR
#define	_LABSTR

#ifdef __cplusplus
extern "C" {            /* Assume C declarations for C++ */
#endif	/* __cplusplus */
///

#ifndef	_OTYPES
#define MAXLINE			80
#define COM_LENGTH		380
#define NAME_SIZE		25
#define SHORT_NAME_SIZE		12
#define	WORD_SIZE		40

	#ifndef	USHORT
	#define	USHORT	WORD
	#define	WWORD	WORD
	#define	ULONG	DWORD

	typedef	USHORT	FAR *LPUSHORT;
	typedef	ULONG	FAR *LPULONG;
	#endif

/// EJP v4.13 07-25-96 HUGE_KEYWORD_OBSOLETE_IN_32BIT
///typedef	BYTE	huge	*HPSTR;
#ifdef _WIN32
	typedef	BYTE	FAR		*HPSTR;
#else // !_WIN32
	typedef	BYTE	huge	*HPSTR;
#endif // _WIN32
/// end HUGE_KEYWORD_OBSOLETE_IN_32BIT

typedef double FAR *LPDOUBLE;
#endif

// def only for DLLs
#define	LABLOCAL	static	int
#define	LABGLOBAL	int

#ifdef	WIN30
#define HFILE	int
#define	HGLOBAL	HANDLE
#define	_tzset()	tzset()
#define	_timezone	timezone
#define	_timeb		timeb
#define	_getcwd(x,y)	getcwd(x,y)
#define	_ftime(x)	ftime(x)
#define	LAB_NO_HWIRTE
#endif

#define	MEM_COPY_N(d,s,n)	LABUTIL_MemCopy(s,d,n)

		/* lpRemains = LABUTIL_next_token(lpBuffer,lpSource); 
		 */
LPSTR   FAR PASCAL LABUTIL_next_token(LPSTR,LPSTR);
///CPY v4.11 6/26/96 ADD_FUNC_PROTOTYPE
//LPSTR   FAR PASCAL LABUTIL_next_token_sep(LPSTR,LPSTR);
LPSTR	FAR PASCAL LABUTIL_next_token_sep(LPSTR lpBuffer,LPSTR lpstr,LPSTR lpList);
///
LPSTR   FAR PASCAL LABUTIL_next_word(LPSTR,LPSTR);
	/* similar to next_token but does not recorgnize quotes */

void FAR PASCAL LABUTIL_strip(LPSTR);/* remove all white spaces in str */
#define strip(str)                              LABUTIL_strip(str)

		/* LABUTIL_real2str(input,lpBuffer,lpFormat);
		 * lpFormat: "*" free format
		 *                       "5.2f" 10.00
		 *                       "5.2g" 1E1
		 */
void    FAR PASCAL LABUTIL_real2str(double,LPSTR,LPSTR);
		/*      
		 * round a real number
		 * to specified number of significent
		 * digits.
		 * out = LABUTIL_real2real(in,n_decimal_pts);
		 */
double  FAR PASCAL LABUTIL_real2real(double,short);

	/* This routine is similar to the C-LIB
	 * routine gcvt
	 * converts a real number to a string
	 * by specifying a significant digits
	 */
/*double        FAR     PASCAL LABUTIL_GCVT(double,int,LPSTR);*/

#define DECIMAL_MAX     1E12
#define DECIMAL_MIN     1E-6
#define IS_D            0x01
#define IS_G            0x02
#define IS_E            0x04
#define IS_GCVT         0x08
#define REM_END_ZEROS   0x10


#define IS_UPPER        0x80
#define IS_LOWER        0x00

#define FORMAT_MASK     0x0F

	/*First parameter is the number to be converted, next the format
	given as IS_E or IS_D,then the total no of digits, and then the no
	of digits after the decimal point.The last parameter is the string
	where the result is placed */

int     FAR     PASCAL LABUTIL_real_str(double,BYTE,BYTE,BYTE,LPSTR);

#define LABUTIL_GCVT(x,ndigits,lpstr)  LABUTIL_real_str(x,IS_GCVT,ndigits,0,lpstr)

void    FAR     PASCAL LABUTIL_int2fixstr(long,int,LPSTR);
double  FAR     PASCAL LABUTIL_str2real(LPSTR);
int     FAR     PASCAL LABUTIL_cvtstr2real(LPSTR,double FAR *);
int     FAR     PASCAL LABUTIL_cvtstr2int(LPSTR,int FAR *);
long    FAR     PASCAL LABUTIL_str2int(LPSTR);
LPSTR   FAR     PASCAL LABUTIL_int2str(long);
long    FAR     PASCAL LABUTIL_hexstr2int(LPSTR);

		/* convert time in 10ms into a 
		 * a string
		 */


///	CPY v4.133 9/16/96 CLEAN_UP_AFTER_JLIU_ANU_FILE_OPEN_BUG_32
DLL_EXPORT(int) LABUTIL_32WriteFile(HFILE hFile,LPVOID lpBuffer,DWORD dwBytes);

///ANU	v4.94 3/06/97 B1794	CHANGED_OPENFILE_TO_CREATEFILE
//DLL_EXPORT(int) LABUTIL_32CreateFile(LPSTR	lpFilename,	DWORD	dwMode); 
DLL_EXPORT(int) LABUTIL_32FileCreate(LPCSTR	lpFilename,	DWORD	dwMode, DWORD 	dwShare );

#define  LABUTIL_32CreateFile(lpFilename, dwMode) \
			LABUTIL_32FileOpen(lpFilename, dwMode, 0,  OPEN_ALWAYS);
	
DLL_EXPORT(int) LABUTIL_32FileOpen(LPCSTR lpFilename,DWORD dwMode,DWORD dwShare,DWORD dwOpenAs );

DLL_EXPORT(int) LABUTIL_32FileTest(LPCSTR lpFilename);

///end 	CHANGED_OPENFILE_TO_CREATEFILE
///

/*
#define T2S_AMPM        0x0100   otherwise in 24 hours 
lowbyte defined the format 
enum {T2S_HOURS = 0,T2S_MIN,T2S_SEC,T2S_SUBSEC};
*/

	
enum {T2S_SEC=1,T2S_SUBSEC,T2S_AMPM };


		/*      Find character in string
		 *
		 * lpChar = LABUTIL_strchr(lpSource,theChar,cntrl);
		 */
LPSTR   FAR PASCAL LABUTIL_strchr(HPSTR,short,USHORT);

		/* cntrl is one of the followings */
#define SC_IGNORE_QUOTE 0x0001/* otherwise, those hidden in (), {}, [] will not be found */
#define SC_FIND_LAST    0x0002/* search from the end of the string */
#define SC_FIND_INSIDE  0x0004
#define SC_BEG_END_SPACE        0x0010
/// CPY v3.782 CHAR_POSITION
#define	SC_IGNORE_CASE	0x0020
///
		/* special characters for theChar */
#define SC_CHAR_SPACE           -1 /* any white space */
#define SC_CHAR_OP                      -2 /* any of +,-,*,/,^ */

/// ML 5/1/96 PUT_IT_INTO_LABUTIL_SO_THAT_EVERYBODY_CAN_USE_IT
#define		CHAR_POSITION_FROM_BEG(str, c)	LABUTIL_strchr((HPSTR)str, c, SC_IGNORE_QUOTE)
#define		CHAR_POSITION_FROM_END(str, c)	LABUTIL_strchr((HPSTR)str, c, SC_FIND_LAST | SC_IGNORE_QUOTE)
/// end PUT_IT_INTO_LABUTIL_SO_THAT_EVERYBODY_CAN_USE_IT


		/* get string inside possible
		 * parenthesis: (string) -> string
		 *
		 *      lpString = LABUTIL_str_inside(lpSource);
		 */
#define	get_next_argument(str)	LABUTIL_strchr(str,',',SC_IGNORE_QUOTE|SC_BEG_END_SPACE)        //dsb 3.69 for FUM labcom etc.

///  JLIU v4.979  5/2/97 GET_TEXT_WITH_LEAD_SPACE								
///LPSTR   FAR PASCAL LABUTIL_str_inside(LPSTR);
LPSTR   FAR PASCAL LABUTIL_str_inside(LPSTR, short);
///end GET_TEXT_WITH_LEAD_SPACE




		/* convert \xhh type into ascii
		 * also support \n, \t, \r, \d
		 */
int	FAR PASCAL	LABUTIL_str2ascii(LPSTR);

		/* Addition to the Windows GetPrivateProfile functions
		 * Please refer to Windows SDK for the others
		 */
double  FAR     PASCAL  LABUTIL_GetPrivateProfileReal(LPSTR,LPSTR,double,LPSTR);

#define LABDATE_HHMM    0
#define LABDATE_HHMMSS  2
#define	LABDATE_HHMMSS_NUM	9
#define	LABDATE_HHMM_NUM	8

#define LABDATE_HHMMPM  5

/// CPY v3.782 HH_MM_SS_DDD
//void    FAR PASCAL LABUTIL_time2str(double, USHORT, LPSTR); 
int    FAR PASCAL LABUTIL_time2str(double, USHORT, LPSTR);
/// enabled when lpstr is LPNULL
#define	LABT_CNTRL_GET_FULL_PREC_INDEX	0x1000
#define	LABT_SET_DIVIDER				0x0000	
///



double  FAR PASCAL LABUTIL_str2time(LPSTR,USHORT);
double  FAR PASCAL LABUTIL_str2date(LPSTR,USHORT,USHORT);
/// RB 3/16/99 t3668 v6.0174 MONTH_DAY_FORMAT_WRONG_INTERPRETATION_IN_JAPANESE
double FAR PASCAL LABUTIL_str2date_ex(LPSTR lpdatestr,WORD cntrl,WORD nFmt);
/// end MONTH_DAY_FORMAT_WRONG_INTERPRETATION_IN_JAPANESE
USHORT    FAR PASCAL LABUTIL_date2str(double,USHORT,LPSTR);

/// RB 6/24/98 t3594 v6.0125 DATE_TIME_CUSTOM_FORMAT
#define	NUMBER_OF_DATE_CUSTOM_FORMATS			2
#define	DATE_CUSTOM_FORMAT_BEGIN				NUM_DATE_FORMAT
#define	DATE_CUSTOM_FORMAT_END					(DATE_CUSTOM_FORMAT_BEGIN + NUMBER_OF_DATE_CUSTOM_FORMATS)

WORD    FAR PASCAL LABUTIL_date2str_custom(double rDate, int nCustomFormat, LPSTR lpszFormattedDate);

#define	SET_CUSTOM_DATE_FORMAT					0x00000000
#define	GET_CUSTOM_DATE_FORMAT					0x00000001

/// EJP 03-23-99 v6.0176 t5005 IMPLEMENT_ABILITY_TO_RESET_CUSTOM_DATE_FORMATS
#define CDF_INITIALIZE							0x00000002
/// end IMPLEMENT_ABILITY_TO_RESET_CUSTOM_DATE_FORMATS

#define	CHECK_CUSTOM_DATE_FORMAT				0x00000010 
/// RB 11/16/98 t4121 v6.0138 CURRENT_DATE_IN_CUSTOM_FORMAT_IN_DIALOG
#define	GET_NUMBER_OF_FIRST_CUSTOM_FORMAT		0x00000100
/// end CURRENT_DATE_IN_CUSTOM_FORMAT_IN_DIALOG
WORD FAR PASCAL LABUTIL_custom_date_format(int nIndex, WORD wCntrl, LPTSTR lpszCustomDateFormat);
/// end DATE_TIME_CUSTOM_FORMAT

int     FAR PASCAL LABUTIL_dateinc(LPDOUBLE,ULONG , USHORT);

#define LABDATE_DATEFORMAT_SEC  (1.0/86400)     /* 1/(24*3600) */

/// CPY v3.782 DATE_INC_BUG
/// these constants are kept the same but they all
/// act with lpOutPut == LPNULL
/// added new for 3.782
#define	MASK_LABDATE_MANAGEMENT		0xF000
#define	LABDATE_IS_SIMPLE_FORMAT	0x7000
	/// return 1 if spcified index in style should
	/// use simple format for data entry
#define LABDATE_INIT			0x8000 /// v3.782 kept the same
/// CPY v3.73
#define	LABDATE_TEST_HEBR_LANGUAGE	0x6000 /// v3.782 changed from 8001
//				0x8001	

///JLIU 4.998 7/14/97 READ_DATE_TIME_MODIFY
#define	LABDATE_TEST_DATATIME		0x1000	
///end READ_DATE_TIME_MODIFY


/// CPY v3.782

/// CPY v3.783 DATE_DIALOG_BUG 4/26/95
//#define LABDATE_SHORT_FORMAT    0x0000
#define LABDATE_SHORT_FORMAT    0x0004
#define LABDATE_LONG_FORMAT		0x0001
#define LABDATE_SHORT_CHAR		0x0002

/// CPY v3.783 DATE_DIALOG_BUG 4/26/95
//#define LABDATE_FORMAT			0x0003
#define LABDATE_FORMAT			0x0007

#define LABDATE_NUM_FORMAT		0x0003	/* 19920201 */
/// CPY v3.783 DATE_DIALOG_BUG 4/26/95
//#define LABDATE_ADD_TIME		0x0004
#define LABDATE_ADD_TIME		0x8000
/// move to the highest bit
#define LABDATE_ADD_SEC			0x0008


#define LABDATE_FOMRAT_READ		0x0010	/* for the FormatDateControl routine only */

/// CPY v3.783 DATE_DIALOG_BUG 4/26/95
#define	MASK_LABDATA_OTHERFORMAT	0x00F0
///

#define LABDATE_ALPHA_MONTH		0x0010
#define LABDATE_NUMERIC_MONTH   0x0020
#define LABDATE_NUMERIC_DAY		0x0030
#define LABDATE_ALPHA_WDAY		0x0040
#define LABDATE_NUMERIC_WDAY    0x0050

#define LABDATE_ALPHA_QUATER    0x0060
#define LABDATE_NUMERIC_QUATER  0x0070
#define LABDATE_NUMERIC_YEAR    0x0080
/* 0x00F0 for basic formats */


/* 0 for full date */
// CPY v3.53, these flags must be in the high byte
#define LABDATE_MONTH_ONLY		0x0800
#define LABDATE_DAY_ONLY		0x0400
#define	LABDATE_ADD_TIME_NUM	0x0200
#define	LABDATE_NO_DAY			0x0100

#define LABDATE_GET_DATE	3
#define LABDATE_GET_CORRECT	4
/// CPY v3.53
#define	LABDATE_SIMPLE_FORMAT	0x0080 // lowbyte but too big for index

#define LABDATE_INCREMENT		0x1000
#define LABDATE_GUESS_PARTIAL   0x2000
#define LABDATE_USE_FORMAT		0x4000 /* hibyte must be none zero to use format */

#define LABDATE_DATETIME	9
#define LABDATE_DATESEC		10








#define	TIME_HHMM		8
#define	TIME_HHMMSS		9

enum {
LABUTIL_DATE_INC = 0,
LABUTIL_DATE_INC_BY_UNIT,
LABUTIL_DATE_ROUND_INC,
LABUTIL_DATE_WAS_WEEK,
LABUTIL_DATE_ROUND_DAY,
LABUTIL_DATE_MATCH_DATE,
LABUTIL_DATE_MATCH_INC,
LABUTIL_DATE_ROUND_MONTH,/// CPY v3.85 11/7/95 DATE_INC_ERR
LABUTIL_DATE_ROUND_QUARTER,///CPY v3.98 11/14/95 ROUND_QUARTER, inc=year, minor=quarter still has problem
};

///CPY v3.85 11/7/95 DATE_INC_ERR
#define DATE_ROUND_DAY		0x10
#define	DATE_ROUND_MONTH	0x20
#define	DATE_ROUND_QUARTER	0x40 /// CPY v3.98 11/14/95 ROUND_QUARTER, inc=year, minor=quarter still has problem
///

void    FAR PASCAL LABUTIL_sprintf(LPSTR,LPSTR,double);
LPSTR   FAR PASCAL get_next_token_sep(LPSTR,LPSTR,LPSTR);

///CPY v4.11 6/26/96 ADD_FUNC_PROTOTYPE
int     FAR PASCAL LABUTIL_MemCopy(register LPSTR,register LPSTR,register LONG);
//int     FAR PASCAL LABUTIL_MemCopy(register HPSTR s,register HPSTR d,register LONG count);
/// can not make this change as there are many places that use this function with LPSTR

///CPY v4.11 6/26/96 ADD_FUNC_PROTOTYPE
//int     FAR PASCAL  LABUTIL_RowColChange(LPSTR,USHORT,USHORT,int);
int FAR PASCAL  LABUTIL_RowColChange(HPSTR lpInp,USHORT nrows,USHORT ncols,int size);

/// EJP v3.8 GETFILESEC
HGLOBAL	FAR PASCAL LABUTIL_GetFileSection(LPSTR lpStrFile, LPSTR lpStrSection);
/// end GETFILESEC
/// EJP v3.8 GETSET_CURR_FILE
// EJP v3.821 09-06-95 GET_PATH, Add message parameter.
//LPSTR	FAR PASCAL LABUTIL_GetFileSection_Filename(LPSTR lpStrNewFilename);
LPSTR	FAR PASCAL LABUTIL_GetFileSection_Filename(LPSTR lpStrNewFilename, WORD msg);
// end GET_PATH
/// end GETSET_CURR_FILE
/// EJP v3.8 GETMEMSEC
LPSTR	FAR PASCAL LABUTIL_GetMemSectionPtr(LPSTR lpStrFile, LPSTR lpStrSection, WORD far*wSize);
WORD	FAR PASCAL LABUTIL_GetMemSection(LPSTR lpStrMem, LPSTR lpStrSection, LPSTR lpStrDest);

int		FAR PASCAL LABUTIL_GetMemSectionEntry(
LPSTR	lpStrSection,
LPSTR	lpStrEntry,
LPSTR	lpStrDefValue,
LPSTR	lpStrDestBuf,
WORD	wDestBufSize,
LPSTR	lpStrFile);
/// end GETMEMSEC

int     FAR PASCAL  LABUTIL_StructCompare(LPSTR,LPSTR,LONG);

USHORT    FAR PASCAL  LABUTIL_MemObject(LPHANDLE,USHORT,USHORT,LPSTR,ULONG);
#define	LUMO_INIT	0
#define	MASK_NEED_HANDLE	0x1000

enum {
	LUMO_ADD = MASK_NEED_HANDLE,
	LUMO_GET,
	LUMO_FIND,
	LUMO_DELETE,
	LUMO_DESTROY,
	//---------- CPY v4.9775 6/17/97 b2457 PLOT_ID_FOR_SCRIPT_ADDED_MENUS
	LUMO_SET_INTERNAL,
	//---------- PLOT_ID_FOR_SCRIPT_ADDED_MENUS
	};

LPSTR	FAR PASCAL LABUTIL_MultiLineControl(LPSTR lpstr,LPSTR lpstr2,USHORT cntrl);
#define	LUMLC_COUNT	0
#define	LUMLC_REVERT_ORDER	1
#define	LUMLC_NEXT_LINE		2

///CPY v3.8 6/1/95 STRLIST
#ifndef	LFS_NOT_IN_LIST ///CPY v3.8 6/1/95 STRLIST 
	typedef struct	STRLIST {
	//typedef struct	LU_STRLIST {
		USHORT	id;
		LPSTR	str;
	}STRLIST,FAR *LPSTRLIST;
	
	/// CPY v3.74
	typedef	int	STRID;
	///
	STRID FAR PASCAL LABUTIL_FindString(LPSTRLIST lpList,LPSTR lpstr);
	#define	LFS_NOT_IN_LIST	32764
#endif	/// LFS_NOT_IN_LIST ///CPY v3.8 6/1/95 STRLIST 

/// CPY v3.53, allow global falgs
#define	MASK_LIST	0x0800
#define	MASK_SUB	0x2000
#define	MASK_STR	0x4000
#define	MASK_CMD	0x8000
///

int FAR PASCAL LABUTIL_End_Number(LPSTR lpdes,LPSTR lpsrc);
/* copy src to des, return number if exist or zero */


/// CPY move these here from labutil.h
int FAR PASCAL Write64K(HFILE hFile,HPSTR lpData,LONG dwDataLen);
int FAR PASCAL Read64K(HFILE hFile,HPSTR lpData,LONG dwDataLen);

#ifdef	ORG_JAPAN

typedef		USHORT	OMBCSCHAR;

///CPY b1666 v4.93 2/22/97 HALF_WIDTH_J_CHARACTERS
//CPY: after more examination, it turns out that it is due to the half width characters. So temp solution is to tell people to avoid using these.
//I looked at the character map and discover the double-byte is in the range
//of 0x80 to 0x9f, 0xe0 to 0xff, and 0xA0 to 0xDF is reserved for these
//halfwidth characters.
//#define	NON_PRNT_ASCII(cc)	((BYTE)(cc) & 0x80)
#define BYTE_CHAR(cc)			((BYTE) (cc))
#define HALF_CHAR(cc)			(BYTE_CHAR(cc) >= 0xA0 && BYTE_CHAR(cc) <= 0xDF)
#define LEAD_CHAR_FOR_2BYTE(cc)	( (BYTE_CHAR(cc) & 0x80) && !HALF_CHAR(cc))

LPSTR	setc_two(LPSTR lp,OMBCSCHAR cc);
USHORT	getc_two(LPSTR lp);
USHORT	getc_two_adv(LPSTR lplp);

///CPY b1666 v4.93 2/22/97 HALF_WIDTH_J_CHARACTERS
//#define	ADV_STR(lp)		lp=NON_PRNT_ASCII(*lp)? (LPSTR)(lp)+2 : (LPSTR)(lp)+1
#define	ADV_STR(lp)		lp=LEAD_CHAR_FOR_2BYTE(*lp)? (LPSTR)(lp)+2 : (LPSTR)(lp)+1
///
#define	SET_CHAR(lp,cc)	lp = setc_two(lp,cc)
#define	GET_CHAR(lp)	getc_two(lp)

#define	SET_ADV(lpd,lps)	SET_CHAR(lpd,GET_CHAR(lps)),ADV_STR(lps)
#define	GET_ADV(lps)		getc_two_adv(&lps)

#else

/// ML 10/27/97 UNIFIED_STRING_MANIPULATION_MBCS

#ifdef		UNIFIED_STRING_MANIPULATION_MBCS

#pragma	message("UNIFIED UNIFIED UNIFIED UNIFIED UNIFIED String manipulation using MBCS UNIFIED UNIFIED UNIFIED UNIFIED UNIFIED")

typedef		USHORT	OMBCSCHAR;

LPSTR		adv_str_MBCS(LPSTR *lplp);
OMBCSCHAR	getc_MBCS(LPCSTR lp);
OMBCSCHAR	setc_MBCS(LPSTR *lplp, OMBCSCHAR cc);
OMBCSCHAR	setc_adv_MBCS(LPSTR *lplpd, LPSTR *lplps);
OMBCSCHAR	getc_adv_MBCS(LPSTR *lplp);

#define	ADV_STR(lp)			adv_str_MBCS(&lp)
#define	GET_CHAR(lp)		getc_MBCS(lp)
#define	SET_CHAR(lp,cc)		setc_MBCS(&lp, cc)
#define	SET_ADV(lpd,lps)	setc_adv_MBCS(&lpd, &lps)
#define	GET_ADV(lps)		getc_adv_MBCS(&lps)



#else		// !UNIFIED_STRING_MANIPULATION_MBCS
/// end UNIFIED_STRING_MANIPULATION_MBCS

typedef	char	OMBCSCHAR; //-----------------------	CPY v6.0130 b4228 9/25/98 PLOT_A_SUPPORT_MORE_THAN_10_NUMBERS

#define	ADV_STR(lp)			lp++
#define	GET_CHAR(lp)		*lp
#define	SET_CHAR(lp,cc)		*lp++ = cc
#define	SET_ADV(lpd,lps)	*lpd++ = *lps++
#define	GET_ADV(lps)		*lps++

/// ML 10/27/97 UNIFIED_STRING_MANIPULATION_MBCS
#endif		// !UNIFIED_STRING_MANIPULATION_MBCS
/// end UNIFIED_STRING_MANIPULATION_MBCS

#endif

#define	ADV_ONE_BYTE(lp)	lp++
#define	SET_ONE_BYTE(lp,cc)	*lp = cc
#define	SET_ONE_ADV(lpd,lps)	*lpd++ = *lps++

///  YN  v4.94 2/28/97  MOVED_ERR_SIGN_TO_OUTIL.DLL
// For make it accessible from NLSF
#ifdef	ORG_JAPAN
#define	SIGN_CHAR	"}"
#else
#define	SIGN_CHAR	""
#endif //!ORG_JAPAN
///  end  MOVED_ERR_SIGN_TO_OUTIL.DLL

///CPY v3.8	5/30/95, CPP, add C++ support
#ifdef __cplusplus
}
#endif	/* __cplusplus */

#endif  /* !_LABMATH_H */
///

