﻿#include "resource.h"

//#define BUILD_ONLY_SNES 1
//#define BUILD_ONLY_NES 1
//#define BUILD_ONLY_MD 1
//#define BUILD_ONLY_GBA 1
//#define BUILD_ONLY_GB 1
//#define BUILD_ONLY_PCE 1

#include <mednafen/mednafen.h>
#include <mednafen/general.h>

#include <mednafen/MemoryStream.h>
#include <SDL.h>
#include <SDL_syswm.h>
#include <Uxtheme.h>
#include "log.h"
#include "xgui.h"



#define SOUND_BUFFER_FRAMES			20

struct Setup
{
	const char* cartName;
	const int* buttonsOrder;
	int count;
	int players;
	int channels;
};

#define JOY_THRESH	1000

int global_genesis_width = 320;

#undef IDD_PLAYER_TAB_DIALOG



#ifdef BUILD_ONLY_SNES

#define VIEW_TEXTURE_WIDTH		256
#define VIEW_TEXTURE_HEIGHT		224
#define VIEW_WINDOW_WIDTH		VIEW_TEXTURE_WIDTH
#define VIEW_WINDOW_HEIGHT		VIEW_TEXTURE_HEIGHT

extern MDFNGI EmulatedSNES;
MDFNGI *MDFNGameInfo = &EmulatedSNES;
static const int SnesButtonsOrders[] = { 5, 6, 8, 9, 0, 1, 2, 3, 4, 7, 10, 11 };
static const Setup CurrentSetup = { "res/game", SnesButtonsOrders , SDL_arraysize(SnesButtonsOrders), 2, 2};

#define CONTROLLER_BUTTONS		12
#define IDD_PLAYER_TAB_DIALOG	IDD_PLAYER_TAB_DIALOG_SNES

const int EditIDs[CONTROLLER_BUTTONS] = {
	IDC_EDIT_SNES_UP,
	IDC_EDIT_SNES_DOWN,
	IDC_EDIT_SNES_LEFT,
	IDC_EDIT_SNES_RIGHT,
	IDC_EDIT_SNES_A,
	IDC_EDIT_SNES_B,
	IDC_EDIT_SNES_Y,
	IDC_EDIT_SNES_X,
	IDC_EDIT_SNES_SELECT,
	IDC_EDIT_SNES_START,
	IDC_EDIT_SNES_L,
	IDC_EDIT_SNES_R
};

const char* ButtonNames[CONTROLLER_BUTTONS] = {
	"Up",
	"Down",
	"Left",
	"Right",
	"A",
	"B",
	"Y",
	"X",
	"Select",
	"Start",
	"L",
	"R"
};

const SDL_Scancode DefaultButtonsKeyb[CONTROLLER_BUTTONS] = {
	SDL_SCANCODE_UP,
	SDL_SCANCODE_DOWN,
	SDL_SCANCODE_LEFT,
	SDL_SCANCODE_RIGHT,
	SDL_SCANCODE_Z,
	SDL_SCANCODE_X,
	SDL_SCANCODE_S,
	SDL_SCANCODE_A,
	SDL_SCANCODE_SPACE,
	SDL_SCANCODE_RETURN,
	SDL_SCANCODE_Q,
	SDL_SCANCODE_W,
};

const int DefaultButtonsJoy[CONTROLLER_BUTTONS] =
{
	SDL_HAT_UP,
	SDL_HAT_DOWN,
	SDL_HAT_LEFT,
	SDL_HAT_RIGHT,
	0,
	1,
	3,
	2,
	6,
	7,
	4,
	5,
};

#endif
#ifdef BUILD_ONLY_NES

#define VIEW_TEXTURE_WIDTH		256
#define VIEW_TEXTURE_HEIGHT		224
#define VIEW_WINDOW_WIDTH		VIEW_TEXTURE_WIDTH
#define VIEW_WINDOW_HEIGHT		VIEW_TEXTURE_HEIGHT

extern MDFNGI EmulatedNES;
MDFNGI *MDFNGameInfo = &EmulatedNES;
static const int NesButtonsOrders[] = { 5, 4, 6, 7, 0, 1, 2, 3 };
static const Setup CurrentSetup = { "res/game", NesButtonsOrders , SDL_arraysize(NesButtonsOrders), 2, 1 };

#define CONTROLLER_BUTTONS		8
#define IDD_PLAYER_TAB_DIALOG	IDD_PLAYER_TAB_DIALOG_NES

const int EditIDs[CONTROLLER_BUTTONS] = {
	IDC_EDIT_NES_UP,
	IDC_EDIT_NES_DOWN,
	IDC_EDIT_NES_LEFT,
	IDC_EDIT_NES_RIGHT,
	IDC_EDIT_NES_A,
	IDC_EDIT_NES_B,
	IDC_EDIT_NES_SELECT,
	IDC_EDIT_NES_START,
};

const char* ButtonNames[CONTROLLER_BUTTONS] = {
	"Up",
	"Down",
	"Left",
	"Right",
	"A",
	"B",
	"Select",
	"Start",
};

const SDL_Scancode DefaultButtonsKeyb[CONTROLLER_BUTTONS] = {
	SDL_SCANCODE_UP,
	SDL_SCANCODE_DOWN,
	SDL_SCANCODE_LEFT,
	SDL_SCANCODE_RIGHT,
	SDL_SCANCODE_Z,
	SDL_SCANCODE_X,
	SDL_SCANCODE_SPACE,
	SDL_SCANCODE_RETURN,
};

const int DefaultButtonsJoy[CONTROLLER_BUTTONS] =
{
	SDL_HAT_UP,
	SDL_HAT_DOWN,
	SDL_HAT_LEFT,
	SDL_HAT_RIGHT,
	0,
	1,
	6,
	7,
};

#endif
#ifdef BUILD_ONLY_MD

#define VIEW_TEXTURE_WIDTH		320
#define VIEW_TEXTURE_HEIGHT		224
#define VIEW_WINDOW_WIDTH		VIEW_TEXTURE_WIDTH
#define VIEW_WINDOW_HEIGHT		VIEW_TEXTURE_HEIGHT

extern MDFNGI EmulatedMD;
MDFNGI *MDFNGameInfo = &EmulatedMD;
static const int SegaButtonsOrders[] = { 0, 1, 2, 3, 5, 6, 4, 7, 10, 9, 8, 11 };
static const Setup CurrentSetup = { "res/game", SegaButtonsOrders , SDL_arraysize(SegaButtonsOrders), 2, 2 };

#define CONTROLLER_BUTTONS		12
#define IDD_PLAYER_TAB_DIALOG	IDD_PLAYER_TAB_DIALOG_SMD

const int EditIDs[CONTROLLER_BUTTONS] = {
	IDC_EDIT_SMD_UP,
	IDC_EDIT_SMD_DOWN,
	IDC_EDIT_SMD_LEFT,
	IDC_EDIT_SMD_RIGHT,
	IDC_EDIT_SMD_A,
	IDC_EDIT_SMD_B,
	IDC_EDIT_SMD_C,
	IDC_EDIT_SMD_START,
	IDC_EDIT_SMD_X,
	IDC_EDIT_SMD_Y,
	IDC_EDIT_SMD_Z,
	IDC_EDIT_SMD_MODE
};

const char* ButtonNames[CONTROLLER_BUTTONS] = {
	"Up",
	"Down",
	"Left",
	"Right",
	"A",
	"B",
	"C",
	"Start",
	"X",
	"Y",
	"Z",
	"Mode",
};

const SDL_Scancode DefaultButtonsKeyb[CONTROLLER_BUTTONS] = {
	SDL_SCANCODE_UP,
	SDL_SCANCODE_DOWN,
	SDL_SCANCODE_LEFT,
	SDL_SCANCODE_RIGHT,
	SDL_SCANCODE_Z,
	SDL_SCANCODE_X,
	SDL_SCANCODE_C,
	SDL_SCANCODE_RETURN,
	SDL_SCANCODE_A,
	SDL_SCANCODE_S,
	SDL_SCANCODE_D,
	SDL_SCANCODE_SPACE,
};

const int DefaultButtonsJoy[CONTROLLER_BUTTONS] =
{
	SDL_HAT_UP,
	SDL_HAT_DOWN,
	SDL_HAT_LEFT,
	SDL_HAT_RIGHT,
	0,
	1,
	5,
	7,
	2,
	3,
	4,
	6,
};

#endif
#ifdef BUILD_ONLY_GBA

#define VIEW_TEXTURE_WIDTH		240
#define VIEW_TEXTURE_HEIGHT		160
#define VIEW_WINDOW_WIDTH		VIEW_TEXTURE_WIDTH
#define VIEW_WINDOW_HEIGHT		VIEW_TEXTURE_HEIGHT

extern MDFNGI EmulatedGBA;
MDFNGI *MDFNGameInfo = &EmulatedGBA;
static const int GbaButtonsOrders[] = { 5,4, 6,7,3,2,0,1,9,8 };
static const Setup CurrentSetup = { "res/game", GbaButtonsOrders , SDL_arraysize(GbaButtonsOrders), 1, 2 };

#define CONTROLLER_BUTTONS		10
#define IDD_PLAYER_TAB_DIALOG	IDD_PLAYER_TAB_DIALOG_GBA

const int EditIDs[CONTROLLER_BUTTONS] = {
	IDC_EDIT_GBA_UP,
	IDC_EDIT_GBA_DOWN,
	IDC_EDIT_GBA_LEFT,
	IDC_EDIT_GBA_RIGHT,
	IDC_EDIT_GBA_A,
	IDC_EDIT_GBA_B,
	IDC_EDIT_GBA_SELECT,
	IDC_EDIT_GBA_START,
	IDC_EDIT_GBA_L,
	IDC_EDIT_GBA_R
};

const char* ButtonNames[CONTROLLER_BUTTONS] = {
	"Up",
	"Down",
	"Left",
	"Right",
	"A",
	"B",
	"Select",
	"Start",
	"L",
	"R"
};

const SDL_Scancode DefaultButtonsKeyb[CONTROLLER_BUTTONS] = {
	SDL_SCANCODE_UP,
	SDL_SCANCODE_DOWN,
	SDL_SCANCODE_LEFT,
	SDL_SCANCODE_RIGHT,
	SDL_SCANCODE_Z,
	SDL_SCANCODE_X,
	SDL_SCANCODE_SPACE,
	SDL_SCANCODE_RETURN,
	SDL_SCANCODE_Q,
	SDL_SCANCODE_W,
};

const int DefaultButtonsJoy[CONTROLLER_BUTTONS] =
{
	SDL_HAT_UP,
	SDL_HAT_DOWN,
	SDL_HAT_LEFT,
	SDL_HAT_RIGHT,
	0,
	1,
	3,
	2,
	4,
	5
};

#endif
#ifdef BUILD_ONLY_GB

#define VIEW_TEXTURE_WIDTH		160
#define VIEW_TEXTURE_HEIGHT		140
#define VIEW_WINDOW_WIDTH		VIEW_TEXTURE_WIDTH
#define VIEW_WINDOW_HEIGHT		VIEW_TEXTURE_HEIGHT

extern MDFNGI EmulatedGB;
MDFNGI *MDFNGameInfo = &EmulatedGB;
static const int GbButtonsOrders[] = { 5,4, 6,7,3,2,0,1 };
static const Setup CurrentSetup = { "res/game", GbButtonsOrders , SDL_arraysize(GbButtonsOrders), 1, 2 };

#define CONTROLLER_BUTTONS		8
#define IDD_PLAYER_TAB_DIALOG	IDD_PLAYER_TAB_DIALOG_GB

const int EditIDs[CONTROLLER_BUTTONS] = {
	IDC_EDIT_GB_UP,
	IDC_EDIT_GB_DOWN,
	IDC_EDIT_GB_LEFT,
	IDC_EDIT_GB_RIGHT,
	IDC_EDIT_GB_A,
	IDC_EDIT_GB_B,
	IDC_EDIT_GB_SELECT,
	IDC_EDIT_GB_START,
};

const char* ButtonNames[CONTROLLER_BUTTONS] = {
	"Up",
	"Down",
	"Left",
	"Right",
	"A",
	"B",
	"Select",
	"Start"
};

const SDL_Scancode DefaultButtonsKeyb[CONTROLLER_BUTTONS] = {
	SDL_SCANCODE_UP,
	SDL_SCANCODE_DOWN,
	SDL_SCANCODE_LEFT,
	SDL_SCANCODE_RIGHT,
	SDL_SCANCODE_Z,
	SDL_SCANCODE_X,
	SDL_SCANCODE_SPACE,
	SDL_SCANCODE_RETURN,
};

const int DefaultButtonsJoy[CONTROLLER_BUTTONS] =
{
	SDL_HAT_UP,
	SDL_HAT_DOWN,
	SDL_HAT_LEFT,
	SDL_HAT_RIGHT,
	0,
	1,
	6,
	7,
};

#endif
#ifdef BUILD_ONLY_PCE

#define VIEW_TEXTURE_WIDTH		320
#define VIEW_TEXTURE_HEIGHT		232
#define VIEW_WINDOW_WIDTH		256
#define VIEW_WINDOW_HEIGHT		VIEW_TEXTURE_HEIGHT

extern MDFNGI EmulatedPCE;
MDFNGI *MDFNGameInfo = &EmulatedPCE;
static const int PCEButtonsOrders[] = { 4, 5, 6, 7, 0, 3, 1, 2 };
static const Setup CurrentSetup = { "res/game", PCEButtonsOrders , SDL_arraysize(PCEButtonsOrders), 2, 2 };

#define CONTROLLER_BUTTONS		8
#define IDD_PLAYER_TAB_DIALOG	IDD_PLAYER_TAB_DIALOG_PCE

static const int EditIDs[CONTROLLER_BUTTONS] = {
	IDC_EDIT_PCE_UP,
	IDC_EDIT_PCE_DOWN,
	IDC_EDIT_PCE_LEFT,
	IDC_EDIT_PCE_RIGHT,
	IDC_EDIT_PCE_I,
	IDC_EDIT_PCE_II,
	IDC_EDIT_PCE_SELECT,
	IDC_EDIT_PCE_RUN,
};

const char* ButtonNames[CONTROLLER_BUTTONS] = {
	"Up",
	"Down",
	"Left",
	"Right",
	"I",
	"II",
	"Select",
	"Run"
};

const SDL_Scancode DefaultButtonsKeyb[CONTROLLER_BUTTONS] = {
	SDL_SCANCODE_UP,
	SDL_SCANCODE_DOWN,
	SDL_SCANCODE_LEFT,
	SDL_SCANCODE_RIGHT,
	SDL_SCANCODE_Z,
	SDL_SCANCODE_X,
	SDL_SCANCODE_SPACE,
	SDL_SCANCODE_RETURN,
};

const int DefaultButtonsJoy[CONTROLLER_BUTTONS] =
{
	SDL_HAT_UP,
	SDL_HAT_DOWN,
	SDL_HAT_LEFT,
	SDL_HAT_RIGHT,
	0,
	1,
	6,
	7,
};

#endif



char working_dir[1024];

int xguiPlay;
int xguiReset;
int xguiQuit;
int xguiFullscreen;
int xguiScale2x;
int xguiScale3x;
int xguiScale4x;
int xguiSmoothing;
int xguiControls;
int xguiSlotSnap[3];
int xguiSlotLoad[3];
int xguiSlotSave[3];
int xguiPlayer1;
int xguiPlayer2;

int xguiBack;
int xguiInput[CONTROLLER_BUTTONS];

int xguiDefKey;
int xguiDefJoy;

int xguiControlID = -1;
int xguiPlayerID = 0;

#include "config.h"

void save_screenshot(char *filename);

void get_working_dir(void)
{
	int i;

	GetModuleFileNameA(0, working_dir, 1024);

	for (i = strlen(working_dir) - 1; i >= 0; --i)
	{
		if (working_dir[i] == '\\' || working_dir[i] == '/')
		{
			working_dir[i + 1] = 0;
			break;
		}
	}
}

void MDFN_DispMessage(const char *format, ...) noexcept
{

}

void MDFN_PrintError(const char *format, ...) noexcept
{

}

void MDFN_MessageBox(const char* str)
{
	MessageBox(NULL, str, "", MB_OK);
}

bool MDFN_DumpToFile(const std::string& path, const void *data, const uint64 length, bool throw_on_error)
{
	//MDFN_MessageBox("dumpfile A");
	FILE *file = fopen(path.c_str(), "wb");

	if (!file) return false;

	fwrite(data, (size_t)length, 1, file);
	fclose(file);

	return true;
}

bool MDFN_DumpToFile(const std::string& path, const std::vector<PtrLengthPair> &pearpairs, bool throw_on_error)
{
	MDFN_MessageBox("dumpfile B");

	return false;
}
/*
std::unique_ptr<Stream> MDFN_AmbigGZOpenHelper(const std::string& path, std::vector<size_t> good_sizes)
{
	return NULL;
}
*/
int MDFNSS_StateAction(StateMem *sm, const unsigned load, const int data_only, SFORMAT *sf, const char *sname, const bool optional) noexcept
{
	char buf[16];
	// !TODO: ugly hack, using it to save my time
	FILE* file = (FILE*)sm;

	while (1)
	{
		if (!sf->v && !sf->size && !sf->flags && !sf->name) break;

		if (load)
		{
			if(sf->name) fread(buf, strlen(sname), 1, file);	//skip section name
			if(sf->v&&sf->size) fread(sf->v, sf->size, 1, file);
		}
		else
		{
			if (sf->name) fwrite(sname, strlen(sname), 1, file);
			if (sf->v&&sf->size) fwrite(sf->v, sf->size, 1, file);
		}

#ifdef BUILD_ONLY_SNES
		break;
#endif
		++sf;
	}

	return 1;
}

bool MDFN_IsFIROPSafe(const std::string &path)
{
	return true;
}

uint64 MDFN_GetSettingUI(const char *name)
{
	const MDFNSetting* ptr = MDFNGameInfo->Settings;

	while (ptr->name)
	{
		if (strcmp(ptr->name, name) == 0)
		{
			switch (ptr->type)
			{
			case MDFNST_INT:
			case MDFNST_UINT:
				return atoi(ptr->default_value);
				break;
			default:
				return 0;
			}
		}
		ptr++;
	}

	return 0;
}

int64 MDFN_GetSettingI(const char *name)
{
	const MDFNSetting* ptr = MDFNGameInfo->Settings;

	while (ptr->name)
	{
		if (strcmp(ptr->name, name) == 0)
		{
			switch (ptr->type)
			{
			case MDFNST_ENUM:
				return ptr->enum_list->number;
				break;
			case MDFNST_INT:
			case MDFNST_UINT:
				return atoi(ptr->default_value);
				break;
			default:
				return 0;
			}
		}
		ptr++;
	}

	return 0;
}

double MDFN_GetSettingF(const char *name)
{
	const MDFNSetting* ptr = MDFNGameInfo->Settings;

	while (ptr->name)
	{
		if (strcmp(ptr->name, name) == 0)
		{
			switch (ptr->type)
			{
			case MDFNST_FLOAT:
				return atof(ptr->default_value);
				break;
			default:
				return 0.0;
			}
		}
		ptr++;
	}

	return 0;
}

bool MDFN_GetSettingB(const char *name)
{
	const MDFNSetting* ptr = MDFNGameInfo->Settings;

	while (ptr->name)
	{
		if (strcmp(ptr->name, name) == 0)
		{
			switch (ptr->type)
			{
			case MDFNST_BOOL:
				return atoi(ptr->default_value) != 0;
				break;
			default:
				return false;
			}
		}
		ptr++;
	}

	return false;
}

std::string MDFN_GetSettingS(const char *name)
{
	const MDFNSetting* ptr = MDFNGameInfo->Settings;

	while (ptr->name)
	{
		if (strcmp(ptr->name, name) == 0)
		{
			if (strcmp(ptr->name, "gba.bios") == 0) return "";// "roms/gba.bios";

			switch (ptr->type)
			{
			case MDFNST_STRING:
				return name;
				break;
			default:
				return "";
			}
		}
		ptr++;
	}

	return "";
}

void MDFN_MidLineUpdate(EmulateSpecStruct *espec, int y)
{

}

std::string MDFN_MakeFName(int type, int id1, const char *cd1)
{
	std::string name;

	switch (type)
	{
	case MDFNMKF_SAV:
	{
		name = working_dir;

		if (strcmp(cd1, "eep") == 0)
		{
			name += "res/eep";
		}
		else
		{
			name += "res/sram";
		}

		if(strcmp(cd1, "type") == 0)
		{
			FILE* f = fopen(name.c_str(), "rb");
			if(!f) f = fopen(name.c_str(), "wb");
			fclose(f);
		}

		return name;
	}
	break;
	case MDFNMKF_FIRMWARE:
	{
		return cd1;
	}
	break;
	}

	return "";
}

//bool MDFNMP_Init(uint32 ps, uint32 numpages)
//{
//	return true;
//}

//void MDFNMP_AddRAM(uint32 size, uint32 address, uint8 *RAM, bool use_in_search)
//{
//
//}

//void MDFNMP_ApplyPeriodicCheats(void)
//{
//
//}

void Player_Draw(MDFN_Surface *surface, MDFN_Rect *dr, int CurrentSong, int16 *samples, int32 sampcount)
{

}

//void MDFNMP_InstallReadPatches(void) {}
//void MDFNMP_RemoveReadPatches(void) {}
void *MDFN_malloc_real(bool dothrow, size_t size, const char *purpose, const char *_file, const int _line)
{
	return SDL_malloc(size);
}

void *MDFN_calloc_real(bool dothrow, size_t nmemb, size_t size, const char *purpose, const char *_file, const int _line)
{
	return SDL_calloc(nmemb, size);
}

void MDFN_free(void *ptr)
{
	SDL_free(ptr);
}
void MDFN_printf(const char *format, ...) noexcept 
{
	va_list ap;
	va_start(ap, format);
	vprintf(format, ap);
	va_end(ap);
}
//char *MDFN_RemoveControlChars(char *str) { return str; }
void MDFN_indent(int indent) {}
//void MDFN_trim(std::string &string) {}
int Player_Init(int tsongs, const std::string &album, const std::string &artist, const std::string &copyright, const std::vector<std::string> &snames) { return 0; }
int strcasecmp(char const * a, char const * b) { return strcmp(a, b); }
void MDFND_PrintError(const char *s) {}
void MDFND_Message(const char *s) {}
void MDFN_GetFilePathComponents(const std::string &file_path, std::string *dir_path_out, std::string *file_base_out, std::string *file_ext_out) {}
std::string MDFN_EvalFIP(const std::string &dir_path, const std::string &rel_path, bool skip_safety_check) { return ""; }

MDFNFILE::MDFNFILE(const char *path, const FileExtensionSpecStruct *known_ext, const char *purpose) : ext((const char * const &)f_ext), fbase((const char * const &)f_fbase)
{
	f_ext = NULL;
	f_fbase = NULL;

	Open(path, known_ext, purpose);
}

MDFNFILE::~MDFNFILE()
{
	Close();
}

void MDFNFILE::Close(void) throw()
{
	if (f_ext)
	{
		free(f_ext);
		f_ext = NULL;
	}

	if (f_fbase)
	{
		free(f_fbase);
		f_fbase = NULL;
	}

	if (str.get())
	{
		delete str.release();
	}
}

static int PendingLoadRom = 0;

void LoadRom(int id)
{
	PendingLoadRom = id;
}

static const SDL_Scancode windows_scancode_table[] =
{
	/*	0						1							2							3							4						5							6							7 */
	/*	8						9							A							B							C						D							E							F */
	SDL_SCANCODE_UNKNOWN,		SDL_SCANCODE_ESCAPE,		SDL_SCANCODE_1,				SDL_SCANCODE_2,				SDL_SCANCODE_3,			SDL_SCANCODE_4,				SDL_SCANCODE_5,				SDL_SCANCODE_6,			/* 0 */
	SDL_SCANCODE_7,				SDL_SCANCODE_8,				SDL_SCANCODE_9,				SDL_SCANCODE_0,				SDL_SCANCODE_MINUS,		SDL_SCANCODE_EQUALS,		SDL_SCANCODE_BACKSPACE,		SDL_SCANCODE_TAB,		/* 0 */

	SDL_SCANCODE_Q,				SDL_SCANCODE_W,				SDL_SCANCODE_E,				SDL_SCANCODE_R,				SDL_SCANCODE_T,			SDL_SCANCODE_Y,				SDL_SCANCODE_U,				SDL_SCANCODE_I,			/* 1 */
	SDL_SCANCODE_O,				SDL_SCANCODE_P,				SDL_SCANCODE_LEFTBRACKET,	SDL_SCANCODE_RIGHTBRACKET,	SDL_SCANCODE_RETURN,	SDL_SCANCODE_LCTRL,			SDL_SCANCODE_A,				SDL_SCANCODE_S,			/* 1 */

	SDL_SCANCODE_D,				SDL_SCANCODE_F,				SDL_SCANCODE_G,				SDL_SCANCODE_H,				SDL_SCANCODE_J,			SDL_SCANCODE_K,				SDL_SCANCODE_L,				SDL_SCANCODE_SEMICOLON,	/* 2 */
	SDL_SCANCODE_APOSTROPHE,	SDL_SCANCODE_GRAVE,			SDL_SCANCODE_LSHIFT,		SDL_SCANCODE_BACKSLASH,		SDL_SCANCODE_Z,			SDL_SCANCODE_X,				SDL_SCANCODE_C,				SDL_SCANCODE_V,			/* 2 */

	SDL_SCANCODE_B,				SDL_SCANCODE_N,				SDL_SCANCODE_M,				SDL_SCANCODE_COMMA,			SDL_SCANCODE_PERIOD,	SDL_SCANCODE_SLASH,			SDL_SCANCODE_RSHIFT,		SDL_SCANCODE_PRINTSCREEN,/* 3 */
	SDL_SCANCODE_LALT,			SDL_SCANCODE_SPACE,			SDL_SCANCODE_CAPSLOCK,		SDL_SCANCODE_F1,			SDL_SCANCODE_F2,		SDL_SCANCODE_F3,			SDL_SCANCODE_F4,			SDL_SCANCODE_F5,		/* 3 */

	SDL_SCANCODE_F6,			SDL_SCANCODE_F7,			SDL_SCANCODE_F8,			SDL_SCANCODE_F9,			SDL_SCANCODE_F10,		SDL_SCANCODE_NUMLOCKCLEAR,	SDL_SCANCODE_SCROLLLOCK,	SDL_SCANCODE_HOME,		/* 4 */
	SDL_SCANCODE_UP,			SDL_SCANCODE_PAGEUP,		SDL_SCANCODE_KP_MINUS,		SDL_SCANCODE_LEFT,			SDL_SCANCODE_KP_5,		SDL_SCANCODE_RIGHT,			SDL_SCANCODE_KP_PLUS,		SDL_SCANCODE_END,		/* 4 */

	SDL_SCANCODE_DOWN,			SDL_SCANCODE_PAGEDOWN,		SDL_SCANCODE_INSERT,		SDL_SCANCODE_DELETE,		SDL_SCANCODE_UNKNOWN,	SDL_SCANCODE_UNKNOWN,		SDL_SCANCODE_NONUSBACKSLASH,SDL_SCANCODE_F11,		/* 5 */
	SDL_SCANCODE_F12,			SDL_SCANCODE_PAUSE,			SDL_SCANCODE_UNKNOWN,		SDL_SCANCODE_LGUI,			SDL_SCANCODE_RGUI,		SDL_SCANCODE_APPLICATION,	SDL_SCANCODE_UNKNOWN,		SDL_SCANCODE_UNKNOWN,	/* 5 */

	SDL_SCANCODE_UNKNOWN,		SDL_SCANCODE_UNKNOWN,		SDL_SCANCODE_UNKNOWN,		SDL_SCANCODE_UNKNOWN,		SDL_SCANCODE_F13,		SDL_SCANCODE_F14,			SDL_SCANCODE_F15,			SDL_SCANCODE_F16,		/* 6 */
	SDL_SCANCODE_F17,			SDL_SCANCODE_F18,			SDL_SCANCODE_F19,			SDL_SCANCODE_UNKNOWN,		SDL_SCANCODE_UNKNOWN,	SDL_SCANCODE_UNKNOWN,		SDL_SCANCODE_UNKNOWN,		SDL_SCANCODE_UNKNOWN,	/* 6 */

	SDL_SCANCODE_INTERNATIONAL2,		SDL_SCANCODE_UNKNOWN,		SDL_SCANCODE_UNKNOWN,		SDL_SCANCODE_INTERNATIONAL1,		SDL_SCANCODE_UNKNOWN,	SDL_SCANCODE_UNKNOWN,		SDL_SCANCODE_UNKNOWN,		SDL_SCANCODE_UNKNOWN,	/* 7 */
	SDL_SCANCODE_UNKNOWN,		SDL_SCANCODE_INTERNATIONAL4,		SDL_SCANCODE_UNKNOWN,		SDL_SCANCODE_INTERNATIONAL5,		SDL_SCANCODE_UNKNOWN,	SDL_SCANCODE_INTERNATIONAL3,		SDL_SCANCODE_UNKNOWN,		SDL_SCANCODE_UNKNOWN	/* 7 */
};

static WNDPROC OldEditProc = NULL;

static SDL_Scancode WindowsScanCodeToSDLScanCode(LPARAM lParam, WPARAM wParam)
{
	SDL_Scancode code;
	char bIsExtended;
	int nScanCode = (lParam >> 16) & 0xFF;

	/* 0x45 here to work around both pause and numlock sharing the same scancode, so use the VK key to tell them apart */
	if (nScanCode == 0 || nScanCode == 0x45) {
		switch (wParam) {
		case VK_CLEAR: return SDL_SCANCODE_CLEAR;
		case VK_MODECHANGE: return SDL_SCANCODE_MODE;
		case VK_SELECT: return SDL_SCANCODE_SELECT;
		case VK_EXECUTE: return SDL_SCANCODE_EXECUTE;
		case VK_HELP: return SDL_SCANCODE_HELP;
		case VK_PAUSE: return SDL_SCANCODE_PAUSE;
		case VK_NUMLOCK: return SDL_SCANCODE_NUMLOCKCLEAR;

		case VK_F13: return SDL_SCANCODE_F13;
		case VK_F14: return SDL_SCANCODE_F14;
		case VK_F15: return SDL_SCANCODE_F15;
		case VK_F16: return SDL_SCANCODE_F16;
		case VK_F17: return SDL_SCANCODE_F17;
		case VK_F18: return SDL_SCANCODE_F18;
		case VK_F19: return SDL_SCANCODE_F19;
		case VK_F20: return SDL_SCANCODE_F20;
		case VK_F21: return SDL_SCANCODE_F21;
		case VK_F22: return SDL_SCANCODE_F22;
		case VK_F23: return SDL_SCANCODE_F23;
		case VK_F24: return SDL_SCANCODE_F24;

		case VK_OEM_NEC_EQUAL: return SDL_SCANCODE_KP_EQUALS;
		case VK_BROWSER_BACK: return SDL_SCANCODE_AC_BACK;
		case VK_BROWSER_FORWARD: return SDL_SCANCODE_AC_FORWARD;
		case VK_BROWSER_REFRESH: return SDL_SCANCODE_AC_REFRESH;
		case VK_BROWSER_STOP: return SDL_SCANCODE_AC_STOP;
		case VK_BROWSER_SEARCH: return SDL_SCANCODE_AC_SEARCH;
		case VK_BROWSER_FAVORITES: return SDL_SCANCODE_AC_BOOKMARKS;
		case VK_BROWSER_HOME: return SDL_SCANCODE_AC_HOME;
		case VK_VOLUME_MUTE: return SDL_SCANCODE_AUDIOMUTE;
		case VK_VOLUME_DOWN: return SDL_SCANCODE_VOLUMEDOWN;
		case VK_VOLUME_UP: return SDL_SCANCODE_VOLUMEUP;

		case VK_MEDIA_NEXT_TRACK: return SDL_SCANCODE_AUDIONEXT;
		case VK_MEDIA_PREV_TRACK: return SDL_SCANCODE_AUDIOPREV;
		case VK_MEDIA_STOP: return SDL_SCANCODE_AUDIOSTOP;
		case VK_MEDIA_PLAY_PAUSE: return SDL_SCANCODE_AUDIOPLAY;
		case VK_LAUNCH_MAIL: return SDL_SCANCODE_MAIL;
		case VK_LAUNCH_MEDIA_SELECT: return SDL_SCANCODE_MEDIASELECT;

		case VK_OEM_102: return SDL_SCANCODE_NONUSBACKSLASH;

		case VK_ATTN: return SDL_SCANCODE_SYSREQ;
		case VK_CRSEL: return SDL_SCANCODE_CRSEL;
		case VK_EXSEL: return SDL_SCANCODE_EXSEL;
		case VK_OEM_CLEAR: return SDL_SCANCODE_CLEAR;

		case VK_LAUNCH_APP1: return SDL_SCANCODE_APP1;
		case VK_LAUNCH_APP2: return SDL_SCANCODE_APP2;

		default: return SDL_SCANCODE_UNKNOWN;
		}
	}

	if (nScanCode > 127)
		return SDL_SCANCODE_UNKNOWN;

	code = windows_scancode_table[nScanCode];

	bIsExtended = (lParam & (1 << 24)) != 0;
	if (!bIsExtended) {
		switch (code) {
		case SDL_SCANCODE_HOME:
			return SDL_SCANCODE_KP_7;
		case SDL_SCANCODE_UP:
			return SDL_SCANCODE_KP_8;
		case SDL_SCANCODE_PAGEUP:
			return SDL_SCANCODE_KP_9;
		case SDL_SCANCODE_LEFT:
			return SDL_SCANCODE_KP_4;
		case SDL_SCANCODE_RIGHT:
			return SDL_SCANCODE_KP_6;
		case SDL_SCANCODE_END:
			return SDL_SCANCODE_KP_1;
		case SDL_SCANCODE_DOWN:
			return SDL_SCANCODE_KP_2;
		case SDL_SCANCODE_PAGEDOWN:
			return SDL_SCANCODE_KP_3;
		case SDL_SCANCODE_INSERT:
			return SDL_SCANCODE_KP_0;
		case SDL_SCANCODE_DELETE:
			return SDL_SCANCODE_KP_PERIOD;
		case SDL_SCANCODE_PRINTSCREEN:
			return SDL_SCANCODE_KP_MULTIPLY;
		default:
			break;
		}
	}
	else {
		switch (code) {
		case SDL_SCANCODE_RETURN:
			return SDL_SCANCODE_KP_ENTER;
		case SDL_SCANCODE_LALT:
			return SDL_SCANCODE_RALT;
		case SDL_SCANCODE_LCTRL:
			return SDL_SCANCODE_RCTRL;
		case SDL_SCANCODE_SLASH:
			return SDL_SCANCODE_KP_DIVIDE;
		case SDL_SCANCODE_CAPSLOCK:
			return SDL_SCANCODE_KP_PLUS;
		default:
			break;
		}
	}

	return code;
}

struct PlayerButton
{
	enum
	{
		KEYBOARD,
		GAMEPAD
	}type;

	union
	{
		SDL_Scancode code;

		struct
		{
			bool hat;
			int value;
			SDL_JoystickGUID guid;
		};
	};

	PlayerButton()
		: type(KEYBOARD), code(SDL_SCANCODE_UNKNOWN), hat(false), value(0)
	{
		memset(&guid, 0, sizeof(SDL_JoystickGUID));
	}

	const char* getName()
	{
		if (type == PlayerButton::KEYBOARD)
			return SDL_GetScancodeName(code);
		else if (type == PlayerButton::GAMEPAD)
		{
			const PlayerButton* button = this;
			const int Masks[] = { SDL_HAT_UP, SDL_HAT_RIGHT, SDL_HAT_DOWN, SDL_HAT_LEFT };
			const char* Names[] = { "up", "right", "down", "left" };
			static char name[256];

			if (hat)
			{
				for (int i = 0; i < sizeof(Masks) / sizeof(Masks[0]); i++)
				{
					if (value & Masks[i])
					{
						sprintf(name, "joy %s", Names[i]);
						break;
					}
				}
			}
			else
			{
				sprintf(name, "joy btn%i", value);
			}

			return name;
		}

		return NULL;
	}
};

struct PlayerSetup
{
	PlayerButton buttons[CONTROLLER_BUTTONS];
};

#define PLAYERS_COUNT 2

struct ControllerSetup
{
	PlayerSetup player[PLAYERS_COUNT];
};

static ControllerSetup controllerSetup;



static class
{
public:
	ControllerSetup data;
	HWND tab;
	HWND dlg;

	PlayerSetup& getSelectedPlayer()
	{
		int sel = TabCtrl_GetCurSel(tab);
		return data.player[sel];
	}

	PlayerSetup& getPlayer(int sel)
	{
		return data.player[sel];
	}

	void updateButtonCodeNames()
	{
		for (int i = 0; i < CONTROLLER_BUTTONS; i++)
		{
			int id = EditIDs[i];

			if (id)
			{
				SetWindowText(GetDlgItem(dlg, id), ControllerSetupDialog.getSelectedPlayer().buttons[i].getName());
			}
		}
	}

} ControllerSetupDialog;

#define WM_JOYSTICK (WM_USER + 1000)



static void SetDefaultControls(int player, bool joy)
{
	PlayerButton* button;

	for (int i = 0; i < CONTROLLER_BUTTONS; i++)
	{
		if (player < 0)
		{
			button = &controllerSetup.player[0].buttons[i];
				
		}
		else
		{
			button = &ControllerSetupDialog.data.player[player].buttons[i];
		}

		memset(button, 0, sizeof(PlayerButton));

		if (!joy)
		{
			button->type = PlayerButton::KEYBOARD;
			button->code = DefaultButtonsKeyb[i];
		}
		else
		{
			button->type = PlayerButton::GAMEPAD;
			button->value = DefaultButtonsJoy[i];
			button->guid = SDL_JoystickGetDeviceGUID(0);

			if (i < 4) button->hat = true;
		}
	}
}

static int getEditControlIndex(HWND edit)
{
	int id = GetWindowLong(edit, GWL_ID);
	int i = 0;
	for (; i < CONTROLLER_BUTTONS; i++)
	{
		if (EditIDs[i] && EditIDs[i] == id) break;
	}

	return i;
}

static int CALLBACK SubEditProc(HWND edit, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch (msg)
	{
	case WM_JOYSTICK:
	{
		ControllerSetupDialog.getSelectedPlayer().buttons[getEditControlIndex(edit)] = *(PlayerButton*)lParam;
		ControllerSetupDialog.updateButtonCodeNames();
	}
	break;
	case WM_GETDLGCODE: return DLGC_WANTALLKEYS;
	case WM_KEYDOWN:
	{
		SDL_Scancode code = WindowsScanCodeToSDLScanCode(lParam, wParam);

		if (code == SDL_SCANCODE_ESCAPE)
			code = SDL_SCANCODE_UNKNOWN;

		PlayerButton& button = ControllerSetupDialog.getSelectedPlayer().buttons[getEditControlIndex(edit)];
		button.type = PlayerButton::KEYBOARD;
		button.code = code;
		ControllerSetupDialog.updateButtonCodeNames();
	}
	case WM_CHAR:
		return FALSE;
	}

	return CallWindowProc(OldEditProc, edit, msg, wParam, lParam);
}

static int CALLBACK PlayerDlgConfig(HWND dlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch (msg)
	{
	case WM_INITDIALOG:

		ControllerSetupDialog.dlg = dlg;
		EnableThemeDialogTexture(dlg, ETDT_ENABLETAB);

		memcpy(&ControllerSetupDialog.data, &controllerSetup, sizeof(ControllerSetup));

		for (int i = 0; i < CONTROLLER_BUTTONS; i++)
		{
			int id = EditIDs[i];

			if (id)
			{
				OldEditProc = (WNDPROC)SetWindowLongPtr(GetDlgItem(dlg, id), GWLP_WNDPROC, (LONG_PTR)SubEditProc);
			}
		}

		ControllerSetupDialog.updateButtonCodeNames();

		return TRUE;
	}

	return FALSE;
}

static void addTabItem(HWND tab, int index)
{
	TCITEM item = { 0 };
	item.mask = TCIF_TEXT;

	char buf[] = "Player #%i";
	sprintf(buf, buf, index + 1);
	item.pszText = buf;

	TabCtrl_InsertItem(tab, index, &item);
}

int CALLBACK DlgConfig(HWND dlg, UINT msg, WPARAM wParam, LPARAM lParam);

#define JOYSTICKS_COUNT 2

class GameState
{
private:
	struct Config
	{
		Config() : scale(3), smoothing(false), fullscreen(true) {}
		int scale;
		bool smoothing;
		bool fullscreen;

		ControllerSetup controller;
	};

public:

	bool exit;
	bool pause;
	int framerate;
	SDL_Joystick* joysticks[JOYSTICKS_COUNT];
	SDL_GameController* gamepads[JOYSTICKS_COUNT];

	int getAxisMask(SDL_Joystick* joystick)
	{
		int axesCount = SDL_JoystickNumAxes(joystick);

		for (int a = 0; a < axesCount; a++)
		{
			int axe = SDL_JoystickGetAxis(joystick, a);

			if (axe)
			{
				if (a == 0)
				{
					if (axe > 16384 + JOY_THRESH) return SDL_HAT_RIGHT;
					else if (axe < -16384 - JOY_THRESH) return SDL_HAT_LEFT;
				}
				else if (a == 1)
				{
					if (axe > 16384 + JOY_THRESH) return SDL_HAT_DOWN;
					else if (axe < -16384 - JOY_THRESH) return SDL_HAT_UP;
				}
			}
		}

		return 0;
	}

	bool processGamepad(PlayerButton& button)
	{
		for (int i = 0; i < JOYSTICKS_COUNT; i++)
		{
			SDL_Joystick* joystick = joysticks[i];

			if (joystick && SDL_JoystickGetAttached(joystick))
			{
				{
					int axe = getAxisMask(joystick);

					if (axe)
					{
						button.type = PlayerButton::GAMEPAD;
						button.guid = SDL_JoystickGetDeviceGUID(i);
						button.hat = true;
						button.value = axe;

						return true;
					}
				}

				{
					int hatsCount = SDL_JoystickNumHats(joystick);

					for (int h = 0; h < hatsCount; h++)
					{
						int hat = SDL_JoystickGetHat(joystick, h);

						if (hat)
						{
							button.type = PlayerButton::GAMEPAD;
							button.guid = SDL_JoystickGetDeviceGUID(i);
							button.hat = true;
							button.value = hat;

							return true;
						}
					}
				}

				{
					int buttonsCount = SDL_JoystickNumButtons(joystick);

					for (int b = 0; b < buttonsCount; b++)
					{
						int btn = SDL_JoystickGetButton(joystick, b);

						if (btn)
						{
							button.type = PlayerButton::GAMEPAD;
							button.guid = SDL_JoystickGetDeviceGUID(i);
							button.hat = false;
							button.value = b;

							return true;
						}
					}
				}
			}
		}

		return false;
	}

	void configureControls()
	{
		if (DialogBox(NULL, MAKEINTRESOURCE(IDD_INPUTCONFIG), hwnd, DlgConfig) == IDOK)
		{
			memcpy(&controllerSetup, &ControllerSetupDialog.data, sizeof(ControllerSetup));

			saveConfig();
		}
	}

	void blit(uint32* pixels, MDFN_Rect& mdfnRect)
	{
		int xoffset = 0, yoffset = 0;
#ifdef BUILD_ONLY_MD
		yoffset = 8;
#elif BUILD_ONLY_NES
		yoffset = 8;
#elif BUILD_ONLY_PCE
		xoffset = -32;
		yoffset = 22;
#endif
	
		SDL_UpdateTexture(texture, NULL, pixels + (textureWidth * yoffset) + xoffset, sizeof(int32) * textureWidth);

		{
			SDL_Rect rect;

			rect.w = windowWidth;
			rect.h = windowHeight;
			rect.x = 0;
			rect.y = 0;

			if (artwork) SDL_RenderCopy(renderer, artwork, NULL, &rect); else SDL_RenderClear(renderer);

			rect.w = VIEW_WINDOW_WIDTH * windowHeight / VIEW_WINDOW_HEIGHT;
			rect.h = windowHeight;
			rect.x = (windowWidth - rect.w) / 2;
			rect.y = 0;

			SDL_Rect srcr;

			srcr.x = 0;
			srcr.y = 0;

#ifdef BUILD_ONLY_MD
			srcr.w = global_genesis_width;
			srcr.h = VIEW_TEXTURE_HEIGHT;
#elif BUILD_ONLY_PCE
			srcr.x = (VIEW_TEXTURE_WIDTH - VIEW_WINDOW_WIDTH) / 2;
			srcr.w = VIEW_WINDOW_WIDTH;
			srcr.h = VIEW_TEXTURE_HEIGHT;
#else
			srcr.w = VIEW_TEXTURE_WIDTH;
			srcr.h = VIEW_TEXTURE_HEIGHT;
#endif

			SDL_RenderCopy(renderer, texture, &srcr, &rect);

			if (xguiEnable) xgui_render(renderer, windowWidth, windowHeight);
		}

		SDL_RenderPresent(renderer);
	}

	void loadIconResource(int id)
	{
		const int size = 48;
		const int bpp = 32;
		HICON icon;
		ICONINFO ici;
		HDC dc;
		BITMAPINFO bmi;
		SDL_Surface* surface;

		surface = SDL_CreateRGBSurface(0, size, size, bpp, 0, 0, 0, 0);

		icon = (HICON)LoadImage(GetModuleHandle(NULL), MAKEINTRESOURCE(id), IMAGE_ICON, size, size, LR_SHARED);

		GetIconInfo(icon, &ici);

		dc = CreateCompatibleDC(NULL);

		bmi.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
		bmi.bmiHeader.biWidth = size;
		bmi.bmiHeader.biHeight = -size;
		bmi.bmiHeader.biPlanes = 1;
		bmi.bmiHeader.biBitCount = bpp;
		bmi.bmiHeader.biCompression = BI_RGB;
		bmi.bmiHeader.biSizeImage = 0;

		SelectObject(dc, ici.hbmColor);
		GetDIBits(dc, ici.hbmColor, 0, size, surface->pixels, &bmi, DIB_RGB_COLORS);
		SDL_SetWindowIcon(window, surface);
		SDL_FreeSurface(surface);

		DeleteDC(dc);

		DeleteObject(ici.hbmColor);
		DeleteObject(ici.hbmMask);

		DestroyIcon(icon);
	}

	bool init()
	{
		config_open();

		xguiEnable = config_read_int("xgui", 0) ? true : false;

		players = config_read_int("players", 1);

		if (players > PLAYERS_COUNT) players = PLAYERS_COUNT;

		config_close();

		window = SDL_CreateWindow("", SDL_WINDOWPOS_CENTERED, SDL_WINDOWPOS_CENTERED, 0, 0, SDL_WINDOW_SHOWN);

		loadIconResource(IDI_ICON1);

		// loadRomData(0);

		SDL_SysWMinfo info;
		SDL_VERSION(&info.version);

		if (!xguiEnable)
		{
			if (SDL_GetWindowWMInfo(window, &info))
			{
				menu = LoadMenu(NULL, MAKEINTRESOURCE(IDR_GAMEMENU));
				hwnd = info.info.win.window;
				SetMenu(hwnd, menu);

				//if (sizeof(RomTitleNames) <= sizeof(const char*))
				//{
				//	RemoveMenu(GetSubMenu(menu, 0), 3, MF_BYPOSITION);
				//}
			}
		}
		else
		{
			menu = NULL;
		}

		renderer = SDL_CreateRenderer(window, -1, SDL_RENDERER_ACCELERATED);

		textureWidth  = VIEW_TEXTURE_WIDTH;
		textureHeight = VIEW_TEXTURE_HEIGHT;

		texture = SDL_CreateTexture(renderer, SDL_PIXELFORMAT_ABGR8888, SDL_TEXTUREACCESS_STREAMING, textureWidth, textureHeight);

		artwork = NULL;

		char path[1024];
		snprintf(path, sizeof(path), "%sres/back", working_dir);

		artwork = xgui_load_jpg(path, renderer);

		updateSmoothing();
		updateWindowSize();
		updateFullscreen();

		return true;
	}

	void escapeFullscreen()
	{
		if (SDL_GetWindowFlags(window) & SDL_WINDOW_FULLSCREEN_DESKTOP) setFullScreen(false);
	}

	void setFullScreen(bool f)
	{
		config.fullscreen = f;
		saveConfig();

		updateSmoothing();
		updateWindowSize();
		updateFullscreen();
	}

	void setSmoothing(bool s)
	{
		config.smoothing = s;
		saveConfig();

		updateSmoothing();
		updateWindowSize();
		updateFullscreen();
	}

	void stateAction(bool load, int slot)
	{
		//if (romIndex)
		{
			char filename[1024] = { 0 };
			snprintf(filename, sizeof(filename), "%s/res/%u%uS", working_dir, romIndex, slot);

			FILE* file = fopen(filename, load ? "rb" : "wb");

			if (file)
			{
				MDFNGameInfo->StateAction((StateMem*)file, load, false);
				fclose(file);

				if (!load)
				{
					snprintf(filename, sizeof(filename), "%s/res/%u%uP", working_dir, romIndex, slot);

					save_screenshot(filename);

					updateSavingMenu();
				}
			}
		}
	}

	void updateSavingMenu()
	{
		if (!menu) return;

		for (int slot = 0; slot < 9; slot++)
		{
			char buf[1024] = { 0 };
			snprintf(buf, sizeof(buf), "%s/res/%u%uS", working_dir, romIndex, slot);

			MENUITEMINFO mii = { 0 };

			mii.cbSize = sizeof(mii);
			char slotString[256] = { 0 };
			char dateString[256] = "empty";

			mii.fState = MFS_DISABLED;

			WIN32_FILE_ATTRIBUTE_DATA attr = { 0 };
			if (GetFileAttributesEx(buf, GetFileExInfoStandard, &attr))
			{
				mii.fState = MFS_ENABLED;

				FILETIME localTime = { 0 };
				FileTimeToLocalFileTime(&attr.ftLastWriteTime, &localTime);

				SYSTEMTIME sysTime;
				if (FileTimeToSystemTime(&localTime, &sysTime))
				{
					sprintf(dateString, "%02i.%02i.%04i %02i:%02i", sysTime.wDay, sysTime.wMonth, sysTime.wYear, sysTime.wHour, sysTime.wMinute);
				}
			}

			sprintf(slotString, "Slot #%i (%s)\tF%i", slot + 1, dateString, slot + 1);
			mii.dwTypeData = slotString;
			mii.fMask = MIIM_STRING | MIIM_STATE;

			SetMenuItemInfo(menu, ID_LOADGAMEPOSITION_SLOT1 + slot, FALSE, &mii);

			sprintf(slotString, "Slot #%i (%s)\tShift+F%i", slot + 1, dateString, slot + 1);
			mii.fMask = MIIM_STRING;
			SetMenuItemInfo(menu, ID_SAVEGAMEPOSITION_SLOT1 + slot, FALSE, &mii);
		}
	}

	bool loadRomData(int id)
	{
		bool quick_saves;
		char filename[MAX_PATH];

		config_open();

		SDL_SetWindowTitle(window, config_read_string("title", "Game"));

		config_close();

		strncpy(filename, working_dir, sizeof(filename));
		strncat(filename, CurrentSetup.cartName, sizeof(filename));

		romIndex = id;

		//quick_saves = romIndex ? true : false;
		quick_saves = true;

		if (menu)
		{
			EnableMenuItem(menu, 1, MF_BYPOSITION | (quick_saves ? MF_ENABLED : MF_DISABLED));

			DrawMenuBar(hwnd);
		}

		//#ifdef EMBED_ROM
		//		MDFNFILE gameFile((const char *)(IDR_RC_ROMDATA0 + id), &MDFNGameInfo->FileExtensions[0], NULL);
		//#else
		MDFNFILE gameFile(filename, &MDFNGameInfo->FileExtensions[0], NULL);
		//#endif

		log_add("load %s\n", filename);
		try {
			MDFNGameInfo->Load(&gameFile);
			log_add("after load\n");
		}
		catch (std::exception &e)
		{
			log_add("Error %s", e.what());

			return false;
		}

		log_add("quick saves\n");
		if (quick_saves)
			updateSavingMenu();

		updateSmoothing();
		updateWindowSize();
		updateFullscreen();

		MDFNGameInfo->DoSimpleCommand(MDFN_MSC_POWER);
		MDFNGameInfo->DoSimpleCommand(MDFN_MSC_RESET);

		return true;
	}

	void setWindowed(int scaleValue)
	{
		config.scale = scaleValue;
		saveConfig();
		setFullScreen(false);
	}

	void pauseGame(bool p)
	{
		pause = p;

		if (!menu) return;

		MENUITEMINFO mii = { 0 };
		mii.cbSize = sizeof(mii);
		mii.dwTypeData = pause ? "&Resume\tPause" : "&Pause\tPause";
		mii.fMask = MIIM_STRING;

		SetMenuItemInfo(menu, ID_GAME_PAUSE, FALSE, &mii);
	}

	void updateCursor()
	{
		bool show;

		if (config.fullscreen) show = false; else show = true;

		if (xguiEnable && xgui_is_enabled()) show = true;

		if (!show)
		{
			while (ShowCursor(FALSE) >= 0);
		}
		else
		{
			while (ShowCursor(TRUE) < 0);
		}
	}

	GameState()
		: exit(false)
		, pause(false)
		, hwnd(NULL)
		, menu(NULL)
		, window(NULL)
		, renderer(NULL)
		, texture(NULL)
		, romIndex(-1)
		, framerate(60)
	{
		memset(&joysticks, NULL, sizeof(joysticks));
		memset(&gamepads, NULL, sizeof(gamepads));

		SetDefaultControls(-1, false);

		get_working_dir();
		loadConfig();
	}

	~GameState()
	{
		if (xguiEnable) xgui_done();

		if (texture) SDL_DestroyTexture(texture);
		if (artwork) SDL_DestroyTexture(artwork);
		if (renderer) SDL_DestroyRenderer(renderer);
		if (window) SDL_DestroyWindow(window);
	}

	void updateWindowSize()
	{
		if (romIndex < 0) return;

		windowWidth = VIEW_WINDOW_WIDTH * config.scale;
		windowHeight = VIEW_WINDOW_HEIGHT * config.scale;

		SDL_SetWindowSize(window, windowWidth, windowHeight);
		SDL_SetWindowPosition(window, SDL_WINDOWPOS_CENTERED, SDL_WINDOWPOS_CENTERED);

		if (menu)
		{
			CheckMenuRadioItem(menu, ID_DISPLAY_SCALE1X, ID_DISPLAY_SCALE4X, ID_DISPLAY_SCALE1X + config.scale - 1, MF_BYCOMMAND);
		}
	}

	void updateSmoothing()
	{
		SDL_SetHint(SDL_HINT_RENDER_SCALE_QUALITY, config.smoothing ? "1" : "0");

		SDL_DestroyTexture(texture);
		texture = SDL_CreateTexture(renderer, SDL_PIXELFORMAT_ABGR8888, SDL_TEXTUREACCESS_STREAMING, textureWidth, textureHeight);

		updateWindowSize();

		if (menu)
		{
			CheckMenuItem(menu, ID_DISPLAY_SMOOTHING, MF_BYCOMMAND | (config.smoothing ? MF_CHECKED : MF_UNCHECKED));
		}
	}

	void updateFullscreen()
	{
		updateCursor();

		if (config.fullscreen)
		{
			SetMenu(hwnd, NULL);
			SDL_SetWindowFullscreen(window, SDL_WINDOW_FULLSCREEN_DESKTOP);
			SDL_GetWindowSize(window, &windowWidth, &windowHeight);
		}
		else
		{
			SDL_SetWindowFullscreen(window, 0);
			SetMenu(hwnd, menu);

			updateWindowSize();
		}

		if (menu)
		{
			CheckMenuItem(menu, ID_DISPLAY_FULLSCREEN, MF_BYCOMMAND | (config.fullscreen ? MF_CHECKED : MF_UNCHECKED));
		}
	}

	void loadConfig()
	{
		char filename[1024];

		strncpy(filename, working_dir, sizeof(filename));
		strncat(filename, "res/conf", sizeof(filename));

		FILE* file = fopen(filename, "rb");

		if (file)
		{
			fseek(file, 0, SEEK_END);
			int size = ftell(file);
			fseek(file, 0, SEEK_SET);

			if (size == sizeof(Config))
			{
				fread(&config, sizeof(Config), 1, file);

				memcpy(&controllerSetup, &config.controller, sizeof(ControllerSetup));
			}

			fclose(file);
		}
	}

	void saveConfig()
	{
		char filename[1024];

		strncpy(filename, working_dir, sizeof(filename));
		strncat(filename, "res/conf", sizeof(filename));

		FILE* file = fopen(filename, "wb");

		if (file)
		{
			memcpy(&config.controller, &controllerSetup, sizeof(ControllerSetup));

			fwrite(&config, sizeof(Config), 1, file);
			fclose(file);
		}
	}

	static bool FileExists(const char* path)
	{
		DWORD attr = GetFileAttributes(path);

		return (attr != INVALID_FILE_ATTRIBUTES &&
			!(attr & FILE_ATTRIBUTE_DIRECTORY));
	}

public:
	HWND hwnd;
	HMENU menu;
	SDL_Window* window;
	SDL_Renderer* renderer;
	SDL_Texture* texture;
	SDL_Texture* artwork;
	int romIndex;
	Config config;
	int textureWidth;
	int textureHeight;
	bool xguiEnable;
	int players;
	int mouseX, mouseY;
	int mouseLButton;
	int windowWidth, windowHeight;
};

static GameState gameState;

#define IDT_TIMER 100

static int CALLBACK DlgConfig(HWND dlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch (msg)
	{
	case WM_INITDIALOG:
	{
		SetTimer(dlg, IDT_TIMER, 100, NULL);

		ControllerSetupDialog.tab = GetDlgItem(dlg, IDC_PLAYER_TAB);

		for (int i = 0; i < gameState.players; i++) addTabItem(ControllerSetupDialog.tab, i);

		HWND content = CreateDialog(NULL, MAKEINTRESOURCE(IDD_PLAYER_TAB_DIALOG), dlg, PlayerDlgConfig);

		SetWindowPos(content, NULL, 20, 40, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
	}
	return TRUE;

	case WM_TIMER:
	{
		SDL_JoystickUpdate();

		PlayerButton button;

		if (gameState.processGamepad(button))
		{
			HWND focus = GetFocus();

			if (focus && GetWindowLongPtr(focus, GWLP_WNDPROC) == (LONG)SubEditProc)
			{
				SubEditProc(focus, WM_JOYSTICK, 0, (LPARAM)&button);
			}
		}
	}
	break;

	case WM_NOTIFY:
		if (wParam == IDC_PLAYER_TAB && ((LPNMHDR)lParam)->code == TCN_SELCHANGE)
			ControllerSetupDialog.updateButtonCodeNames();
		break;

	case WM_CLOSE:
		KillTimer(dlg, IDT_TIMER);
		EndDialog(dlg, IDCANCEL);
		return TRUE;

	case WM_COMMAND:
		switch (LOWORD(wParam))
		{
		case IDOK:
		case IDCANCEL:
			KillTimer(dlg, IDT_TIMER);
			return EndDialog(dlg, LOWORD(wParam));

		case IDDEFKEYB:
			if (MessageBox(dlg, "Change to default keyboard layout, are you sure?", "Confirm", MB_YESNO) == IDYES)
			{
				SetDefaultControls(TabCtrl_GetCurSel(ControllerSetupDialog.tab), false);
				ControllerSetupDialog.updateButtonCodeNames();
			}
			return TRUE;

		case IDDEFJOY:
			if (MessageBox(dlg, "Change to default gamepad layout, are you sure?", "Confirm", MB_YESNO) == IDYES)
			{
				SetDefaultControls(TabCtrl_GetCurSel(ControllerSetupDialog.tab), true);
				ControllerSetupDialog.updateButtonCodeNames();
			}
			return TRUE;
		}
	}

	return FALSE;
}

void MDFNFILE::Open(const char *path, const FileExtensionSpecStruct *known_ext, const char *purpose)
{
#ifdef EMBED_ROM
	// !TODO: ugly hack :(
	int id = (int)path;
	HRSRC res = FindResource(NULL, MAKEINTRESOURCE(id), RT_RCDATA);
	int size = SizeofResource(NULL, res);
	HGLOBAL data = LoadResource(NULL, res);
	void* bin = LockResource(data);

	str.reset(new MemoryStream(size, true));
	memcpy(str->map(), bin, str->size());

	UnlockResource(data);
	FreeResource(data);
#else


	FILE *file;
	int size;

	file = fopen(path, "rb");

	if (!file) exit(1);

	fseek(file, 0, SEEK_END);
	size = ftell(file);
	fseek(file, 0, SEEK_SET);

	int8* buf = (int8*)SDL_malloc(size);
	fread(buf, size, 1, file);
	fclose(file);

	str.reset(new MemoryStream(size, true));
	memcpy(str->map(), buf, (size_t)str->size());

	SDL_free(buf);

#endif
}

StateMem::~StateMem(void)
{
}

class SoundBuffer
{
public:

	static const int Freq = 44100;

	SoundBuffer()
	{
		SDL_AudioSpec want = {0};
		want.freq = Freq;
		want.format = AUDIO_S16;
		want.channels = CurrentSetup.channels;

		device = SDL_OpenAudioDevice(NULL, 0, &want, &spec, 0);
		stream = (int16*)SDL_malloc(spec.freq * sizeof(int16) * 10);
	}

	~SoundBuffer()
	{
		SDL_CloseAudioDevice(device);
		SDL_free(stream);
	}

	void resume()
	{
		SDL_PauseAudioDevice(device, 0);
	}

	void pause()
	{
		SDL_PauseAudioDevice(device, 1);
	}

	void blit(int samples, bool mute)
	{
		SDL_PauseAudioDevice(device, 0);

		if (mute) memset(stream, 0, samples * sizeof(int16) * spec.channels);

		SDL_QueueAudio(device, stream, samples * sizeof(int16) * spec.channels);
	}

	int16* getStream() const
	{
		return stream;
	}

	int getQuened(void)
	{
		return SDL_GetQueuedAudioSize(device) / sizeof(int16) / spec.channels;
	}

private:

	int32 framerate;
	int16* stream;
	SDL_AudioDeviceID device;
	SDL_AudioSpec spec;
};

static void WindowsMessageHook(void *userdata, void *hWnd, unsigned int message, Uint64 wParam, Sint64 lParam)
{
	GameState* gameState = (GameState*)userdata;
	switch (message)
	{
	case WM_COMMAND:
		switch (LOWORD(wParam))
		{
		case ID_CONFIGURE_CONTROLS:
			gameState->configureControls();
			break;
		case ID_GAME_PAUSE:
			gameState->pauseGame(!gameState->pause);
			break;
		case ID_GAME_RESETTOMENU:
			if (!gameState->loadRomData(0))
			{
				SDL_Quit();
			}
			break;
		case ID_GAME_RESETGAME:
			gameState->pauseGame(false);
			MDFNGameInfo->DoSimpleCommand(MDFN_MSC_RESET);
			break;
		case ID_GAME_EXIT:
			gameState->exit = true;
			break;
		case ID_DISPLAY_SCALE1X:
		case ID_DISPLAY_SCALE2X:
		case ID_DISPLAY_SCALE3X:
		case ID_DISPLAY_SCALE4X:
			gameState->setWindowed(LOWORD(wParam) - ID_DISPLAY_SCALE1X + 1);
			break;
		case ID_SAVEGAMEPOSITION_SLOT1:
		case ID_SAVEGAMEPOSITION_SLOT2:
		case ID_SAVEGAMEPOSITION_SLOT3:
		case ID_SAVEGAMEPOSITION_SLOT4:
		case ID_SAVEGAMEPOSITION_SLOT5:
		case ID_SAVEGAMEPOSITION_SLOT6:
		case ID_SAVEGAMEPOSITION_SLOT7:
		case ID_SAVEGAMEPOSITION_SLOT8:
		case ID_SAVEGAMEPOSITION_SLOT9:
			gameState->stateAction(false, LOWORD(wParam) - ID_SAVEGAMEPOSITION_SLOT1);
			break;
		case ID_LOADGAMEPOSITION_SLOT1:
		case ID_LOADGAMEPOSITION_SLOT2:
		case ID_LOADGAMEPOSITION_SLOT3:
		case ID_LOADGAMEPOSITION_SLOT4:
		case ID_LOADGAMEPOSITION_SLOT5:
		case ID_LOADGAMEPOSITION_SLOT6:
		case ID_LOADGAMEPOSITION_SLOT7:
		case ID_LOADGAMEPOSITION_SLOT8:
		case ID_LOADGAMEPOSITION_SLOT9:
			gameState->stateAction(true, LOWORD(wParam) - ID_LOADGAMEPOSITION_SLOT1);
			break;
		case ID_DISPLAY_FULLSCREEN:
			gameState->setFullScreen(true);
			break;
		case ID_DISPLAY_SMOOTHING:
			gameState->setSmoothing(!gameState->config.smoothing);
			break;
		}
		break;
	}
}

static void setPlayerInput(int index, const int* buttonsOrders, int count)
{
	if (index >= CurrentSetup.players)
		return;

	static Uint16 inputData[PLAYERS_COUNT] = { 0 };

	Uint16& input = inputData[index];

	input = 0;

	PlayerSetup& player = controllerSetup.player[index];

	const Uint8* state = SDL_GetKeyboardState(NULL);

	for (int i = 0; i < count; i++)
	{
		bool pressed = false;

		if (buttonsOrders[i] >= 0)
		{
			PlayerButton& button = player.buttons[buttonsOrders[i]];

			if (button.type == PlayerButton::KEYBOARD)
			{
				if (button.code != SDL_SCANCODE_UNKNOWN && state[button.code])
					pressed = true;
			}
			else if (button.type == PlayerButton::GAMEPAD)
			{
				for (int j = 0; j < JOYSTICKS_COUNT; j++)
				{
					SDL_Joystick* joystick = gameState.joysticks[j];

					if (joystick && SDL_JoystickGetAttached(joystick))
					{
						SDL_JoystickGUID guid = SDL_JoystickGetGUID(joystick);
						if (memcmp(&guid, &button.guid, sizeof(SDL_JoystickGUID)) == 0)
						{
							if (button.hat)
							{
								int hatsCount = SDL_JoystickNumHats(joystick);

								for (int h = 0; h < hatsCount; h++)
									if (SDL_JoystickGetHat(joystick, h) & button.value)
									{
										pressed = true;
										break;
									}

								if (!pressed)
								{
									int axe = gameState.getAxisMask(joystick);

									if (axe & button.value)
									{
										pressed = true;
										break;
									}
								}
							}
							else
							{
								int buttonsCount = SDL_JoystickNumButtons(joystick);

								for (int b = 0; b < buttonsCount; b++)
								{
									if (SDL_JoystickGetButton(joystick, b) && button.value == b)
									{
										pressed = true;
										break;
									}
								}
							}

							break;
						}
					}
				}
			}
		}

		if (pressed) input |= (1 << i);
	}

#ifndef BUILD_ONLY_MD
	MDFNGameInfo->SetInput(index, "gamepad", (uint8*)&inputData[index]);
#else
	MDFNGameInfo->SetInput(index, "gamepad6", (uint8*)&inputData[index]);
#endif
}



void load_save_thumbs(void)
{
	char filename[1024];
	FILE *file;

	SDL_SetHint(SDL_HINT_RENDER_SCALE_QUALITY, "1");	//thumbs filtered

	for (int slot = 0; slot < 3; ++slot)
	{
		snprintf(filename, sizeof(filename), "%s/res/%u%uP", working_dir, gameState.romIndex, slot);

		xgui_picture_load(xguiSlotSnap[slot], gameState.renderer, filename);

		snprintf(filename, sizeof(filename), "%s/res/%u%uS", working_dir, gameState.romIndex, slot);

		file = fopen(filename, "rb");

		if (file)
		{
			xgui_visible(xguiSlotLoad[slot], true);
			fclose(file);
		}
		else
		{
			xgui_visible(xguiSlotLoad[slot], false);
		}
	}
}



void save_screenshot(char *filename)
{
	SDL_Texture *ren_tex;
	SDL_Surface *surf;
	int st;
	int w;
	int h;
	int format;
	void *pixels;

	format = SDL_PIXELFORMAT_RGB24;

	st = SDL_QueryTexture(gameState.texture, NULL, NULL, &w, &h);

	ren_tex = SDL_CreateTexture(gameState.renderer, format, SDL_TEXTUREACCESS_TARGET, w, h);

	st = SDL_SetRenderTarget(gameState.renderer, ren_tex);

	st = SDL_RenderCopy(gameState.renderer, gameState.texture, NULL, NULL);

	pixels = malloc(w * h * SDL_BYTESPERPIXEL(format));

	st = SDL_RenderReadPixels(gameState.renderer, NULL, format, pixels, w * SDL_BYTESPERPIXEL(format));

	surf = SDL_CreateRGBSurfaceWithFormatFrom(pixels, w, h, SDL_BITSPERPIXEL(format), w * SDL_BYTESPERPIXEL(format), format);

	st = SDL_SaveBMP(surf, filename);

	SDL_FreeSurface(surf);

	free(pixels);

	SDL_DestroyTexture(ren_tex);
}



void update_button_keys(void)
{
	for (int i = 0; i < CONTROLLER_BUTTONS; ++i)
	{
		char buf[128];

		strcpy(buf, "      : ");
		memcpy(buf, ButtonNames[i], strlen(ButtonNames[i]));

		if (xguiControlID != i)
		{
			const char* name = controllerSetup.player[xguiPlayerID].buttons[i].getName();

			if (strlen(name) > 0)
			{
				strncat(buf, name, sizeof(buf));
			}
			else
			{
				strcat(buf, "none");
			}
		}
		else
		{
			strcat(buf, "???");
		}

		xgui_set_text(xguiInput[i], buf);
	}
}



int main(int argc, char **argv)
{
	//log_open("log.txt");

	SDL_SetHint(SDL_HINT_JOYSTICK_ALLOW_BACKGROUND_EVENTS, "1");
	SDL_SetHint(SDL_HINT_TIMER_RESOLUTION, "1");
	SDL_SetHint(SDL_HINT_RENDER_VSYNC, "0");

	SDL_Init(SDL_INIT_VIDEO | SDL_INIT_AUDIO | SDL_INIT_JOYSTICK);

	log_add("init done\n");

	SDL_SetWindowsMessageHook(WindowsMessageHook, &gameState);

	log_add("hook set\n");

	if (!gameState.init())
	{
		SDL_Quit();

		return 1;
	}

	if (gameState.xguiEnable)
	{
		xgui_init(working_dir, gameState.renderer);	//changesSDL_HINT_RENDER_SCALE_QUALITY

		SDL_SetHint(SDL_HINT_RENDER_SCALE_QUALITY, gameState.config.smoothing ? "1" : "0");
	}

	xgui_clear();

	xguiPlay  = xgui_add(XGUI_BUTTON        , 0, 450, 250, "Play");
	xguiReset = xgui_add(XGUI_BUTTON_CONFIRM, 0, 450, 300, "Reset");
	xguiQuit  = xgui_add(XGUI_BUTTON_CONFIRM, 0, 450, 350, "Quit");
	
	xguiFullscreen = xgui_add(XGUI_CHECKBOX, 0, 420, 450, "Full");
	xguiScale2x    = xgui_add(XGUI_CHECKBOX, 0, 420, 500, "2x");
	xguiScale3x    = xgui_add(XGUI_CHECKBOX, 0, 420, 550, "3x");
	xguiScale4x    = xgui_add(XGUI_CHECKBOX, 0, 420, 600, "4x");
	xguiSmoothing  = xgui_add(XGUI_CHECKBOX, 0, 420, 650, "Smooth");
		
	xguiControls = xgui_add(XGUI_BUTTON        , 0, 1150, 650, "Change keys");

	int sx, sy;

	sy = 900; 
	sx = 1920 / 2 - 380;
	
	xguiSlotSnap[0] = xgui_add(XGUI_PICTURE, 0, sx, sy, "");
	xguiSlotLoad[0] = xgui_add(XGUI_BUTTON, 0, sx - 110, sy - 120, "Load");
	xguiSlotSave[0] = xgui_add(XGUI_BUTTON, 0, sx - 10, sy + 80, "Save");

	sx = 1920 / 2;

	xguiSlotSnap[1] = xgui_add(XGUI_PICTURE, 0, sx, sy, "");
	xguiSlotLoad[1] = xgui_add(XGUI_BUTTON, 0, sx - 110, sy - 120, "Load");
	xguiSlotSave[1] = xgui_add(XGUI_BUTTON, 0, sx - 10, sy + 80, "Save");

	sx = 1920 / 2 + 380;

	xguiSlotSnap[2] = xgui_add(XGUI_PICTURE, 0, sx, sy, "");
	xguiSlotLoad[2] = xgui_add(XGUI_BUTTON, 0, sx - 110, sy - 120, "Load");
	xguiSlotSave[2] = xgui_add(XGUI_BUTTON, 0, sx - 10, sy + 80, "Save");
	

	xguiPlayer1 = 0;
	xguiPlayer2 = 0;

	xguiControlID = -1;
	xguiPlayerID = 0;

	xguiPlayer1 = xgui_add(XGUI_CHECKBOX, 1, 425, 250, "Player 1");

	xgui_set_check(xguiPlayer1, true); 
	
	if (gameState.players > 1) xguiPlayer2 = xgui_add(XGUI_CHECKBOX, 1, 750, 250, "Player 2");
	
	xguiBack = xgui_add(XGUI_BUTTON, 1, 1350, 250, "Back");

	sx = 460;
	sy = 350;

	for (int i = 0; i < CONTROLLER_BUTTONS; ++i)
	{
		xguiInput[i] = xgui_add(XGUI_BUTTON, 1, sx, sy, "");

		sy += 50;
	}

	update_button_keys();

	xguiDefKey = xgui_add(XGUI_BUTTON_CONFIRM, 1, 1150, 850, "Default key");
	xguiDefJoy = xgui_add(XGUI_BUTTON_CONFIRM, 1, 1150, 900, "Default joy");



	log_add("gamestate init done\n");

	log_add("nwdt %i\n", MDFNGameInfo->nominal_width); 
	log_add("nhgt %i\n", MDFNGameInfo->nominal_height);
	log_add("fbwdt %i\n", MDFNGameInfo->fb_width); 
	log_add("fbhgt %i\n", MDFNGameInfo->fb_height);

	MDFN_PixelFormat nf(MDFN_COLORSPACE_RGB, 0, 8, 16, 24);
	MDFN_Surface videoBuffer(NULL, MDFNGameInfo->nominal_width, MDFNGameInfo->nominal_height, MDFNGameInfo->nominal_width, nf);
	std::vector<int32> videoLineWidths(MDFNGameInfo->fb_height);

	SDL_Event event;

	log_add("trying to load file\n");

	if (!gameState.loadRomData(0))
	{
		SDL_Quit();

		return 1;
	}

	log_add("load done\n");

	gameState.framerate = (MDFNGameInfo->VideoSystem == VIDSYS_NONE || MDFNGameInfo->VideoSystem == VIDSYS_NTSC) ? 60 : 50;
	SoundBuffer soundBuffer;

	EmulateSpecStruct espec = {0};
	{
		memset(&espec, 0, sizeof(EmulateSpecStruct));
		espec.VideoFormatChanged = true;
		espec.SoundFormatChanged = true;
		espec.surface = &videoBuffer;
		espec.LineWidths = &videoLineWidths[0];
		espec.SoundRate = SoundBuffer::Freq;
		espec.SoundBuf = soundBuffer.getStream();
		espec.SoundVolume = 1.0;
		espec.SoundBufMaxSize = SoundBuffer::Freq / gameState.framerate * SOUND_BUFFER_FRAMES;
	}

	load_save_thumbs();

	float nextTick = (float)SDL_GetTicks();

	log_add("entering loop\n");

	while (!gameState.exit)
	{
		nextTick += (1000.0f / (float)gameState.framerate);

		while (SDL_PollEvent(&event))
		{
			switch (event.type)
			{
			case SDL_CONTROLLERDEVICEADDED:
			{
				int id = event.cdevice.which;
				if (id < JOYSTICKS_COUNT)
				{
					if (gameState.gamepads[id])
						SDL_GameControllerClose(gameState.gamepads[id]);

					gameState.gamepads[id] = SDL_GameControllerOpen(id);
				}
			}
			break;
			case SDL_JOYDEVICEADDED:
			{
				int id = event.jdevice.which;

				if (id < JOYSTICKS_COUNT)
				{
					if (gameState.joysticks[id])
						SDL_JoystickClose(gameState.joysticks[id]);


					gameState.joysticks[id] = SDL_JoystickOpen(id);
				}
			}
			break;
			case SDL_JOYDEVICEREMOVED:
			{
				int id = event.jdevice.which;

				if (id < JOYSTICKS_COUNT && gameState.joysticks[id])
				{
					SDL_JoystickClose(gameState.joysticks[id]);
					gameState.joysticks[id] = NULL;
				}
			}
			break;
			case SDL_MOUSEMOTION:
			{
				int mx, my;

				mx = event.motion.x;
				my = event.motion.y;

				if (!gameState.config.fullscreen)
				{
					int wswdt = gameState.windowHeight * 1920 / 1080;

					mx += (wswdt - gameState.windowWidth) / 2;

					gameState.mouseX = mx * 1920 / wswdt;
					gameState.mouseY = my * 1080 / gameState.windowHeight;
				}
				else
				{
					gameState.mouseX = mx * 1920 / gameState.windowWidth;
					gameState.mouseY = my * 1080 / gameState.windowHeight;
				}
			}
			break;
			case SDL_MOUSEBUTTONDOWN:
			{
				if (event.button.button == SDL_BUTTON_LEFT) gameState.mouseLButton = 1;

				if (event.button.button == SDL_BUTTON_RIGHT)
				{
					if (gameState.xguiEnable)
					{
						if (xgui_is_enabled())
						{
							xgui_enable(false);
							gameState.pauseGame(false);
						}
						else
						{
							xgui_enable(true);
							gameState.pauseGame(true);
						}

						gameState.updateCursor();
					}
				}
			}
			break;
			case SDL_QUIT: gameState.exit = true; break;
			case SDL_KEYDOWN:
				if (xguiControlID >= 0)
				{
					int player = xgui_is_checked(xguiPlayer2) ? 1 : 0; 
					
					if (event.key.keysym.scancode != SDL_SCANCODE_ESCAPE)
					{
						controllerSetup.player[player].buttons[xguiControlID].type = PlayerButton::KEYBOARD;
						controllerSetup.player[player].buttons[xguiControlID].code = event.key.keysym.scancode;

						gameState.saveConfig();
					}
					
					xguiControlID = -1; 
					
					update_button_keys();

					if (event.key.keysym.scancode == SDL_SCANCODE_ESCAPE) break;
				}
				switch (event.key.keysym.scancode)
				{
				case SDL_SCANCODE_PAUSE:
					gameState.pauseGame(!gameState.pause);
					break;
				case SDL_SCANCODE_F1:
				case SDL_SCANCODE_F2:
				case SDL_SCANCODE_F3:
				case SDL_SCANCODE_F4:
				case SDL_SCANCODE_F5:
				case SDL_SCANCODE_F6:
				case SDL_SCANCODE_F7:
				case SDL_SCANCODE_F8:
				case SDL_SCANCODE_F9:
				{
					int slot = event.key.keysym.sym - SDLK_F1;

					if (event.key.keysym.mod & KMOD_SHIFT)
					{
						gameState.stateAction(false, slot);
					}
					else
					{
						gameState.stateAction(true, slot);
					}
				}
				break;

				case SDL_SCANCODE_RETURN:
					if (event.key.keysym.mod & KMOD_ALT)
					{
						gameState.setFullScreen(!gameState.config.fullscreen);
					}
					break;
				case SDL_SCANCODE_ESCAPE:
					if (!gameState.xguiEnable)
					{
						gameState.escapeFullscreen();
					}
					else
					{
						if (xgui_is_enabled())
						{
							xgui_enable(false);
							gameState.pauseGame(false);
						}
						else
						{
							xgui_enable(true);
							gameState.pauseGame(true);
						}

						gameState.updateCursor();
					}
					break;
				}
				break;
			case SDL_JOYAXISMOTION:
			case SDL_JOYBUTTONDOWN:
			case SDL_JOYHATMOTION:
				if (xguiControlID >= 0)
				{
					int player = xgui_is_checked(xguiPlayer2) ? 1 : 0;

					SDL_JoystickUpdate();

					PlayerButton button;

					if (gameState.processGamepad(button))
					{
						controllerSetup.player[player].buttons[xguiControlID] = button;

						gameState.saveConfig();
					}

					xguiControlID = -1;

					update_button_keys();
				}
				break;
			}
		}

		for (int i = 0; i < PLAYERS_COUNT; i++) 
			setPlayerInput(i, CurrentSetup.buttonsOrder, CurrentSetup.count);

		if(!gameState.pause) MDFNGameInfo->Emulate(&espec);

		xgui_update(gameState.windowWidth, gameState.windowHeight, gameState.mouseX, gameState.mouseY, gameState.mouseLButton);

		gameState.mouseLButton = 0;

		if (xgui_is_enabled())
		{
			if (xgui_is_down(xguiFullscreen)) gameState.setFullScreen(true);
			if (xgui_is_down(xguiScale2x)) gameState.setWindowed(2);
			if (xgui_is_down(xguiScale3x)) gameState.setWindowed(3);
			if (xgui_is_down(xguiScale4x)) gameState.setWindowed(4);
			if (xgui_is_down(xguiSmoothing)) gameState.setSmoothing(!gameState.config.smoothing);
			if (xgui_is_down(xguiPlay))
			{
				xgui_enable(false);
				gameState.pauseGame(false);
			}
			if (xgui_is_down(xguiReset))
			{
				MDFNGameInfo->DoSimpleCommand(MDFN_MSC_RESET);
				xgui_enable(false);
				gameState.pauseGame(false);
			}
			if (xgui_is_down(xguiQuit))
			{
				gameState.exit = true;
			}
			for (int slot = 0; slot < 3; ++slot)
			{
				if (xgui_is_down(xguiSlotSave[slot]))
				{
					gameState.stateAction(false, slot);
					load_save_thumbs();
				}
				if (xgui_is_down(xguiSlotLoad[slot]))
				{
					gameState.stateAction(true, slot);
					xgui_enable(false);
					gameState.pauseGame(false);
				}
			}
			
			if (gameState.players > 1)
			{
				if (xgui_is_down(xguiPlayer1))
				{
					xguiPlayerID = 0; 
					
					xgui_set_check(xguiPlayer1, true);
					xgui_set_check(xguiPlayer2, false);

					update_button_keys();
				}
				if (xgui_is_down(xguiPlayer2))
				{
					xguiPlayerID = 1;

					xgui_set_check(xguiPlayer1, false);
					xgui_set_check(xguiPlayer2, true);

					update_button_keys();
				}
			}

			if (xgui_is_down(xguiControls))
			{
				xgui_select_page(1);
				xguiControlID = -1;
			}
			if (xgui_is_down(xguiBack))
			{
				xgui_select_page(0);
				xguiControlID = -1;
			}

			if (xgui_is_down(xguiDefKey))
			{
				memcpy(&ControllerSetupDialog.data, &controllerSetup, sizeof(ControllerSetup));

				SetDefaultControls(xgui_is_checked(xguiPlayer2) ? 1 : 0, false);

				memcpy(&controllerSetup, &ControllerSetupDialog.data, sizeof(ControllerSetup));

				gameState.saveConfig();

				update_button_keys();
			}
			if (xgui_is_down(xguiDefJoy))
			{
				memcpy(&ControllerSetupDialog.data, &controllerSetup, sizeof(ControllerSetup));

				SetDefaultControls(xgui_is_checked(xguiPlayer2) ? 1 : 0, true);

				memcpy(&controllerSetup, &ControllerSetupDialog.data, sizeof(ControllerSetup));

				gameState.saveConfig();

				update_button_keys();
			}

			if (xguiControlID < 0)
			{
				for (int id = 0; id < CONTROLLER_BUTTONS; ++id)
				{
					if (xgui_is_down(xguiInput[id]))
					{
						xguiControlID = id;

						update_button_keys();

						break;
					}
				}
			}

			if (gameState.config.fullscreen)
			{
				xgui_set_check(xguiFullscreen, true);
				xgui_set_check(xguiScale2x, false);
				xgui_set_check(xguiScale3x, false);
				xgui_set_check(xguiScale4x, false);
			}
			else
			{
				xgui_set_check(xguiFullscreen, false);
				//xgui_set_check(xguiScale1x, gameState.config.scale == 1 ? true : false);
				xgui_set_check(xguiScale2x, gameState.config.scale == 2 ? true : false);
				xgui_set_check(xguiScale3x, gameState.config.scale == 3 ? true : false);
				xgui_set_check(xguiScale4x, gameState.config.scale == 4 ? true : false);
			}

			xgui_set_check(xguiSmoothing, gameState.config.smoothing == 1 ? true : false);
		}

		gameState.blit(videoBuffer.pixels, espec.DisplayRect);
		soundBuffer.blit(espec.SoundBufSize, gameState.pause);

		espec.VideoFormatChanged = false;
		espec.SoundFormatChanged = false;


		float delay = nextTick - SDL_GetTicks();

		if (delay < 0)
		{
			nextTick -= delay;
		}
		else
		{
			SDL_Delay((Uint32)delay);

			nextTick += (delay - floorf(delay));
		}

		//if there is less than two thirds of the sound buffer filled up with sound, skip some future frames to catch up

		if (soundBuffer.getQuened() < espec.SoundBufMaxSize-(espec.SoundBufMaxSize / 3))
		{
			nextTick -= 64;
		}

		//log_add("queue %i\n", soundBuffer.getQuened());
	}

	MDFNGameInfo->CloseGame();

	SDL_Quit();

	log_close();

	return 0;
}
