/*
noMeiryoUI (C) 2005,2012,2013 Tatsuhiko Shoji
The sources for noMeiryoUI are distributed under the MIT open source license
*/
#include "stdafx.h"
#include "AppliBase.h"
#include "TwrCombobox.h"

/**
 * RXgN^
 */
TwrCombobox::TwrCombobox() : TwrWnd()
{
	style = CBS_DROPDOWNLIST;
}

/**
 * RXgN^
 *
 * @param IuWFNgɌѕtEChẼnh
 */
TwrCombobox::TwrCombobox(HWND newHwnd) : TwrWnd()
{
	hWnd = newHwnd;
}

/**
 * R{{bNX쐬܂B
 */
HWND TwrCombobox::create(void)
{
	hWnd = CreateWindowEx(
		WS_EX_CLIENTEDGE,
		_T("COMBOBOX"),
		NULL,
		WS_CHILD|WS_VISIBLE|WS_TABSTOP|style,
		left,	// X
		top,	// Y
		width,	// Width
		height,	// Height
		GetDesktopWindow(),	// Parent
		NULL,
		hInst,
		NULL);

	return hWnd;
}

/**
 * R{{bNX쐬܂B
 *
 * @param parent eEChEnh
 */
HWND TwrCombobox::create(HWND parent)
{
	hWnd = CreateWindowEx(
		WS_EX_CLIENTEDGE,
		_T("COMBOBOX"),
		NULL,
		WS_CHILD|WS_VISIBLE|WS_TABSTOP|style,
		left,	// X
		top,	// Y
		width,	// Width
		height,	// Height
		parent,	// Parent
		NULL,
		hInst,
		NULL);

	return hWnd;
}

/**
 * R{{bNXɗvfǉ܂B
 *
 * @param item ǉ镶
 */
void TwrCombobox::addItem(const TCHAR *item)
{
	SendMessage(hWnd, CB_ADDSTRING, 0, (LPARAM)item);
}

/**
 * Iꂽvf̈ʒu擾܂B
 *
 * @return -1:IĂȂ -1ȊO:Iꂽꏊ
 */
int TwrCombobox::getSelectedIndex(void)
{
	LRESULT result = SendMessage(hWnd, CB_GETCURSEL, 0, 0);
	if (result == CB_ERR) {
		return -1;
	} else {
		return (int)result;
	}
}

/**
 * vf̐擾܂B
 *
 * @return -1:IĂȂ -1ȊO:Iꂽꏊ
 */
int TwrCombobox::getCount(void)
{
	LRESULT result = SendMessage(hWnd, CB_GETCOUNT, 0, 0);
	if (result == CB_ERR) {
		return -1;
	} else {
		return (int)result;
	}
}

/**
 * R{{bNXNA܂B
 */
void TwrCombobox::clear(void)
{
	SendMessage(hWnd, CB_RESETCONTENT, 0, 0);
}

/**
 * w肵ʒu̗vfI܂B
 *
 * @param index Iʒu
 */
void TwrCombobox::setSelectedIndex(int index)
{
	SendMessage(hWnd, CB_SETCURSEL, index, 0);
}

/**
 * Iʒu̕Ԃ܂B
 *
 * @return Iʒu̕(IĂȂꍇ͋)
 */
tstring TwrCombobox::getSelectedText(void)
{
	TCHAR *buf;
	tstring ret = _T("");
	LRESULT len;

	int item = getSelectedIndex();
	if (item < 0) {
		return ret;
	}

	len = SendMessage(hWnd, CB_GETLBTEXTLEN, item, 0);
	try {
		buf = new TCHAR[len + 1];
		SendMessage(hWnd, CB_GETLBTEXT, item, (LPARAM)buf);

		ret = buf;
		delete []buf;
	} catch (...) {
	}

	return ret;	
}

/**
 * w肵ʒu̕Ԃ܂B
 *
 * @param index 擾鍀ڂ̈ʒu
 * @return (IĂȂꍇ͋)
 */
tstring TwrCombobox::getItem(int index)
{
	TCHAR *buf;
	tstring ret = _T("");
	LRESULT len;

	len = SendMessage(hWnd, CB_GETLBTEXTLEN, index, 0);
	try {
		buf = new TCHAR[len + 1];
		SendMessage(hWnd, CB_GETLBTEXT, index, (LPARAM)buf);

		ret = buf;
		delete []buf;
	} catch (...) {
	}

	return ret;	
}

