/**
 * 项目公有函数
 * @type {Object}
 */ 
var chargeUtil = { 
	/**
	 * 客户端中转请求
	 * @param {[type]} options [description]
	 */
	postData: function(options) {
		var jname = "KGSupercall_PostData" + Math.random().toString().substr(2, 9);
		KgSuperCall.postData(Kg.JSON.stringify({
			url: options.url,
			callback: jname,
			param: options.param
		}));
		top.window[jname] = function(params) {
			try {
				if (params) {
					var json = Kg.JSON.parse(params);
					options.callback && options.callback(json == null ? "error" : json);
				} else {
					options.callback && options.callback();
				}
				top.window[jname] = null;
			} catch (ex) {
				options.callback && options.callback("error");
				top.window[jname] = null;
			}
		};
	},
	/**
	 * 设置本地存储
	 * @param {[type]} key         [description]
	 * @param {[type]} value       [description]
	 * @param {[type]} addTime     [description]
	 * @param {[type]} expriedTime [description]
	 */
	setLocalData: function(key, value, addTime, expriedTime) {
		var opt = [];
		if (typeof value == 'object') {
			for (var i in value) {
				opt.push(i + ':\\"' + value[i] + '\\"');
			}
			value = '{' + opt.join(",") + '}';
		}
		try {
			var p1 = '{"filename":"' + key + '",',
				p2 = '"addTime":"' + (addTime || new Date().getTime()) + '","expriedTime":"' + (expriedTime || (new Date().getTime()) * 2) + '"}',
				p3 = value;
			if (external.GetVersion() >= 8041) {
				external.SetLocalData(p1 + p2, p3.replace(/\\\"/g, '\"'));
			} else {
				external.SuperCall(803, p1 + '"content":"' + p3 + '",' + p2);
			}
		} catch (ex) {}
	},
	/**
	 * 客户端异步获取mid和appid
	 * @param  {Function} callback [description]
	 * @return {[type]}            [description]
	 */
	getMID_APPID : function(callback){
		var jname = "KGSupercall_getMID_APPID" + Math.random().toString().substr(2, 9);
		KgSuperCall.getMID_APPID(Kg.JSON.stringify({
			callback: jname
		}));
		top.window[jname] = function(params) {
			if(params){
				top.window[jname] = null;
				callback && callback(Kg.JSON.parse(params));
			}
		};
	},
	/**
	 * 客户端异步获取加密串
	 * @param  {[type]} options [description]
	 * @return {[type]}         [description]
	 */
	getSIGN : function(options){
		var jname = "KGSupercall_getSIGN" + Math.random().toString().substr(2, 9);
		KgSuperCall.getSIGN(Kg.JSON.stringify({
			params: options.params,
			callback: jname
		}));
		top.window[jname] = function(params) {
			if(params){
				top.window[jname] = null;
				options.callback && options.callback(Kg.JSON.parse(params));
			}
		};
	},
	/**
	 * 扩展对象
	 * @param  {[type]} target  [description]
	 * @param  {[type]} options [description]
	 * @return {[type]}         [description]
	 */
	extendObject: function(target, options) {
		for (var i in options) {
			target[i] = options[i];
		}
		return target;
	},
	/**
	 * 构建新对象
	 * @param  {[type]} target  [description]
	 * @param  {[type]} options [description]
	 * @return {[type]}         [description]
	 */
	buildObject : function(target,options){
		var object = [];
		for(var i in target){
			object[i] = {};
			for(var j in options){
				if(typeof options[j] != 'object'){
					object[i][j] = target[i][options[j]] || options[j];
				}
				else{
					for(var m in options[j]){
						var ele = options[j][m];
						if(target[i][ele]){
							object[i][j] = target[i][ele];
							break;
						}
						else if(typeof ele == 'object'){
							var arr = ele[0].split(","),
								str = [];
							for(var n in arr){
								str.push(target[i][arr[n]]);
								ele[+n + 1] && (str.push(ele[+n + 1]));
							}
							str = str.join("");
							object[i][j] = str;
							break;
						}
					}
				}
			}
		}
		return object;
	},
	/**
	 * 数组深拷贝
	 * @param  {[type]} target  [description]
	 * @param  {[type]} options [description]
	 * @return {[type]}         [description]
	 */
	copyObject : function(target,options){
		for (var i in target) {
			if (target[i] instanceof Array || target[i] instanceof Object) {
				options[i] = target[i] instanceof Array ? [] : {};
				arguments.callee(target[i],options[i]);
			} else {
				options[i] = target[i];
			}
		}
	},
	/**
	 * 删除数组元素
	 * @param  {[type]} arrays [description]
	 * @param  {[type]} indexs [description]
	 * @return {[type]}        [description]
	 */
	deleteObject : function(arrays,indexs){
		for(var i in indexs){
			delete arrays[indexs[i]];
		}
		var temp = [];
		for (var i in arrays) {
			temp.push(arrays[i]);
		}
		return temp;
	},
	/**
	 * 渲染模板
	 * @param  {[type]} id   [description]
	 * @param  {[type]} data [description]
	 * @return {[type]}      [description]
	 */
	bindView : function(id,data,wrap){
		(typeof wrap == 'object' ? wrap : document.getElementById(wrap || "wrap")).innerHTML = template(id,data);
	},
	/**
	 * 弹出层 将html内容和弹出层组合返回html
	 * @param  {[type]} content [description]
	 * @param  {[type]} arrow   [description]
	 * @param  {[type]} right   [description]
	 * @return {[type]}         [description]
	 */
	dialogInsert: function(content, arrow, right) {
		return template('dialog', {
			content: content,
			arrow: arrow,
			right: right
		});
	},
	/**
	 * 查找值是否存在
	 * @param  {[type]} data [description]
	 * @param  {[type]} key  [description]
	 * @return {[type]}      [description]
	 */
	getIndex : function(data,key){
		for(var i in data){
			if(data[i] == key){
				return i;
			}
		}
		return -1;
	},
	/**
	 * 补0
	 * @param  {[type]} str    [description]
	 * @param  {[type]} length [description]
	 * @return {[type]}        [description]
	 */
	padLeft: function(str, length) {
		if (str.length >= length) {
			return str;
		} else {
			return arguments.callee("0" + str, length);
		}
	},
	/**
	 * 浮点数相加
	 * @return {[type]} [description]
	 */
	floatAdd : function(arg1,arg2){
		var r1, r2, m;
		try {
			r1 = arg1.toString().split(".")[1].length;
		} catch (e) {
			r1 = 0;
		}
		try {
			r2 = arg2.toString().split(".")[1].length;
		} catch (e) {
			r2 = 0;
		}
		m = Math.pow(10, Math.max(r1, r2));
		var r = ((arg1 * m + arg2 * m) / m).toFixed(2);
		r.toString().split(".")[1] == "00" && (r = parseInt(r));
		return r;
	},
	/**
	 * 浮点数相减
	 * @return {[type]} [description]
	 */
	floatSub: function(arg1,arg2) {
		var r1, r2, m, n;
		try {
			r1 = arg1.toString().split(".")[1].length
		} catch (e) {
			r1 = 0
		}
		try {
			r2 = arg2.toString().split(".")[1].length
		} catch (e) {
			r2 = 0
		}
		m = Math.pow(10, Math.max(r1, r2));
		//last modify by deeka
		//动态控制精度长度
		n = (r1 >= r2) ? r1 : r2;
		var r = ((arg1 * m - arg2 * m) / m).toFixed(2);
		r.toString().split(".")[1] == "00" && (r = parseInt(r));
		return r;
	},
	/**
	 * 获取下一个节点
	 * @param  {[type]} node [description]
	 * @return {[type]}      [description]
	 */
	getNextNode: function(node) {
		node = typeof node == "string" ? document.getElementById(node) : node;
		var nextNode = node.nextSibling;
		if (!nextNode) return null;
		if ((nextNode.nodeType != 1) && (nextNode.nextSibling)) nextNode = nextNode.nextSibling;
		return nextNode;
	},
	/**
	 * 博汇统计
	 * @param  {[type]} opt [description]
	 * @return {[type]}     [description]
	 */
	behaviorLog: function(opt) {
		try {
			var str = '';
			if (!opt.name) {
				str = ['"ActionName":"点击' + opt.path.replace(/\\/g, "").replace(/"/g, '\\"') + '"'];
			} else {
				str = ['"ActionName":"' + opt.name + '"'];
			}
			opt.id && str.push('"ActionId":"' + opt.id.toString().replace(/\\/g, '\\\\').replace(/"/g, '\\"') + '"');
			opt.path && str.push('"ActionSource":"' + opt.path.replace(/\\/g, '\\\\').replace(/"/g, '\\"') + '"');
			opt.hash && str.push('"Hash":"' + opt.hash + '"');
			opt.song && str.push('"SongName":"' + opt.song.replace(/【[^(【|】)]+】/gi, "").replace(/\\/g, '\\\\').replace(/"/g, '\\"') + '"');
			str = str.join(",");
			external.SuperCall(693, '{' + str + '}');
		} catch (ex) {}
	},
	/**
	 * 漏斗统计
	 * @param  {[type]} id [description]
	 * @return {[type]}    [description]
	 */
	webCollect: function(id) {
		function collect() {
			if (typeof newLogCount != "undefined") {
				chargeUtil.getMID_APPID(function(data) {
					if (data.status == 1) {
						getVipTime(function(rechar, user_id) {
							newLogCount("31000", {
								plat_id: '1001',
								business_id: '001',
								user_id: user_id, //用户ID 
								mid: data.mid,
								nettype: "",
								ip: "",
								enter_id: id, //入口ID
								tv: KgSuperCall.GetVersion(), //版本号，web端默认为0
								rechar: rechar, //会员身份
								ad_id: "",
								space: "",
								pay_type: "",
								ordernumber: "",
								ext_content: "",
								sell_status: ""
							});
						});
					}
				});
				return true;
			}
			return false;
		}
		function getvip(){
			if(typeof getVipTime != 'undefined'){
				if (!collect()) {
					Kg.loadScript("http://js.webcollect.kugou.com/v2/web/collect.js?appid=2400", {},collect);
				}
				return true;
			}
			return false;
		}
		if(!getvip()){
			Kg.loadScript("http://static.kgimg.com/common/js/pc_getviptime.js", {},getvip);
		}
	},
	/**
	 * 按二进制低位取到高位
	 * @param  {[type]} val [description]
	 * @param  {[type]} num [description]
	 * @return {[type]}     [description]
	 */
	getBinary: function(val, num) {
		var str = parseInt(val).toString("2");
		if (str.length >= num) {
			return +(str.substr(str.length - num, 1));
		}
		return 0;
	},
	/**
	 * 打开VIP
	 * @param  {[type]} entrance [description]
	 * @param  {[type]} from     [description]
	 * @return {[type]}          [description]
	 */
	popVip: function(entrance,from) {
		                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 