/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.util.file_system_manager;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import kohgylw.kiftd.printer.Printer;
import kohgylw.kiftd.server.model.Node;
import kohgylw.kiftd.server.util.ConfigureReader;
import kohgylw.kiftd.server.util.FileNodeUtil;
import kohgylw.kiftd.server.util.ServerTimeUtil;
import kohgylw.kiftd.util.file_system_manager.pojo.Folder;
import kohgylw.kiftd.util.file_system_manager.pojo.FolderView;

public class FileSystemManager {
    public static final String BOTH = "BOTH";
    public static final String COVER = "COVER";
    private static FileSystemManager fsm;
    private static final int BUFFER_SIZE = 4096;
    public static int per;
    public static String message;
    private boolean gono;
    private PreparedStatement selectFolderById;
    private PreparedStatement selectNodeById;
    private PreparedStatement selectNodeByFolderId;
    private PreparedStatement selectFoldersByParentFolderId;
    private PreparedStatement insertNode;
    private PreparedStatement insertFolder;
    private PreparedStatement deleteNodeById;
    private PreparedStatement deleteFolderById;
    private PreparedStatement updateNodeById;
    private PreparedStatement updateFolderById;

    private FileSystemManager() {
        Connection c = FileNodeUtil.getNodeDBConnection();
        try {
            this.selectFolderById = c.prepareStatement("SELECT * FROM FOLDER WHERE folder_id = ?");
            this.selectNodeById = c.prepareStatement("SELECT * FROM FILE WHERE file_id = ?");
            this.selectNodeByFolderId = c.prepareStatement("SELECT * FROM FILE WHERE file_parent_folder = ?");
            this.selectFoldersByParentFolderId = c.prepareStatement("SELECT * FROM FOLDER WHERE folder_parent = ?");
            this.insertNode = c.prepareStatement("INSERT INTO FILE VALUES(?,?,?,?,?,?,?)");
            this.insertFolder = c.prepareStatement("INSERT INTO FOLDER VALUES(?,?,?,?,?,?)");
            this.deleteNodeById = c.prepareStatement("DELETE FROM FILE WHERE file_id = ?");
            this.deleteFolderById = c.prepareStatement("DELETE FROM FOLDER WHERE folder_id = ?");
            this.updateNodeById = c.prepareStatement("UPDATE FILE SET file_name = ? , file_size = ? , file_parent_folder = ? , file_creation_date = ? , file_creator = ? , file_path = ? WHERE file_id = ?");
            this.updateFolderById = c.prepareStatement("UPDATE FOLDER SET folder_name= ? , folder_creation_date = ? , folder_creator = ? , folder_parent = ? , folder_constraint = ? WHERE folder_id = ?");
        }
        catch (SQLException e) {
            Printer.instance.print("\u9519\u8bef\uff1a\u51fa\u73b0\u672a\u77e5\u9519\u8bef\uff0c\u6587\u4ef6\u7cfb\u7edf\u89e3\u6790\u5931\u8d25\uff0c\u65e0\u6cd5\u6d4f\u89c8\u6587\u4ef6\u3002");
        }
    }

    public static FileSystemManager getInstance() {
        if (fsm == null) {
            fsm = new FileSystemManager();
        }
        return fsm;
    }

    public FolderView getFolderView(String folderId) throws SQLException {
        FolderView fv = new FolderView();
        fv.setCurrent(this.selectFolderById(folderId));
        fv.setFiles(this.selectNodesByFolderId(folderId));
        fv.setFolders(this.getFoldersByParentId(folderId));
        return fv;
    }

    public boolean delete(String[] foldersId, String[] filesId) throws SQLException {
        int i;
        this.gono = true;
        for (i = 0; i < filesId.length && this.gono; ++i) {
            this.deleteFile(filesId[i]);
        }
        for (i = 0; i < foldersId.length && this.gono; ++i) {
            this.deleteFolder(foldersId[i]);
        }
        return this.gono;
    }

    public boolean exportTo(String[] foldersId, String[] nodesId, File path, String type) throws Exception {
        int i;
        this.gono = true;
        for (i = 0; i < nodesId.length && this.gono; ++i) {
            this.exportNode(nodesId[i], path, type);
        }
        for (i = 0; i < foldersId.length && this.gono; ++i) {
            this.exportFolder(foldersId[i], path, type);
        }
        return this.gono;
    }

    public int hasExistsFilesOrFolders(File[] files, String folderId) throws SQLException {
        int result = 0;
        List<Folder> folders = this.getFoldersByParentId(folderId);
        List<Node> nodes = this.selectNodesByFolderId(folderId);
        for (File f : files) {
            if (f.isDirectory() && folders.parallelStream().anyMatch(e -> e.getFolderName().equals(new String(f.getName().getBytes(Charset.forName("UTF-8")), Charset.forName("UTF-8"))))) {
                ++result;
                continue;
            }
            if (!nodes.parallelStream().anyMatch(e -> e.getFileName().equals(new String(f.getName().getBytes(Charset.forName("UTF-8")), Charset.forName("UTF-8"))))) continue;
            ++result;
        }
        return result;
    }

    public int hasExistsFilesOrFolders(String[] foldersId, String[] filesId, File path) throws Exception {
        if (path.isDirectory()) {
            int c = 0;
            ArrayList<Folder> folders = new ArrayList<Folder>();
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (String fid : foldersId) {
                folders.add(this.selectFolderById(fid));
            }
            for (String nid : filesId) {
                nodes.add(this.selectNodeById(nid));
            }
            for (File f : path.listFiles()) {
                if (f.isDirectory() && folders.parallelStream().anyMatch(e -> e.getFolderName().equals(new String(f.getName().getBytes(Charset.forName("UTF-8")), Charset.forName("UTF-8"))))) {
                    ++c;
                    continue;
                }
                if (!nodes.parallelStream().anyMatch(e -> e.getFileName().equals(new String(f.getName().getBytes(Charset.forName("UTF-8")), Charset.forName("UTF-8"))))) continue;
                ++c;
            }
            return c;
        }
        throw new IllegalArgumentException();
    }

    public boolean importFrom(File[] files, String folderId, String type) throws Exception {
        this.gono = true;
        for (int i = 0; i < files.length && this.gono; ++i) {
            if (files[i].isDirectory()) {
                this.importFolderInto(files[i], folderId, type);
                continue;
            }
            this.importFileInto(files[i], folderId, type);
        }
        return this.gono;
    }

    public List<Folder> getFoldersByParentId(String folderId) throws SQLException {
        this.selectFoldersByParentFolderId.setString(1, folderId);
        ResultSet r = this.selectFoldersByParentFolderId.executeQuery();
        ArrayList<Folder> folders = new ArrayList<Folder>();
        while (r.next()) {
            folders.add(this.resultSetAccessFolder(r));
        }
        return folders;
    }

    public Folder selectFolderById(String folderId) throws SQLException {
        this.selectFolderById.setString(1, folderId);
        ResultSet r = this.selectFolderById.executeQuery();
        if (r.next()) {
            return this.resultSetAccessFolder(r);
        }
        return null;
    }

    private Node selectNodeById(String nodeId) throws SQLException {
        this.selectNodeById.setString(1, nodeId);
        ResultSet r = this.selectNodeById.executeQuery();
        if (r.next()) {
            return this.resultSetAccessNode(r);
        }
        return null;
    }

    public List<Node> selectNodesByFolderId(String folderId) throws SQLException {
        ArrayList<Node> nodes = new ArrayList<Node>();
        this.selectNodeByFolderId.setString(1, folderId);
        ResultSet r = this.selectNodeByFolderId.executeQuery();
        while (r.next()) {
            nodes.add(this.resultSetAccessNode(r));
        }
        return nodes;
    }

    private int insertNode(Node n) throws SQLException {
        this.insertNode.setString(1, n.getFileId());
        this.insertNode.setString(2, n.getFileName());
        this.insertNode.setString(3, n.getFileSize());
        this.insertNode.setString(4, n.getFileParentFolder());
        this.insertNode.setString(5, n.getFileCreationDate());
        this.insertNode.setString(6, n.getFileCreator());
        this.insertNode.setString(7, n.getFilePath());
        this.insertNode.execute();
        return this.insertNode.getUpdateCount();
    }

    private int insertFolder(Folder f) throws SQLException {
        this.insertFolder.setString(1, f.getFolderId());
        this.insertFolder.setString(2, f.getFolderName());
        this.insertFolder.setString(3, f.getFolderCreationDate());
        this.insertFolder.setString(4, f.getFolderCreator());
        this.insertFolder.setString(5, f.getFolderParent());
        this.insertFolder.setInt(6, f.getFolderConstraint());
        this.insertFolder.execute();
        return this.insertFolder.getUpdateCount();
    }

    private Node resultSetAccessNode(ResultSet r) throws SQLException {
        Node node = new Node();
        node.setFileId(r.getString("file_id"));
        node.setFileName(r.getString("file_name"));
        node.setFileSize(r.getString("file_size"));
        node.setFileParentFolder(r.getString("file_parent_folder"));
        node.setFileCreationDate(r.getString("file_creation_date"));
        node.setFileCreator(r.getString("file_creator"));
        node.setFilePath(r.getString("file_path"));
        return node;
    }

    private Folder resultSetAccessFolder(ResultSet r) throws SQLException {
        Folder folder = new Folder();
        folder.setFolderId(r.getString("folder_id"));
        folder.setFolderName(r.getString("folder_name"));
        folder.setFolderParent(r.getString("folder_parent"));
        folder.setFolderCreationDate(r.getString("folder_creation_date"));
        folder.setFolderCreator(r.getString("folder_creator"));
        folder.setFolderConstraint(r.getInt("folder_constraint"));
        return folder;
    }

    private void importFileInto(File f, String folderId, String type) throws Exception {
        if (f.isFile()) {
            File target;
            long size;
            block16: {
                int mb;
                String name;
                String newName = name = new String(f.getName().getBytes("UTF-8"), "UTF-8");
                per = 0;
                message = "\u6b63\u5728\u5bfc\u5165\u6587\u4ef6\uff1a" + name;
                List<Node> nodes = this.selectNodesByFolderId(folderId);
                Node node = null;
                size = f.length();
                String fileBlocks = ConfigureReader.instance().getFileBlockPath();
                if (nodes.parallelStream().anyMatch(e -> e.getFileName().equals(name))) {
                    switch (type) {
                        case "COVER": {
                            node = nodes.parallelStream().filter(e -> e.getFileName().equals(f.getName())).findFirst().get();
                            node.setFileCreationDate(ServerTimeUtil.accurateToDay());
                            node.setFileCreator("SYS_IN");
                            mb = (int)(size / 1024L / 1024L);
                            node.setFileSize(mb + "");
                            if (this.updateNode(node) != 0) break;
                            throw new SQLException();
                        }
                        case "BOTH": {
                            newName = FileNodeUtil.getNewNodeName(name, nodes);
                            break;
                        }
                        default: {
                            per = 100;
                            return;
                        }
                    }
                }
                if (node == null) {
                    node = new Node();
                    node.setFileName(newName);
                    node.setFileId(UUID.randomUUID().toString());
                    node.setFileParentFolder(folderId);
                    String id = UUID.randomUUID().toString().replace("-", "");
                    String path = "file_" + id + ".block";
                    node.setFilePath(path);
                    target = new File(fileBlocks, path);
                    target.createNewFile();
                    node.setFileCreationDate(ServerTimeUtil.accurateToDay());
                    node.setFileCreator("SYS_IN");
                    mb = (int)(size / 1024L / 1024L);
                    node.setFileSize(mb + "");
                    int i = 0;
                    while (true) {
                        try {
                            if (this.insertNode(node) == 0) {
                                throw new SQLException();
                            }
                            break block16;
                        }
                        catch (Exception e2) {
                            node.setFileId(UUID.randomUUID().toString());
                            if (++i < 10) continue;
                        }
                        break;
                    }
                }
                target = new File(fileBlocks, node.getFilePath());
            }
            FileOutputStream fileOutputStream = new FileOutputStream(target);
            FileInputStream fileInputStream = new FileInputStream(f);
            FileChannel out = fileOutputStream.getChannel();
            FileChannel in = fileInputStream.getChannel();
            ByteBuffer buffer = ByteBuffer.allocate(4096);
            int length = 0;
            long finishLength = 0L;
            while ((length = in.read(buffer)) != -1 && this.gono) {
                buffer.flip();
                out.write(buffer);
                buffer.clear();
                per = (int)((double)(finishLength += (long)length) / (double)size * 100.0);
            }
            in.close();
            out.close();
            fileInputStream.close();
            fileOutputStream.close();
            return;
        }
        throw new IllegalArgumentException();
    }

    private void importFolderInto(File f, String folderId, String type) throws Exception {
        if (f.isDirectory()) {
            int i;
            kohgylw.kiftd.server.model.Folder folder;
            block19: {
                String name;
                String newName = name = new String(f.getName().getBytes("UTF-8"), "UTF-8");
                per = 0;
                message = "\u6b63\u5728\u5bfc\u5165\u6587\u4ef6\u5939\uff1a" + name;
                Folder parent = this.selectFolderById(folderId);
                List<Folder> folders = this.getFoldersByParentId(folderId);
                folder = null;
                if (folders.parallelStream().anyMatch(e -> e.getFolderName().equals(name))) {
                    switch (type) {
                        case "COVER": {
                            folder = folders.parallelStream().filter(e -> e.getFolderName().equals(name)).findFirst().get();
                            break;
                        }
                        case "BOTH": {
                            newName = FileNodeUtil.getNewFolderName(name, folders);
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                }
                per = 50;
                if (folder == null) {
                    folder = new Folder();
                    String nFolderId = UUID.randomUUID().toString();
                    folder.setFolderId(nFolderId);
                    folder.setFolderName(newName);
                    folder.setFolderConstraint(parent.getFolderConstraint());
                    folder.setFolderParent(folderId);
                    folder.setFolderCreator("SYS_IN");
                    folder.setFolderCreationDate(ServerTimeUtil.accurateToDay());
                    i = 0;
                    while (true) {
                        try {
                            if (this.insertFolder((Folder)folder) == 0) {
                                throw new SQLException();
                            }
                            break block19;
                        }
                        catch (Exception e2) {
                            folder.setFolderId(UUID.randomUUID().toString());
                            if (++i < 10) continue;
                        }
                        break;
                    }
                }
                folder.setFolderCreationDate(ServerTimeUtil.accurateToDay());
                if (this.updateFolder((Folder)folder) == 0) {
                    throw new SQLException();
                }
            }
            per = 100;
            File[] childs = f.listFiles();
            for (i = 0; i < childs.length && this.gono; ++i) {
                if (childs[i].isDirectory()) {
                    this.importFolderInto(childs[i], folder.getFolderId(), type);
                    continue;
                }
                this.importFileInto(childs[i], folder.getFolderId(), type);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    private int deleteNodeById(String nodeId) throws SQLException {
        this.deleteNodeById.setString(1, nodeId);
        this.deleteNodeById.execute();
        return this.deleteNodeById.getUpdateCount();
    }

    private int deleteFolderById(String folderId) throws SQLException {
        this.deleteFolderById.setString(1, folderId);
        this.deleteFolderById.execute();
        return this.deleteFolderById.getUpdateCount();
    }

    private int updateNode(Node n) throws SQLException {
        this.updateNodeById.setString(1, n.getFileName());
        this.updateNodeById.setString(2, n.getFileSize());
        this.updateNodeById.setString(3, n.getFileParentFolder());
        this.updateNodeById.setString(4, n.getFileCreationDate());
        this.updateNodeById.setString(5, n.getFileCreator());
        this.updateNodeById.setString(6, n.getFilePath());
        this.updateNodeById.setString(7, n.getFileId());
        this.updateNodeById.execute();
        return this.updateNodeById.getUpdateCount();
    }

    private int updateFolder(Folder f) throws SQLException {
        this.updateFolderById.setString(1, f.getFolderName());
        this.updateFolderById.setString(2, f.getFolderCreationDate());
        this.updateFolderById.setString(3, f.getFolderCreator());
        this.updateFolderById.setString(4, f.getFolderParent());
        this.updateFolderById.setInt(5, f.getFolderConstraint());
        this.updateFolderById.setString(6, f.getFolderId());
        this.updateFolderById.execute();
        return this.updateFolderById.getUpdateCount();
    }

    private void deleteFolder(String folderId) throws SQLException {
        Folder f = this.selectFolderById(folderId);
        List<Node> nodes = this.selectNodesByFolderId(folderId);
        int size = nodes.size();
        if (f == null) {
            return;
        }
        for (int i = 0; i < size && this.gono; ++i) {
            this.deleteFile(nodes.get(i).getFileId());
        }
        List<Folder> folders = this.getFoldersByParentId(folderId);
        size = folders.size();
        for (int i = 0; i < size && this.gono; ++i) {
            this.deleteFolder(folders.get(i).getFolderId());
        }
        per = 50;
        message = "\u6b63\u5728\u5220\u9664\u6587\u4ef6\u5939\uff1a" + f.getFolderName();
        if (this.deleteFolderById(folderId) > 0) {
            per = 100;
            return;
        }
        throw new SQLException();
    }

    private void deleteFile(String nodeId) throws SQLException {
        Node n = this.selectNodeById(nodeId);
        per = 50;
        message = "\u6b63\u5728\u5220\u9664\u6587\u4ef6\uff1a" + n.getFileName();
        if (n != null) {
            if (new File(ConfigureReader.instance().getFileBlockPath(), n.getFilePath()).delete()) {
                per = 80;
                if (this.deleteNodeById(nodeId) > 0) {
                    per = 100;
                    return;
                }
            }
            throw new SQLException();
        }
    }

    private void exportNode(String nodeId, File path, String type) throws Exception {
        Node node = this.selectNodeById(nodeId);
        File target = null;
        if (node != null && path != null && path.isDirectory()) {
            per = 0;
            message = "\u6b63\u5728\u5bfc\u51fa\u6587\u4ef6\uff1a" + node.getFileName();
            if (((Stream)Arrays.stream(path.listFiles()).parallel()).filter(e -> e.isFile()).anyMatch(f -> new String(f.getName().getBytes()).equals(node.getFileName()))) {
                switch (type) {
                    case "COVER": {
                        target = ((Stream)Arrays.stream(path.listFiles()).parallel()).filter(e -> e.isFile()).filter(e -> new String(e.getName().getBytes()).equals(node.getFileName())).findFirst().get();
                        break;
                    }
                    case "BOTH": {
                        target = new File(path, new String(FileNodeUtil.getNewNodeName(node, path).getBytes()));
                        target.createNewFile();
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (target == null) {
                target = new File(path, new String(node.getFileName().getBytes()));
                target.createNewFile();
            }
            File block = new File(ConfigureReader.instance().getFileBlockPath(), node.getFilePath());
            long size = block.length();
            FileInputStream in = new FileInputStream(block);
            FileOutputStream out = new FileOutputStream(target);
            FileChannel fci = in.getChannel();
            FileChannel fco = out.getChannel();
            ByteBuffer buffer = ByteBuffer.allocate(4096);
            int length = 0;
            long finishLength = 0L;
            while ((length = fci.read(buffer)) != -1 && this.gono) {
                buffer.flip();
                fco.write(buffer);
                buffer.clear();
                per = (int)((double)(finishLength += (long)length) / (double)size * 100.0);
            }
            fci.close();
            fco.close();
            in.close();
            out.close();
            return;
        }
        throw new IllegalArgumentException();
    }

    private void exportFolder(String folderId, File path, String type) throws Exception {
        Folder folder = this.selectFolderById(folderId);
        File target = null;
        per = 0;
        message = "\u6b63\u5728\u5bfc\u51fa\u6587\u4ef6\u5939\uff1a" + folder.getFolderName();
        if (folder != null && path != null && path.isDirectory()) {
            if (((Stream)Arrays.stream(path.listFiles()).parallel()).filter(e -> e.isDirectory()).anyMatch(f -> new String(f.getName().getBytes()).equals(folder.getFolderName()))) {
                switch (type) {
                    case "COVER": {
                        target = ((Stream)Arrays.stream(path.listFiles()).parallel()).filter(e -> e.isDirectory()).filter(e -> new String(e.getName().getBytes()).equals(folder.getFolderName())).findFirst().get();
                        break;
                    }
                    case "BOTH": {
                        target = new File(path, new String(FileNodeUtil.getNewFolderName(folder, path).getBytes()));
                        target.mkdir();
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (((Stream)Arrays.stream(path.listFiles()).parallel()).filter(e -> e.isFile()).anyMatch(e -> new String(e.getName().getBytes()).equals(folder.getFolderName()))) {
                target = new File(path, new String(folder.getFolderName().getBytes()) + "_\u4e0e\u6587\u4ef6\u540c\u540d" + UUID.randomUUID().toString().replaceAll("-", ""));
                target.mkdir();
            }
            if (target == null) {
                target = new File(path, new String(folder.getFolderName().getBytes()));
                target.mkdir();
            }
            per = 100;
            List<Node> nodes = this.selectNodesByFolderId(folderId);
            List<Folder> folders = this.getFoldersByParentId(folderId);
            int size = 0;
            int i = 0;
            size = nodes.size();
            for (i = 0; i < size && this.gono; ++i) {
                this.exportNode(nodes.get(i).getFileId(), target, type);
            }
            size = folders.size();
            for (i = 0; i < size && this.gono; ++i) {
                this.exportFolder(folders.get(i).getFolderId(), target, type);
            }
            return;
        }
        throw new IllegalArgumentException();
    }

    public void cannel() {
        message = "\u6b63\u5728\u7ec8\u6b62\uff0c\u8bf7\u7a0d\u5019...";
        this.gono = false;
    }
}

