/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.ui.util;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import kohgylw.kiftd.server.model.Node;
import kohgylw.kiftd.util.file_system_manager.pojo.Folder;

public class FilesTable
extends JTable {
    private static final String[] columns = new String[]{"\u540d\u79f0", "\u521b\u5efa\u65e5\u671f", "\u5927\u5c0f\uff08MB\uff09", "\u521b\u5efa\u8005"};
    private static List<Folder> folders;
    private static final long serialVersionUID = -3436472714356711024L;

    public FilesTable() {
        super(new Object[0][], columns);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public void updateValues(final List<Folder> folders, final List<Node> files) {
        Runnable doUpdate = new Runnable(){

            @Override
            public void run() {
                try {
                    FilesTable.this.setModel(new TableModel(){

                        @Override
                        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                        }

                        @Override
                        public void removeTableModelListener(TableModelListener l) {
                        }

                        @Override
                        public boolean isCellEditable(int rowIndex, int columnIndex) {
                            return false;
                        }

                        @Override
                        public Object getValueAt(int rowIndex, int columnIndex) {
                            switch (columnIndex) {
                                case 0: {
                                    return rowIndex < folders.size() ? "/" + ((Folder)folders.get(rowIndex)).getFolderName() : ((Node)files.get(rowIndex - folders.size())).getFileName();
                                }
                                case 1: {
                                    return rowIndex < folders.size() ? ((Folder)folders.get(rowIndex)).getFolderCreationDate() : ((Node)files.get(rowIndex - folders.size())).getFileCreationDate();
                                }
                                case 2: {
                                    return rowIndex < folders.size() ? "--" : ((Node)files.get(rowIndex - folders.size())).getFileSize();
                                }
                                case 3: {
                                    return rowIndex < folders.size() ? ((Folder)folders.get(rowIndex)).getFolderCreator() : ((Node)files.get(rowIndex - folders.size())).getFileCreator();
                                }
                            }
                            return "--";
                        }

                        @Override
                        public int getRowCount() {
                            return folders.size() + files.size();
                        }

                        @Override
                        public String getColumnName(int columnIndex) {
                            return columns[columnIndex];
                        }

                        @Override
                        public int getColumnCount() {
                            return columns.length;
                        }

                        @Override
                        public Class<?> getColumnClass(int columnIndex) {
                            return Object.class;
                        }

                        @Override
                        public void addTableModelListener(TableModelListener l) {
                        }
                    });
                    FilesTable.this.setRowFontColor();
                    FilesTable.this.validate();
                    folders = folders;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        Thread t = new Thread(() -> SwingUtilities.invokeLater(doUpdate));
        t.start();
    }

    private void setRowFontColor() {
        DefaultTableCellRenderer dtcr = new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 5132133158132959506L;

            @Override
            protected void setValue(Object value) {
                if (value instanceof String && ((String)value).startsWith("/")) {
                    this.setForeground(Color.BLUE);
                } else {
                    this.setForeground(Color.black);
                }
                this.setText((String)value);
            }
        };
        DefaultTableCellRenderer dtcr2 = new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 5132133158132959506L;

            @Override
            protected void setValue(Object value) {
                if (value instanceof String && ((String)value).equals("0")) {
                    this.setText("<1");
                } else {
                    this.setText((String)value);
                }
            }
        };
        this.getColumn(columns[0]).setCellRenderer(dtcr);
        this.getColumn(columns[2]).setCellRenderer(dtcr2);
    }

    public Folder getDoubleClickFolder(MouseEvent e) {
        int row;
        if (e.getClickCount() == 2 && (row = this.rowAtPoint(e.getPoint())) >= 0 && row < folders.size()) {
            return folders.get(row);
        }
        return null;
    }
}

