/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.ui.module;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kohgylw.kiftd.printer.Printer;
import kohgylw.kiftd.ui.callback.GetServerStatus;
import kohgylw.kiftd.ui.callback.GetServerTime;
import kohgylw.kiftd.ui.callback.OnCloseServer;
import kohgylw.kiftd.ui.callback.OnStartServer;
import kohgylw.kiftd.ui.callback.UpdateSetting;
import kohgylw.kiftd.ui.module.FSViewer;
import kohgylw.kiftd.ui.module.KiftdDynamicWindow;
import kohgylw.kiftd.ui.module.SettingWindow;

public class ServerUIModule
extends KiftdDynamicWindow {
    protected static JFrame window;
    private static SystemTray tray;
    private static TrayIcon trayIcon;
    private static JTextArea output;
    private static ServerUIModule instance;
    private static SettingWindow sw;
    private static FSViewer fsv;
    private static OnCloseServer cs;
    private static OnStartServer ss;
    private static GetServerStatus st;
    private static GetServerTime ti;
    private static JButton start;
    private static JButton stop;
    private static JButton resatrt;
    private static JButton setting;
    private static JButton fileIOUtil;
    private static JButton exit;
    private static JLabel serverStatusLab;
    private static JLabel portStatusLab;
    private static JLabel logLevelLab;
    private static JLabel bufferSizeLab;
    private static final String S_STOP = "\u505c\u6b62[Stopped]";
    private static final String S_START = "\u8fd0\u884c[Running]";
    private static final String S_STARTING = "\u542f\u52a8\u4e2d[Starting]...";
    private static final String S_STOPPING = "\u505c\u6b62\u4e2d[Stopping]...";
    protected static final String L_ALL = "\u8bb0\u5f55\u5168\u90e8(ALL)";
    protected static final String L_EXCEPTION = "\u4ec5\u5f02\u5e38(EXCEPTION)";
    protected static final String L_NONE = "\u4e0d\u8bb0\u5f55(NONE)";
    private final int OriginSize_Width = 300;
    private final int OriginSize_Height = 570;
    private static MenuItem filesViewer;

    private ServerUIModule() {
        this.setUIFont();
        window = new JFrame("kiftd-\u670d\u52a1\u5668\u63a7\u5236\u53f0");
        window.setSize(300, 570);
        window.setLocation(100, 100);
        window.setResizable(false);
        try {
            window.setIconImage(ImageIO.read(this.getClass().getResourceAsStream("/kohgylw/kiftd/ui/resource/icon.png")));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (SystemTray.isSupported()) {
            window.setDefaultCloseOperation(1);
            tray = SystemTray.getSystemTray();
            String iconType = "/kohgylw/kiftd/ui/resource/icon_tray.png";
            if (System.getProperty("os.name").toLowerCase().indexOf("window") >= 0) {
                iconType = "/kohgylw/kiftd/ui/resource/icon_tray_w.png";
            }
            try {
                trayIcon = new TrayIcon(ImageIO.read(this.getClass().getResourceAsStream(iconType)));
                trayIcon.setToolTip("\u9752\u9633\u7f51\u7edc\u6587\u4ef6\u7cfb\u7edf-kiftd");
                trayIcon.setImageAutoSize(true);
                PopupMenu pMenu = new PopupMenu();
                MenuItem exit = new MenuItem("\u9000\u51fa(Exit)");
                filesViewer = new MenuItem("\u6587\u4ef6...(Files)");
                MenuItem show = new MenuItem("\u663e\u793a\u4e3b\u7a97\u53e3(Show)");
                trayIcon.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseReleased(MouseEvent e) {
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                    }

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (e.getClickCount() == 2) {
                            ServerUIModule.this.show();
                        }
                    }
                });
                exit.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ServerUIModule.this.exit();
                    }
                });
                filesViewer.addActionListener(e -> {
                    filesViewer.setEnabled(false);
                    fileIOUtil.setEnabled(false);
                    Thread t = new Thread(() -> {
                        try {
                            fsv = FSViewer.getInstance();
                            fsv.show();
                        }
                        catch (SQLException e1) {
                            JOptionPane.showMessageDialog(window, "\u9519\u8bef\uff1a\u65e0\u6cd5\u6253\u5f00\u6587\u4ef6\uff0c\u6587\u4ef6\u7cfb\u7edf\u53ef\u80fd\u5df2\u635f\u574f\uff0c\u60a8\u53ef\u4ee5\u5c1d\u8bd5\u91cd\u542f\u5e94\u7528\u3002", "\u9519\u8bef", 0);
                        }
                        filesViewer.setEnabled(true);
                        fileIOUtil.setEnabled(true);
                    });
                    t.start();
                });
                show.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ServerUIModule.this.show();
                    }
                });
                pMenu.add(exit);
                pMenu.addSeparator();
                pMenu.add(filesViewer);
                pMenu.add(show);
                trayIcon.setPopupMenu(pMenu);
                tray.add(trayIcon);
            }
            catch (FileNotFoundException pMenu) {
            }
            catch (IOException pMenu) {
            }
            catch (AWTException pMenu) {}
        } else {
            window.setDefaultCloseOperation(1);
        }
        window.setLayout(new BoxLayout(window.getContentPane(), 3));
        JPanel titlebox = new JPanel(new FlowLayout(1));
        titlebox.setBorder(new EmptyBorder(0, 0, (int)(-25.0 * this.proportion), 0));
        JLabel title = new JLabel("kiftd");
        title.setFont(new Font("\u5b8b\u4f53", 1, (int)(30.0 * this.proportion)));
        titlebox.add(title);
        window.add(titlebox);
        JPanel subtitlebox = new JPanel(new FlowLayout(1));
        subtitlebox.setBorder(new EmptyBorder(0, 0, (int)(-20.0 * this.proportion), 0));
        JLabel subtitle = new JLabel("\u9752\u9633\u7f51\u7edc\u6587\u4ef6\u7cfb\u7edf-\u670d\u52a1\u5668");
        subtitle.setFont(new Font("\u5b8b\u4f53", 0, (int)(13.0 * this.proportion)));
        subtitlebox.add(subtitle);
        window.add(subtitlebox);
        JPanel statusBox = new JPanel(new GridLayout(4, 1));
        statusBox.setBorder(BorderFactory.createEtchedBorder());
        JPanel serverStatus = new JPanel(new FlowLayout());
        serverStatus.setBorder(new EmptyBorder(0, 0, (int)(-8.0 * this.proportion), 0));
        serverStatus.add(new JLabel("\u670d\u52a1\u5668\u72b6\u6001(Status)\uff1a"));
        serverStatusLab = new JLabel("--");
        serverStatus.add(serverStatusLab);
        statusBox.add(serverStatus);
        JPanel portStatus = new JPanel(new FlowLayout());
        portStatus.setBorder(new EmptyBorder(0, 0, (int)(-8.0 * this.proportion), 0));
        portStatus.add(new JLabel("\u7aef\u53e3\u53f7(Port)\uff1a"));
        portStatusLab = new JLabel("--");
        portStatus.add(portStatusLab);
        statusBox.add(portStatus);
        JPanel addrStatus = new JPanel(new FlowLayout());
        addrStatus.setBorder(new EmptyBorder(0, 0, (int)(-8.0 * this.proportion), 0));
        addrStatus.add(new JLabel("\u65e5\u5fd7\u7b49\u7ea7(LogLevel)\uff1a"));
        logLevelLab = new JLabel("--");
        addrStatus.add(logLevelLab);
        statusBox.add(addrStatus);
        JPanel bufferStatus = new JPanel(new FlowLayout());
        bufferStatus.setBorder(new EmptyBorder(0, 0, (int)(-8.0 * this.proportion), 0));
        bufferStatus.add(new JLabel("\u4e0b\u8f7d\u7f13\u51b2\u533a(Buffer)\uff1a"));
        bufferSizeLab = new JLabel("--");
        bufferStatus.add(bufferSizeLab);
        statusBox.add(bufferStatus);
        window.add(statusBox);
        JPanel buttonBox = new JPanel(new GridLayout(6, 1));
        start = new JButton("\u5f00\u542f(Start)>>");
        buttonBox.add(start);
        stop = new JButton("\u5173\u95ed(Stop)||");
        buttonBox.add(stop);
        resatrt = new JButton("\u91cd\u542f(Restart)~>");
        buttonBox.add(resatrt);
        fileIOUtil = new JButton("\u6587\u4ef6(Files)[*]");
        buttonBox.add(fileIOUtil);
        setting = new JButton("\u8bbe\u7f6e(Setting)[/]");
        buttonBox.add(setting);
        exit = new JButton("\u9000\u51fa(Exit)[X]");
        buttonBox.add(exit);
        window.add(buttonBox);
        JPanel outputBox = new JPanel(new FlowLayout(1));
        outputBox.add(new JLabel("[\u8f93\u51fa\u4fe1\u606f(Server Message)]\uff1a"));
        output = new JTextArea();
        output.setLineWrap(true);
        output.setRows(3 + (int)this.proportion);
        output.setSize((int)(292.0 * this.proportion), 100);
        output.setEditable(false);
        output.setForeground(Color.RED);
        output.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                Thread t = new Thread(() -> {
                    if (output.getLineCount() >= 1000) {
                        int end = 0;
                        try {
                            end = output.getLineEndOffset(100);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        output.replaceRange("", 0, end);
                    }
                    output.setCaretPosition(output.getText().length());
                });
                t.start();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                output.selectAll();
                output.setCaretPosition(output.getSelectedText().length());
                output.requestFocus();
            }
        });
        outputBox.add(new JScrollPane(output));
        window.add(outputBox);
        JPanel bottombox = new JPanel(new FlowLayout(1));
        bottombox.setBorder(new EmptyBorder(0, 0, (int)(-30.0 * this.proportion), 0));
        bottombox.add(new JLabel("--\u9752\u9633\u9f99\u91ce@kohgylw--"));
        window.add(bottombox);
        start.setEnabled(false);
        stop.setEnabled(false);
        resatrt.setEnabled(false);
        setting.setEnabled(false);
        start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                start.setEnabled(false);
                setting.setEnabled(false);
                fileIOUtil.setEnabled(false);
                filesViewer.setEnabled(false);
                ServerUIModule.this.printMessage("\u542f\u52a8\u670d\u52a1\u5668...");
                if (ss != null) {
                    serverStatusLab.setText(ServerUIModule.S_STARTING);
                    Thread t = new Thread(() -> {
                        if (ss.start()) {
                            ServerUIModule.this.printMessage("\u542f\u52a8\u5b8c\u6210\u3002\u6b63\u5728\u68c0\u67e5\u670d\u52a1\u5668\u72b6\u6001...");
                            if (st.getServerStatus()) {
                                ServerUIModule.this.printMessage("KIFT\u670d\u52a1\u5668\u5df2\u7ecf\u542f\u52a8\uff0c\u53ef\u4ee5\u6b63\u5e38\u8bbf\u95ee\u4e86\u3002");
                            } else {
                                ServerUIModule.this.printMessage("KIFT\u670d\u52a1\u5668\u672a\u80fd\u6210\u529f\u542f\u52a8\uff0c\u8bf7\u68c0\u67e5\u8bbe\u7f6e\u6216\u67e5\u770b\u5f02\u5e38\u4fe1\u606f\u3002");
                            }
                        } else {
                            ServerUIModule.this.printMessage("KIFT\u65e0\u6cd5\u542f\u52a8\uff0c\u8bf7\u68c0\u67e5\u8bbe\u7f6e\u3002");
                            serverStatusLab.setText(ServerUIModule.S_STOP);
                        }
                        ServerUIModule.this.updateServerStatus();
                    });
                    t.start();
                }
            }
        });
        stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                stop.setEnabled(false);
                resatrt.setEnabled(false);
                fileIOUtil.setEnabled(false);
                filesViewer.setEnabled(false);
                ServerUIModule.this.printMessage("\u5173\u95ed\u670d\u52a1\u5668...");
                Thread t = new Thread(() -> {
                    if (cs != null) {
                        serverStatusLab.setText(ServerUIModule.S_STOPPING);
                        if (cs.close()) {
                            ServerUIModule.this.printMessage("\u5173\u95ed\u5b8c\u6210\u3002\u6b63\u5728\u68c0\u67e5\u670d\u52a1\u5668\u72b6\u6001...");
                            if (st.getServerStatus()) {
                                ServerUIModule.this.printMessage("KIFT\u670d\u52a1\u5668\u672a\u80fd\u6210\u529f\u5173\u95ed\uff0c\u5982\u6709\u9700\u8981\uff0c\u53ef\u4ee5\u5f3a\u5236\u5173\u95ed\u7a0b\u5e8f\uff08\u4e0d\u5b89\u5168\uff09\u3002");
                            } else {
                                ServerUIModule.this.printMessage("KIFT\u670d\u52a1\u5668\u5df2\u7ecf\u5173\u95ed\uff0c\u505c\u6b62\u6240\u6709\u8bbf\u95ee\u3002");
                            }
                        } else {
                            ServerUIModule.this.printMessage("KIFT\u670d\u52a1\u5668\u65e0\u6cd5\u5173\u95ed\uff0c\u8bf7\u624b\u52a8\u7ed3\u675f\u672c\u7a0b\u5e8f\u3002");
                        }
                        ServerUIModule.this.updateServerStatus();
                    }
                });
                t.start();
            }
        });
        exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fileIOUtil.setEnabled(false);
                filesViewer.setEnabled(false);
                ServerUIModule.this.exit();
            }
        });
        resatrt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                stop.setEnabled(false);
                resatrt.setEnabled(false);
                fileIOUtil.setEnabled(false);
                filesViewer.setEnabled(false);
                Thread t = new Thread(() -> {
                    ServerUIModule.this.printMessage("\u6b63\u5728\u91cd\u542f\u670d\u52a1\u5668...");
                    if (cs.close()) {
                        if (ss.start()) {
                            ServerUIModule.this.printMessage("\u91cd\u542f\u6210\u529f\uff0c\u53ef\u4ee5\u6b63\u5e38\u8bbf\u95ee\u4e86\u3002");
                        } else {
                            ServerUIModule.this.printMessage("\u9519\u8bef\uff1a\u670d\u52a1\u5668\u5df2\u5173\u95ed\u4f46\u672a\u80fd\u91cd\u65b0\u542f\u52a8\uff0c\u8bf7\u5c1d\u8bd5\u624b\u52a8\u542f\u52a8\u670d\u52a1\u5668\u3002");
                        }
                    } else {
                        ServerUIModule.this.printMessage("\u9519\u8bef\uff1a\u65e0\u6cd5\u5173\u95ed\u670d\u52a1\u5668\uff0c\u8bf7\u5c1d\u8bd5\u624b\u52a8\u5173\u95ed\u3002");
                    }
                    ServerUIModule.this.updateServerStatus();
                });
                t.start();
            }
        });
        setting.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                sw = SettingWindow.getInstance();
                Thread t = new Thread(() -> sw.show());
                t.start();
            }
        });
        fileIOUtil.addActionListener(e -> {
            fileIOUtil.setEnabled(false);
            filesViewer.setEnabled(false);
            Thread t = new Thread(() -> {
                try {
                    fsv = FSViewer.getInstance();
                    fsv.show();
                }
                catch (SQLException e1) {
                    Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u8bfb\u53d6\u6587\u4ef6\uff0c\u6587\u4ef6\u7cfb\u7edf\u53ef\u80fd\u5df2\u7ecf\u635f\u574f\uff0c\u60a8\u53ef\u4ee5\u5c1d\u8bd5\u91cd\u542f\u5e94\u7528\u3002");
                }
                fileIOUtil.setEnabled(true);
                filesViewer.setEnabled(true);
            });
            t.start();
        });
        this.modifyComponentSize(window);
    }

    public void show() {
        window.setVisible(true);
    }

    public static void setOnCloseServer(OnCloseServer cs) {
        ServerUIModule.cs = cs;
    }

    public static ServerUIModule getInsatnce() {
        if (instance == null) {
            instance = new ServerUIModule();
        }
        return instance;
    }

    public static void setStartServer(OnStartServer ss) {
        ServerUIModule.ss = ss;
    }

    public static void setGetServerStatus(GetServerStatus st) {
        ServerUIModule.st = st;
        SettingWindow.st = st;
    }

    public void updateServerStatus() {
        Thread t = new Thread(() -> {
            if (st != null) {
                if (st.getServerStatus()) {
                    serverStatusLab.setText(S_START);
                    start.setEnabled(false);
                    stop.setEnabled(true);
                    resatrt.setEnabled(true);
                    setting.setEnabled(false);
                } else {
                    serverStatusLab.setText(S_STOP);
                    start.setEnabled(true);
                    stop.setEnabled(false);
                    resatrt.setEnabled(false);
                    setting.setEnabled(true);
                }
                fileIOUtil.setEnabled(true);
                filesViewer.setEnabled(true);
                portStatusLab.setText(st.getPort() + "");
                switch (st.getLogLevel()) {
                    case Event: {
                        logLevelLab.setText(L_ALL);
                        break;
                    }
                    case None: {
                        logLevelLab.setText(L_NONE);
                        break;
                    }
                    case Runtime_Exception: {
                        logLevelLab.setText(L_EXCEPTION);
                        break;
                    }
                    default: {
                        logLevelLab.setText("\u65e0\u6cd5\u83b7\u53d6(?)");
                    }
                }
                bufferSizeLab.setText(st.getBufferSize() / 1024 + " KB");
            }
        });
        t.start();
    }

    private void exit() {
        start.setEnabled(false);
        stop.setEnabled(false);
        exit.setEnabled(false);
        resatrt.setEnabled(false);
        setting.setEnabled(false);
        this.printMessage("\u9000\u51fa\u7a0b\u5e8f...");
        if (cs != null) {
            Thread t = new Thread(() -> {
                if (st.getServerStatus()) {
                    cs.close();
                }
                System.exit(0);
            });
            t.start();
        } else {
            System.exit(0);
        }
    }

    public void printMessage(String context) {
        output.append("[" + this.getFormateDate() + "]" + context + "\n");
    }

    private String getFormateDate() {
        if (ti != null) {
            Date d = ti.get();
            return new SimpleDateFormat("YYYY-MM-dd hh:mm:ss").format(d);
        }
        return new SimpleDateFormat("YYYY-MM-dd hh:mm:ss").format(new Date());
    }

    public static void setGetServerTime(GetServerTime ti) {
        ServerUIModule.ti = ti;
    }

    public static void setUpdateSetting(UpdateSetting us) {
        SettingWindow.us = us;
    }
}

