/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.ui.module;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kohgylw.kiftd.printer.Printer;
import kohgylw.kiftd.server.util.FileNodeUtil;
import kohgylw.kiftd.ui.module.FSProgressDialog;
import kohgylw.kiftd.ui.module.KiftdDynamicWindow;
import kohgylw.kiftd.ui.module.ServerUIModule;
import kohgylw.kiftd.ui.util.FilesTable;
import kohgylw.kiftd.util.file_system_manager.FileSystemManager;
import kohgylw.kiftd.util.file_system_manager.pojo.Folder;
import kohgylw.kiftd.util.file_system_manager.pojo.FolderView;

public class FSViewer
extends KiftdDynamicWindow {
    protected static JDialog window;
    private JButton homeBtn;
    private JButton backToParentFolder;
    private JButton importBtn;
    private JButton exportBtn;
    private JButton deleteBtn;
    private JButton refreshBtn;
    private FilesTable filesTable;
    private static FSViewer fsv;
    private static FolderView currentView;
    private static Executor worker;

    private FSViewer() throws SQLException {
        this.setUIFont();
        worker = Executors.newSingleThreadExecutor();
        window = new JDialog((Frame)ServerUIModule.window, "kiftd-ROOT");
        window.setSize(750, 450);
        window.setDefaultCloseOperation(1);
        window.setLocation(150, 150);
        window.setResizable(true);
        Container c = window.getContentPane();
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        this.homeBtn = new JButton("\u6839\u76ee\u5f55[/Root]");
        this.backToParentFolder = new JButton("\u4e0a\u4e00\u7ea7[^]");
        this.importBtn = new JButton("\u5bfc\u5165[<-]");
        this.exportBtn = new JButton("\u5bfc\u51fa[->]");
        this.deleteBtn = new JButton("\u5220\u9664[X]");
        this.refreshBtn = new JButton("\u5237\u65b0[*]");
        this.homeBtn.setPreferredSize(new Dimension((int)(110.0 * this.proportion), (int)(35.0 * this.proportion)));
        this.homeBtn.setEnabled(false);
        this.backToParentFolder.setPreferredSize(new Dimension((int)(110.0 * this.proportion), (int)(35.0 * this.proportion)));
        this.backToParentFolder.setEnabled(false);
        this.importBtn.setPreferredSize(new Dimension((int)(110.0 * this.proportion), (int)(35.0 * this.proportion)));
        this.exportBtn.setPreferredSize(new Dimension((int)(110.0 * this.proportion), (int)(35.0 * this.proportion)));
        this.exportBtn.setEnabled(false);
        this.deleteBtn.setPreferredSize(new Dimension((int)(105.0 * this.proportion), (int)(35.0 * this.proportion)));
        this.deleteBtn.setEnabled(false);
        this.refreshBtn.setPreferredSize(new Dimension((int)(105.0 * this.proportion), (int)(35.0 * this.proportion)));
        toolBar.add(this.homeBtn);
        toolBar.add(this.backToParentFolder);
        toolBar.addSeparator();
        toolBar.add(this.importBtn);
        toolBar.addSeparator();
        toolBar.add(this.exportBtn);
        toolBar.add(this.deleteBtn);
        toolBar.addSeparator();
        toolBar.add(this.refreshBtn);
        c.add((Component)toolBar, "North");
        this.homeBtn.addActionListener(e -> {
            this.disableAllButtons();
            worker.execute(() -> {
                try {
                    this.getFolderView("root");
                }
                catch (Exception e1) {
                    JOptionPane.showMessageDialog(window, "\u51fa\u73b0\u610f\u5916\u9519\u8bef\uff1a\u65e0\u6cd5\u8bfb\u53d6\u6587\u4ef6\u5217\u8868\uff0c\u8bf7\u91cd\u8bd5\u6216\u91cd\u542f\u5e94\u7528\u3002", "\u9519\u8bef", 0);
                }
                this.enableAllButtons();
            });
        });
        this.backToParentFolder.addActionListener(e -> {
            this.disableAllButtons();
            worker.execute(() -> {
                try {
                    this.getFolderView(currentView.getCurrent().getFolderParent());
                }
                catch (Exception e1) {
                    JOptionPane.showMessageDialog(window, "\u51fa\u73b0\u610f\u5916\u9519\u8bef\uff1a\u65e0\u6cd5\u8bfb\u53d6\u6587\u4ef6\u5217\u8868\uff0c\u8bf7\u91cd\u8bd5\u6216\u91cd\u542f\u5e94\u7528\u3002", "\u9519\u8bef", 0);
                }
                this.enableAllButtons();
            });
        });
        this.importBtn.addActionListener(e -> {
            this.disableAllButtons();
            JFileChooser importChooer = new JFileChooser();
            importChooer.setMultiSelectionEnabled(true);
            importChooer.setFileSelectionMode(2);
            importChooer.setPreferredSize(this.fileChooerSize);
            importChooer.setDialogTitle("\u8bf7\u9009\u62e9...");
            if (importChooer.showOpenDialog(null) == 0) {
                worker.execute(() -> {
                    this.doImport(importChooer.getSelectedFiles());
                    this.enableAllButtons();
                });
            } else {
                this.enableAllButtons();
            }
        });
        this.exportBtn.addActionListener(e -> {
            JFileChooser exportChooer = new JFileChooser();
            exportChooer.setFileSelectionMode(1);
            exportChooer.setPreferredSize(this.fileChooerSize);
            exportChooer.setDialogTitle("\u5bfc\u51fa\u5230...");
            if (exportChooer.showOpenDialog(null) == 0) {
                this.disableAllButtons();
                worker.execute(() -> {
                    File path = exportChooer.getSelectedFile();
                    int[] selected = this.filesTable.getSelectedRows();
                    ArrayList<String> selectedNodes = new ArrayList<String>();
                    ArrayList<String> selectedFolders = new ArrayList<String>();
                    int borderIndex = currentView.getFolders().size();
                    for (int i : selected) {
                        if (i < borderIndex) {
                            selectedFolders.add(currentView.getFolders().get(i).getFolderId());
                            continue;
                        }
                        selectedNodes.add(currentView.getFiles().get(i - borderIndex).getFileId());
                    }
                    String[] folders = selectedFolders.toArray(new String[0]);
                    String[] nodes = selectedNodes.toArray(new String[0]);
                    int exi = 0;
                    try {
                        exi = FileSystemManager.getInstance().hasExistsFilesOrFolders(folders, nodes, path);
                    }
                    catch (Exception e2) {
                        JOptionPane.showMessageDialog(window, "\u51fa\u73b0\u610f\u5916\u9519\u8bef\uff0c\u65e0\u6cd5\u5bfc\u51fa\u6587\u4ef6\uff0c\u8bf7\u91cd\u8bd5\u3002", "\u9519\u8bef", 0);
                        this.refresh();
                        this.enableAllButtons();
                        return;
                    }
                    String type = null;
                    if (exi > 0) {
                        switch (JOptionPane.showConfirmDialog(window, "\u8be5\u8def\u5f84\u5b58\u5728" + exi + "\u4e2a\u540c\u540d\u6587\u4ef6\u6216\u6587\u4ef6\u5939\uff0c\u60a8\u5e0c\u671b\u8986\u76d6\u5b83\u4eec\u4e48\uff1f\uff08\u201c\u662f\u201d\u8986\u76d6\uff0c\u201c\u5426\u201d\u4fdd\u7559\u4e24\u8005\uff0c\u201c\u53d6\u6d88\u201d\u7ec8\u6b62\u5bfc\u5165\uff09", "\u5bfc\u5165", 1)) {
                            case 0: {
                                type = "COVER";
                                break;
                            }
                            case 1: {
                                type = "BOTH";
                                break;
                            }
                            default: {
                                type = "CANCEL";
                                this.enableAllButtons();
                                return;
                            }
                        }
                    }
                    FSProgressDialog fsd = FSProgressDialog.getNewInstance();
                    Thread deleteListenerDialog = new Thread(() -> fsd.show());
                    deleteListenerDialog.start();
                    try {
                        FileSystemManager.getInstance().exportTo(folders, nodes, path, type);
                        fsd.close();
                    }
                    catch (Exception e1) {
                        fsd.close();
                        JOptionPane.showMessageDialog(window, "\u5bfc\u51fa\u6587\u4ef6\u65f6\u5931\u8d25\uff0c\u8be5\u64cd\u4f5c\u5df2\u88ab\u4e2d\u65ad\uff0c\u672a\u80fd\u5168\u90e8\u5bfc\u51fa\u3002", "\u9519\u8bef", 0);
                    }
                    this.refresh();
                    this.enableAllButtons();
                });
            }
        });
        this.deleteBtn.addActionListener(e -> {
            this.disableAllButtons();
            if (JOptionPane.showConfirmDialog(window, "\u786e\u8ba4\u8981\u5220\u9664\u8fd9\u4e9b\u6587\u4ef6\u4e48\uff1f\u8b66\u544a\uff1a\u8be5\u64cd\u4f5c\u65e0\u6cd5\u6062\u590d\u3002", "\u5220\u9664", 0) == 0) {
                final int[] selected = this.filesTable.getSelectedRows();
                worker.execute(() -> {
                    Runnable doDeleteThread = new Runnable(){

                        @Override
                        public void run() {
                            ArrayList<String> selectedNodes = new ArrayList<String>();
                            ArrayList<String> selectedFolders = new ArrayList<String>();
                            int borderIndex = currentView.getFolders().size();
                            for (int i : selected) {
                                if (i < borderIndex) {
                                    selectedFolders.add(currentView.getFolders().get(i).getFolderId());
                                    continue;
                                }
                                selectedNodes.add(currentView.getFiles().get(i - borderIndex).getFileId());
                            }
                            FSProgressDialog fsd = FSProgressDialog.getNewInstance();
                            Thread deleteListenerDialog = new Thread(() -> fsd.show());
                            deleteListenerDialog.start();
                            try {
                                FileSystemManager.getInstance().delete(selectedFolders.toArray(new String[0]), selectedNodes.toArray(new String[0]));
                                fsd.close();
                            }
                            catch (Exception e1) {
                                fsd.close();
                                JOptionPane.showMessageDialog(window, "\u5220\u9664\u6587\u4ef6\u65f6\u5931\u8d25\uff0c\u8be5\u64cd\u4f5c\u5df2\u88ab\u4e2d\u65ad\uff0c\u672a\u80fd\u5168\u90e8\u5220\u9664\u3002", "\u9519\u8bef", 0);
                                FSViewer.this.refresh();
                            }
                            FSViewer.this.refresh();
                            FSViewer.this.enableAllButtons();
                        }
                    };
                    SwingUtilities.invokeLater(doDeleteThread);
                });
            } else {
                this.enableAllButtons();
            }
        });
        this.refreshBtn.addActionListener(e -> {
            this.disableAllButtons();
            worker.execute(() -> {
                this.refresh();
                this.enableAllButtons();
            });
        });
        this.filesTable = new FilesTable();
        this.filesTable.setRowHeight((int)(16.0 * this.proportion));
        JScrollPane mianPane = new JScrollPane(this.filesTable);
        this.filesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (FSViewer.this.filesTable.getSelectedRows().length > 0) {
                    FSViewer.this.exportBtn.setEnabled(true);
                    FSViewer.this.deleteBtn.setEnabled(true);
                } else {
                    FSViewer.this.exportBtn.setEnabled(false);
                    FSViewer.this.deleteBtn.setEnabled(false);
                }
            }
        });
        this.filesTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                FSViewer.this.disableAllButtons();
                worker.execute(() -> {
                    Folder f = FSViewer.this.filesTable.getDoubleClickFolder(e);
                    if (f != null) {
                        try {
                            FSViewer.this.getFolderView(f.getFolderId());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    FSViewer.this.enableAllButtons();
                });
            }
        });
        DropTargetListener dtl = new DropTargetListener(){

            @Override
            public void dropActionChanged(DropTargetDragEvent dtde) {
            }

            @Override
            public void drop(DropTargetDropEvent dtde) {
                if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    dtde.acceptDrop(3);
                    try {
                        Object dropTarget = dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                        final List files = (List)dropTarget;
                        dtde.dropComplete(true);
                        worker.execute(() -> {
                            Runnable doImportThread = new Runnable(){

                                @Override
                                public void run() {
                                    FSViewer.this.disableAllButtons();
                                    FSViewer.this.doImport(files.toArray(new File[0]));
                                    FSViewer.this.enableAllButtons();
                                }
                            };
                            SwingUtilities.invokeLater(doImportThread);
                        });
                    }
                    catch (Exception e) {
                        worker.execute(() -> {
                            Runnable refreshThread = new Runnable(){

                                @Override
                                public void run() {
                                    FSViewer.this.refresh();
                                }
                            };
                            SwingUtilities.invokeLater(refreshThread);
                        });
                    }
                }
            }

            @Override
            public void dragOver(DropTargetDragEvent dtde) {
            }

            @Override
            public void dragExit(DropTargetEvent dte) {
            }

            @Override
            public void dragEnter(DropTargetDragEvent dtde) {
            }
        };
        window.setDropTarget(new DropTarget(window, 3, dtl));
        c.add(mianPane);
        this.modifyComponentSize(window);
    }

    private void refresh() {
        try {
            this.getFolderView(currentView.getCurrent().getFolderId());
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(window, "\u65e0\u6cd5\u5237\u65b0\u6587\u4ef6\u5217\u8868\uff0c\u8bf7\u91cd\u8bd5\u6216\u8fd4\u56de\u6839\u76ee\u5f55\u3002", "\u9519\u8bef", 0);
        }
    }

    public void show() {
        this.disableAllButtons();
        FileNodeUtil.initNodeTableToDataBase();
        try {
            if (currentView == null) {
                this.getFolderView("root");
            } else {
                this.refresh();
            }
            this.enableAllButtons();
            window.setVisible(true);
        }
        catch (Exception e) {
            Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u6253\u5f00\u6587\u4ef6\u7cfb\u7edf\uff0c\u8be5\u6587\u4ef6\u7cfb\u7edf\u53ef\u80fd\u6b63\u5728\u88ab\u53e6\u4e00\u4e2akiftd\u5360\u7528\u3002");
        }
    }

    private void getFolderView(String folderId) throws Exception {
        currentView = FileSystemManager.getInstance().getFolderView(folderId);
        if (currentView != null && currentView.getCurrent() != null) {
            this.filesTable.updateValues(currentView.getFolders(), currentView.getFiles());
            window.setTitle("kiftd-" + currentView.getCurrent().getFolderName());
        } else {
            this.getFolderView("root");
        }
    }

    public static FSViewer getInstance() throws SQLException {
        if (fsv == null) {
            fsv = new FSViewer();
        }
        return fsv;
    }

    private void doImport(File[] files) {
        int exi = 0;
        String folderId = currentView.getCurrent().getFolderId();
        try {
            exi = FileSystemManager.getInstance().hasExistsFilesOrFolders(files, folderId);
        }
        catch (SQLException e1) {
            JOptionPane.showMessageDialog(window, "\u51fa\u73b0\u610f\u5916\u9519\u8bef\uff0c\u65e0\u6cd5\u5bfc\u5165\u6587\u4ef6\uff0c\u8bf7\u5237\u65b0\u6216\u91cd\u542f\u5e94\u7528\u540e\u91cd\u8bd5\u3002", "\u9519\u8bef", 0);
            this.refresh();
            return;
        }
        String type = null;
        if (exi > 0) {
            switch (JOptionPane.showConfirmDialog(window, "\u8be5\u8def\u5f84\u5b58\u5728" + exi + "\u4e2a\u540c\u540d\u6587\u4ef6\u6216\u6587\u4ef6\u5939\uff0c\u60a8\u5e0c\u671b\u8986\u76d6\u5b83\u4eec\u4e48\uff1f\uff08\u201c\u662f\u201d\u8986\u76d6\uff0c\u201c\u5426\u201d\u4fdd\u7559\u4e24\u8005\uff0c\u201c\u53d6\u6d88\u201d\u7ec8\u6b62\u5bfc\u5165\uff09", "\u5bfc\u5165", 1)) {
                case 0: {
                    type = "COVER";
                    break;
                }
                case 1: {
                    type = "BOTH";
                    break;
                }
                default: {
                    type = "CANCEL";
                    return;
                }
            }
        }
        FSProgressDialog fsd = FSProgressDialog.getNewInstance();
        Thread importListenerDialog = new Thread(() -> fsd.show());
        importListenerDialog.start();
        try {
            FileSystemManager.getInstance().importFrom(files, folderId, type);
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(window, "\u5bfc\u5165\u6587\u4ef6\u65f6\u5931\u8d25\uff0c\u8be5\u64cd\u4f5c\u5df2\u88ab\u4e2d\u65ad\uff0c\u672a\u80fd\u5168\u90e8\u5bfc\u5165\u3002", "\u9519\u8bef", 0);
        }
        fsd.close();
        this.refresh();
    }

    private void disableAllButtons() {
        this.homeBtn.setEnabled(false);
        this.backToParentFolder.setEnabled(false);
        this.importBtn.setEnabled(false);
        this.exportBtn.setEnabled(false);
        this.deleteBtn.setEnabled(false);
        this.refreshBtn.setEnabled(false);
    }

    private void enableAllButtons() {
        this.refreshBtn.setEnabled(true);
        this.importBtn.setEnabled(true);
        if (this.filesTable.getSelectedRows().length > 0) {
            this.exportBtn.setEnabled(true);
            this.deleteBtn.setEnabled(true);
        }
        if (currentView != null && !"null".equals(currentView.getCurrent().getFolderParent())) {
            this.backToParentFolder.setEnabled(true);
            this.homeBtn.setEnabled(true);
        }
    }
}

