/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import kohgylw.kiftd.server.mapper.NodeMapper;
import kohgylw.kiftd.server.model.Node;
import kohgylw.kiftd.server.pojo.VideoTranscodeThread;
import kohgylw.kiftd.server.util.ConfigureReader;
import kohgylw.kiftd.server.util.FileBlockUtil;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.stereotype.Component;
import ws.schild.jave.AudioAttributes;
import ws.schild.jave.EncodingAttributes;
import ws.schild.jave.VideoAttributes;

@Component
public class VideoTranscodeUtil {
    private EncodingAttributes ea;
    @Resource
    private FileBlockUtil fbu;
    @Resource
    private NodeMapper nm;
    public static Map<String, VideoTranscodeThread> videoTranscodeThreads = new HashMap<String, VideoTranscodeThread>();

    public VideoTranscodeUtil() {
        AudioAttributes audio = new AudioAttributes();
        audio.setCodec("libmp3lame");
        audio.setBitRate(Integer.valueOf(128000));
        audio.setChannels(Integer.valueOf(2));
        audio.setSamplingRate(Integer.valueOf(44100));
        VideoAttributes video = new VideoAttributes();
        video.setCodec("libx264");
        this.ea = new EncodingAttributes();
        this.ea.setFormat("MP4");
        this.ea.setVideoAttributes(video);
        this.ea.setAudioAttributes(audio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTranscodeProcess(String fId) throws Exception {
        Map<String, VideoTranscodeThread> map = videoTranscodeThreads;
        synchronized (map) {
            String suffix;
            VideoTranscodeThread vtt = videoTranscodeThreads.get(fId);
            Node n = this.nm.queryById(fId);
            File f = this.fbu.getFileFromBlocks(n);
            if (vtt != null) {
                if ("FIN".equals(vtt.getProgress())) {
                    String md5 = DigestUtils.md5Hex((InputStream)new FileInputStream(f));
                    if (md5.equals(vtt.getMd5()) && new File(ConfigureReader.instance().getTemporaryfilePath(), vtt.getOutputFileName()).isFile()) {
                        return vtt.getProgress();
                    }
                    videoTranscodeThreads.remove(fId);
                } else {
                    return vtt.getProgress();
                }
            }
            switch (suffix = n.getFileName().substring(n.getFileName().lastIndexOf(".") + 1).toLowerCase()) {
                case "mp4": 
                case "webm": 
                case "mov": 
                case "avi": 
                case "wmv": 
                case "mkv": 
                case "flv": {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            videoTranscodeThreads.put(fId, new VideoTranscodeThread(f, this.ea));
            return "0.0";
        }
    }
}

