/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.util;

import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfWriter;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import kohgylw.kiftd.server.util.CharsetDetectionObserverImpl;
import org.mozilla.intl.chardet.nsDetector;
import org.mozilla.intl.chardet.nsICharsetDetectionObserver;
import org.springframework.stereotype.Component;

@Component
public class Txt2PDFUtil {
    public void convertPdf(File in, OutputStream out) throws Exception {
        Rectangle rect = new Rectangle(PageSize.A4);
        Document doc = new Document(rect);
        PdfWriter pw = PdfWriter.getInstance((Document)doc, (OutputStream)out);
        doc.open();
        BaseFont songFont = BaseFont.createFont((String)"fonts/wqy-zenhei.ttc,0", (String)"Identity-H", (boolean)false);
        Font font = new Font(songFont, 12.0f, 0);
        Paragraph paragraph = new Paragraph();
        paragraph.setFont(font);
        String charset = this.getTxtCharset(new FileInputStream(in));
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(in), charset));
        String line = null;
        while ((line = reader.readLine()) != null) {
            paragraph.add((Object)(line + "\n"));
        }
        reader.close();
        doc.add((Element)paragraph);
        doc.close();
        pw.flush();
        pw.close();
    }

    private String getTxtCharset(InputStream in) throws Exception {
        int len;
        int lang = 2;
        nsDetector det = new nsDetector(lang);
        CharsetDetectionObserverImpl cdoi = new CharsetDetectionObserverImpl();
        det.Init((nsICharsetDetectionObserver)cdoi);
        BufferedInputStream imp = new BufferedInputStream(in);
        byte[] buf = new byte[1024];
        boolean isAscii = true;
        while ((len = imp.read(buf, 0, buf.length)) != -1) {
            if (isAscii) {
                isAscii = det.isAscii(buf, len);
            }
            if (isAscii || !det.DoIt(buf, len, false)) continue;
        }
        imp.close();
        in.close();
        det.DataEnd();
        if (isAscii) {
            return "ASCII";
        }
        if (cdoi.getCharset() != null) {
            return cdoi.getCharset();
        }
        String[] prob = det.getProbableCharsets();
        if (prob != null && prob.length > 0) {
            return prob[0];
        }
        return "GBK";
    }
}

