/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import kohgylw.kiftd.server.mapper.FolderMapper;
import kohgylw.kiftd.server.mapper.NodeMapper;
import kohgylw.kiftd.server.model.Folder;
import kohgylw.kiftd.server.model.Node;
import kohgylw.kiftd.server.util.ConfigureReader;
import kohgylw.kiftd.server.util.FileBlockUtil;
import org.springframework.stereotype.Component;

@Component
public class FolderUtil {
    @Resource
    private FolderMapper fm;
    @Resource
    private NodeMapper fim;
    @Resource
    private FileBlockUtil fbu;

    public List<Folder> getParentList(String fid) {
        Folder f = this.fm.queryById(fid);
        ArrayList<Folder> folderList = new ArrayList<Folder>();
        if (f != null) {
            while (!f.getFolderParent().equals("null")) {
                f = this.fm.queryById(f.getFolderParent());
                folderList.add(f);
            }
        }
        Collections.reverse(folderList);
        return folderList;
    }

    public int deleteAllChildFolder(String folderId) {
        String fileblocks = ConfigureReader.instance().getFileBlockPath();
        Thread deleteChildFolderThread = new Thread(() -> this.iterationDeleteFolder(fileblocks, folderId));
        deleteChildFolderThread.start();
        return this.fm.deleteById(folderId);
    }

    private void iterationDeleteFolder(String fileblocks, String folderId) {
        List<Node> files;
        List<Folder> cf = this.fm.queryByParentId(folderId);
        if (cf.size() > 0) {
            for (Folder f : cf) {
                this.iterationDeleteFolder(fileblocks, f.getFolderId());
            }
        }
        if ((files = this.fim.queryByParentFolderId(folderId)).size() > 0) {
            this.fim.deleteByParentFolderId(folderId);
            for (Node f2 : files) {
                this.fbu.deleteFromFileBlocks(f2);
            }
        }
        this.fm.deleteById(folderId);
    }
}

