/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.zip.ZipEntry;
import javax.annotation.Resource;
import kohgylw.kiftd.server.mapper.FolderMapper;
import kohgylw.kiftd.server.mapper.NodeMapper;
import kohgylw.kiftd.server.model.Folder;
import kohgylw.kiftd.server.model.Node;
import kohgylw.kiftd.server.util.ConfigureReader;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;
import org.zeroturnaround.zip.FileSource;
import org.zeroturnaround.zip.ZipEntrySource;
import org.zeroturnaround.zip.ZipUtil;

@Component
public class FileBlockUtil {
    @Resource
    private NodeMapper fm;
    @Resource
    private FolderMapper flm;
    private final String fileBlocks = ConfigureReader.instance().getFileBlockPath();

    public String saveToFileBlocks(MultipartFile f) {
        String fileBlocks = ConfigureReader.instance().getFileBlockPath();
        String id = UUID.randomUUID().toString().replace("-", "");
        String path = "file_" + id + ".block";
        File file = new File(fileBlocks, path);
        try {
            f.transferTo(file);
            return path;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "ERROR";
        }
    }

    public String getFileSize(MultipartFile f) {
        long size = f.getSize();
        int mb = (int)(size / 1024L / 1024L);
        return "" + mb;
    }

    public boolean deleteFromFileBlocks(Node f) {
        File file = new File(ConfigureReader.instance().getFileBlockPath(), f.getFilePath());
        return file.exists() && file.isFile() && file.delete();
    }

    public File getFileFromBlocks(Node f) {
        File file = new File(ConfigureReader.instance().getFileBlockPath(), f.getFilePath());
        if (file.exists() && file.isFile()) {
            return file;
        }
        return null;
    }

    public void checkFileBlocks() {
        String fileblocks = ConfigureReader.instance().getFileBlockPath();
        Thread checkThread = new Thread(() -> {
            String[] bn;
            List<Node> nodes = this.fm.queryAll();
            for (Node node : nodes) {
                File block = new File(fileblocks, node.getFilePath());
                if (block.exists()) continue;
                this.fm.deleteById(node.getFileId());
            }
            File blocks = new File(fileblocks);
            for (String n : bn = blocks.list()) {
                Node node = this.fm.queryByPath(n);
                if (node != null) continue;
                File f = new File(fileblocks, n);
                f.delete();
            }
        });
        checkThread.start();
    }

    public String createZip(List<String> idList, List<String> fidList, String account) {
        String zipname = "tf_" + UUID.randomUUID().toString() + ".zip";
        String tempPath = ConfigureReader.instance().getTemporaryfilePath();
        File f = new File(tempPath, zipname);
        try {
            ArrayList<ZipEntrySource> zs = new ArrayList<ZipEntrySource>();
            ArrayList<Folder> folders = new ArrayList<Folder>();
            for (String fid : fidList) {
                Folder fo = this.flm.queryById(fid);
                if (fo == null) continue;
                folders.add(fo);
            }
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (String id : idList) {
                Node n = this.fm.queryById(id);
                if (n == null) continue;
                nodes.add(n);
            }
            for (Folder fo : folders) {
                int i = 1;
                String flname = fo.getFolderName();
                while (folders.parallelStream().filter(e -> e.getFolderName().equals(fo.getFolderName())).count() > 1L) {
                    fo.setFolderName(flname + " " + i);
                    ++i;
                }
                this.addFoldersToZipEntrySourceArray(fo, zs, account, "");
            }
            for (Node node : nodes) {
                int i = 1;
                String fname = node.getFileName();
                while (nodes.parallelStream().filter(e -> e.getFileName().equals(node.getFileName())).count() > 1L || folders.parallelStream().filter(e -> e.getFolderName().equals(node.getFileName())).count() > 0L) {
                    if (fname.indexOf(".") >= 0) {
                        node.setFileName(fname.substring(0, fname.lastIndexOf(".")) + " (" + i + ")" + fname.substring(fname.lastIndexOf(".")));
                    } else {
                        node.setFileName(fname + " (" + i + ")");
                    }
                    ++i;
                }
                zs.add((ZipEntrySource)new FileSource(node.getFileName(), new File(this.fileBlocks, node.getFilePath())));
            }
            for (ZipEntrySource zes : zs) {
                System.out.println(zes.getPath());
            }
            ZipUtil.pack((ZipEntrySource[])zs.toArray(new ZipEntrySource[0]), (File)f);
            return zipname;
        }
        catch (Exception e2) {
            return null;
        }
    }

    private void addFoldersToZipEntrySourceArray(Folder f, List<ZipEntrySource> zs, String account, String parentPath) {
        if (f != null && ConfigureReader.instance().accessFolder(f, account)) {
            String folderName = f.getFolderName();
            final String thisPath = parentPath + folderName + "/";
            zs.add(new ZipEntrySource(){

                public String getPath() {
                    return thisPath;
                }

                public InputStream getInputStream() throws IOException {
                    return null;
                }

                public ZipEntry getEntry() {
                    return new ZipEntry(thisPath);
                }
            });
            List<Folder> folders = this.flm.queryByParentId(f.getFolderId());
            for (Folder fo : folders) {
                int i = 1;
                String flname = fo.getFolderName();
                while (folders.parallelStream().filter(e -> e.getFolderName().equals(fo.getFolderName())).count() > 1L) {
                    fo.setFolderName(flname + " " + i);
                    ++i;
                }
                this.addFoldersToZipEntrySourceArray(fo, zs, account, thisPath);
            }
            List<Node> nodes = this.fm.queryByParentFolderId(f.getFolderId());
            for (Node node : nodes) {
                int i = 1;
                String fname = node.getFileName();
                while (nodes.parallelStream().filter(e -> e.getFileName().equals(node.getFileName())).count() > 1L || folders.parallelStream().filter(e -> e.getFolderName().equals(node.getFileName())).count() > 0L) {
                    if (fname.indexOf(".") >= 0) {
                        node.setFileName(fname.substring(0, fname.lastIndexOf(".")) + " (" + i + ")" + fname.substring(fname.lastIndexOf(".")));
                    } else {
                        node.setFileName(fname + " (" + i + ")");
                    }
                    ++i;
                }
                zs.add((ZipEntrySource)new FileSource(thisPath + node.getFileName(), new File(this.fileBlocks, node.getFilePath())));
            }
        }
    }
}

