/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import kohgylw.kiftd.printer.Printer;
import kohgylw.kiftd.server.enumeration.AccountAuth;
import kohgylw.kiftd.server.enumeration.LogLevel;
import kohgylw.kiftd.server.model.Folder;
import kohgylw.kiftd.server.pojo.ServerSetting;

public class ConfigureReader {
    private static ConfigureReader cr;
    private Properties serverp;
    private Properties accountp;
    private int propertiesStatus = -1;
    private String path = System.getProperty("user.dir");
    private String fileSystemPath;
    private String confdir;
    private String mustLogin;
    private int port;
    private String log;
    private String FSPath;
    private int bufferSize;
    private String fileBlockPath;
    private String fileNodePath;
    private String TFPath;
    private String dbURL;
    private String dbDriver;
    private String dbUser;
    private String dbPwd;
    private final String ACCOUNT_PROPERTIES_FILE = "account.properties";
    private final String SERVER_PROPERTIES_FILE = "server.properties";
    private final int DEFAULT_BUFFER_SIZE = 0x100000;
    private final int DEFAULT_PORT = 8080;
    private final String DEFAULT_LOG_LEVEL = "E";
    private final String DEFAULT_MUST_LOGIN = "O";
    private final String DEFAULT_FILE_SYSTEM_PATH;
    private final String DEFAULT_FILE_SYSTEM_PATH_SETTING = "DEFAULT";
    private final String DEFAULT_ACCOUNT_ID = "admin";
    private final String DEFAULT_ACCOUNT_PWD = "000000";
    private final String DEFAULT_ACCOUNT_AUTH = "cudrm";
    private final String DEFAULT_AUTH_OVERALL = "l";
    public static final int INVALID_PORT = 1;
    public static final int INVALID_LOG = 2;
    public static final int INVALID_FILE_SYSTEM_PATH = 3;
    public static final int INVALID_BUFFER_SIZE = 4;
    public static final int CANT_CREATE_FILE_BLOCK_PATH = 5;
    public static final int CANT_CREATE_FILE_NODE_PATH = 6;
    public static final int CANT_CREATE_TF_PATH = 7;
    public static final int CANT_CONNECT_DB = 8;
    public static final int LEGAL_PROPERTIES = 0;
    private static Thread accountPropertiesUpdateDaemonThread;
    private String timeZone;

    private ConfigureReader() {
        File accountProp;
        File f;
        String classPath = System.getProperty("java.class.path");
        if (classPath.indexOf(File.pathSeparator) < 0 && (classPath = (f = new File(classPath)).getAbsolutePath()).endsWith(".jar")) {
            this.path = classPath.substring(0, classPath.lastIndexOf(File.separator));
        }
        this.DEFAULT_FILE_SYSTEM_PATH = this.path + File.separator + "filesystem" + File.separator;
        this.confdir = this.path + File.separator + "conf" + File.separator;
        this.serverp = new Properties();
        this.accountp = new Properties();
        File serverProp = new File(this.confdir + "server.properties");
        if (!serverProp.isFile()) {
            Printer.instance.print("\u670d\u52a1\u5668\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u9700\u8981\u521d\u59cb\u5316\u670d\u52a1\u5668\u914d\u7f6e\u3002");
            this.createDefaultServerPropertiesFile();
        }
        if (!(accountProp = new File(this.confdir + "account.properties")).isFile()) {
            Printer.instance.print("\u7528\u6237\u8d26\u6237\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u9700\u8981\u521d\u59cb\u5316\u8d26\u6237\u914d\u7f6e\u3002");
            this.createDefaultAccountPropertiesFile();
        }
        try {
            Printer.instance.print("\u6b63\u5728\u8f7d\u5165\u914d\u7f6e\u6587\u4ef6...");
            FileInputStream serverPropIn = new FileInputStream(serverProp);
            this.serverp.load(serverPropIn);
            FileInputStream accountPropIn = new FileInputStream(accountProp);
            this.accountp.load(accountPropIn);
            Printer.instance.print("\u914d\u7f6e\u6587\u4ef6\u8f7d\u5165\u5b8c\u6bd5\u3002\u6b63\u5728\u68c0\u67e5\u914d\u7f6e...");
            this.propertiesStatus = this.testServerPropertiesAndEffect();
            if (this.propertiesStatus == 0) {
                Printer.instance.print("\u51c6\u5907\u5c31\u7eea\u3002");
                this.startAccountRealTimeUpdateListener();
            }
        }
        catch (Exception e) {
            Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u52a0\u8f7d\u4e00\u4e2a\u6216\u591a\u4e2a\u914d\u7f6e\u6587\u4ef6\uff08\u4f4d\u4e8e" + this.confdir + "\u8def\u5f84\u4e0b\uff09\uff0c\u8bf7\u5c1d\u8bd5\u5220\u9664\u65e7\u7684\u914d\u7f6e\u6587\u4ef6\u5e76\u91cd\u65b0\u542f\u52a8\u672c\u5e94\u7528\u6216\u67e5\u770b\u5b89\u88c5\u8def\u5f84\u7684\u6743\u9650\uff08\u5fc5\u987b\u53ef\u8bfb\u5199\uff09\u3002");
        }
    }

    public static ConfigureReader instance() {
        if (cr == null) {
            cr = new ConfigureReader();
        }
        return cr;
    }

    public boolean foundAccount(String account) {
        String accountPwd = this.accountp.getProperty(account + ".pwd");
        return accountPwd != null && accountPwd.length() > 0;
    }

    public boolean checkAccountPwd(String account, String pwd) {
        String apwd = this.accountp.getProperty(account + ".pwd");
        return apwd != null && apwd.equals(pwd);
    }

    public boolean authorized(String account, AccountAuth auth) {
        if (account != null && account.length() > 0) {
            StringBuffer auths = new StringBuffer();
            String accauth = this.accountp.getProperty(account + ".auth");
            String overall = this.accountp.getProperty("authOverall");
            if (accauth != null) {
                auths.append(accauth);
            }
            if (overall != null) {
                auths.append(overall);
            }
            switch (auth) {
                case CREATE_NEW_FOLDER: {
                    return auths.indexOf("c") >= 0;
                }
                case UPLOAD_FILES: {
                    return auths.indexOf("u") >= 0;
                }
                case DELETE_FILE_OR_FOLDER: {
                    return auths.indexOf("d") >= 0;
                }
                case RENAME_FILE_OR_FOLDER: {
                    return auths.indexOf("r") >= 0;
                }
                case DOWNLOAD_FILES: {
                    return auths.indexOf("l") >= 0;
                }
                case MOVE_FILES: {
                    return auths.indexOf("m") >= 0;
                }
            }
            return false;
        }
        String overall2 = this.accountp.getProperty("authOverall");
        if (overall2 == null) {
            return false;
        }
        switch (auth) {
            case CREATE_NEW_FOLDER: {
                return overall2.indexOf("c") >= 0;
            }
            case UPLOAD_FILES: {
                return overall2.indexOf("u") >= 0;
            }
            case DELETE_FILE_OR_FOLDER: {
                return overall2.indexOf("d") >= 0;
            }
            case RENAME_FILE_OR_FOLDER: {
                return overall2.indexOf("r") >= 0;
            }
            case DOWNLOAD_FILES: {
                return overall2.indexOf("l") >= 0;
            }
            case MOVE_FILES: {
                return overall2.indexOf("m") >= 0;
            }
        }
        return false;
    }

    public int getBuffSize() {
        return this.bufferSize;
    }

    public boolean inspectLogLevel(LogLevel l) {
        String log;
        int o = 0;
        int m = 0;
        if (l == null) {
            return false;
        }
        switch (l) {
            case None: {
                m = 0;
                break;
            }
            case Runtime_Exception: {
                m = 1;
            }
            case Event: {
                m = 2;
                break;
            }
            default: {
                m = 0;
            }
        }
        if (this.log == null) {
            this.log = "";
        }
        switch (log = this.log) {
            case "N": {
                o = 0;
                break;
            }
            case "R": {
                o = 1;
                break;
            }
            case "E": {
                o = 2;
                break;
            }
            default: {
                o = 1;
            }
        }
        return o >= m;
    }

    public boolean mustLogin() {
        return this.mustLogin != null && this.mustLogin.equals("N");
    }

    public String getFileSystemPath() {
        return this.fileSystemPath;
    }

    public String getFileBlockPath() {
        return this.fileBlockPath;
    }

    public String getFileNodePath() {
        return this.fileNodePath;
    }

    public String getTemporaryfilePath() {
        return this.TFPath;
    }

    public String getPath() {
        return this.path;
    }

    public LogLevel getLogLevel() {
        String log;
        if (this.log == null) {
            this.log = "";
        }
        switch (log = this.log) {
            case "N": {
                return LogLevel.None;
            }
            case "R": {
                return LogLevel.Runtime_Exception;
            }
            case "E": {
                return LogLevel.Event;
            }
        }
        return null;
    }

    public int getPort() {
        return this.port;
    }

    public int getPropertiesStatus() {
        return this.propertiesStatus;
    }

    public boolean doUpdate(ServerSetting ss) {
        if (ss != null) {
            Printer.instance.print("\u6b63\u5728\u66f4\u65b0\u670d\u52a1\u5668\u914d\u7f6e...");
            this.serverp.setProperty("mustLogin", ss.isMustLogin() ? "N" : "O");
            this.serverp.setProperty("buff.size", ss.getBuffSize() + "");
            String loglevelCode = "E";
            switch (ss.getLog()) {
                case Event: {
                    loglevelCode = "E";
                    break;
                }
                case Runtime_Exception: {
                    loglevelCode = "R";
                    break;
                }
                case None: {
                    loglevelCode = "N";
                }
            }
            this.serverp.setProperty("log", loglevelCode);
            this.serverp.setProperty("port", ss.getPort() + "");
            this.serverp.setProperty("FS.path", (ss.getFsPath() + File.separator).equals(this.DEFAULT_FILE_SYSTEM_PATH) ? "DEFAULT" : ss.getFsPath());
            if (this.testServerPropertiesAndEffect() == 0) {
                try {
                    this.serverp.store(new FileOutputStream(this.confdir + "server.properties"), "<Kiftd server setting file is update.>");
                    Printer.instance.print("\u914d\u7f6e\u66f4\u65b0\u5b8c\u6bd5\uff0c\u51c6\u5907\u5c31\u7eea\u3002");
                    return true;
                }
                catch (Exception e) {
                    Printer.instance.print("\u9519\u8bef\uff1a\u66f4\u65b0\u8bbe\u7f6e\u5931\u8d25\uff0c\u65e0\u6cd5\u5b58\u5165\u8bbe\u7f6e\u6587\u4ef6\u3002");
                }
            }
        }
        return false;
    }

    private int testServerPropertiesAndEffect() {
        File fsFile;
        String ports;
        Printer.instance.print("\u6b63\u5728\u68c0\u67e5\u670d\u52a1\u5668\u914d\u7f6e...");
        this.mustLogin = this.serverp.getProperty("mustLogin");
        if (this.mustLogin == null) {
            Printer.instance.print("\u8b66\u544a\uff1a\u672a\u627e\u5230\u662f\u5426\u5fc5\u987b\u767b\u5f55\u914d\u7f6e\uff0c\u5c06\u91c7\u7528\u9ed8\u8ba4\u503c\uff08O\uff09\u3002");
            this.mustLogin = "O";
        }
        if ((ports = this.serverp.getProperty("port")) == null) {
            Printer.instance.print("\u8b66\u544a\uff1a\u672a\u627e\u5230\u7aef\u53e3\u914d\u7f6e\uff0c\u5c06\u91c7\u7528\u9ed8\u8ba4\u503c\uff088080\uff09\u3002");
            this.port = 8080;
        } else {
            try {
                this.port = Integer.parseInt(ports);
                if (this.port <= 0 || this.port > 65535) {
                    return 1;
                }
            }
            catch (Exception e) {
                return 1;
            }
        }
        String logs = this.serverp.getProperty("log");
        if (logs == null) {
            Printer.instance.print("\u8b66\u544a\uff1a\u672a\u627e\u5230\u65e5\u5fd7\u7b49\u7ea7\u914d\u7f6e\uff0c\u5c06\u91c7\u7528\u9ed8\u8ba4\u503c\uff08E\uff09\u3002");
            this.log = "E";
        } else {
            if (!(logs.equals("N") || logs.equals("R") || logs.equals("E"))) {
                return 2;
            }
            this.log = logs;
        }
        String bufferSizes = this.serverp.getProperty("buff.size");
        if (bufferSizes == null) {
            Printer.instance.print("\u8b66\u544a\uff1a\u672a\u627e\u5230\u7f13\u51b2\u5927\u5c0f\u914d\u7f6e\uff0c\u5c06\u91c7\u7528\u9ed8\u8ba4\u503c\uff081048576\uff09\u3002");
            this.bufferSize = 0x100000;
        } else {
            try {
                this.bufferSize = Integer.parseInt(bufferSizes);
                if (this.bufferSize <= 0) {
                    Printer.instance.print("\u9519\u8bef\uff1a\u7f13\u51b2\u533a\u5927\u5c0f\u8bbe\u7f6e\u65e0\u6548\u3002");
                    return 4;
                }
            }
            catch (Exception e2) {
                Printer.instance.print("\u9519\u8bef\uff1a\u7f13\u51b2\u533a\u5927\u5c0f\u8bbe\u7f6e\u65e0\u6548\u3002");
                return 4;
            }
        }
        this.FSPath = this.serverp.getProperty("FS.path");
        if (this.FSPath == null) {
            Printer.instance.print("\u8b66\u544a\uff1a\u672a\u627e\u5230\u6587\u4ef6\u7cfb\u7edf\u914d\u7f6e\uff0c\u5c06\u91c7\u7528\u9ed8\u8ba4\u503c\u3002");
            this.fileSystemPath = this.DEFAULT_FILE_SYSTEM_PATH;
        } else {
            this.fileSystemPath = this.FSPath.equals("DEFAULT") ? this.DEFAULT_FILE_SYSTEM_PATH : this.FSPath;
        }
        if (!this.fileSystemPath.endsWith(File.separator)) {
            this.fileSystemPath = this.fileSystemPath + File.separator;
        }
        if (!((fsFile = new File(this.fileSystemPath)).isDirectory() && fsFile.canRead() && fsFile.canWrite())) {
            Printer.instance.print("\u9519\u8bef\uff1a\u6587\u4ef6\u7cfb\u7edf\u8def\u5f84[" + this.fileSystemPath + "]\u65e0\u6548\uff0c\u8be5\u8def\u5f84\u5fc5\u987b\u6307\u5411\u4e00\u4e2a\u5177\u5907\u8bfb\u5199\u6743\u9650\u7684\u6587\u4ef6\u5939\u3002");
            return 3;
        }
        this.fileBlockPath = this.fileSystemPath + "fileblocks" + File.separator;
        File fbFile = new File(this.fileBlockPath);
        if (!fbFile.isDirectory() && !fbFile.mkdirs()) {
            Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u521b\u5efa\u6587\u4ef6\u5757\u5b58\u653e\u533a[" + this.fileBlockPath + "]\u3002");
            return 5;
        }
        this.fileNodePath = this.fileSystemPath + "filenodes" + File.separator;
        File fnFile = new File(this.fileNodePath);
        if (!fnFile.isDirectory() && !fnFile.mkdirs()) {
            Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u521b\u5efa\u6587\u4ef6\u8282\u70b9\u5b58\u653e\u533a[" + this.fileNodePath + "]\u3002");
            return 6;
        }
        this.TFPath = this.fileSystemPath + "temporaryfiles" + File.separator;
        File tfFile = new File(this.TFPath);
        if (!tfFile.isDirectory() && !tfFile.mkdirs()) {
            Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5b58\u653e\u533a[" + this.TFPath + "]\u3002");
            return 7;
        }
        if ("true".equals(this.serverp.getProperty("mysql.enable"))) {
            this.dbDriver = "com.mysql.cj.jdbc.Driver";
            String url = this.serverp.getProperty("mysql.url", "127.0.0.1/kift");
            if (url.indexOf("/") <= 0 || url.substring(url.indexOf("/")).length() == 1) {
                Printer.instance.print("\u9519\u8bef\uff1a\u81ea\u5b9a\u4e49\u6570\u636e\u5e93\u7684URL\u4e2d\u5fc5\u987b\u6307\u5b9a\u6570\u636e\u5e93\u540d\u79f0\u3002");
                return 8;
            }
            this.dbURL = "jdbc:mysql://" + url + "?useUnicode=true&characterEncoding=utf8";
            this.dbUser = this.serverp.getProperty("mysql.user", "root");
            this.dbPwd = this.serverp.getProperty("mysql.password", "");
            this.timeZone = this.serverp.getProperty("mysql.timezone");
            if (this.timeZone != null) {
                this.dbURL = this.dbURL + "&serverTimezone=" + this.timeZone;
            }
            try {
                Class.forName(this.dbDriver).newInstance();
                Connection testConn = DriverManager.getConnection(this.dbURL, this.dbUser, this.dbPwd);
                testConn.close();
            }
            catch (Exception e) {
                Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u8fde\u63a5\u81f3\u81ea\u5b9a\u4e49\u6570\u636e\u5e93\uff1a" + this.dbURL + "\uff08user=" + this.dbUser + ",password=" + this.dbPwd + "\uff09\uff0c\u8bf7\u786e\u91cd\u65b0\u914d\u7f6eMySQL\u6570\u636e\u5e93\u76f8\u5173\u9879\u3002");
                return 8;
            }
        } else {
            this.dbDriver = "org.h2.Driver";
            this.dbURL = "jdbc:h2:file:" + this.fileNodePath + File.separator + "kift";
            this.dbUser = "root";
            this.dbPwd = "301537gY";
        }
        Printer.instance.print("\u68c0\u67e5\u5b8c\u6bd5\u3002");
        return 0;
    }

    public void createDefaultServerPropertiesFile() {
        Printer.instance.print("\u6b63\u5728\u751f\u6210\u521d\u59cb\u670d\u52a1\u5668\u914d\u7f6e\u6587\u4ef6\uff08" + this.confdir + "server.properties" + "\uff09...");
        Properties dsp = new Properties();
        dsp.setProperty("mustLogin", "O");
        dsp.setProperty("port", "8080");
        dsp.setProperty("log", "E");
        dsp.setProperty("FS.path", "DEFAULT");
        dsp.setProperty("buff.size", "1048576");
        if ("true".equals(this.serverp.getProperty("mysql.enable"))) {
            dsp.setProperty("mysql.enable", "false");
            dsp.setProperty("mysql.url", this.serverp == null ? "127.0.0.1/kift" : this.serverp.getProperty("mysql.url", "127.0.0.1/kift"));
            dsp.setProperty("mysql.user", this.dbUser == null ? "root" : this.dbUser);
            dsp.setProperty("mysql.password", this.dbPwd == null ? "" : this.dbPwd);
            dsp.setProperty("mysql.timezone", this.timeZone == null ? "GMT%2B8" : this.timeZone);
        }
        try {
            dsp.store(new FileOutputStream(this.confdir + "server.properties"), "<This is the default kiftd server setting file. >");
            Printer.instance.print("\u521d\u59cb\u670d\u52a1\u5668\u914d\u7f6e\u6587\u4ef6\u751f\u6210\u5b8c\u6bd5\u3002");
        }
        catch (FileNotFoundException e) {
            Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u751f\u6210\u521d\u59cb\u670d\u52a1\u5668\u914d\u7f6e\u6587\u4ef6\uff0c\u5b58\u50a8\u8def\u5f84\u4e0d\u5b58\u5728\u3002");
        }
        catch (IOException e2) {
            Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u751f\u6210\u521d\u59cb\u670d\u52a1\u5668\u914d\u7f6e\u6587\u4ef6\uff0c\u5199\u5165\u5931\u8d25\u3002");
        }
    }

    private void createDefaultAccountPropertiesFile() {
        Printer.instance.print("\u6b63\u5728\u751f\u6210\u521d\u59cb\u8d26\u6237\u914d\u7f6e\u6587\u4ef6\uff08" + this.confdir + "account.properties" + "\uff09...");
        Properties dap = new Properties();
        dap.setProperty("admin.pwd", "000000");
        dap.setProperty("admin.auth", "cudrm");
        dap.setProperty("authOverall", "l");
        try {
            dap.store(new FileOutputStream(this.confdir + "account.properties"), "<This is the default kiftd account setting file. >");
            Printer.instance.print("\u521d\u59cb\u8d26\u6237\u914d\u7f6e\u6587\u4ef6\u751f\u6210\u5b8c\u6bd5\u3002");
        }
        catch (FileNotFoundException e) {
            Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u751f\u6210\u521d\u59cb\u8d26\u6237\u914d\u7f6e\u6587\u4ef6\uff0c\u5b58\u50a8\u8def\u5f84\u4e0d\u5b58\u5728\u3002");
        }
        catch (IOException e2) {
            Printer.instance.print("\u9519\u8bef\uff1a\u65e0\u6cd5\u751f\u6210\u521d\u59cb\u8d26\u6237\u914d\u7f6e\u6587\u4ef6\uff0c\u5199\u5165\u5931\u8d25\u3002");
        }
    }

    public boolean useMySQL() {
        return this.serverp == null ? false : "true".equals(this.serverp.getProperty("mysql.enable"));
    }

    public String getFileNodePathURL() {
        return this.dbURL;
    }

    public String getFileNodePathDriver() {
        return this.dbDriver;
    }

    public String getFileNodePathUserName() {
        return this.dbUser;
    }

    public String getFileNodePathPassWord() {
        return this.dbPwd;
    }

    public boolean accessFolder(Folder f, String account) {
        if (f == null) {
            return false;
        }
        int cl = f.getFolderConstraint();
        if (cl == 0) {
            return true;
        }
        if (account != null) {
            if (cl == 1) {
                if (f.getFolderCreator().equals(account)) {
                    return true;
                }
                String vGroup = this.accountp.getProperty(account + ".group");
                String cGroup = this.accountp.getProperty(f.getFolderCreator() + ".group");
                if (vGroup != null && cGroup != null) {
                    if ("*".equals(vGroup) || "*".equals(cGroup)) {
                        return true;
                    }
                    String[] vgs = vGroup.split(";");
                    String[] cgs = cGroup.split(";");
                    for (String vs : vgs) {
                        for (String cs : cgs) {
                            if (!vs.equals(cs)) continue;
                            return true;
                        }
                    }
                }
            }
            if (cl == 2 && f.getFolderCreator().equals(account)) {
                return true;
            }
        }
        return false;
    }

    public void startAccountRealTimeUpdateListener() {
        if (accountPropertiesUpdateDaemonThread == null) {
            Path confPath = Paths.get(this.confdir, new String[0]);
            accountPropertiesUpdateDaemonThread = new Thread(() -> {
                try {
                    block2: while (true) {
                        WatchService ws = confPath.getFileSystem().newWatchService();
                        confPath.register(ws, StandardWatchEventKinds.ENTRY_MODIFY);
                        WatchKey wk = ws.take();
                        List<WatchEvent<?>> es = wk.pollEvents();
                        Iterator<WatchEvent<?>> iterator = es.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block2;
                            WatchEvent<?> we = iterator.next();
                            if (we.kind() != StandardWatchEventKinds.ENTRY_MODIFY || !"account.properties".equals(we.context().toString())) continue;
                            Printer.instance.print("\u6b63\u5728\u66f4\u65b0\u8d26\u6237\u914d\u7f6e\u4fe1\u606f...");
                            this.accountp.clear();
                            File accountProp = new File(this.confdir + "account.properties");
                            FileInputStream accountPropIn = new FileInputStream(accountProp);
                            this.accountp.load(accountPropIn);
                            Printer.instance.print("\u8d26\u6237\u914d\u7f6e\u66f4\u65b0\u5b8c\u6210\uff0c\u5df2\u52a0\u8f7d\u6700\u65b0\u914d\u7f6e\u3002");
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    Printer.instance.print("\u9519\u8bef\uff1a\u7528\u6237\u914d\u7f6e\u6587\u4ef6\u66f4\u6539\u76d1\u542c\u5931\u8d25\uff0c\u8be5\u529f\u80fd\u5df2\u5931\u6548\uff0ckiftd\u53ef\u80fd\u65e0\u6cd5\u5b9e\u65f6\u66f4\u65b0\u7528\u6237\u914d\u7f6e\uff08\u91cd\u542f\u5e94\u7528\u53ef\u6062\u590d\u8be5\u529f\u80fd\uff09\u3002");
                    return;
                }
            });
            accountPropertiesUpdateDaemonThread.setDaemon(true);
            accountPropertiesUpdateDaemonThread.start();
        }
    }
}

