/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.service.impl;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kohgylw.kiftd.server.enumeration.AccountAuth;
import kohgylw.kiftd.server.mapper.NodeMapper;
import kohgylw.kiftd.server.model.Node;
import kohgylw.kiftd.server.pojo.PictureViewList;
import kohgylw.kiftd.server.service.ShowPictureService;
import kohgylw.kiftd.server.util.ConfigureReader;
import net.coobird.thumbnailator.Thumbnails;
import org.springframework.stereotype.Service;

@Service
public class ShowPictureServiceImpl
implements ShowPictureService {
    @Resource
    private NodeMapper fm;
    @Resource
    private Gson gson;

    private PictureViewList foundPictures(HttpServletRequest request) {
        String fileId = request.getParameter("fileId");
        if (fileId != null && fileId.length() > 0) {
            String account = (String)request.getSession().getAttribute("ACCOUNT");
            if (ConfigureReader.instance().authorized(account, AccountAuth.DOWNLOAD_FILES)) {
                List<Node> nodes = this.fm.queryBySomeFolder(fileId);
                ArrayList<Node> pictureViewList = new ArrayList<Node>();
                int index = 0;
                for (Node n : nodes) {
                    String fileName = n.getFileName();
                    String suffix = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
                    if (!suffix.equals("jpg") && !suffix.equals("jpeg") && !suffix.equals("gif") && !suffix.equals("bmp") && !suffix.equals("png")) continue;
                    int pSize = Integer.parseInt(n.getFileSize());
                    if (pSize > 1) {
                        n.setFilePath("homeController/showCondensedPicture.do?fileId=" + n.getFileId());
                    }
                    pictureViewList.add(n);
                    if (!n.getFileId().equals(fileId)) continue;
                    index = pictureViewList.size() - 1;
                }
                PictureViewList pvl = new PictureViewList();
                pvl.setIndex(index);
                pvl.setPictureViewList(pictureViewList);
                return pvl;
            }
        }
        return null;
    }

    @Override
    public String getPreviewPictureJson(HttpServletRequest request) {
        PictureViewList pvl = this.foundPictures(request);
        if (pvl != null) {
            return this.gson.toJson((Object)pvl);
        }
        return "ERROR";
    }

    @Override
    public void getCondensedPicture(HttpServletRequest request, HttpServletResponse response) {
        File pBlock;
        Node node;
        String fileId;
        if (ConfigureReader.instance().authorized((String)request.getSession().getAttribute("ACCOUNT"), AccountAuth.DOWNLOAD_FILES) && (fileId = request.getParameter("fileId")) != null && (node = this.fm.queryById(fileId)) != null && (pBlock = new File(ConfigureReader.instance().getFileBlockPath(), node.getFilePath())).exists()) {
            try {
                int pSize = Integer.parseInt(node.getFileSize());
                if (pSize < 3) {
                    Thumbnails.of((File[])new File[]{pBlock}).size(1024, 1024).outputFormat("JPG").toOutputStream((OutputStream)response.getOutputStream());
                } else if (pSize < 5) {
                    Thumbnails.of((File[])new File[]{pBlock}).size(1440, 1440).outputFormat("JPG").toOutputStream((OutputStream)response.getOutputStream());
                } else {
                    Thumbnails.of((File[])new File[]{pBlock}).size(1680, 1680).outputFormat("JPG").toOutputStream((OutputStream)response.getOutputStream());
                }
            }
            catch (IOException e) {
                try {
                    Files.copy(pBlock.toPath(), (OutputStream)response.getOutputStream());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

