/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.service.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kohgylw.kiftd.server.enumeration.AccountAuth;
import kohgylw.kiftd.server.mapper.NodeMapper;
import kohgylw.kiftd.server.model.Node;
import kohgylw.kiftd.server.pojo.VideoTranscodeThread;
import kohgylw.kiftd.server.service.ResourceService;
import kohgylw.kiftd.server.util.ConfigureReader;
import kohgylw.kiftd.server.util.Docx2PDFUtil;
import kohgylw.kiftd.server.util.FileBlockUtil;
import kohgylw.kiftd.server.util.LogUtil;
import kohgylw.kiftd.server.util.Txt2PDFUtil;
import kohgylw.kiftd.server.util.VideoTranscodeUtil;
import org.springframework.stereotype.Service;

@Service
public class ResourceServiceImpl
implements ResourceService {
    @Resource
    private NodeMapper nm;
    @Resource
    private FileBlockUtil fbu;
    @Resource
    private LogUtil lu;
    @Resource
    private Docx2PDFUtil d2pu;
    @Resource
    private Txt2PDFUtil t2pu;
    @Resource
    private VideoTranscodeUtil vtu;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getResource(HttpServletRequest request, HttpServletResponse response) {
        Node n;
        String fid;
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        if (ConfigureReader.instance().authorized(account, AccountAuth.DOWNLOAD_FILES) && (fid = request.getParameter("fid")) != null && (n = this.nm.queryById(fid)) != null) {
            File file = this.fbu.getFileFromBlocks(n);
            String suffix = "";
            if (n.getFileName().indexOf(".") >= 0) {
                suffix = n.getFileName().substring(n.getFileName().lastIndexOf(".")).trim().toLowerCase();
            }
            String contentType = "application/octet-stream";
            switch (suffix) {
                case ".mp4": 
                case ".webm": 
                case ".mov": 
                case ".avi": 
                case ".wmv": 
                case ".mkv": 
                case ".flv": {
                    contentType = "video/mp4";
                    Map<String, VideoTranscodeThread> map = VideoTranscodeUtil.videoTranscodeThreads;
                    synchronized (map) {
                        VideoTranscodeThread vtt = VideoTranscodeUtil.videoTranscodeThreads.get(fid);
                        if (vtt != null) {
                            File f = new File(ConfigureReader.instance().getTemporaryfilePath(), vtt.getOutputFileName());
                            if (f.isFile() && vtt.getProgress().equals("FIN")) {
                                file = f;
                            } else {
                                try {
                                    response.sendError(500);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                return;
                            }
                        }
                        break;
                    }
                }
                case ".mp3": {
                    contentType = "audio/mpeg";
                    break;
                }
                case ".ogg": {
                    contentType = "audio/ogg";
                    break;
                }
            }
            this.sendResource(file, n.getFileName(), contentType, request, response);
            if (request.getHeader("Range") == null) {
                this.lu.writeDownloadFileEvent(request, n);
            }
            return;
        }
        try {
            response.sendError(404);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendResource(File resource, String fname, String contentType, HttpServletRequest request, HttpServletResponse response) {
        try (RandomAccessFile randomFile = new RandomAccessFile(resource, "r");){
            long contentLength = randomFile.length();
            String range = request.getHeader("Range");
            long start = 0L;
            long end = 0L;
            if (range != null && range.startsWith("bytes=")) {
                String[] values = range.split("=")[1].split("-");
                start = Long.parseLong(values[0]);
                if (values.length > 1) {
                    end = Long.parseLong(values[1]);
                }
            }
            long requestSize = 0L;
            requestSize = end != 0L && end > start ? end - start + 1L : Long.MAX_VALUE;
            byte[] buffer = new byte[ConfigureReader.instance().getBuffSize()];
            response.setContentType(contentType);
            response.setHeader("Accept-Ranges", "bytes");
            response.setHeader("ETag", fname);
            response.setHeader("Last-Modified", new Date().toString());
            if (range == null) {
                response.setHeader("Content-length", contentLength + "");
            } else {
                response.setStatus(206);
                long requestStart = 0L;
                long requestEnd = 0L;
                String[] ranges = range.split("=");
                if (ranges.length > 1) {
                    String[] rangeDatas = ranges[1].split("-");
                    requestStart = Long.parseLong(rangeDatas[0]);
                    if (rangeDatas.length > 1) {
                        requestEnd = Long.parseLong(rangeDatas[1]);
                    }
                }
                long length = 0L;
                if (requestEnd > 0L) {
                    length = requestEnd - requestStart + 1L;
                    response.setHeader("Content-length", "" + length);
                    response.setHeader("Content-Range", "bytes " + requestStart + "-" + requestEnd + "/" + contentLength);
                } else {
                    length = contentLength - requestStart;
                    response.setHeader("Content-length", "" + length);
                    response.setHeader("Content-Range", "bytes " + requestStart + "-" + (contentLength - 1L) + "/" + contentLength);
                }
            }
            ServletOutputStream out = response.getOutputStream();
            randomFile.seek(start);
            for (long needSize = requestSize; needSize > 0L; needSize -= (long)buffer.length) {
                int len = randomFile.read(buffer);
                if (needSize < (long)buffer.length) {
                    out.write(buffer, 0, (int)needSize);
                    continue;
                }
                out.write(buffer, 0, len);
                if (len < buffer.length) break;
            }
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void getWordView(String fileId, HttpServletRequest request, HttpServletResponse response) {
        Node n;
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        if (ConfigureReader.instance().authorized(account, AccountAuth.DOWNLOAD_FILES) && fileId != null && (n = this.nm.queryById(fileId)) != null) {
            File file = this.fbu.getFileFromBlocks(n);
            String suffix = "";
            if (n.getFileName().indexOf(".") >= 0) {
                suffix = n.getFileName().substring(n.getFileName().lastIndexOf(".")).trim().toLowerCase();
            }
            if (".docx".equals(suffix)) {
                String contentType = "application/octet-stream";
                response.setContentType(contentType);
                try {
                    this.d2pu.convertPdf(new FileInputStream(file), (OutputStream)response.getOutputStream());
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        try {
            response.sendError(500);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void getTxtView(String fileId, HttpServletRequest request, HttpServletResponse response) {
        Node n;
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        if (ConfigureReader.instance().authorized(account, AccountAuth.DOWNLOAD_FILES) && fileId != null && (n = this.nm.queryById(fileId)) != null) {
            File file = this.fbu.getFileFromBlocks(n);
            String suffix = "";
            if (n.getFileName().indexOf(".") >= 0) {
                suffix = n.getFileName().substring(n.getFileName().lastIndexOf(".")).trim().toLowerCase();
            }
            if (".txt".equals(suffix)) {
                String contentType = "application/octet-stream";
                response.setContentType(contentType);
                try {
                    this.t2pu.convertPdf(file, (OutputStream)response.getOutputStream());
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        try {
            response.sendError(500);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getVideoTranscodeStatus(HttpServletRequest request) {
        String fId;
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        if (ConfigureReader.instance().authorized(account, AccountAuth.DOWNLOAD_FILES) && (fId = request.getParameter("fileId")) != null) {
            try {
                return this.vtu.getTranscodeProcess(fId);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.lu.writeException(e);
            }
        }
        return "ERROR";
    }
}

