/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.service.impl;

import com.google.gson.Gson;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import kohgylw.kiftd.server.enumeration.AccountAuth;
import kohgylw.kiftd.server.mapper.NodeMapper;
import kohgylw.kiftd.server.model.Node;
import kohgylw.kiftd.server.pojo.VideoInfo;
import kohgylw.kiftd.server.service.PlayVideoService;
import kohgylw.kiftd.server.util.ConfigureReader;
import kohgylw.kiftd.server.util.FileBlockUtil;
import org.springframework.stereotype.Service;
import ws.schild.jave.MultimediaObject;

@Service
public class PlayVideoServiceImpl
implements PlayVideoService {
    @Resource
    private NodeMapper fm;
    @Resource
    private Gson gson;
    @Resource
    private FileBlockUtil fbu;

    private VideoInfo foundVideo(HttpServletRequest request) {
        String fileId = request.getParameter("fileId");
        if (fileId != null && fileId.length() > 0) {
            Node f = this.fm.queryById(fileId);
            VideoInfo vi = new VideoInfo(f);
            if (f != null) {
                String account = (String)request.getSession().getAttribute("ACCOUNT");
                if (ConfigureReader.instance().authorized(account, AccountAuth.DOWNLOAD_FILES)) {
                    String suffix;
                    String fileName = f.getFileName();
                    switch (suffix = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase()) {
                        case "mp4": 
                        case "mov": {
                            MultimediaObject mo = new MultimediaObject(this.fbu.getFileFromBlocks(f));
                            try {
                                if (mo.getInfo().getVideo().getDecoder().indexOf("h264") >= 0) {
                                    vi.setNeedEncode("N");
                                    return vi;
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            vi.setNeedEncode("Y");
                            return vi;
                        }
                        case "webm": 
                        case "avi": 
                        case "wmv": 
                        case "mkv": 
                        case "flv": {
                            vi.setNeedEncode("Y");
                            return vi;
                        }
                    }
                }
            }
        }
        return null;
    }

    @Override
    public String getPlayVideoJson(HttpServletRequest request) {
        VideoInfo v = this.foundVideo(request);
        if (v != null) {
            return this.gson.toJson((Object)v);
        }
        return "ERROR";
    }
}

