/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.service.impl;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import kohgylw.kiftd.server.enumeration.AccountAuth;
import kohgylw.kiftd.server.mapper.FolderMapper;
import kohgylw.kiftd.server.mapper.NodeMapper;
import kohgylw.kiftd.server.model.Folder;
import kohgylw.kiftd.server.model.Node;
import kohgylw.kiftd.server.pojo.FolderView;
import kohgylw.kiftd.server.pojo.SreachView;
import kohgylw.kiftd.server.service.FolderViewService;
import kohgylw.kiftd.server.util.ConfigureReader;
import kohgylw.kiftd.server.util.FolderUtil;
import kohgylw.kiftd.server.util.ServerTimeUtil;
import org.springframework.stereotype.Service;

@Service
public class FolderViewServiceImpl
implements FolderViewService {
    @Resource
    private FolderUtil fu;
    @Resource
    private FolderMapper fm;
    @Resource
    private NodeMapper flm;
    @Resource
    private Gson gson;

    @Override
    public String getFolderViewToJson(String fid, HttpSession session, HttpServletRequest request) {
        ConfigureReader cr = ConfigureReader.instance();
        if (fid == null || fid.length() == 0) {
            return "ERROR";
        }
        Folder vf = this.fm.queryById(fid);
        String account = (String)session.getAttribute("ACCOUNT");
        if (!ConfigureReader.instance().accessFolder(vf, account)) {
            return "notAccess";
        }
        FolderView fv = new FolderView();
        fv.setFolder(vf);
        fv.setParentList(this.fu.getParentList(fid));
        LinkedList<Folder> fs = new LinkedList<Folder>();
        for (Folder f : this.fm.queryByParentId(fid)) {
            if (!ConfigureReader.instance().accessFolder(f, account)) continue;
            fs.add(f);
        }
        fv.setFolderList(fs);
        fv.setFileList(this.flm.queryByParentFolderId(fid));
        if (account != null) {
            fv.setAccount(account);
        }
        ArrayList<String> authList = new ArrayList<String>();
        if (cr.authorized(account, AccountAuth.UPLOAD_FILES)) {
            authList.add("U");
        }
        if (cr.authorized(account, AccountAuth.CREATE_NEW_FOLDER)) {
            authList.add("C");
        }
        if (cr.authorized(account, AccountAuth.DELETE_FILE_OR_FOLDER)) {
            authList.add("D");
        }
        if (cr.authorized(account, AccountAuth.RENAME_FILE_OR_FOLDER)) {
            authList.add("R");
        }
        if (cr.authorized(account, AccountAuth.DOWNLOAD_FILES)) {
            authList.add("L");
        }
        if (cr.authorized(account, AccountAuth.MOVE_FILES)) {
            authList.add("M");
        }
        fv.setAuthList(authList);
        fv.setPublishTime(ServerTimeUtil.accurateToMinute());
        return this.gson.toJson((Object)fv);
    }

    @Override
    public String getSreachViewToJson(HttpServletRequest request) {
        ConfigureReader cr = ConfigureReader.instance();
        String fid = request.getParameter("fid");
        String keyWorld = request.getParameter("keyworld");
        if (fid == null || fid.length() == 0 || keyWorld == null) {
            return "ERROR";
        }
        if (keyWorld.length() == 0) {
            return this.getFolderViewToJson(fid, request.getSession(), request);
        }
        Folder vf = this.fm.queryById(fid);
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        if (!ConfigureReader.instance().accessFolder(vf, account)) {
            return "notAccess";
        }
        SreachView sv = new SreachView();
        Folder sf = new Folder();
        sf.setFolderId(vf.getFolderId());
        sf.setFolderName("\u5728\u201c" + vf.getFolderName() + "\u201d\u5185\u641c\u7d22\u201c" + keyWorld + "\u201d\u7684\u7ed3\u679c...");
        sf.setFolderParent(vf.getFolderId());
        sf.setFolderCreator("--");
        sf.setFolderCreationDate("--");
        sf.setFolderConstraint(vf.getFolderConstraint());
        sv.setFolder(sf);
        List<Folder> pl = this.fu.getParentList(fid);
        pl.add(vf);
        sv.setParentList(pl);
        LinkedList<Node> ns = new LinkedList<Node>();
        LinkedList<Folder> fs = new LinkedList<Folder>();
        this.sreachFilesAndFolders(fid, keyWorld, account, ns, fs);
        sv.setFileList(ns);
        sv.setFolderList(fs);
        if (account != null) {
            sv.setAccount(account);
        }
        ArrayList<String> authList = new ArrayList<String>();
        if (cr.authorized(account, AccountAuth.DOWNLOAD_FILES)) {
            authList.add("L");
        }
        authList.add("O");
        sv.setAuthList(authList);
        sv.setPublishTime(ServerTimeUtil.accurateToMinute());
        sv.setKeyWorld(keyWorld);
        return this.gson.toJson((Object)sv);
    }

    private void sreachFilesAndFolders(String fid, String key, String account, List<Node> ns, List<Folder> fs) {
        for (Folder f : this.fm.queryByParentId(fid)) {
            if (!ConfigureReader.instance().accessFolder(f, account)) continue;
            if (f.getFolderName().indexOf(key) >= 0) {
                f.setFolderName(f.getFolderName());
                fs.add(f);
            }
            this.sreachFilesAndFolders(f.getFolderId(), key, account, ns, fs);
        }
        for (Node n : this.flm.queryByParentFolderId(fid)) {
            if (n.getFileName().indexOf(key) < 0) continue;
            n.setFileName(n.getFileName());
            ns.add(n);
        }
    }
}

