/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import kohgylw.kiftd.server.enumeration.AccountAuth;
import kohgylw.kiftd.server.mapper.FolderMapper;
import kohgylw.kiftd.server.mapper.NodeMapper;
import kohgylw.kiftd.server.model.Folder;
import kohgylw.kiftd.server.service.FolderService;
import kohgylw.kiftd.server.util.ConfigureReader;
import kohgylw.kiftd.server.util.FolderUtil;
import kohgylw.kiftd.server.util.LogUtil;
import kohgylw.kiftd.server.util.ServerTimeUtil;
import kohgylw.kiftd.server.util.TextFormateUtil;
import org.springframework.stereotype.Service;

@Service
public class FolderServiceImpl
implements FolderService {
    @Resource
    private FolderMapper fm;
    @Resource
    private NodeMapper nm;
    @Resource
    private FolderUtil fu;
    @Resource
    private LogUtil lu;

    @Override
    public String newFolder(HttpServletRequest request) {
        String parentId = request.getParameter("parentId");
        String folderName = request.getParameter("folderName");
        String folderConstraint = request.getParameter("folderConstraint");
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        if (!ConfigureReader.instance().authorized(account, AccountAuth.CREATE_NEW_FOLDER)) {
            return "noAuthorized";
        }
        if (parentId == null || folderName == null || parentId.length() <= 0 || folderName.length() <= 0) {
            return "errorParameter";
        }
        if (!TextFormateUtil.instance().matcherFolderName(folderName) || folderName.indexOf(".") == 0) {
            return "errorParameter";
        }
        Folder parentFolder = this.fm.queryById(parentId);
        if (parentFolder == null) {
            return "errorParameter";
        }
        if (this.fm.queryByParentId(parentId).parallelStream().anyMatch(e -> e.getFolderName().equals(folderName))) {
            return "nameOccupied";
        }
        Folder f = new Folder();
        int pc = parentFolder.getFolderConstraint();
        if (folderConstraint != null) {
            try {
                int ifc = Integer.parseInt(folderConstraint);
                if (ifc > 0 && account == null) {
                    return "errorParameter";
                }
                if (ifc < pc) {
                    return "errorParameter";
                }
                f.setFolderConstraint(ifc);
            }
            catch (Exception e2) {
                return "errorParameter";
            }
        } else {
            return "errorParameter";
        }
        f.setFolderId(UUID.randomUUID().toString());
        f.setFolderName(folderName);
        f.setFolderCreationDate(ServerTimeUtil.accurateToDay());
        if (account != null) {
            f.setFolderCreator(account);
        } else {
            f.setFolderCreator("\u533f\u540d\u7528\u6237");
        }
        f.setFolderParent(parentId);
        int i = 0;
        while (true) {
            try {
                int r = this.fm.insertNewFolder(f);
                if (r > 0) {
                    this.lu.writeCreateFolderEvent(request, f);
                    return "createFolderSuccess";
                }
            }
            catch (Exception e3) {
                f.setFolderId(UUID.randomUUID().toString());
                if (++i < 10) continue;
            }
            break;
        }
        return "cannotCreateFolder";
    }

    @Override
    public String deleteFolder(HttpServletRequest request) {
        String folderId = request.getParameter("folderId");
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        if (!ConfigureReader.instance().authorized(account, AccountAuth.DELETE_FILE_OR_FOLDER)) {
            return "noAuthorized";
        }
        if (folderId == null || folderId.length() <= 0) {
            return "errorParameter";
        }
        Folder folder = this.fm.queryById(folderId);
        if (folder == null) {
            return "deleteFolderSuccess";
        }
        List<Folder> l = this.fu.getParentList(folderId);
        if (this.fu.deleteAllChildFolder(folderId) > 0) {
            this.lu.writeDeleteFolderEvent(request, folder, l);
            return "deleteFolderSuccess";
        }
        return "cannotDeleteFolder";
    }

    @Override
    public String renameFolder(HttpServletRequest request) {
        String folderId = request.getParameter("folderId");
        String newName = request.getParameter("newName");
        String folderConstraint = request.getParameter("folderConstraint");
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        if (!ConfigureReader.instance().authorized(account, AccountAuth.RENAME_FILE_OR_FOLDER)) {
            return "noAuthorized";
        }
        if (folderId == null || folderId.length() <= 0 || newName == null || newName.length() <= 0) {
            return "errorParameter";
        }
        if (!TextFormateUtil.instance().matcherFolderName(newName) || newName.indexOf(".") == 0) {
            return "errorParameter";
        }
        Folder folder = this.fm.queryById(folderId);
        if (folder == null) {
            return "errorParameter";
        }
        Folder parentFolder = this.fm.queryById(folder.getFolderParent());
        int pc = parentFolder.getFolderConstraint();
        if (folderConstraint != null) {
            try {
                int ifc = Integer.parseInt(folderConstraint);
                if (ifc > 0 && account == null) {
                    return "errorParameter";
                }
                if (ifc < pc) {
                    return "errorParameter";
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("newConstraint", ifc);
                map.put("folderId", folderId);
                this.fm.updateFolderConstraintById(map);
                this.changeChildFolderConstraint(folderId, ifc);
                if (!folder.getFolderName().equals(newName)) {
                    if (this.fm.queryByParentId(parentFolder.getFolderId()).parallelStream().anyMatch(e -> e.getFolderName().equals(newName))) {
                        return "nameOccupied";
                    }
                    HashMap<String, String> map2 = new HashMap<String, String>();
                    map2.put("folderId", folderId);
                    map2.put("newName", newName);
                    if (this.fm.updateFolderNameById(map2) == 0) {
                        return "errorParameter";
                    }
                }
                this.lu.writeRenameFolderEvent(request, folder, newName, folderConstraint);
                return "renameFolderSuccess";
            }
            catch (Exception e2) {
                return "errorParameter";
            }
        }
        return "errorParameter";
    }

    private void changeChildFolderConstraint(String folderId, int c) {
        List<Folder> cfs = this.fm.queryByParentId(folderId);
        for (Folder cf : cfs) {
            if (cf.getFolderConstraint() < c) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("newConstraint", c);
                map.put("folderId", cf.getFolderId());
                this.fm.updateFolderConstraintById(map);
            }
            this.changeChildFolderConstraint(cf.getFolderId(), c);
        }
    }
}

