/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.service.impl;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kohgylw.kiftd.server.enumeration.AccountAuth;
import kohgylw.kiftd.server.mapper.FolderMapper;
import kohgylw.kiftd.server.mapper.NodeMapper;
import kohgylw.kiftd.server.model.Folder;
import kohgylw.kiftd.server.model.Node;
import kohgylw.kiftd.server.pojo.CheckUploadFilesRespons;
import kohgylw.kiftd.server.pojo.UploadKeyCertificate;
import kohgylw.kiftd.server.service.FileService;
import kohgylw.kiftd.server.util.ConfigureReader;
import kohgylw.kiftd.server.util.FileBlockUtil;
import kohgylw.kiftd.server.util.FileNodeUtil;
import kohgylw.kiftd.server.util.FolderUtil;
import kohgylw.kiftd.server.util.LogUtil;
import kohgylw.kiftd.server.util.RangeFileStreamWriter;
import kohgylw.kiftd.server.util.ServerTimeUtil;
import kohgylw.kiftd.server.util.TextFormateUtil;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileServiceImpl
extends RangeFileStreamWriter
implements FileService {
    private static final String ERROR_PARAMETER = "errorParameter";
    private static final String NO_AUTHORIZED = "noAuthorized";
    private static final String UPLOADSUCCESS = "uploadsuccess";
    private static final String UPLOADERROR = "uploaderror";
    private static Map<String, UploadKeyCertificate> keyEffecMap = new HashMap<String, UploadKeyCertificate>();
    @Resource
    private NodeMapper fm;
    @Resource
    private FolderMapper flm;
    @Resource
    private LogUtil lu;
    @Resource
    private Gson gson;
    @Resource
    private FileBlockUtil fbu;
    @Resource
    private FolderUtil fu;
    private static final String CONTENT_TYPE = "application/octet-stream";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String checkUploadFile(HttpServletRequest request, HttpServletResponse response) {
        Object fileName2;
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        String folderId = request.getParameter("folderId");
        String nameList = request.getParameter("namelist");
        if (!ConfigureReader.instance().authorized(account, AccountAuth.UPLOAD_FILES)) {
            return NO_AUTHORIZED;
        }
        List namelistObj = (List)this.gson.fromJson(nameList, new TypeToken<List<String>>(){}.getType());
        ArrayList<String> pereFileNameList = new ArrayList<String>();
        for (Object fileName2 : namelistObj) {
            if (folderId == null || folderId.length() <= 0 || fileName2 == null || ((String)fileName2).length() <= 0) {
                return ERROR_PARAMETER;
            }
            List<Node> files = this.fm.queryByParentFolderId(folderId);
            if (!((Stream)files.stream().parallel()).anyMatch(arg_0 -> FileServiceImpl.lambda$checkUploadFile$0((String)fileName2, arg_0))) continue;
            pereFileNameList.add((String)fileName2);
        }
        String key = UUID.randomUUID().toString();
        fileName2 = keyEffecMap;
        synchronized (fileName2) {
            keyEffecMap.put(key, new UploadKeyCertificate(namelistObj.size(), account));
        }
        CheckUploadFilesRespons cufr = new CheckUploadFilesRespons();
        cufr.setUploadKey(key);
        if (pereFileNameList.size() > 0) {
            cufr.setCheckResult("hasExistsNames");
            cufr.setPereFileNameList(pereFileNameList);
        } else {
            cufr.setCheckResult("permitUpload");
            cufr.setPereFileNameList(new ArrayList<String>());
        }
        return this.gson.toJson((Object)cufr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String doUploadFile(HttpServletRequest request, HttpServletResponse response, MultipartFile file) {
        String path;
        String originalFileName;
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        String folderId = request.getParameter("folderId");
        String fileName = originalFileName = new String(file.getOriginalFilename().getBytes(Charset.forName("UTF-8")), Charset.forName("UTF-8"));
        String repeType = request.getParameter("repeType");
        if (folderId == null || folderId.length() <= 0 || originalFileName == null || originalFileName.length() <= 0) {
            return UPLOADERROR;
        }
        String uploadKey = request.getParameter("uploadKey");
        if (uploadKey != null) {
            Map<String, UploadKeyCertificate> map = keyEffecMap;
            synchronized (map) {
                Object c = keyEffecMap.get(uploadKey);
                if (c != null && ((UploadKeyCertificate)c).isEffective()) {
                    ((UploadKeyCertificate)c).checked();
                    account = ((UploadKeyCertificate)c).getAccount();
                    if (!((UploadKeyCertificate)c).isEffective()) {
                        keyEffecMap.remove(uploadKey);
                    }
                } else {
                    return UPLOADERROR;
                }
            }
        } else {
            return UPLOADERROR;
        }
        List<Node> files = this.fm.queryByParentFolderId(folderId);
        if (files.parallelStream().anyMatch(e -> e.getFileName().equals(originalFileName))) {
            if (repeType != null) {
                switch (repeType) {
                    case "skip": {
                        return UPLOADSUCCESS;
                    }
                    case "cover": {
                        if (!ConfigureReader.instance().authorized(account, AccountAuth.DELETE_FILE_OR_FOLDER)) {
                            return UPLOADERROR;
                        }
                        for (Node f : files) {
                            if (!f.getFileName().equals(originalFileName)) continue;
                            File file2 = this.fbu.getFileFromBlocks(f);
                            try {
                                file.transferTo(file2);
                                f.setFileSize(this.fbu.getFileSize(file));
                                f.setFileCreationDate(ServerTimeUtil.accurateToDay());
                                if (account != null) {
                                    f.setFileCreator(account);
                                } else {
                                    f.setFileCreator("\u533f\u540d\u7528\u6237");
                                }
                                if (this.fm.update(f) > 0) {
                                    this.lu.writeUploadFileEvent(f, account);
                                    return UPLOADSUCCESS;
                                }
                                return UPLOADERROR;
                            }
                            catch (Exception e2) {
                                return UPLOADERROR;
                            }
                        }
                        return UPLOADERROR;
                    }
                    case "both": {
                        fileName = FileNodeUtil.getNewNodeName(originalFileName, files);
                        break;
                    }
                    default: {
                        return UPLOADERROR;
                    }
                }
            } else {
                return UPLOADERROR;
            }
        }
        if ((path = this.fbu.saveToFileBlocks(file)).equals("ERROR")) {
            return UPLOADERROR;
        }
        String fsize = this.fbu.getFileSize(file);
        Node f2 = new Node();
        f2.setFileId(UUID.randomUUID().toString());
        if (account != null) {
            f2.setFileCreator(account);
        } else {
            f2.setFileCreator("\u533f\u540d\u7528\u6237");
        }
        f2.setFileCreationDate(ServerTimeUtil.accurateToDay());
        f2.setFileName(fileName);
        f2.setFileParentFolder(folderId);
        f2.setFilePath(path);
        f2.setFileSize(fsize);
        int i = 0;
        while (true) {
            try {
                if (this.fm.insert(f2) > 0) {
                    this.lu.writeUploadFileEvent(f2, account);
                    return UPLOADSUCCESS;
                }
            }
            catch (Exception e3) {
                f2.setFileId(UUID.randomUUID().toString());
                if (++i < 10) continue;
            }
            break;
        }
        return UPLOADERROR;
    }

    @Override
    public String deleteFile(HttpServletRequest request) {
        String fileId = request.getParameter("fileId");
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        if (!ConfigureReader.instance().authorized(account, AccountAuth.DELETE_FILE_OR_FOLDER)) {
            return NO_AUTHORIZED;
        }
        if (fileId == null || fileId.length() <= 0) {
            return ERROR_PARAMETER;
        }
        Node file = this.fm.queryById(fileId);
        if (file == null) {
            return ERROR_PARAMETER;
        }
        if (!this.fbu.deleteFromFileBlocks(file)) {
            return "cannotDeleteFile";
        }
        if (this.fm.deleteById(fileId) > 0) {
            this.lu.writeDeleteFileEvent(request, file);
            return "deleteFileSuccess";
        }
        return "cannotDeleteFile";
    }

    @Override
    public void doDownloadFile(HttpServletRequest request, HttpServletResponse response) {
        Node f;
        String fileId;
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        if (ConfigureReader.instance().authorized(account, AccountAuth.DOWNLOAD_FILES) && (fileId = request.getParameter("fileId")) != null && (f = this.fm.queryById(fileId)) != null) {
            File fo = this.fbu.getFileFromBlocks(f);
            this.writeRangeFileStream(request, response, fo, f.getFileName(), CONTENT_TYPE);
            if (request.getHeader("Range") == null) {
                this.lu.writeDownloadFileEvent(request, f);
            }
            return;
        }
        try {
            response.sendError(404);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String doRenameFile(HttpServletRequest request) {
        String fileId = request.getParameter("fileId");
        String newFileName = request.getParameter("newFileName");
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        if (!ConfigureReader.instance().authorized(account, AccountAuth.RENAME_FILE_OR_FOLDER)) {
            return NO_AUTHORIZED;
        }
        if (fileId == null || fileId.length() <= 0 || newFileName == null || newFileName.length() <= 0) {
            return ERROR_PARAMETER;
        }
        if (!TextFormateUtil.instance().matcherFileName(newFileName) || newFileName.indexOf(".") == 0) {
            return ERROR_PARAMETER;
        }
        Node file = this.fm.queryById(fileId);
        if (file == null) {
            return ERROR_PARAMETER;
        }
        if (!file.getFileName().equals(newFileName)) {
            if (this.fm.queryBySomeFolder(fileId).parallelStream().anyMatch(e -> e.getFileName().equals(newFileName))) {
                return "nameOccupied";
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("fileId", fileId);
            map.put("newFileName", newFileName);
            if (this.fm.updateFileNameById(map) == 0) {
                return "cannotRenameFile";
            }
        }
        this.lu.writeRenameFileEvent(request, file, newFileName);
        return "renameFileSuccess";
    }

    @Override
    public String deleteCheckedFiles(HttpServletRequest request) {
        String strIdList = request.getParameter("strIdList");
        String strFidList = request.getParameter("strFidList");
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        if (ConfigureReader.instance().authorized(account, AccountAuth.DELETE_FILE_OR_FOLDER)) {
            try {
                List idList = (List)this.gson.fromJson(strIdList, new TypeToken<List<String>>(){}.getType());
                for (String fileId : idList) {
                    if (fileId == null || fileId.length() <= 0) {
                        return ERROR_PARAMETER;
                    }
                    Node file = this.fm.queryById(fileId);
                    if (file == null) {
                        return "deleteFileSuccess";
                    }
                    if (!this.fbu.deleteFromFileBlocks(file)) {
                        return "cannotDeleteFile";
                    }
                    if (this.fm.deleteById(fileId) <= 0) {
                        return "cannotDeleteFile";
                    }
                    this.lu.writeDeleteFileEvent(request, file);
                }
                List fidList = (List)this.gson.fromJson(strFidList, new TypeToken<List<String>>(){}.getType());
                for (String fid : fidList) {
                    Folder folder = this.flm.queryById(fid);
                    List<Folder> l = this.fu.getParentList(fid);
                    if (this.fu.deleteAllChildFolder(fid) <= 0) {
                        return "cannotDeleteFile";
                    }
                    this.lu.writeDeleteFolderEvent(request, folder, l);
                }
                return "deleteFileSuccess";
            }
            catch (Exception e) {
                return ERROR_PARAMETER;
            }
        }
        return NO_AUTHORIZED;
    }

    @Override
    public String downloadCheckedFiles(HttpServletRequest request) {
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        if (ConfigureReader.instance().authorized(account, AccountAuth.DOWNLOAD_FILES)) {
            String strIdList = request.getParameter("strIdList");
            String strFidList = request.getParameter("strFidList");
            try {
                List idList = (List)this.gson.fromJson(strIdList, new TypeToken<List<String>>(){}.getType());
                List fidList = (List)this.gson.fromJson(strFidList, new TypeToken<List<String>>(){}.getType());
                if (idList.size() > 0 || fidList.size() > 0) {
                    String zipname = this.fbu.createZip(idList, fidList, account);
                    this.lu.writeDownloadCheckedFileEvent(request, idList);
                    return zipname;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "ERROR";
    }

    @Override
    public void downloadCheckedFilesZip(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String zipname = request.getParameter("zipId");
        if (zipname != null && !zipname.equals("ERROR")) {
            String tfPath = ConfigureReader.instance().getTemporaryfilePath();
            File zip = new File(tfPath, zipname);
            String fname = "kiftd_" + ServerTimeUtil.accurateToDay() + "_\u6253\u5305\u4e0b\u8f7d.zip";
            if (zip.exists()) {
                this.writeRangeFileStream(request, response, zip, fname, CONTENT_TYPE);
                zip.delete();
            }
        }
    }

    @Override
    public String getPackTime(HttpServletRequest request) {
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        if (ConfigureReader.instance().authorized(account, AccountAuth.DOWNLOAD_FILES)) {
            String strIdList = request.getParameter("strIdList");
            String strFidList = request.getParameter("strFidList");
            try {
                List idList = (List)this.gson.fromJson(strIdList, new TypeToken<List<String>>(){}.getType());
                List fidList = (List)this.gson.fromJson(strFidList, new TypeToken<List<String>>(){}.getType());
                for (String fid : fidList) {
                    this.countFolderFilesId(account, fid, fidList);
                }
                long packTime = 0L;
                for (String fid : idList) {
                    Node n = this.fm.queryById(fid);
                    File f = new File(ConfigureReader.instance().getFileBlockPath(), n.getFilePath());
                    if (!f.exists()) continue;
                    packTime += f.length() / 25000000L;
                }
                if (packTime < 4L) {
                    return "\u9a6c\u4e0a\u5b8c\u6210";
                }
                if (packTime >= 4L && packTime < 10L) {
                    return "\u5927\u7ea610\u79d2";
                }
                if (packTime >= 10L && packTime < 35L) {
                    return "\u4e0d\u5230\u534a\u5206\u949f";
                }
                if (packTime >= 35L && packTime < 65L) {
                    return "\u5927\u7ea61\u5206\u949f";
                }
                if (packTime >= 65L) {
                    return "\u8d85\u8fc7" + packTime / 60L + "\u5206\u949f\uff0c\u8017\u65f6\u8f83\u957f\uff0c\u5efa\u8bae\u76f4\u63a5\u4e0b\u8f7d";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "0";
    }

    private void countFolderFilesId(String account, String fid, List<String> idList) {
        Folder f = this.flm.queryById(fid);
        if (ConfigureReader.instance().accessFolder(f, account)) {
            idList.addAll(Arrays.asList(this.fm.queryByParentFolderId(fid).parallelStream().map(e -> e.getFileId()).toArray(String[]::new)));
            List<Folder> cFolders = this.flm.queryByParentId(fid);
            for (Folder cFolder : cFolders) {
                this.countFolderFilesId(account, cFolder.getFolderId(), idList);
            }
        }
    }

    @Override
    public String doMoveFiles(HttpServletRequest request) {
        String strIdList = request.getParameter("strIdList");
        String strFidList = request.getParameter("strFidList");
        String strOptMap = request.getParameter("strOptMap");
        String locationpath = request.getParameter("locationpath");
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        if (ConfigureReader.instance().authorized(account, AccountAuth.MOVE_FILES)) {
            try {
                List idList = (List)this.gson.fromJson(strIdList, new TypeToken<List<String>>(){}.getType());
                Map optMap = (Map)this.gson.fromJson(strOptMap, new TypeToken<Map<String, String>>(){}.getType());
                for (String id : idList) {
                    if (id == null || id.length() <= 0) {
                        return ERROR_PARAMETER;
                    }
                    Node node = this.fm.queryById(id);
                    if (node == null) {
                        return ERROR_PARAMETER;
                    }
                    if (node.getFileParentFolder().equals(locationpath)) break;
                    if (this.fm.queryByParentFolderId(locationpath).parallelStream().anyMatch(e -> e.getFileName().equals(node.getFileName()))) {
                        if (optMap.get(id) == null) {
                            return ERROR_PARAMETER;
                        }
                        switch ((String)optMap.get(id)) {
                            case "cover": {
                                HashMap<String, String> map;
                                if (!ConfigureReader.instance().authorized(account, AccountAuth.DELETE_FILE_OR_FOLDER)) {
                                    return NO_AUTHORIZED;
                                }
                                Node n = this.fm.queryByParentFolderId(locationpath).parallelStream().filter(e -> e.getFileName().equals(node.getFileName())).findFirst().get();
                                if (this.fm.deleteById(n.getFileId()) > 0) {
                                    map = new HashMap();
                                    map.put("fileId", node.getFileId());
                                    map.put("locationpath", locationpath);
                                    if (this.fm.moveById(map) <= 0) {
                                        return "cannotMoveFiles";
                                    }
                                } else {
                                    return "cannotMoveFiles";
                                }
                                this.lu.writeMoveFileEvent(request, node);
                                break;
                            }
                            case "both": {
                                node.setFileName(FileNodeUtil.getNewNodeName(node.getFileName(), this.fm.queryByParentFolderId(locationpath)));
                                if (this.fm.update(node) <= 0) {
                                    return "cannotMoveFiles";
                                }
                                HashMap<String, String> map = new HashMap<String, String>();
                                map.put("fileId", node.getFileId());
                                map.put("locationpath", locationpath);
                                if (this.fm.moveById(map) <= 0) {
                                    return "cannotMoveFiles";
                                }
                                this.lu.writeMoveFileEvent(request, node);
                                break;
                            }
                            case "skip": {
                                break;
                            }
                            default: {
                                return ERROR_PARAMETER;
                            }
                        }
                        continue;
                    }
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("fileId", node.getFileId());
                    map.put("locationpath", locationpath);
                    if (this.fm.moveById(map) <= 0) {
                        return "cannotMoveFiles";
                    }
                    this.lu.writeMoveFileEvent(request, node);
                }
                List fidList = (List)this.gson.fromJson(strFidList, new TypeToken<List<String>>(){}.getType());
                for (String fid : fidList) {
                    if (fid == null || fid.length() <= 0) {
                        return ERROR_PARAMETER;
                    }
                    Folder folder = this.flm.queryById(fid);
                    if (folder == null) {
                        return ERROR_PARAMETER;
                    }
                    if (folder.getFolderParent().equals(locationpath)) break;
                    if (fid.equals(locationpath) || this.fu.getParentList(locationpath).parallelStream().anyMatch(e -> e.getFolderId().equals(folder.getFolderId()))) {
                        return ERROR_PARAMETER;
                    }
                    if (this.flm.queryByParentId(locationpath).parallelStream().anyMatch(e -> e.getFolderName().equals(folder.getFolderName()))) {
                        if (optMap.get(fid) == null) {
                            return ERROR_PARAMETER;
                        }
                        switch ((String)optMap.get(fid)) {
                            case "cover": {
                                if (!ConfigureReader.instance().authorized(account, AccountAuth.DELETE_FILE_OR_FOLDER)) {
                                    return NO_AUTHORIZED;
                                }
                                Folder f = this.flm.queryByParentId(locationpath).parallelStream().filter(e -> e.getFolderName().equals(folder.getFolderName())).findFirst().get();
                                HashMap<String, String> map = new HashMap<String, String>();
                                map.put("folderId", folder.getFolderId());
                                map.put("locationpath", locationpath);
                                if (this.flm.moveById(map) > 0 && this.fu.deleteAllChildFolder(f.getFolderId()) > 0) {
                                    this.lu.writeMoveFileEvent(request, folder);
                                    break;
                                }
                                return "cannotMoveFiles";
                            }
                            case "both": {
                                HashMap<String, String> map3 = new HashMap<String, String>();
                                map3.put("folderId", folder.getFolderId());
                                map3.put("locationpath", locationpath);
                                if (this.flm.moveById(map3) > 0) {
                                    HashMap<String, String> map2 = new HashMap<String, String>();
                                    map2.put("folderId", folder.getFolderId());
                                    map2.put("newName", FileNodeUtil.getNewFolderName(folder.getFolderName(), this.flm.queryByParentId(locationpath)));
                                    if (this.flm.updateFolderNameById(map2) <= 0) {
                                        return "cannotMoveFiles";
                                    }
                                    this.lu.writeMoveFileEvent(request, folder);
                                    break;
                                }
                                this.lu.writeMoveFileEvent(request, folder);
                                break;
                            }
                            case "skip": {
                                break;
                            }
                            default: {
                                return ERROR_PARAMETER;
                            }
                        }
                        continue;
                    }
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("folderId", folder.getFolderId());
                    map.put("locationpath", locationpath);
                    if (this.flm.moveById(map) > 0) {
                        this.lu.writeMoveFileEvent(request, folder);
                        continue;
                    }
                    return "cannotMoveFiles";
                }
                return "moveFilesSuccess";
            }
            catch (Exception e2) {
                return ERROR_PARAMETER;
            }
        }
        return NO_AUTHORIZED;
    }

    @Override
    public String confirmMoveFiles(HttpServletRequest request) {
        String strIdList = request.getParameter("strIdList");
        String strFidList = request.getParameter("strFidList");
        String locationpath = request.getParameter("locationpath");
        String account = (String)request.getSession().getAttribute("ACCOUNT");
        if (ConfigureReader.instance().authorized(account, AccountAuth.MOVE_FILES)) {
            try {
                List idList = (List)this.gson.fromJson(strIdList, new TypeToken<List<String>>(){}.getType());
                List fidList = (List)this.gson.fromJson(strFidList, new TypeToken<List<String>>(){}.getType());
                ArrayList<Node> repeNodes = new ArrayList<Node>();
                ArrayList<Folder> repeFolders = new ArrayList<Folder>();
                for (String fileId : idList) {
                    if (fileId == null || fileId.length() <= 0) {
                        return ERROR_PARAMETER;
                    }
                    Node node = this.fm.queryById(fileId);
                    if (node == null) {
                        return ERROR_PARAMETER;
                    }
                    if (node.getFileParentFolder().equals(locationpath)) break;
                    if (!this.fm.queryByParentFolderId(locationpath).parallelStream().anyMatch(e -> e.getFileName().equals(node.getFileName()))) continue;
                    repeNodes.add(node);
                }
                for (String folderId : fidList) {
                    if (folderId == null || folderId.length() <= 0) {
                        return ERROR_PARAMETER;
                    }
                    Folder folder = this.flm.queryById(folderId);
                    if (folder == null) {
                        return ERROR_PARAMETER;
                    }
                    if (folder.getFolderParent().equals(locationpath)) break;
                    if (folderId.equals(locationpath) || this.fu.getParentList(locationpath).parallelStream().anyMatch(e -> e.getFolderId().equals(folder.getFolderId()))) {
                        return "CANT_MOVE_TO_INSIDE:" + folder.getFolderName();
                    }
                    if (!this.flm.queryByParentId(locationpath).parallelStream().anyMatch(e -> e.getFolderName().equals(folder.getFolderName()))) continue;
                    repeFolders.add(folder);
                }
                if (repeNodes.size() > 0 || repeFolders.size() > 0) {
                    HashMap<String, ArrayList<Object>> repeMap = new HashMap<String, ArrayList<Object>>();
                    repeMap.put("repeFolders", repeFolders);
                    repeMap.put("repeNodes", repeNodes);
                    return "duplicationFileName:" + this.gson.toJson(repeMap);
                }
                return "confirmMoveFiles";
            }
            catch (Exception e2) {
                return ERROR_PARAMETER;
            }
        }
        return NO_AUTHORIZED;
    }

    private static /* synthetic */ boolean lambda$checkUploadFile$0(String fileName, Node n) {
        return n.getFileName().equals(new String(fileName.getBytes(Charset.forName("UTF-8")), Charset.forName("UTF-8")));
    }
}

