/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.service.impl;

import com.google.gson.Gson;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import kohgylw.kiftd.server.pojo.LoginInfoPojo;
import kohgylw.kiftd.server.pojo.PublicKeyInfo;
import kohgylw.kiftd.server.service.AccountService;
import kohgylw.kiftd.server.util.ConfigureReader;
import kohgylw.kiftd.server.util.DecryptionUtil;
import kohgylw.kiftd.server.util.KeyUtil;
import org.springframework.stereotype.Service;

@Service
public class AccountServiceImpl
implements AccountService {
    @Resource
    private KeyUtil ku;
    private static final long TIME_OUT = 30000L;
    @Resource
    private Gson gson;

    @Override
    public String checkLoginRequest(HttpServletRequest request, HttpSession session) {
        String encrypted = request.getParameter("encrypted");
        String loginInfoStr = DecryptionUtil.dncryption(encrypted, this.ku.getPrivateKey());
        try {
            String accountId;
            LoginInfoPojo info = (LoginInfoPojo)this.gson.fromJson(loginInfoStr, LoginInfoPojo.class);
            if (System.currentTimeMillis() - Long.parseLong(info.getTime()) > 30000L) {
                return "error";
            }
            ConfigureReader cr = ConfigureReader.instance();
            if (!cr.foundAccount(accountId = info.getAccountId())) {
                return "accountnotfound";
            }
            if (cr.checkAccountPwd(accountId, info.getAccountPwd())) {
                session.setAttribute("ACCOUNT", (Object)accountId);
                return "permitlogin";
            }
            return "accountpwderror";
        }
        catch (Exception e) {
            return "error";
        }
    }

    @Override
    public void logout(HttpSession session) {
        session.invalidate();
    }

    @Override
    public String getPublicKey() {
        PublicKeyInfo pki = new PublicKeyInfo();
        pki.setPublicKey(this.ku.getPublicKey());
        pki.setTime(System.currentTimeMillis());
        return this.gson.toJson((Object)pki);
    }
}

