/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.pojo;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.UUID;
import kohgylw.kiftd.server.util.ConfigureReader;
import org.apache.commons.codec.digest.DigestUtils;
import ws.schild.jave.Encoder;
import ws.schild.jave.EncoderProgressListener;
import ws.schild.jave.EncodingAttributes;
import ws.schild.jave.MultimediaInfo;
import ws.schild.jave.MultimediaObject;

public class VideoTranscodeThread {
    private String md5;
    private String progress;
    private Encoder encoder;
    private String outputFileName;

    public VideoTranscodeThread(File f, EncodingAttributes ea) throws Exception {
        this.md5 = DigestUtils.md5Hex((InputStream)new FileInputStream(f));
        this.progress = "0.0";
        MultimediaObject mo = new MultimediaObject(f);
        this.encoder = new Encoder();
        Thread t = new Thread(() -> {
            try {
                this.outputFileName = "video_" + UUID.randomUUID().toString() + ".mp4";
                this.encoder.encode(mo, new File(ConfigureReader.instance().getTemporaryfilePath(), this.outputFileName), ea, new EncoderProgressListener(){

                    public void sourceInfo(MultimediaInfo arg0) {
                    }

                    public void progress(int arg0) {
                        VideoTranscodeThread.this.progress = (double)arg0 / 10.0 + "";
                    }

                    public void message(String arg0) {
                    }
                });
                this.progress = "FIN";
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        t.start();
    }

    public String getMd5() {
        return this.md5;
    }

    public String getProgress() {
        return this.progress;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public void abort() {
        File f;
        if (this.encoder != null) {
            this.encoder.abortEncoding();
        }
        if ((f = new File(ConfigureReader.instance().getTemporaryfilePath(), this.outputFileName)).exists()) {
            f.delete();
        }
    }
}

