/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.ctl;

import kohgylw.kiftd.printer.Printer;
import kohgylw.kiftd.server.configation.MVC;
import kohgylw.kiftd.server.util.ConfigureReader;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.server.ErrorPage;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpStatus;

@SpringBootApplication
@Import(value={MVC.class})
public class KiftdCtl
implements WebServerFactoryCustomizer<ConfigurableServletWebServerFactory> {
    private static ApplicationContext context;
    private static boolean run;

    public boolean start() {
        Printer.instance.print("\u6b63\u5728\u542f\u52a8\u670d\u52a1\u5668...");
        String[] args = new String[]{};
        if (!run) {
            if (ConfigureReader.instance().getPropertiesStatus() == 0) {
                try {
                    Printer.instance.print("\u6b63\u5728\u5f00\u542f\u670d\u52a1\u5668\u5f15\u64ce...");
                    context = SpringApplication.run(KiftdCtl.class, (String[])args);
                    run = context != null;
                    Printer.instance.print("\u670d\u52a1\u5668\u5f15\u64ce\u5df2\u542f\u52a8\u3002");
                    return run;
                }
                catch (Exception e) {
                    return false;
                }
            }
            Printer.instance.print("\u670d\u52a1\u5668\u8bbe\u7f6e\u68c0\u67e5\u5931\u8d25\uff0c\u65e0\u6cd5\u5f00\u542f\u670d\u52a1\u5668\u3002");
            return false;
        }
        Printer.instance.print("\u670d\u52a1\u5668\u6b63\u5728\u8fd0\u884c\u4e2d\u3002");
        return true;
    }

    public boolean stop() {
        Printer.instance.print("\u6b63\u5728\u5173\u95ed\u670d\u52a1\u5668...");
        if (context != null) {
            Printer.instance.print("\u6b63\u5728\u7ec8\u6b62\u670d\u52a1\u5668\u5f15\u64ce...");
            try {
                run = SpringApplication.exit((ApplicationContext)context, (ExitCodeGenerator[])new ExitCodeGenerator[0]) != 0;
                Printer.instance.print("\u670d\u52a1\u5668\u5f15\u64ce\u5df2\u7ec8\u6b62\u3002");
                return !run;
            }
            catch (Exception e) {
                return false;
            }
        }
        Printer.instance.print("\u670d\u52a1\u5668\u672a\u542f\u52a8\u3002");
        return true;
    }

    public void customize(ConfigurableServletWebServerFactory factory) {
        factory.setPort(ConfigureReader.instance().getPort());
        factory.addErrorPages(new ErrorPage[]{new ErrorPage(HttpStatus.NOT_FOUND, "/errorController/pageNotFound.do")});
        factory.addErrorPages(new ErrorPage[]{new ErrorPage(HttpStatus.INTERNAL_SERVER_ERROR, "/errorController/pageNotFound.do")});
    }

    public boolean started() {
        return run;
    }

    static {
        run = false;
    }
}

