/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.controller;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import kohgylw.kiftd.server.service.AccountService;
import kohgylw.kiftd.server.service.FileService;
import kohgylw.kiftd.server.service.FolderService;
import kohgylw.kiftd.server.service.FolderViewService;
import kohgylw.kiftd.server.service.PlayAudioService;
import kohgylw.kiftd.server.service.PlayVideoService;
import kohgylw.kiftd.server.service.ServerInfoService;
import kohgylw.kiftd.server.service.ShowPictureService;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/homeController"})
public class HomeController {
    private static final String CHARSET_BY_AJAX = "text/html; charset=utf-8";
    @Resource
    private ServerInfoService si;
    @Resource
    private AccountService as;
    @Resource
    private FolderViewService fvs;
    @Resource
    private FolderService fs;
    @Resource
    private FileService fis;
    @Resource
    private PlayVideoService pvs;
    @Resource
    private ShowPictureService sps;
    @Resource
    private PlayAudioService pas;

    @RequestMapping(value={"/getServerOS.ajax"})
    @ResponseBody
    public String getServerOS() {
        return this.si.getOSName();
    }

    @RequestMapping(value={"/getPublicKey.ajax"}, produces={"text/html; charset=utf-8"})
    @ResponseBody
    public String getPublicKey() {
        return this.as.getPublicKey();
    }

    @RequestMapping(value={"/doLogin.ajax"})
    @ResponseBody
    public String doLogin(HttpServletRequest request, HttpSession session) {
        return this.as.checkLoginRequest(request, session);
    }

    @RequestMapping(value={"/getFolderView.ajax"}, produces={"text/html; charset=utf-8"})
    @ResponseBody
    public String getFolderView(String fid, HttpSession session, HttpServletRequest request) {
        return this.fvs.getFolderViewToJson(fid, session, request);
    }

    @RequestMapping(value={"/doLogout.ajax"})
    @ResponseBody
    public String doLogout(HttpSession session) {
        this.as.logout(session);
        return "SUCCESS";
    }

    @RequestMapping(value={"/newFolder.ajax"})
    @ResponseBody
    public String newFolder(HttpServletRequest request) {
        return this.fs.newFolder(request);
    }

    @RequestMapping(value={"/deleteFolder.ajax"})
    @ResponseBody
    public String deleteFolder(HttpServletRequest request) {
        return this.fs.deleteFolder(request);
    }

    @RequestMapping(value={"/renameFolder.ajax"})
    @ResponseBody
    public String renameFolder(HttpServletRequest request) {
        return this.fs.renameFolder(request);
    }

    @RequestMapping(value={"/douploadFile.ajax"}, produces={"text/html; charset=utf-8"})
    @ResponseBody
    public String douploadFile(HttpServletRequest request, HttpServletResponse response, MultipartFile file) {
        return this.fis.doUploadFile(request, response, file);
    }

    @RequestMapping(value={"/checkUploadFile.ajax"}, produces={"text/html; charset=utf-8"})
    @ResponseBody
    public String checkUploadFile(HttpServletRequest request, HttpServletResponse response) {
        return this.fis.checkUploadFile(request, response);
    }

    @RequestMapping(value={"/deleteFile.ajax"})
    @ResponseBody
    public String deleteFile(HttpServletRequest request) {
        return this.fis.deleteFile(request);
    }

    @RequestMapping(value={"/downloadFile.do"})
    public void downloadFile(HttpServletRequest request, HttpServletResponse response) {
        this.fis.doDownloadFile(request, response);
    }

    @RequestMapping(value={"/renameFile.ajax"})
    @ResponseBody
    public String renameFile(HttpServletRequest request) {
        return this.fis.doRenameFile(request);
    }

    @RequestMapping(value={"/playVideo.ajax"}, produces={"text/html; charset=utf-8"})
    @ResponseBody
    public String playVideo(HttpServletRequest request, HttpServletResponse response) {
        return this.pvs.getPlayVideoJson(request);
    }

    @RequestMapping(value={"/getPrePicture.ajax"}, produces={"text/html; charset=utf-8"})
    @ResponseBody
    public String getPrePicture(HttpServletRequest request) {
        return this.sps.getPreviewPictureJson(request);
    }

    @RequestMapping(value={"/showCondensedPicture.do"})
    public void showCondensedPicture(HttpServletRequest request, HttpServletResponse response) {
        this.sps.getCondensedPicture(request, response);
    }

    @RequestMapping(value={"/deleteCheckedFiles.ajax"})
    @ResponseBody
    public String deleteCheckedFiles(HttpServletRequest request) {
        return this.fis.deleteCheckedFiles(request);
    }

    @RequestMapping(value={"/getPackTime.ajax"})
    @ResponseBody
    public String getPackTime(HttpServletRequest request) {
        return this.fis.getPackTime(request);
    }

    @RequestMapping(value={"/downloadCheckedFiles.ajax"})
    @ResponseBody
    public String downloadCheckedFiles(HttpServletRequest request) {
        return this.fis.downloadCheckedFiles(request);
    }

    @RequestMapping(value={"/downloadCheckedFilesZip.do"})
    public void downloadCheckedFilesZip(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.fis.downloadCheckedFilesZip(request, response);
    }

    @RequestMapping(value={"/playAudios.ajax"}, produces={"text/html; charset=utf-8"})
    @ResponseBody
    public String playAudios(HttpServletRequest request) {
        return this.pas.getAudioInfoListByJson(request);
    }

    @RequestMapping(value={"/confirmMoveFiles.ajax"}, produces={"text/html; charset=utf-8"})
    @ResponseBody
    public String confirmMoveFiles(HttpServletRequest request) {
        return this.fis.confirmMoveFiles(request);
    }

    @RequestMapping(value={"/moveCheckedFiles.ajax"})
    @ResponseBody
    public String moveCheckedFiles(HttpServletRequest request) {
        return this.fis.doMoveFiles(request);
    }

    @RequestMapping(value={"/sreachInCompletePath.ajax"}, produces={"text/html; charset=utf-8"})
    @ResponseBody
    public String sreachInCompletePath(HttpServletRequest request) {
        return this.fvs.getSreachViewToJson(request);
    }
}

