/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.server.configation;

import com.google.gson.Gson;
import java.io.File;
import javax.servlet.MultipartConfigElement;
import kohgylw.kiftd.server.configation.DataAccess;
import kohgylw.kiftd.server.util.ConfigureReader;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.boot.web.servlet.MultipartConfigFactory;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Import;
import org.springframework.web.servlet.config.annotation.DefaultServletHandlerConfigurer;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

@Configurable
@ComponentScan(value={"kohgylw.kiftd.server.controller", "kohgylw.kiftd.server.service.impl", "kohgylw.kiftd.server.util"})
@ServletComponentScan(value={"kohgylw.kiftd.server.listener", "kohgylw.kiftd.server.filter"})
@Import(value={DataAccess.class})
public class MVC
extends ResourceHttpRequestHandler
implements WebMvcConfigurer {
    public void configureDefaultServletHandling(DefaultServletHandlerConfigurer configurer) {
        configurer.enable();
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(new String[]{"file:" + ConfigureReader.instance().getPath() + File.separator + "webContext" + File.separator});
        registry.addResourceHandler(new String[]{"/fileblocks/**"}).addResourceLocations(new String[]{"file:" + ConfigureReader.instance().getFileBlockPath()});
    }

    @Bean
    public MultipartConfigElement multipartConfigElement() {
        MultipartConfigFactory factory = new MultipartConfigFactory();
        factory.setMaxFileSize(-1L);
        factory.setLocation(ConfigureReader.instance().getTemporaryfilePath());
        return factory.createMultipartConfig();
    }

    @Bean
    public Gson gson() {
        return new Gson();
    }
}

