/*
 * Decompiled with CFR 0.152.
 */
package kohgylw.kiftd.mc;

import kohgylw.kiftd.printer.Printer;
import kohgylw.kiftd.server.ctl.KiftdCtl;
import kohgylw.kiftd.server.enumeration.LogLevel;
import kohgylw.kiftd.server.pojo.ServerSetting;
import kohgylw.kiftd.server.util.ConfigureReader;
import kohgylw.kiftd.server.util.ServerTimeUtil;
import kohgylw.kiftd.ui.callback.GetServerStatus;
import kohgylw.kiftd.ui.callback.UpdateSetting;
import kohgylw.kiftd.ui.module.ServerUIModule;

public class UIRunner {
    private static UIRunner ui;

    private UIRunner() {
        Printer.init(true);
        ServerUIModule ui = ServerUIModule.getInsatnce();
        ui.show();
        Thread t = new Thread(() -> {
            final KiftdCtl ctl = new KiftdCtl();
            ServerUIModule.setStartServer(() -> ctl.start());
            ServerUIModule.setOnCloseServer(() -> ctl.stop());
            ServerUIModule.setGetServerTime(() -> ServerTimeUtil.getServerTime());
            ServerUIModule.setGetServerStatus(new GetServerStatus(){

                @Override
                public boolean getServerStatus() {
                    return ctl.started();
                }

                @Override
                public boolean getPropertiesStatus() {
                    return ConfigureReader.instance().getPropertiesStatus() == 0;
                }

                @Override
                public int getPort() {
                    return ConfigureReader.instance().getPort();
                }

                @Override
                public boolean getMustLogin() {
                    return ConfigureReader.instance().mustLogin();
                }

                @Override
                public LogLevel getLogLevel() {
                    return ConfigureReader.instance().getLogLevel();
                }

                @Override
                public String getFileSystemPath() {
                    return ConfigureReader.instance().getFileSystemPath();
                }

                @Override
                public int getBufferSize() {
                    return ConfigureReader.instance().getBuffSize();
                }
            });
            ServerUIModule.setUpdateSetting(new UpdateSetting(){

                @Override
                public boolean update(ServerSetting s) {
                    return ConfigureReader.instance().doUpdate(s);
                }
            });
            if (ConfigureReader.instance().getPropertiesStatus() == 0) {
                ui.updateServerStatus();
            } else {
                ConfigureReader.instance().createDefaultServerPropertiesFile();
                Printer.instance.print("\u914d\u7f6e\u6587\u4ef6\u5b58\u5728\u9519\u8bef\uff0c\u5df2\u8fd8\u539f\u4e3a\u521d\u59cb\u72b6\u6001\uff0c\u8bf7\u91cd\u65b0\u542f\u52a8kiftd\u3002");
            }
        });
        t.start();
    }

    public static UIRunner build() {
        if (ui == null) {
            ui = new UIRunner();
        }
        return ui;
    }
}

