/*
 * Decompiled with CFR 0.152.
 */
package ws.schild.jave;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ws.schild.jave.DefaultFFMPEGLocator;
import ws.schild.jave.EncoderException;
import ws.schild.jave.FFMPEGExecutor;
import ws.schild.jave.FFMPEGLocator;
import ws.schild.jave.InputFormatException;
import ws.schild.jave.MultimediaInfo;
import ws.schild.jave.MultimediaObject;
import ws.schild.jave.RBufferedReader;

public class ScreenExtractor {
    private static final Log LOG = LogFactory.getLog(ScreenExtractor.class);
    private final FFMPEGLocator locator;
    private int numberOfScreens;

    public ScreenExtractor() {
        this.locator = new DefaultFFMPEGLocator();
    }

    public int getNumberOfScreens() {
        return this.numberOfScreens;
    }

    public ScreenExtractor(FFMPEGLocator locator) {
        this.locator = locator;
    }

    public void render(MultimediaObject multimediaObject, int width, int height, int seconds, File outputDir, String fileNamePrefix, String extension, int quality) throws InputFormatException, EncoderException {
        File inputFile = multimediaObject.getFile();
        try {
            if (!outputDir.exists() && !outputDir.mkdirs()) {
                LOG.debug((Object)"Failed to create destination folder");
                throw new SecurityException();
            }
            if (!inputFile.canRead()) {
                LOG.debug((Object)"Failed to open input file");
                throw new SecurityException();
            }
        }
        catch (SecurityException e) {
            LOG.debug((Object)("Access denied checking destination folder" + e));
        }
        MultimediaInfo multimediaInfo = multimediaObject.getInfo();
        this.numberOfScreens = (int)Math.ceil((double)multimediaInfo.getDuration() * 0.001 / (double)seconds + 1.0);
        FFMPEGExecutor ffmpeg = this.locator.createExecutor();
        ffmpeg.addArgument("-i");
        ffmpeg.addArgument(inputFile.getAbsolutePath());
        ffmpeg.addArgument("-f");
        ffmpeg.addArgument("image2");
        ffmpeg.addArgument("-vf");
        ffmpeg.addArgument(String.format("fps=fps=1/%s", String.valueOf(seconds)));
        ffmpeg.addArgument("-s");
        ffmpeg.addArgument(String.format("%sx%s", String.valueOf(width), String.valueOf(height)));
        ffmpeg.addArgument("-qscale");
        ffmpeg.addArgument(String.valueOf(quality));
        ffmpeg.addArgument(String.format("%s%s%s-%%04d.%s", outputDir.getAbsolutePath(), File.separator, fileNamePrefix, extension));
        try {
            ffmpeg.execute();
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        try {
            String line;
            RBufferedReader reader = new RBufferedReader(new InputStreamReader(ffmpeg.getErrorStream()));
            boolean step = false;
            int lineNR = 0;
            while ((line = reader.readLine()) != null) {
                LOG.debug((Object)("Input Line (" + ++lineNR + "): " + line));
            }
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        finally {
            ffmpeg.destroy();
        }
    }

    public void render(MultimediaObject multimediaObject, int width, int height, int seconds, File target, int quality) throws EncoderException {
        File inputFile = multimediaObject.getFile();
        target = target.getAbsoluteFile();
        target.getParentFile().mkdirs();
        try {
            if (!inputFile.canRead()) {
                LOG.debug((Object)"Failed to open input file");
                throw new SecurityException();
            }
        }
        catch (SecurityException e) {
            LOG.debug((Object)("Access denied checking destination folder" + e));
        }
        MultimediaInfo multimediaInfo = multimediaObject.getInfo();
        int duration = (int)((double)multimediaInfo.getDuration() * 0.001);
        this.numberOfScreens = seconds <= duration ? 1 : 0;
        FFMPEGExecutor ffmpeg = this.locator.createExecutor();
        ffmpeg.addArgument("-i");
        ffmpeg.addArgument(inputFile.getAbsolutePath());
        ffmpeg.addArgument("-f");
        ffmpeg.addArgument("image2");
        ffmpeg.addArgument("-vframes");
        ffmpeg.addArgument("1");
        ffmpeg.addArgument("-ss");
        ffmpeg.addArgument(String.valueOf(seconds));
        ffmpeg.addArgument("-s");
        ffmpeg.addArgument(String.format("%sx%s", String.valueOf(width), String.valueOf(height)));
        ffmpeg.addArgument("-qscale");
        ffmpeg.addArgument(String.valueOf(quality));
        ffmpeg.addArgument(target.getAbsolutePath());
        try {
            ffmpeg.execute();
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        try {
            String line;
            RBufferedReader reader = new RBufferedReader(new InputStreamReader(ffmpeg.getErrorStream()));
            boolean step = false;
            int lineNR = 0;
            while ((line = reader.readLine()) != null) {
                LOG.debug((Object)("Input Line (" + ++lineNR + "): " + line));
            }
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        finally {
            ffmpeg.destroy();
        }
    }
}

