/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.parsing;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.parsing.PropertyParser;
import org.apache.ibatis.parsing.XPathParser;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XNode {
    private Node node;
    private String name;
    private String body;
    private Properties attributes;
    private Properties variables;
    private XPathParser xpathParser;

    public XNode(XPathParser xpathParser, Node node, Properties variables) {
        this.xpathParser = xpathParser;
        this.node = node;
        this.name = node.getNodeName();
        this.variables = variables;
        this.attributes = this.parseAttributes(node);
        this.body = this.parseBody(node);
    }

    public XNode newXNode(Node node) {
        return new XNode(this.xpathParser, node, this.variables);
    }

    public XNode getParent() {
        Node parent = this.node.getParentNode();
        if (parent == null || !(parent instanceof Element)) {
            return null;
        }
        return new XNode(this.xpathParser, parent, this.variables);
    }

    public String getPath() {
        StringBuilder builder = new StringBuilder();
        for (Node current = this.node; current != null && current instanceof Element; current = current.getParentNode()) {
            if (current != this.node) {
                builder.insert(0, "/");
            }
            builder.insert(0, current.getNodeName());
        }
        return builder.toString();
    }

    public String getValueBasedIdentifier() {
        StringBuilder builder = new StringBuilder();
        for (XNode current = this; current != null; current = current.getParent()) {
            String value;
            if (current != this) {
                builder.insert(0, "_");
            }
            if ((value = current.getStringAttribute("id", current.getStringAttribute("value", current.getStringAttribute("property", null)))) != null) {
                value = value.replace('.', '_');
                builder.insert(0, "]");
                builder.insert(0, value);
                builder.insert(0, "[");
            }
            builder.insert(0, current.getName());
        }
        return builder.toString();
    }

    public String evalString(String expression) {
        return this.xpathParser.evalString(this.node, expression);
    }

    public Boolean evalBoolean(String expression) {
        return this.xpathParser.evalBoolean(this.node, expression);
    }

    public Double evalDouble(String expression) {
        return this.xpathParser.evalDouble(this.node, expression);
    }

    public List<XNode> evalNodes(String expression) {
        return this.xpathParser.evalNodes(this.node, expression);
    }

    public XNode evalNode(String expression) {
        return this.xpathParser.evalNode(this.node, expression);
    }

    public Node getNode() {
        return this.node;
    }

    public String getName() {
        return this.name;
    }

    public String getStringBody() {
        return this.getStringBody(null);
    }

    public String getStringBody(String def) {
        if (this.body == null) {
            return def;
        }
        return this.body;
    }

    public Boolean getBooleanBody() {
        return this.getBooleanBody(null);
    }

    public Boolean getBooleanBody(Boolean def) {
        if (this.body == null) {
            return def;
        }
        return Boolean.valueOf(this.body);
    }

    public Integer getIntBody() {
        return this.getIntBody(null);
    }

    public Integer getIntBody(Integer def) {
        if (this.body == null) {
            return def;
        }
        return Integer.parseInt(this.body);
    }

    public Long getLongBody() {
        return this.getLongBody(null);
    }

    public Long getLongBody(Long def) {
        if (this.body == null) {
            return def;
        }
        return Long.parseLong(this.body);
    }

    public Double getDoubleBody() {
        return this.getDoubleBody(null);
    }

    public Double getDoubleBody(Double def) {
        if (this.body == null) {
            return def;
        }
        return Double.parseDouble(this.body);
    }

    public Float getFloatBody() {
        return this.getFloatBody(null);
    }

    public Float getFloatBody(Float def) {
        if (this.body == null) {
            return def;
        }
        return Float.valueOf(Float.parseFloat(this.body));
    }

    public <T extends Enum<T>> T getEnumAttribute(Class<T> enumType, String name) {
        return this.getEnumAttribute(enumType, name, null);
    }

    public <T extends Enum<T>> T getEnumAttribute(Class<T> enumType, String name, T def) {
        String value = this.getStringAttribute(name);
        if (value == null) {
            return def;
        }
        return Enum.valueOf(enumType, value);
    }

    public String getStringAttribute(String name) {
        return this.getStringAttribute(name, null);
    }

    public String getStringAttribute(String name, String def) {
        String value = this.attributes.getProperty(name);
        if (value == null) {
            return def;
        }
        return value;
    }

    public Boolean getBooleanAttribute(String name) {
        return this.getBooleanAttribute(name, null);
    }

    public Boolean getBooleanAttribute(String name, Boolean def) {
        String value = this.attributes.getProperty(name);
        if (value == null) {
            return def;
        }
        return Boolean.valueOf(value);
    }

    public Integer getIntAttribute(String name) {
        return this.getIntAttribute(name, null);
    }

    public Integer getIntAttribute(String name, Integer def) {
        String value = this.attributes.getProperty(name);
        if (value == null) {
            return def;
        }
        return Integer.parseInt(value);
    }

    public Long getLongAttribute(String name) {
        return this.getLongAttribute(name, null);
    }

    public Long getLongAttribute(String name, Long def) {
        String value = this.attributes.getProperty(name);
        if (value == null) {
            return def;
        }
        return Long.parseLong(value);
    }

    public Double getDoubleAttribute(String name) {
        return this.getDoubleAttribute(name, null);
    }

    public Double getDoubleAttribute(String name, Double def) {
        String value = this.attributes.getProperty(name);
        if (value == null) {
            return def;
        }
        return Double.parseDouble(value);
    }

    public Float getFloatAttribute(String name) {
        return this.getFloatAttribute(name, null);
    }

    public Float getFloatAttribute(String name, Float def) {
        String value = this.attributes.getProperty(name);
        if (value == null) {
            return def;
        }
        return Float.valueOf(Float.parseFloat(value));
    }

    public List<XNode> getChildren() {
        ArrayList<XNode> children = new ArrayList<XNode>();
        NodeList nodeList = this.node.getChildNodes();
        if (nodeList != null) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                children.add(new XNode(this.xpathParser, node, this.variables));
            }
        }
        return children;
    }

    public Properties getChildrenAsProperties() {
        Properties properties = new Properties();
        for (XNode child : this.getChildren()) {
            String name = child.getStringAttribute("name");
            String value = child.getStringAttribute("value");
            if (name == null || value == null) continue;
            properties.setProperty(name, value);
        }
        return properties;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<");
        builder.append(this.name);
        for (Map.Entry<Object, Object> entry : this.attributes.entrySet()) {
            builder.append(" ");
            builder.append(entry.getKey());
            builder.append("=\"");
            builder.append(entry.getValue());
            builder.append("\"");
        }
        List<XNode> children = this.getChildren();
        if (!children.isEmpty()) {
            builder.append(">\n");
            for (XNode node : children) {
                builder.append(node.toString());
            }
            builder.append("</");
            builder.append(this.name);
            builder.append(">");
        } else if (this.body != null) {
            builder.append(">");
            builder.append(this.body);
            builder.append("</");
            builder.append(this.name);
            builder.append(">");
        } else {
            builder.append("/>");
        }
        builder.append("\n");
        return builder.toString();
    }

    private Properties parseAttributes(Node n) {
        Properties attributes = new Properties();
        NamedNodeMap attributeNodes = n.getAttributes();
        if (attributeNodes != null) {
            for (int i = 0; i < attributeNodes.getLength(); ++i) {
                Node attribute = attributeNodes.item(i);
                String value = PropertyParser.parse(attribute.getNodeValue(), this.variables);
                attributes.put(attribute.getNodeName(), value);
            }
        }
        return attributes;
    }

    private String parseBody(Node node) {
        String data = this.getBodyData(node);
        if (data == null) {
            Node child;
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength() && (data = this.getBodyData(child = children.item(i))) == null; ++i) {
            }
        }
        return data;
    }

    private String getBodyData(Node child) {
        if (child.getNodeType() == 4 || child.getNodeType() == 3) {
            String data = ((CharacterData)child).getData();
            data = PropertyParser.parse(data, this.variables);
            return data;
        }
        return null;
    }
}

