/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.core.utils;

import java.util.List;
import org.apache.poi.xwpf.converter.core.utils.StringUtils;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFldChar;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBrType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STFldCharType;

public class XWPFRunHelper {
    private static final String PAGE = "page";
    private static final String NUMPAGES = "numpages";
    private static final String PAGE_AND_SPACE = "page ";
    private static final String HYPERLINK = "HYPERLINK";
    private static final String QUOTE = "\"";

    public static CTFldChar getFldChar(CTR r) {
        List fldChars = r.getFldCharList();
        if (fldChars == null || fldChars.size() < 1) {
            return null;
        }
        return (CTFldChar)fldChars.get(0);
    }

    public static STFldCharType.Enum getFldCharType(CTR r) {
        CTFldChar fldChar = XWPFRunHelper.getFldChar(r);
        if (fldChar == null) {
            return null;
        }
        return fldChar.getFldCharType();
    }

    public static String getInstrText(CTR r) {
        List instrTextList = r.getInstrTextList();
        if (instrTextList == null || instrTextList.size() < 1) {
            return null;
        }
        if (instrTextList.size() == 1) {
            return ((CTText)instrTextList.get(0)).getStringValue();
        }
        StringBuilder instrText = new StringBuilder();
        for (CTText ctText : instrTextList) {
            instrText.append(ctText.getStringValue());
        }
        return instrText.toString();
    }

    public static boolean isInstrTextPage(String instr) {
        if (StringUtils.isEmpty(instr)) {
            return false;
        }
        return (instr = instr.trim().toLowerCase()).equals(PAGE) || instr.startsWith(PAGE_AND_SPACE);
    }

    public static String getInstrTextHyperlink(String instr) {
        if (StringUtils.isEmpty(instr)) {
            return null;
        }
        if ((instr = instr.trim()).startsWith(HYPERLINK)) {
            instr = instr.substring(HYPERLINK.length(), instr.length());
            if ((instr = instr.trim()).startsWith(QUOTE)) {
                instr = instr.substring(1, instr.length());
            }
            if (instr.endsWith(QUOTE)) {
                instr = instr.substring(0, instr.length() - 1);
            }
            return instr;
        }
        return null;
    }

    public static STBrType.Enum getBrType(CTBr br) {
        STBrType.Enum brType;
        if (br != null && (brType = br.getType()) != null) {
            return brType;
        }
        return STBrType.TEXT_WRAPPING;
    }

    public static boolean isInstrTextNumpages(String instr) {
        if (StringUtils.isEmpty(instr)) {
            return false;
        }
        instr = instr.trim().toLowerCase();
        return instr.startsWith(NUMPAGES);
    }
}

