/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.core.styles;

import org.apache.poi.xwpf.converter.core.BorderSide;
import org.apache.poi.xwpf.converter.core.styles.TableInfo;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;

public class TableCellInfo {
    private final boolean firstRow;
    private final boolean lastRow;
    private final boolean firstCol;
    private final boolean lastCol;
    private final TableInfo tableInfo;

    public TableCellInfo(TableInfo tableInfo, boolean firstRow, boolean lastRow, boolean firstCol, boolean lastCol) {
        this.tableInfo = tableInfo;
        this.firstRow = firstRow;
        this.lastRow = lastRow;
        this.firstCol = firstCol;
        this.lastCol = lastCol;
    }

    public boolean isFirstRow() {
        return this.firstRow;
    }

    public boolean isLastRow() {
        return this.lastRow;
    }

    public boolean isFirstCol() {
        return this.firstCol;
    }

    public boolean isLastCol() {
        return this.lastCol;
    }

    public boolean canApplyFirstRow() {
        return this.isFirstRow() && this.tableInfo.canApplyFirstRow();
    }

    public boolean canApplyLastRow() {
        return this.isLastRow() && this.tableInfo.canApplyLastRow();
    }

    public boolean canApplyFirstCol() {
        return this.isFirstCol() && this.tableInfo.canApplyFirstCol();
    }

    public boolean canApplyLastCol() {
        return this.isLastCol() && this.tableInfo.canApplyLastCol();
    }

    public boolean isInside(BorderSide borderSide) {
        return this.isInside(this.firstRow, this.lastRow, this.firstCol, this.lastCol, borderSide);
    }

    private boolean isInside(boolean firstRow, boolean lastRow, boolean firstCol, boolean lastCol, BorderSide borderSide) {
        switch (borderSide) {
            case TOP: {
                return !firstRow;
            }
            case BOTTOM: {
                return !lastRow;
            }
            case LEFT: {
                return !firstCol;
            }
            case RIGHT: {
                return !lastCol;
            }
        }
        return false;
    }

    public void getTableCellBorder(XWPFTableCell cell, BorderSide borderSide) {
    }
}

