
$(function(){
	moduleJs();
});

$('[drag-carousel]').each(function(){
	carouseJs(this);
});


//遍历轮播图模块
function carouseJs(obj){
	var parameter = $(obj).attr('drag-carousel').split(',');
	var parameterLength = parameter.length;
	var carouselArray = {};
	for(i=0;i<parameterLength;i++){
		var nodeName = parameter[i].split(':')[0];
		var nodeContent = parameter[i].split(':')[1];
		if(nodeContent=='true'){
			nodeContent = true;
		}
		if(nodeName=='speed'||nodeName=='interval'){
			nodeContent = Number(nodeContent)
		}
		carouselArray[nodeName] = nodeContent
	}
	$(obj).carousel(carouselArray);

};

function moduleJs(){

	imgErrerHandle('.m-img','/sysimg/nopic_225_142.png');
	imgErrerHandle('.m-avatar','/sysimg/avatar.jpg');

	//课程图片比例
	$('.m-cos-img').aspectRatio({
		set:0.65
	});
	//新闻图片比例
	$('.m-news-img').aspectRatio({
		set:0.65
	});
	//教师头像比例
	$('.m-tc-img').aspectRatio({
		set:1
	});	
	
	//商品图片比例
	$('.m-shop-img').aspectRatio({
		set:1
	});	
	//品牌图片比例
	$('.m-brand-img').aspectRatio({
		set:0.25
	});	

	$('.m-cos-img,.m-tc-img,.m-news-img,.m-shop-img').each(function() {
		
		var $mImg = $(this).find('.m-img');
		var thisHeight = $(this).height();
		var imgHeight = $mImg.height();
		var result = (imgHeight-thisHeight)/2;
		if(result>0){
			$mImg.css({marginTop:'-'+result+'px'});
		};
	});

	$('.m-b-img-top').each(function() {
        $(this).css({top:'50%',marginTop:'-'+$(this).height()/2+'px'})
    });
		
};

function imgErrerHandle(target,url){

	$(target).each(function(){
		var that = this;
		var imgSrc = $(this).attr('src');
		
		//判断是否是字段链接，字段链接不处理
		if(imgSrc.substr(0,1)!='{'){
			var ImgObj = new Image(); //创建图片对象
		    ImgObj.src = imgSrc;
		    ImgObj.onerror = function(){
				that.src = url;			
		    }
		 
		};

	});
};


function headLoadJs(){
	
	if($('.m-header-concise').length!=0){
		$('.m-header-concise').on('click','.m-icon',function(e){
			var $menubox = $(this).siblings('.m-menu-box');
			var width = $menubox.width();
			$('body').animate({marginRight:width},300);
			if($menubox.find('.m-close').size()==0){
				$menubox.prepend('<div class="m-close"><i class="modulefont m-icon-close"></i></div><div class="clear"></div>');
			};
			$menubox.show();
			$menubox.animate({right:0},300);
			e.stopPropagation();
			$menubox.click(function(e){
				e.stopPropagation();
			});
			$(document).click(function(){
				closeMenu();
			});
			$menubox.on('click','.m-close',function(){
				closeMenu();
			});
			function closeMenu(){
				$menubox.stop().animate({right:'-'+width},300);
				setTimeout(function(){
					$menubox.fadeOut(300);
				},300);
				$('body').stop().animate({marginRight:'0'},300);
			};
			
		});
		$('.m-header-concise li').hover(function(){
			$(this).find('.nav-sub-box').slideDown(300);	
			$(this).find('.m-icon-down').css({transform:'rotate(-180deg)'});
		},function(){
			$(this).find('.nav-sub-box').stop().slideUp(300);	
			$(this).find('.m-icon-down').css({transform:''});
		});	
	};

	//购课车数量
	$('[drag-cart]').each(function(){
		var $that = $(this);
		$.ajax({
			url:'/plus/Course/GetcourseNum.aspx',
			success:function(num){
				var val = num.split('document.write(')[1].split("'")[1];
				if(val!='0'){
					$that.html('<i class="m-cartnum">'+val+'</i>')
				}else{
					$that.html('');
				};
			}
		});
	});

	//遍历登录模块
	$('[drag-user]').each(function(){
		var userType = $(this).attr('drag-user');
		var that = $(this);

		$.ajax({
			type: "get",
			dataType: "xml",
			url: "/plus/ajaxs.ashx?a=checkislogin",
			success: function (xml) {
				
				var islogin = $(xml).find("login islogin").text();
				if (islogin != 'false'){
					that.find('.m-avatar').attr('src','/UploadFiles/avatar/' + $(xml).find("login userid").text() + '.jpg');
					that.find('.m-username').html($(xml).find("login username").text());
					if($(xml).find("login message").text()!='0'){
						that.find('.m-username').append('<i></i>');
						if(that.find('.m-message-num').length==0){
							that.find('.m-ismessage').append('<i class="m-message-num">'+$(xml).find("login message").text()+'</i>')
						}
					}
					that.find('.m-islogin0').hide().siblings('.m-islogin1').show();

				}else{
					that.find('.m-islogin0').show().siblings('.m-islogin1').hide();
				};

				imgErrerHandle('.m-avatar','/sysimg/avatar.jpg');

			}
		});

		
	});

};
headLoadJs();

//搜索
var searchDefaultUrl = ''; //默认搜索链接

//打开搜索
function openSearchBox(target){
	$(target).next().slideToggle(200);
	var e = event || window.event;
	e.stopPropagation();
	$(target).next().click(function(e){
		var e = event || window.event;
		e.stopPropagation();
	});
	$(document).click(function(){
		$(target).next().slideUp(200);
	});
};
//打开搜索下拉项
function openSearchSelect(obj){
	if($(obj).attr('class').indexOf('search-selected-click')==-1){
		$(obj).addClass('search-selected-click');
		$(obj).next().show();
	}else{
		$(obj).removeClass('search-selected-click');
		$(obj).next().hide();
	};

	var e = event || window.event;
	e.stopPropagation();
};


function selectSearchType(obj,url){
	var text = $(obj).text();
	$('.search-selected').find('span').html(text);
	searchDefaultUrl = url; //改变url
};

function doSearch(url){
	if(window.name=='dragmain'){
		return false;
	};
	var searchUrl = url;
	if(searchDefaultUrl!=''){
		searchUrl = searchDefaultUrl;
	};
	var key = $.trim($("#search-key-text").val());
	if (key == '' || key == '请输入关键字...') {
		$('#search-key-text').val('').focus();
	}else{
		if (searchUrl.indexOf("?")==-1){
			  searchUrl += "?key-"+key;

			}else{
			  searchUrl += "&key="+key;
		}
		location.href = searchUrl;
	};
};


