﻿<%@ Control Language="C#" %>
<%@ Import Namespace="Kesion.Cache" %>
<%@ Import Namespace="Kesion.Publics" %>
<%@ Import Namespace="Kesion.BLL" %>
<%@ Import Namespace="Kesion.Config" %>
<%@ Import Namespace="Kesion.Components" %>
<%@ Import Namespace="Kesion.HtmlTags" %>
<%@ Import Namespace="System.Data" %>
<script runat="server" type="text/C#">
    dynamic __user = HttpContext.Current.Items["user"];                //初始化用户信息，
    private static dynamic __info = new System.Dynamic.ExpandoObject();   //初始化当前页信息
    bool isLoadPage = true;  //定义页面是否加载

    private string action = string.Empty;
    private int Id = 0;
    protected void Page_Load(object sender, EventArgs e)
    {
        action = KSCMS.S("action");
        if (string.IsNullOrEmpty(action))
        {
            action = BasicField.GetParam("do");
        }
        Id = Utils.StrToInt(BasicField.GetParam("id"));
        if (Id == 0)
        {
            Id = Utils.StrToInt(KSCMS.S("id"));
        }

        action = action.ToLower();
        switch (action)
        {
            case "addpages":
            case "modify":
                #region 修改
                Modify();
                break;
            #endregion
            case "dosave":
                DoSave();
                return;
            case "status":
                var v = Utils.StrToInt(BasicField.GetParam("v"));
                if (v > 0)
                    v = 0;
                else
                    v = 1;
                DataFactory.ExecuteNonQuery("Update KS_BlogNav Set flag=" +v + " where id=" + Id + " and userid=" + __user.UserID);
                Msg.Alert("恭喜，修改成功!", KSCMS.GetComeUrl());
                isLoadPage = false;
                return;
            case "del":
                if (!ChkUserGroupsPower())
                {
                    Msg.Alert("你所在的用户组无权限此操作！", KSCMS.GetComeUrl());
                    isLoadPage = false;
                    return;
                }

                Hashtable ht = new Hashtable();
                ht.Add("ID", Id);
                ht.Add("userid", __user.UserID);

                if (CommonData.Delete("KS_BlogNav", ht))
                {
                    Msg.Alert("删除成功！",BasicField.GetUserSpaceUrl("space/BlogNav"));
                }
                else
                {
                     Msg.AlertDoFun("删除失败！", BasicField.GetUserSpaceUrl("space/BlogNav"));
                }
                break;
            default:
                Initial();
                break;
        }



    }
    private void Initial()
    {
        __info.NavName = "";
        __info.NavAlias = "";
        __info.OrderID = CommonData.GetMaxIdAddOne("KS_BlogNav","navorderid","where userid="+__user.UserID);
        __info.Descript = "";
        __info.Flag =true;
        __info.CustomPage = "";
        __info.OwnSys = "0";
    }
    private void Modify()
    {
        if (!ChkUserGroupsPower())
        {
            Msg.AlertDoFun("你所在的用户组无权限此操作！", "location.href='" + BasicField.GetUserSpaceUrl("space/BlogNav") + "';");
            isLoadPage = false;
            return;
        }
        if (Id > 0)
        {
            using (DataTable dt = DataFactory.GetDataTable("select top 1 * from KS_BlogNav where UserID="+__user.UserID+" and ID=" + Id))
            {
                if (dt.Rows.Count > 0)
                {
                    DataRow dr = dt.Rows[0];
                    __info.NavName = dr["NavName"].ToString();
                    __info.NavAlias = dr["NavAlias"].ToString();
                    __info.OrderID = dr["NavOrderId"].ToString();
                    __info.Descript = dr["Marks"].ToString();
                    __info.Flag = dr["Flag"].ToString() == "1" ? true : false;
                    __info.CustomPage = dr["CustomPage"].ToString();
                    __info.OwnSys = dr["OwnSys"].ToString();

                }
                else
                {
                    Msg.Alert("error",KSCMS.GetComeUrl());
                    isLoadPage = false;
                    return;
                }
            }
        } else
        {
            Initial();
        }
    }
    /// <summary>
    /// 保存
    /// </summary>
    private void DoSave()
    {
        if (!ChkUserGroupsPower())
        {
            Msg.AlertDoFun("你所在的用户组无权限此操作！", "location.href='" + BasicField.GetUserSpaceUrl("space/BlogNav") + "';");
            isLoadPage = false;
            return;
        }
        string navName = Utils.RemoveXss(KSCMS.S("NavName"));
        string navAlias = Utils.RemoveXss(KSCMS.S("NavAlias"));
        string descript = Utils.RemoveXss(KSCMS.S("Descript"));
        int orderID = Utils.StrToInt(KSCMS.S("OrderID"));
        if (navName == "")
        {
            Msg.Alert("名称不能为空");
            return;
        }
        if (navAlias == "" || !Regex.IsMatch(navAlias, @"[a-zA-z]", RegexOptions.IgnoreCase))
        {
            Msg.Alert("别名不能为空，且只能为字母！");
            return;
        }


        Hashtable ht = new Hashtable();

        ht.Add("NavName", navName);
        ht.Add("NavAlias", navAlias);
        ht.Add("NavOrderId", orderID);

        ht.Add("Marks", descript);
        ht.Add("Flag", Utils.StrToInt(KSCMS.S("flag")));
        ht.Add("CustomPage", KSCMS.S("CustomPage"));


        if (Id > 0)
        {
            if (CommonData.Update("KS_BlogNav", ht, "where ID = " + Id + ";"))
            {
                Msg.Alert("恭喜，修改成功!", BasicField.GetUserSpaceUrl("space/BlogNav"));
                return;
            }
            else
            {
                Msg.Alert("修改失败!");
                return;
            }
        }
        else
        {
            ht.Add("UserId", __user.UserID);
            ht.Add("UserName", __user.UserName);
            ht.Add("OwnSys", 0);
            if (DataFactory.Exists("KS_BlogNav", "NavAlias='" + Utils.ChkSQL(navAlias) + "' and OwnSys != 1 and UserID=" + __user.UserID))
            {
                string op = "album archive ask blog corpus footer header index left photo message";
                if (!op.Contains(navAlias))
                {
                    Msg.Alert("自定义别名不能重复!", KSCMS.GetComeUrl());
                    return;
                }

            }

            if (CommonData.Insert("KS_BlogNav", ht))
            {
                Msg.Confirm("是否继续添加？", "top.location.href='" + BasicField.GetUserSpaceUrl("space/BlogNav", "do-addpages") + "';", "top.location.href='" + BasicField.GetUserSpaceUrl("space/BlogNav") + "';");
                return;
            }
            else
            {
                Msg.Alert("添加失败!", BasicField.GetUserSpaceUrl("space/BlogNav"));
                return;
            }
        }

    }


    private bool ChkUserGroupsPower()
    {

        BlogConfigInfo __configinfo = BlogConfigManage.Deserialize(Server.MapPath("~/config/plus/plus.space/Blog.config"));
        bool isPower = true;
        if (!string.IsNullOrEmpty(__configinfo.BlogCustomPageUserGroups))
        {
            isPower = Utils.InArray(UserManage.GetUserInfo().GroupID.ToString(), __configinfo.BlogCustomPageUserGroups, ",", true);
        }
        return isPower;


    }

</script>

<%
    if (!isLoadPage) return;
%>

<div class="r_tybox nomar">
<div class="r_title"><h4>空间导航管理</h4></div>
    <div class="tabs">	
			<ul>
				<li><a href="<%=BasicField.GetUserSpaceUrl("space/blogedit") %>">空间参数设置</a></li>
				<li class='puton'><a href="<%=BasicField.GetUserSpaceUrl("space/BlogNav") %>">空间导航管理</a></li>
				<li><a href="/plus/SetSpaceTemplate.aspx" target="_blank">空间模板绑定</a></li>
			</ul>
    </div>
	<div class="r_padbox">
   
       <% if (string.IsNullOrEmpty(action))
           { %>
       <div class="clear"></div>
       <div class="padnav">
           <span><a href="<%=BasicField.GetUserSpaceUrl("space/BlogNav", "do-addPages") %>">添加一页面</a></span>

        </div>

        <table class="border" cellspacing="0" align="Center" border="0" id="ctl00_KSContent_List" style="width:100%;border-collapse:collapse;">
				<tr class="title">
					<th scope="col"  style="width:50px;">编号</th>
                    <th align="left" scope="col">名称</th>
                    <th align="left" scope="col">别名</th>
                    <th align="center" scope="col">排序</th>
                    <th scope="col">必须</th>
                    <th scope="col">启用</th>
                    <th scope="col">↓管理操作</th>
				</tr>
        <%
            int recordcount, pagecount;
            int CurrPage = new BasicField().GetCurrPage;
            int PageSize = 10;
            Kesion.HtmlTags.CommonFunc.InitBlogNav(UserManage.GetUserInfo().UserID, (new TemporaryVar()).UserName);


            using (DataTable dt = DataFactory.GetPage("*", "KS_BlogNav where UserID =" + __user.UserID, "ID", "order by NavOrderId desc,id", CurrPage, PageSize, out recordcount, out pagecount))
            {
                if (dt.Rows.Count > 0)
                {
                    foreach (DataRow dr in dt.Rows)
                    {
                        KSCMS.W(string.Format(@"<tr class=""tdbg""><td class=""splittd"" align=""center"">{0}</td>", dr["id"].ToString()));
                        KSCMS.W(string.Format(@"<td class=""splittd"">{0}</td>", dr["NavName"].ToString()));
                        KSCMS.W(string.Format(@"<td class=""splittd"">{0}</td>", dr["NavAlias"].ToString()));
                        KSCMS.W(string.Format(@"<td class=""splittd"">{0}</td>", dr["NavOrderId"].ToString()));
                        KSCMS.W(string.Format(@"<td class=""splittd"">{0}</td>", dr["OwnSys"].ToString() == "0" ? "否" : "<span style='color:red'>是</span>"));
                        KSCMS.W(string.Format(@"<td class=""splittd"">{0}</td>", dr["flag"].ToString() == "0" ? "否" : "<span style='color:red'>是</span>"));

                        KSCMS.W(@"<td class=""splittd"" style=""text-align:center"">");
                        KSCMS.W("<a href='" + BasicField.GetUserSpaceUrl("space/BlogNav", "do-modify,id-" + dr["id"].ToString()) + "'>修改</a>");
                        KSCMS.W(" <a href='" + BasicField.GetUserSpaceUrl("space/BlogNav", "do-status,id-" + dr["id"].ToString()+",v-"+dr["flag"].ToString()) + "'>状态</a>");
                        if (dr["OwnSys"].ToString() == "0")
                        {
                        KSCMS.W(@" <a onclick=""return(confirm('确认删除吗？'))"" href='" + BasicField.GetUserSpaceUrl("space/BlogNav", "do-del,id-" + dr["id"].ToString()) + "'>删除</a>");
                        }else
                        {

                        }
                        KSCMS.W("</td>");

                        KSCMS.W("</tr>");
                    }
                }

            }

        %>
        </table>
        <%
            #region 分页
            string PageStr = "[KS:PageStr3]";
            BasicField.ReplaceFilterPage(ref PageStr, CurrPage, PageSize, pagecount, recordcount);
            KSCMS.W(PageStr);
            #endregion
         %>

    	</div>    
    
    
    <%} else if (action == "modify" || action=="addpages")
        {%>
    
     <% Kesion.APPCode.EditorAPI.EchoHead();%>
      <iframe src="about:blank" style="display:none;width:0px;height:0px" name="hidiframe"></iframe>
      <form name="myform" action="{$GetCurrUrl}" method="post" id="myform" target="hidiframe">
       <input type="hidden" name="action" value="dosave"/>
          <script type="text/javascript">
                                reg = /[a-zA-z]/;
                                function CheckForm1() {
                                if (jQuery("#NavName").val() == '') {
                                    KesionJS.Alert('请输入导航显示名称!', 'jQuery("#NavName").focus()');
	                            return false
                                }
                                if (jQuery("#NavAlias").val() == '' || !reg.test(jQuery("#NavAlias").val())) {
                                    KesionJS.Alert('请输入导航别名，且只能为字母！', 'jQuery("#NavAlias").focus()');
                                    return false
                                }
                                if (!is_number(jQuery("#OrderID").val()) || jQuery("#OrderID").val() == '') {
                                    KesionJS.Alert('序号请填写有数数字！', 'jQuery("#OrderID").focus()');
                                    return false;
                                }

                                return true;
                            }

                            </script>
        <table  cellspacing="1" cellpadding="3" class="border" width="100%" align="center" border="0">
                          <tr class="tdbg">
                            <td  class="lefttd">名称：</td>
                            <td style="text-align:left">
                                <input type="text" name="NavName" id="NavName" class="textbox" value="<%=__info.NavName %>"/>
                                <span class="tips">导航显示名称。</span><span style="color: red">*</span></td>
                          </tr>
              
                            <tr class="tdbg">
                            <td  class="lefttd">别名：</td>
                            <td style="text-align:left"> <input type="text" name="NavAlias" id="NavAlias"<%if (action.Equals("modify")) Response.Write(" readonly"); %> class="textbox" value="<%=__info.NavAlias%>"/><span class="tips">别名（英文）。</span><span style="color: red">*</span></td>
                          </tr>
                          <tr class="tdbg">
                            <td class="lefttd">序号：</td>
                            <td style="text-align:left"><input type="text" name="OrderID" id="OrderID" class="textbox" value="<%=__info.OrderID %>"/><span class="tips">导航序号(越大越靠前)</span>
                            <span style="color: red">* 
                                </span></td>
                          </tr>
                          <tr class="tdbg">
                            <td class="lefttd">导航描述（先填）：</td>
                            <td style="text-align:left"><textarea  class="textbox" id="Descript" name="Descript" style="width:500px; height:100px;"><%=__info.Descript %></textarea><span style="color: red">* 
                                  </span></td>
                          </tr>

            <tr class="tdbg"<%=__info.OwnSys=="1"?" style='display:none'":"" %>>
            <td class="lefttd">页面内容：</td>
            <td style="text-align:left">
                <textarea id="CustomPage" name="CustomPage" style="height:300px;width:95%"><%=__info.CustomPage %></textarea>
                 <%
                     Kesion.APPCode.EditorAPI.EchoEditor("editor", "CustomPage", "Basic", 0, false, true, true, false);    
             %>
               </td>
            </tr>

                        <tr class="tdbg">
                            <td class="lefttd">是否启用：</td>
                            <td style="text-align:left">
                                <input type="checkbox" id="Flag" name="Flag" value="1"<%=__info.Flag==true?" checked":string.Empty %> />
                            </td>
                          </tr>
                          
						<tr class="tdbg">
                            <td class="lefttd" style="border-bottom:0px;" height="40">&nbsp;</td>
                            <td style="text-align:left;border-bottom:0px;">
                                
                                <div class="cz_btn">
                                	<span><input type="submit" onclick="return(CheckForm1());" ID="Button1" Class="button" value="OK!确定保存" /></span>
                              		<span><input type="button" onclick="location.href='<%=BasicField.GetUserSpaceUrl("space/BlogNav")%>'" class="button" value=" 返 回 " /></span>
                                </div>
                            </td>
                        </tr>

            </table>
     </form>
    <%} %>
     


 </div>   