﻿<!doctype html>
<html>
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
  <meta name="renderer" content="webkit"> 
  <title>增加/修改静态模块标签</title>
  <link type="text/css" rel="Stylesheet" href="/admin/drag/css/drag.base.css">
  <link type="text/css" rel="Stylesheet" href="/admin/drag/css/kesion.form.css">
  <link type="text/css" rel="Stylesheet" href="/admin/drag/css/label.css">
  <link type="text/css" rel="Stylesheet" href="/admin/drag/fonts/iconfont.css">  

</head>
<body style="overflow:hidden;">

   	
    <div class="ks-tab">
    	<ul>
        	<li class="active"><span>新增标签</span></li>
        	<li onClick="selectLabel()"><span>选择现有标签</span></li>
        </ul>
    </div>

    <div id="Content">
    	<div class="tab-box">
        
        	  <div class="tab-inner" style="overflow:hidden; padding-right:20px;">	 
              <table width="100%" cellpadding="0" cellspacing="0" class="ks-table">
                <tr>
                    <td class="ks-td-tit">标签名称</td>
                    <td>
                        <input name="labelname" id="labelname" type="text" class="ks-text">
                    </td>
                </tr>
    
                <tr id="tr-format">
                    <td class="ks-td-tit">选择样式</td>
                    <td style="padding-bottom:10px;">
                    	<div style="width: 580px">
                      <div class="format-carousel" id="carousel">
                          <ul>
                              
                          </ul>
                      </div>
                      </div>
                    </td>
                </tr>
                <tr>
                    <td class="ks-td-tit">颜色配置</td>
                    <td>
                        <div class="set-color" id="setColor">
                            <ul>
                                <li data-color="white" class="white active"><i class="drag-font drag-i-yes"></i></li>
                                <li data-color="black" class="black"><i class="drag-font drag-i-yes"></i></li>
                                <li data-color="mingBlue" class="mingBlue"><i class="drag-font drag-i-yes"></i></li>
                                <li data-color="ultramarine" class="ultramarine"><i class="drag-font drag-i-yes"></i></li>
                                <li data-color="blue" class="blue"><i class="drag-font drag-i-yes"></i></li>
                                <li data-color="red" class="red"><i class="drag-font drag-i-yes"></i></li>
                                <li data-color="green" class="green"><i class="drag-font drag-i-yes"></i></li>
                                <li data-color="orange" class="orange"><i class="drag-font drag-i-yes"></i></li>
                            </ul>
                        </div>
                    </td>
                </tr>
                 
             </table>
             <div class="clear blank20"></div>
    		</div>
            <div class="ks-btn-center" style="border-top:1px solid #ebebeb; padding:20px 0;">
              <button class="ks-btn ks-btn-normal" onClick="page.Determine()" id="btn-set">确定</button>
              &nbsp;
              <button class="ks-btn" onClick="page.Cancel()">取消</button>
            
            </div>
            
        </div>
        <div class="tab-box d-none">
        	<div class="label-box">
                <div class="label-sc-box"><input name="" type="text" class="ks-text" id="labelSearch" placeholder="快速搜索标签" ></div>
                <ul>
                    <li class="li-head"><span>更新时间</span>标签名称</li>
                </ul>
            </div>
            
            <div class="ks-btn-center" style="border-top:1px solid #ebebeb; padding:20px 0;">
              <button class="ks-btn ks-btn-normal" onClick="Determine()" id="btn-save">确定</button>
              &nbsp;
              <button class="ks-btn" onClick="parent.closeWindow(window.name)">取消</button>
            
            </div>
           
        </div>
	</div>

	
   <script src="/admin/drag/js/utils.js"></script>
   <script>utils.loadJs(['jquery','assembly','nicescroll'])</script>
   
	<script>
		
		var urlParameter = utils.getUrlParameter();
		var $carousel = $('#carousel');
		var $setColor = $('#setColor');
		var page = new utils.page({
			type:urlParameter.type,     //获取类型 编辑|添加
			labelContentArray:[],
			ready:function(){
				this.tabHeight();
				var module = urlParameter.module; //获取模块名称			
				var that = this;
				//获取标签信息
				$.ajax({
					url:'../label/'+module+'.aspx',
					success:function(labelList){
						
						var labelArray = $(labelList);
						
						var labelSlide = '';
						for(var i in labelArray){
							if(labelArray[i].nodeName=='LABEL'){

								//将获取的版式内容存入数组
								that.labelContentArray.push(labelArray[i].innerHTML);
								
								var src;
								var id;
								//获取版式图片以及ID
								for(var a in labelArray[i].attributes){
									if(labelArray[i].attributes[a].nodeName=='src'){
										src = labelArray[i].attributes[a].nodeValue;
									}else if(labelArray[i].attributes[a].nodeName=='id'){
										id = labelArray[i].attributes[a].nodeValue;
									}
									
								};
								labelSlide += '<li data-id="'+id+'"><div class="li-content"><div class="check"><i class="drag-font drag-i-yes"></i></div><img src="'+src+'" /></div></li>';
							};
						};

						$carousel.find('ul').html(labelSlide);
						$carousel.find('li:first').addClass('active');

						//设置版式轮播
						$carousel.carousel({
							object:'li',
							scrollType:'slide',
							width:'100%',
							height:'22%',
							arrow:true,
							autoPlay:false,
							dots:1,
							speed:400,
							interval:3000
					    });
						$carousel.find('.carousel-prev').append('<i class="drag-font drag-i-left"></i>');
						$carousel.find('.carousel-next').append('<i class="drag-font drag-i-right"></i>');

						$carousel.on('click','li',function(){
							$(this).addClass('active').siblings().removeClass('active');

						});

					}
				});

				$setColor.on('click','li',function(){
					$(this).addClass('active').siblings().removeClass('active');
					if(that.type=='edit'){
						var activeColor = $(this).attr('data-color');
						parent.staticLabel.Edit(activeColor,urlParameter.module);
					};
				});

				if(this.type=='edit'){

					var moduleColor = urlParameter.moduleColor; //获取模块颜色
					var labelName = urlParameter.labelName;     //获取标签名称
					_id('btn-set').value = '编辑';
					$('#labelname').attr('disabled',true);

					$('#tr-format').remove();

					if(moduleColor){
						$setColor.find('li').each(function() {
							var thisColor = $(this).attr('data-color');
							if(thisColor==moduleColor){
								$(this).addClass('active').siblings().removeClass('active');
							};
						});
					};
					
					if(labelName){
						$('#labelname').val(decodeURI(labelName));
					};

				};	

			},
			tabHeight:function(){
				$('.tab-inner,.label-box').height($(window).height()-$('.ks-tab').outerHeight()-$('.ks-btn-center').outerHeight());
				$(".tab-inner").niceScroll({  
					cursorcolor:"rgba(0,0,0,0.3)",  
					cursoropacitymax:1,  
					touchbehavior:false,  
					cursorwidth:"7px",  
					cursorborder:"0", 
					cursorborderradius:"10px"  
				});
			},
			Determine:function(){
				
				//点击确定返回结果
				//获取选中版式id
				var formatId = $carousel.find('.active').attr('data-id');
				//获取选中颜色
				var color = $setColor.find('.active').attr('data-color');

				//得到内容并替换颜色
				var result = this.labelContentArray[formatId].replace('{{color}}',color); 

				var labelName = $.trim($("#labelname").val());
					labelName = escape(labelName);

				if(this.type=='edit'){

					parent.staticLabel.Save(labelName,window.name)

				}else if(this.type=='add'){

					//生成该标签并保存
					$.post("/plus/AjaxLabel.aspx", { labelname: labelName, labelcontent: result, action: "savelabel", skinid: parent.skinId },function (data) {

						if(data == 'success') {
							parent.popup.tips({
								  title:'保存成功',
							});
							
							labelname = unescape(labelName);
							
							parent.staticLabel.Add(result,labelName,window.name,urlParameter.module);//返回结果
							
						}else {
							parent.popup.tips({
								title:data,
							});
						};

					}, "text");
				}

			},
			Cancel:function(){
				
				//取消编辑||创建
				if(this.type=='edit'){
					parent.staticLabel.Edit(urlParameter.moduleColor,urlParameter.module);
				};
				parent.closePopup(window.name);

			}
		});
   		

		$('.ks-tab').on('click','li',function(){
			$(this).addClass('active').siblings().removeClass('active');
			$('.tab-box').eq($(this).index()).fadeIn(300).siblings('.tab-box').hide();	
		});


		//选择现有标签

		var skinId = parent.skinId;
		$('.label-box').on('click','li:not(".li-head")',function(){
			$(this).addClass('active').siblings().removeClass('active');			
		});
		
		$('#labelSearch').keyup(function(){
			var key = $(this).val();
			$.ajax({
					url:"/plus/ajaxlabel.aspx?action=labellist&labelflag=100&skinid="+skinId+"&key="+key+"",
					success:function(data){
						$('.label-box').find('li:not(".li-head"),.empty').remove();
						if(data==''){
							$('.label-box').find('ul').append('<p class="empty">没有找到标签数据</p>');
						}else{
							$('.label-box').find('ul').append(data);
						};
					}
			});
		});
		
		//现有标签请求
		var labelFlag = true;
		function selectLabel(){
			$.ajax({
					url:"/plus/ajaxlabel.aspx?action=labellist&labelflag=100&skinid="+skinId+"",
					success:function(data){
						if(labelFlag==true){
							$('.label-box').find('ul').append(data);
							if(data==''){
								$('.label-box').find('ul').append('<p class="empty">没有找到标签数据</p>');
							};
							labelFlag = false;
							
						};
					}
			});
					
		};

		//选择已有标签 - 确定		
		function Determine(){
			var labelName = $('.label-box').find('.active').attr('data-value');
			if(!labelName){
				parent.popup.tips({
					title:'请先选择标签'
				})
			}else{
				parent.staticLabel.Insert(labelName,window.name,urlParameter.module);
			};
		};

    </script>


</body>
</html>