﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Kesion.Publics;
using Kesion.BLL;
using Kesion.Cache;
using System.Xml;
using System.Text;

namespace Kesion.NET.WebSite.Admin.drag
{
    public partial class Index : System.Web.UI.Page
    {

        public int skinID = 0;
        public string templateDir = string.Empty;
        public string tempalteFileName = string.Empty;
        public string tempaltePath = string.Empty;
        private string configPath = "/config/drag/";
        public string tpType = "home";   //模板类型
        public StringBuilder xmlMenu = null;
        protected void Page_Load(object sender, EventArgs e)
        {
            KSSecurity.CheckPermissions();
            SiteKey.CheckSiteKey("drag");

            skinID = Utils.StrToInt(KSCMS.S("skinId"));
            templateDir = MyCache.GetAutoTemplateDir();

            if (!string.IsNullOrEmpty(KSCMS.S("TemplateType")))                       //初始化模板,如有传SkinID.将获取当前模板ID下的标签
            {
                templateDir = MyCache.GetTemplateDir(Utils.StrToInt(KSCMS.S("TemplateType")));
            }
            else
            {
                templateDir = MyCache.GetTemplateDir(0);
            }

            if (skinID == 0) skinID = MyCache.GetTemplateID(0);

            int pageID = Utils.StrToInt(KSCMS.S("pageid"));//id代替模板名称，防止模板名称重复
            string xmlPath = configPath + "template.xml";
            XmlDocument xmlDoc = new XmlDocument();
            xmlDoc.Load(Server.MapPath(xmlPath));
            if (xmlDoc != null)
            {

                tempalteFileName = xmlDoc.SelectSingleNode("template/module/file[@pageid=" + pageID + "]").InnerText.ToString();
            }
            if (string.IsNullOrEmpty(tempalteFileName)) tempalteFileName = "网站首页.html";

            tempaltePath = Utils.RemoveXss(KSCMS.S("templatepath")) + tempalteFileName;
            tpType = Utils.RemoveXss(KSCMS.S("tptype"));
            if (string.IsNullOrEmpty(tpType)) tpType = "home";
            LoadTemplateXML();

        }

        /// <summary>
        ///  加载可编辑的模板XML 
        /// </summary>
        private void LoadTemplateXML()
        {
            #region 加载可编辑的模板XML
            string xmlPath = configPath + "template.xml";
            XmlDocument xmlDoc = new XmlDocument();
            xmlDoc.Load(Server.MapPath(xmlPath));
            if (xmlDoc == null)
            {
                KSCMS.Die("load template xml error!");
            }
            xmlMenu = new StringBuilder();
            XmlNodeList xl = xmlDoc.SelectNodes("//template/module");
            foreach (XmlNode xn in xl)
            {
                xmlMenu.AppendLine("<li>");
                xmlMenu.AppendLine(string.Format(@"<div class=""folder-name""><i class=""drag-font drag-i-wenjianjia""></i>" + xn.SelectSingleNode("@name").InnerText + "</div>"));
                if (xn.ChildNodes.Count > 0)
                {
                    xmlMenu.AppendLine("<div class='folder-box'>");
                    foreach (XmlNode xnl in xn.ChildNodes)
                    {
                        string templateFile = string.Empty;
                        if (xn.Attributes["filepath"] != null) templateFile = "&templatepath=" + Server.UrlEncode(xn.Attributes["filepath"].InnerText) + "/";

                        xmlMenu.AppendLine(@"<a " + (tempalteFileName == xnl.InnerText ? "" : "") + @" href = ""?skinid=" + skinID + templateFile + "&pageid=" + xnl.SelectSingleNode("@pageid").InnerText + "&tptype=" + xnl.SelectSingleNode("@tptype").InnerText + @"""><i class=""drag-font drag-i-wenjian""></i>" + xnl.InnerText + "</a>");
                    }
                    xmlMenu.AppendLine("</div></li>");
                }
            }
            #endregion

        }

    }
}