;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;-| Default Values |-------------------------------------------------------
[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.
command.time = 15

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.
command.buffer.time = 1


;-| Super Motions |--------------------------------------------------------
[Command]
Name = "SUPER"
Command = $D, DF, F, D, DF, F, x
time = 36
[Command]
Name = "SUPER"
Command = $D, DF, F, D, DF, F, y
time = 36
[Command]
Name = "SUPER"
Command = $D, DF, F, D, DF, F, z
time = 36

;-| Special Motions |------------------------------------------------------
; Dash Punch Strait
[Command]
name = "dpunch_x"
command = ~D, DB, B, x
[Command]
name = "dpunch_y"
command = ~D, DB, B, y
[Command]
name = "dpunch_z"
command = ~D, DB, B, z
[Command]
name = "dpunch_x"
command = ~D, DB, B, ~x
[Command]
name = "dpunch_y"
command = ~D, DB, B, ~y
[Command]
name = "dpunch_z"
command = ~D, DB, B, ~z

; Dash Punch Upper
[Command]
name = "dpunch_a"
command = ~D, DB, B, a
[Command]
name = "dpunch_b"
command = ~D, DB, B, b
[Command]
name = "dpunch_c"
command = ~D, DB, B, c
[Command]
name = "dpunch_a"
command = ~D, DB, B, ~a
[Command]
name = "dpunch_b"
command = ~D, DB, B, ~b
[Command]
name = "dpunch_c"
command = ~D, DB, B, ~c

; Turn Punch
[Command]
name = "turnpunch_x"
command = ~D, DF, F, x
[Command]
name = "turnpunch_y"
command = ~D, DF, F, y
[Command]
name = "turnpunch_z"
command = ~D, DF, F, z
[Command]
name = "turnpunch_x"
command = ~D, DF, F, ~x
[Command]
name = "turnpunch_y"
command = ~D, DF, F, ~y
[Command]
name = "turnpunch_z"
command = ~D, DF, F, ~z

; Electric Shock
[Command]
name = "shock_x"
command = x, x, x, x
time = 25
[Command]
name = "shock_y"
command = y, y, y, y
time = 25
[Command]
name = "shock_z"
command = z, z, z, z
time = 25

; Charge Punch
[Command]
name = "charge_x"
command = ~50$B, F, x
[Command]
name = "charge_y"
command = ~50$B, F, y
[Command]
name = "charge_z"
command = ~50$B, F, z
[Command]
name = "charge_x"
command = ~50$B, F, ~x
[Command]
name = "charge_y"
command = ~50$B, F, ~y
[Command]
name = "charge_z"
command = ~50$B, F, ~z

; Charge Kick
[Command]
name = "charge_a"
command = ~50$B, F, a
[Command]
name = "charge_b"
command = ~50$B, F, b
[Command]
name = "charge_c"
command = ~50$B, F, c
[Command]
name = "charge_a"
command = ~50$B, F, ~a
[Command]
name = "charge_b"
command = ~50$B, F, ~b
[Command]
name = "charge_c"
command = ~50$B, F, ~c


;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery" ;Required (do not remove)
command = x+y
time = 1

[Command]
name = "recovery"
command = y+z
time = 1

[Command]
name = "recovery"
command = x+z
time = 1

[Command]
name = "recovery"
command = a+b
time = 1

[Command]
name = "recovery"
command = b+c
time = 1

[Command]
name = "recovery"
command = a+c
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "back_x"
command = /$B,x
time = 1

[Command]
name = "back_y"
command = /$B,y
time = 1

[Command]
name = "back_z"
command = /$B,z
time = 1

[Command]
name = "down_x"
command = /$D,x
time = 1

[Command]
name = "down_y"
command = /$D,y
time = 1

[Command]
name = "down_z"
command = /$D,z
time = 1

[Command]
name = "fwd_x"
command = /$F,x
time = 1

[Command]
name = "fwd_y"
command = /$F,y
time = 1

[Command]
name = "fwd_z"
command = /$F,z
time = 1

[Command]
name = "up_x"
command = /$U,x
time = 1

[Command]
name = "up_y"
command = /$U,y
time = 1

[Command]
name = "up_z"
command = /$U,z
time = 1

[Command]
name = "back_a"
command = /$B,a
time = 1

[Command]
name = "back_b"
command = /$B,b
time = 1

[Command]
name = "back_c"
command = /$B,c
time = 1

[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

[Command]
name = "down_c"
command = /$D,c
time = 1

[Command]
name = "fwd_a"
command = /$F,a
time = 1

[Command]
name = "fwd_b"
command = /$F,b
time = 1

[Command]
name = "fwd_c"
command = /$F,c
time = 1

[Command]
name = "up_a"
command = /$U,a
time = 1

[Command]
name = "up_b"
command = /$U,b
time = 1

[Command]
name = "up_c"
command = /$U,c
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "start"
command = s
time = 1

;-| Single Dir |------------------------------------------------------------
[Command]
name = "fwd" ;Required (do not remove)
command = $F
time = 1

[Command]
name = "downfwd"
command = $DF
time = 1

[Command]
name = "down" ;Required (do not remove)
command = $D
time = 1

[Command]
name = "downback"
command = $DB
time = 1

[Command]
name = "back" ;Required (do not remove)
command = $B
time = 1

[Command]
name = "upback"
command = $UB
time = 1

[Command]
name = "up" ;Required (do not remove)
command = $U
time = 1

[Command]
name = "upfwd"
command = $UF
time = 1

;-| Hold Button |--------------------------------------------------------------
[Command]
name = "hold_x"
command = /x
time = 1

[Command]
name = "hold_y"
command = /y
time = 1

[Command]
name = "hold_z"
command = /z
time = 1

[Command]
name = "hold_a"
command = /a
time = 1

[Command]
name = "hold_b"
command = /b
time = 1

[Command]
name = "hold_c"
command = /c
time = 1

[Command]
name = "hold_s"
command = /s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd" ;Required (do not remove)
command = /$F
time = 1

[Command]
name = "holddownfwd"
command = /$DF
time = 1

[Command]
name = "holddown" ;Required (do not remove)
command = /$D
time = 1

[Command]
name = "holddownback"
command = /$DB
time = 1

[Command]
name = "holdback" ;Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdupback"
command = /$UB
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holdupfwd"
command = /$UF
time = 1

;---------------------------------------------------------------------------
; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;--------------------
[State -1, VarAdd]
type = VarAdd
trigger1 = AILevel <= 0
trigger1 = Command = "start"
ignorehitpause = 1
v = 51
value = 1

[State -1, VarSet]
type = VarSet
trigger1 = Var(51) > 1
trigger2 = AILevel > 0
ignorehitpause = 1
v = 51
value = 0
;--------------------
[State -1]
Type = ChangeState
Value = 3000
Triggerall = Command = "SUPER"
Triggerall = Power >= 1000
Trigger1 = StateType != A
Trigger1 = Ctrl
Trigger2 = Stateno = 200 && Movehit
Trigger3 = Stateno = 210 && Movehit
Trigger4 = Stateno = 300 && Movehit
Trigger5 = Stateno = 310 && Movehit

;===========================================================================
;---------------------------------------------------------------------------
; Special Moves
;---------------------------------------------------------------------------
; Turn Punch
[State -1, State]
type = ChangeState
value = 1000
triggerall = Var(51) <= 0
triggerall = command = "turnpunch_x" || command = "turnpunch_y" || command = "turnpunch_z"
trigger1 = statetype != A
trigger1 = ctrl

;---------------------------------------------------------------------------
; Dash Punch
[State -1, State]
type = ChangeState
value = 1100
triggerall = Var(51) <= 0
triggerall = command = "dpunch_x" || command = "dpunch_y" || command = "dpunch_z" || command = "dpunch_a" || command = "dpunch_b" || command = "dpunch_c"
trigger1 = statetype != A
trigger1 = ctrl

;---------------------------------------------------------------------------
; Electric Shock
[State -1, State]
type = ChangeState
value = 2000
triggerall = Var(51) > 0
triggerall = command = "shock_x" || command = "shock_y" || command = "shock_z"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = StateNo >= 200
trigger2 = StateNo < 500
trigger2 = StateTime > 0

;---------------------------------------------------------------------------
; Rolling Attack
[State -1, State]
type = ChangeState
value = 2100
triggerall = Var(51) > 0
triggerall = command = "charge_x" || command = "charge_y" || command = "charge_z"
trigger1 = statetype != A
trigger1 = ctrl

;---------------------------------------------------------------------------

;===========================================================================
;---------------------------------------------------------------------------
; Basic Moves
;---------------------------------------------------------------------------
; Stand Light Punch
[State -1, State]
type = ChangeState
value = 200
triggerall = command = "x" || Var(50) > 0 && command = "a"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

; Stand Medium Punch
[State -1, State]
type = ChangeState
value = 220
triggerall = command = "y" || Var(50) > 0 && command = "b"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

; Stand Strong Punch
[State -1, State]
type = ChangeState
value = 210
triggerall = command = "z" || Var(50) > 0 && command = "c"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
; Stand Light Punch
[State -1, State]
type = ChangeState
value = 230
triggerall = Var(50) <= 0
triggerall = command = "a"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

; Stand Medium Punch
[State -1, State]
type = ChangeState
value = 240
triggerall = Var(50) <= 0
triggerall = command = "b"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

; Stand Strong Punch
[State -1, State]
type = ChangeState
value = 250
triggerall = Var(50) <= 0
triggerall = command = "c"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
; Crouch Punch
[State -1, State]
type = ChangeState
value = 400
triggerall = command = "x" || command = "a"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

; Crouch Medium Punch
[State -1, State]
type = ChangeState
value = 410
triggerall = command = "y" || command = "b"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

; Crouch Strong Punch
[State -1, State]
type = ChangeState
value = 420
triggerall = command = "z" || command = "c"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

;---------------------------------------------------------------------------
; Jump Light Punch
[State -1, State]
type = ChangeState
value = 600
triggerall = command = "x" || command = "a"
trigger1 = statetype = A
trigger1 = ctrl

; Jump Medium Punch
[State -1, State]
type = ChangeState
value = 610
triggerall = command = "y" || command = "b"
trigger1 = statetype = A
trigger1 = ctrl

; Jump Strong Punch
[State -1, State]
type = ChangeState
value = 620
triggerall = command = "z" || command = "c"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------

;===========================================================================
;---------------------------------------------------------------------------
; AI System
;---------------------------------------------------------------------------
; Random AI
[State -1, Random]
type = VarRandom
trigger1 = Ctrl
trigger1 = AILevel > 0
trigger1 = RoundState = 2
ignorehitpause = 1
v = 30
range = 0,100

[State -1, VarSet]
type = VarSet
trigger1 = AILevel <= 0
trigger2 = RoundState != 2
ignorehitpause = 1
v = 30
value = 0

;--------------------
; Crouch Light Punch
[State -1, State]
type = ChangeState
value = 400
triggerall = Ctrl
triggerall = AILevel > 0
triggerall = MoveType = I
triggerall = StateType != A
triggerall = StateNo < 120
triggerall = EnemyNear, StateType != L
trigger1 = Var(30) = 30
trigger2 = P2BodyDist X <= 60
trigger2 = P2StateNo >= 200
trigger2 = P2StateNo < 300
trigger2 = Var(30) > 0
trigger2 = Var(30) < 50

;--------------------
; Turn Punch
[State -1, State]
type = ChangeState
value = 1000
triggerall = Ctrl
triggerall = AILevel > 0
triggerall = MoveType = I
triggerall = StateType != A
triggerall = StateNo < 120
triggerall = P2BodyDist X <= 60
triggerall = EnemyNear, StateType != L
trigger1 = Var(30) = 10

;--------------------
; Dash Punch
[State -1, State]
type = ChangeState
value = 1100
triggerall = Ctrl
triggerall = AILevel > 0
triggerall = MoveType = I
triggerall = StateType != A
triggerall = StateNo < 120
triggerall = EnemyNear, StateType != L
trigger1 = Var(30) >= 90
trigger1 = Var(30) <= 100

;--------------------
; Stand Guard
[State -1, Guard]
type = ChangeState
value = 130
triggerall = Ctrl
triggerall = AILevel > 0
triggerall = StateNo < 160
triggerall = StateType != A
trigger1 = EnemyNear, StateType = A
trigger1 = EnemyNear, MoveType = A
trigger1 = P2Dist X <= 100

; Crouch Guard
[State -1, Guard]
type = ChangeState
value = 131
triggerall = Ctrl
triggerall = AILevel > 0
triggerall = StateNo < 160
triggerall = StateType != A
trigger1 = EnemyNear, StateType = C
trigger1 = EnemyNear, MoveType = A
trigger1 = P2Dist X <= 100
;--------------------

;---------------------------------------------------------------------------
