;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;-| Default Values |-------------------------------------------------------
[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.
command.time = 15

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.
command.buffer.time = 1

;-| Super Motions |--------------------------------------------------------
[Command]
Name = "SUPER"
Command = $D, DF, F, D, DF, F, x
time = 36
[Command]
Name = "SUPER"
Command = $D, DF, F, D, DF, F, y
time = 36
[Command]
Name = "SUPER"
Command = $D, DF, F, D, DF, F, z
time = 36

;-| Special Motions |------------------------------------------------------

; Rolling Claw
[Command]
name = "roll_x"
command = $D, DF, F, x
[Command]
name = "roll_y"
command = $D, DF, F, y
[Command]
name = "roll_z"
command = $D, DF, F, z
[Command]
name = "roll_x"
command = $D, DF, F, ~x
[Command]
name = "roll_y"
command = $D, DF, F, ~y
[Command]
name = "roll_z"
command = $D, DF, F, ~z

; Wall Cling Thrust
[Command]
name = "climb_a"
command = $D, DB, B, a
[Command]
name = "climb_b"
command = $D, DB, B, b
[Command]
name = "climb_c"
command = $D, DB, B, c
[Command]
name = "climb_a"
command = $D, DB, B, ~a
[Command]
name = "climb_b"
command = $D, DB, B, ~b
[Command]
name = "climb_c"
command = $D, DB, B, ~c

;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery" ;Required (do not remove)
command = x+y
time = 1

[Command]
name = "recovery"
command = y+z
time = 1

[Command]
name = "recovery"
command = x+z
time = 1

[Command]
name = "recovery"
command = a+b
time = 1

[Command]
name = "recovery"
command = b+c
time = 1

[Command]
name = "recovery"
command = a+c
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "back_x"
command = /$B,x
time = 1

[Command]
name = "back_y"
command = /$B,y
time = 1

[Command]
name = "back_z"
command = /$B,z
time = 1

[Command]
name = "down_x"
command = /$D,x
time = 1

[Command]
name = "down_y"
command = /$D,y
time = 1

[Command]
name = "down_z"
command = /$D,z
time = 1

[Command]
name = "fwd_x"
command = /$F,x
time = 1

[Command]
name = "fwd_y"
command = /$F,y
time = 1

[Command]
name = "fwd_z"
command = /$F,z
time = 1

[Command]
name = "up_x"
command = /$U,x
time = 1

[Command]
name = "up_y"
command = /$U,y
time = 1

[Command]
name = "up_z"
command = /$U,z
time = 1

[Command]
name = "back_a"
command = /$B,a
time = 1

[Command]
name = "back_b"
command = /$B,b
time = 1

[Command]
name = "back_c"
command = /$B,c
time = 1

[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

[Command]
name = "down_c"
command = /$D,c
time = 1

[Command]
name = "fwd_a"
command = /$F,a
time = 1

[Command]
name = "fwd_b"
command = /$F,b
time = 1

[Command]
name = "fwd_c"
command = /$F,c
time = 1

[Command]
name = "up_a"
command = /$U,a
time = 1

[Command]
name = "up_b"
command = /$U,b
time = 1

[Command]
name = "up_c"
command = /$U,c
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "start"
command = s
time = 1

;-| Single Dir |------------------------------------------------------------
[Command]
name = "fwd" ;Required (do not remove)
command = $F
time = 1

[Command]
name = "downfwd"
command = $DF
time = 1

[Command]
name = "down" ;Required (do not remove)
command = $D
time = 1

[Command]
name = "downback"
command = $DB
time = 1

[Command]
name = "back" ;Required (do not remove)
command = $B
time = 1

[Command]
name = "upback"
command = $UB
time = 1

[Command]
name = "up" ;Required (do not remove)
command = $U
time = 1

[Command]
name = "upfwd"
command = $UF
time = 1

;-| Hold Button |--------------------------------------------------------------
[Command]
name = "hold_x"
command = /x
time = 1

[Command]
name = "hold_y"
command = /y
time = 1

[Command]
name = "hold_z"
command = /z
time = 1

[Command]
name = "hold_a"
command = /a
time = 1

[Command]
name = "hold_b"
command = /b
time = 1

[Command]
name = "hold_c"
command = /c
time = 1

[Command]
name = "hold_s"
command = /s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd" ;Required (do not remove)
command = /$F
time = 1

[Command]
name = "holddownfwd"
command = /$DF
time = 1

[Command]
name = "holddown" ;Required (do not remove)
command = /$D
time = 1

[Command]
name = "holddownback"
command = /$DB
time = 1

[Command]
name = "holdback" ;Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdupback"
command = /$UB
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holdupfwd"
command = /$UF
time = 1

;---------------------------------------------------------------------------
; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]
[State -1]
Type = ChangeState
Value = 3000
Triggerall = Command = "SUPER"
Triggerall = Power >= 1000
Trigger1 = StateType != A
Trigger1 = Ctrl
Trigger2 = Stateno = 200 && Movehit
Trigger3 = Stateno = 210 && Movehit
Trigger4 = Stateno = 300 && Movehit
Trigger5 = Stateno = 310 && Movehit

;--------------------
[State -1, VarAdd]
type = VarAdd
trigger1 = AILevel <= 0
trigger1 = Command = "start"
;trigger1 = Var(50) <= 0
ignorehitpause = 1
v = 51
value = 1

[State -1, VarSet]
type = VarSet
trigger1 = Var(51) > 1
trigger2 = AILevel > 0
;trigger3 = Var(50) > 0
ignorehitpause = 1
v = 51
value = 0
;--------------------

;===========================================================================
;---------------------------------------------------------------------------
; Special Moves
;---------------------------------------------------------------------------
; Wall Cling Thrust
[State -1, State]
type = ChangeState
value = 1100
triggerall = Var(51) <= 0
triggerall = AILevel <= 0
triggerall = command = "climb_a" || command = "climb_b" || command = "climb_c"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = stateno = 40

;---------------------------------------------------------------------------
; Rolling Claw
[State -1, State]
type = ChangeState
value = 1000
triggerall = Var(51) <= 0
triggerall = AILevel <= 0
triggerall = command = "roll_x" || command = "roll_y" || command = "roll_z"
trigger1 = statetype != A
trigger1 = ctrl

;---------------------------------------------------------------------------
; Backflip
[State -1, State]
type = ChangeState
value = 900
triggerall = Var(51) <= 0
triggerall = AILevel <= 0
triggerall = command = "BB"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
; Fireball
[State -1, State]
type = ChangeState
value = 2000
triggerall = Var(51) > 0
triggerall = AILevel <= 0
triggerall = NumHelper(2010) <= 0
triggerall = command = "roll_x" || command = "roll_y" || command = "roll_z"
trigger1 = statetype != A
trigger1 = ctrl

;---------------------------------------------------------------------------
; Jump Upper
[State -1, State]
type = ChangeState
value = 2100
triggerall = Var(51) > 0
triggerall = AILevel <= 0
triggerall = command = "climb_a" || command = "climb_b" || command = "climb_c"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = stateno = 40

;===========================================================================
;---------------------------------------------------------------------------
; Throw
[State -1, State]
type = ChangeState
value = 800
triggerall = AILevel <= 0
triggerall = command = "y" || command = "z" || command = "b" || command = "c"
triggerall = statetype = S 
triggerall = ctrl
triggerall = stateno != 100
trigger1 = command = "holdfwd"
trigger1 = p2bodydist X <= 20
trigger1 = (p2statetype = S) || (p2statetype = C)
trigger1 = p2movetype != H || p2stateno = 5300
trigger2 = command = "holdback"
trigger2 = p2bodydist X <= 20
trigger2 = (p2statetype = S) || (p2statetype = C)
trigger2 = p2movetype != H || p2stateno = 5300

;===========================================================================
;---------------------------------------------------------------------------
; Basic Moves
;---------------------------------------------------------------------------
; Stand Light Punch
[State -1, State]
type = ChangeState
value = 200
triggerall = AILevel <= 0
triggerall = command = "x" || command = "a"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = Var(50) > 0
trigger2 = stateno = 200
trigger2 = time >= 5

; Stand Medium Punch
[State -1, State]
type = ChangeState
value = 210
triggerall = AILevel <= 0
triggerall = command = "y" || command = "b"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

; Stand Strong Punch
[State -1, State]
type = ChangeState
value = 220
triggerall = AILevel <= 0
triggerall = command = "z" || command = "c"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
; Crouch Punch
[State -1, State]
type = ChangeState
value = 400
triggerall = AILevel <= 0
triggerall = command = "x" || command = "y" || command = "z"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

; Crouch Kick
[State -1, State]
type = ChangeState
value = 430
triggerall = AILevel <= 0
triggerall = command = "a"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

; Crouch Slide Kick
[State -1, State]
type = ChangeState
value = 440
triggerall = AILevel <= 0
triggerall = command = "b" || command = "c"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

;---------------------------------------------------------------------------
; Jump Kick
[State -1, State]
type = ChangeState
value = 630
triggerall = AILevel <= 0
triggerall = command = "x" || command = "y" || command = "z"
trigger1 = statetype = A
trigger1 = ctrl

; Jump Kick
[State -1, State]
type = ChangeState
value = 630
triggerall = AILevel <= 0
triggerall = command = "a" || command = "b" || command = "c"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------
; Wall Jump
[State -1]
type = ChangeState
value = 60
triggerall = ctrl || StateNo >= 600 && StateNo < 700 && Time > 10
triggerall = Var(51) <= 0
triggerall = statetype = A
triggerall = stateno < 5000
triggerall = command = "holdup"
trigger1 = command = "holdfwd"
trigger1 = BackEdgeBodyDist <= 0
trigger2 = command = "holdback"
trigger2 = FrontEdgeBodyDist <= 0

;---------------------------------------------------------------------------

;===========================================================================
;---------------------------------------------------------------------------
; AI System
;---------------------------------------------------------------------------
; Random AI
[State -1, Random]
type = VarRandom
trigger1 = Ctrl
trigger1 = AILevel > 0
trigger1 = RoundState = 2
ignorehitpause = 1
v = 30
range = 0,100

[State -1, VarSet]
type = VarSet
trigger1 = AILevel <= 0
trigger2 = RoundState != 2
ignorehitpause = 1
v = 30
value = 0

;--------------------
; Walk & Throw
[State -1, State]
type = ChangeState
value = 25
triggerall = Ctrl
triggerall = AILevel > 0
triggerall = MoveType = I
triggerall = StateType != A
triggerall = P2Dist X <= 100
triggerall = EnemyNear, StateType != L
triggerall = StateNo < 25
trigger1 = Var(30) > 80
trigger1 = Var(30) < 90
;--------------------

;--------------------
; Wall Jump
[State -1]
type = ChangeState
value = 60
triggerall = AILevel > 0
triggerall = Var(30) > 0
triggerall = ctrl || StateNo >= 600 && StateNo < 700 && Time > 10
triggerall = Var(51) <= 0
triggerall = statetype = A
triggerall = stateno < 5000
trigger1 = BackEdgeBodyDist <= 0
trigger1 = Vel X <= 0
trigger1 = Vel Y > 0
trigger2 = FrontEdgeBodyDist <= 0
trigger2 = Vel X >= 0
trigger2 = Vel Y > 0

;--------------------
; Stand Light Punch
[State -1, State]
type = ChangeState
value = 200
triggerall = Ctrl
triggerall = AILevel > 0
triggerall = MoveType = I
triggerall = StateType != A
triggerall = StateNo < 120
triggerall = P2Dist X <= 150
triggerall = EnemyNear, StateType != L
trigger1 = Var(30) = 5

; Stand Medium Punch
[State -1, State]
type = ChangeState
value = 210
triggerall = Ctrl
triggerall = AILevel > 0
triggerall = MoveType = I
triggerall = StateType != A
triggerall = StateNo < 120
triggerall = P2Dist X <= 150
triggerall = EnemyNear, StateType != L
trigger1 = Var(30) = 10

; Stand Strong Punch
[State -1, State]
type = ChangeState
value = 220
triggerall = Ctrl
triggerall = AILevel > 0
triggerall = MoveType = I
triggerall = StateType != A
triggerall = StateNo < 120
triggerall = P2Dist X <= 150
triggerall = EnemyNear, StateType != L
trigger1 = Var(30) = 15

;--------------------
; Crouch Punch
[State -1, State]
type = ChangeState
value = 400
triggerall = Ctrl
triggerall = AILevel > 0
triggerall = StateType = C
triggerall = MoveType = I
triggerall = StateType != A
triggerall = P2Dist X <= 150
triggerall = EnemyNear, StateType != L
trigger1 = Var(30) > 10
trigger1 = Var(30) < 20

;--------------------
; Crouch Kick
[State -1, State]
type = ChangeState
value = 430
triggerall = Ctrl
triggerall = AILevel > 0
triggerall = MoveType = I
triggerall = StateType != A
triggerall = StateNo < 120
triggerall = P2Dist X <= 100
triggerall = EnemyNear, StateType != L
trigger1 = Var(30) = 11
trigger2 = P2StateNo >= 200
trigger2 = P2StateNo < 300
trigger2 = Var(30) > 0
trigger2 = Var(30) < 50

; Crouch Slide
[State -1, State]
type = ChangeState
value = 440
triggerall = Ctrl
triggerall = AILevel > 0
triggerall = MoveType = I
triggerall = StateType != A
triggerall = StateNo < 120
triggerall = P2Dist X <= 100
triggerall = EnemyNear, StateType != L
trigger1 = Var(30) = 10
trigger2 = P2StateNo >= 200
trigger2 = P2StateNo < 300
trigger2 = Var(30) >= 50
trigger2 = Var(30) < 100
;--------------------

;--------------------
; Jump Kick
[State -1, State]
type = ChangeState
value = 630
triggerall = Ctrl
triggerall = AILevel > 0
triggerall = MoveType = I
triggerall = StateType = A
triggerall = P2Dist X <= 150
triggerall = EnemyNear, StateType != L
trigger1 = StateNo < 120
trigger1 = Var(30) > 20
trigger1 = Var(30) < 30
trigger2 = EnemyNear, MoveType = A
trigger2 = Var(30) > 25
trigger2 = Var(30) < 30

;--------------------
; Backflip
[State -1, State]
type = ChangeState
value = 900
triggerall = AILevel > 0
triggerall = statetype != A
triggerall = P2Dist X <= 200
trigger1 = EnemyNear, StateType = A
trigger1 = EnemyNear, MoveType = A
trigger1 = Ctrl
trigger2 = StateNo = 990
trigger2 = EnemyNear, MoveType = A

;--------------------
; CPU Begin Attack
[State -1, State]
type = ChangeState
value = 990
triggerall = Ctrl
triggerall = AILevel > 0
triggerall = MoveType = I
triggerall = StateType = S
triggerall = StateNo < 120
triggerall = P2Dist X > 150
triggerall = EnemyNear, StateType != L
trigger1 = Var(30) >= 20
trigger1 = Var(30) < 30

;--------------------
; Wall Cling Thrust
[State -1, State]
type = ChangeState
value = 1100
triggerall = Ctrl
triggerall = AILevel > 0
triggerall = MoveType = I
triggerall = StateType != A
triggerall = StateNo < 120
triggerall = P2Dist X > 150
triggerall = EnemyNear, StateType != L
trigger1 = Var(30) >= 50
trigger1 = Var(30) < 55

;--------------------
; Crouch Guard
[State -1, Guard]
type = ChangeState
value = 131
triggerall = Ctrl
triggerall = AILevel > 0
triggerall = StateNo < 160
triggerall = RoundState = 2
triggerall = StateType != A
triggerall = P2Dist X <= 100
trigger1 = EnemyNear, MoveType = A
trigger1 = EnemyNear, HitDefAttr = C, AA, AP

; Stand Guard
[State -1, Guard]
type = ChangeState
value = 130
triggerall = Ctrl
triggerall = AILevel > 0
triggerall = StateNo < 160
triggerall = RoundState = 2
triggerall = StateType != A
triggerall = P2Dist X <= 100
trigger1 = P2StateType = A
trigger1 = EnemyNear, MoveType != H
trigger2 = EnemyNear, MoveType = A
trigger2 = EnemyNear, HitDefAttr = S, AA, AP
trigger3 = P2StateNo >= 1000
trigger3 = P2StateNo < 3000
trigger3 = P2MoveType != H
trigger3 = P2MoveType = A

;---------------------------------------------------------------------------
