in vec3 vertex_position_in;
in vec3 vertex_normal_in;

out vec3 vertex_world_position_out;
out vec4 vertex_position_out;
out vec4 vertex_position_prev_out;

uniform mat4 mat_view_proj;
uniform mat4 mat_view_proj_prev;
uniform mat4 mat_world;

uniform mat4 mat_world_to_weather_camera;

uniform sampler2D texture_depth;

bool is_position_occluded(vec4 world_position)
{
	vec4 camera_coord = (mat_world_to_weather_camera * world_position);
	camera_coord /= camera_coord.w;
	camera_coord = camera_coord * 0.5 + 0.5;

	float depth = texture(texture_depth, camera_coord.xy).r;

	return depth < camera_coord.z;
}

void main()
{
	vertex_world_position_out = (mat_world * vec4(vertex_position_in, 1.0)).xyz;

	vertex_position_out = mat_view_proj * vec4(vertex_world_position_out, 1.0);
	vertex_position_prev_out = mat_view_proj_prev * vec4(vertex_world_position_out, 1.0);

	gl_Position = vertex_position_out;

	vec4 particle_position = mat_world * vec4(vertex_normal_in, 1.0);
	bool is_rain_occluded = is_position_occluded(particle_position);

	if(is_rain_occluded)
	{
		gl_Position.y = -1000.0;
	}
}
