in vec3 vertex_position_in;
in vec3 vertex_normal_in;

out vec3 vertex_normal_out;
out vec4 vertex_position_out;
out vec4 vertex_position_prev_out;

uniform mat4 mat_view_proj;
uniform mat4 mat_view_proj_prev;
uniform mat4 mat_world;
uniform mat4 mat_vp_orig; // Unjittered view-proj (so jitter is not counted as camera motion)

void main()
{
	vertex_normal_out = vertex_normal_in;

	vec3 world_pos = (mat_world * vec4(vertex_position_in, 1.0)).xyz;

	vertex_position_out = mat_vp_orig * vec4(world_pos, 1.0);
	vertex_position_prev_out = mat_view_proj_prev * vec4(world_pos, 1.0);

	gl_Position = mat_view_proj * vec4(world_pos, 1);
}
