in vec3 vertex_position_in;
in vec2 vertex_coord0_in;
in vec3 vertex_normal_in;

out vec2 vertex_coord0_out;
out vec3 vertex_normal_out;
out vec3 vertex_world_position_out;
out vec4 vertex_position_out;
out vec4 vertex_position_prev_out;

uniform mat4 mat_view_proj;
uniform mat4 mat_world;
uniform mat4 mat_view_proj_prev;
uniform mat4 mat_world_prev;

void main()
{
	vertex_coord0_out = vertex_coord0_in;
	vertex_normal_out = (mat_world * vec4(vertex_normal_in, 0.0)).xyz;

	vec4 world_pos = mat_world * vec4(vertex_position_in, 1.0);
	vertex_world_position_out = world_pos.xyz;

	vertex_position_out = mat_view_proj * world_pos;
	vertex_position_prev_out = mat_view_proj_prev * (mat_world_prev * vec4(vertex_position_in, 1.0));

	gl_Position = vertex_position_out;
}
