in vec4 screen_pos_out;

out vec4 color_out;

// uniform sampler2D gnormal;
uniform sampler2D gdepth;
uniform sampler2D gcolor;

uniform mat4 mat_view_proj_inverse;

uniform mat4 light_transform_inverse;
uniform vec3 light_bounding_min;
uniform vec3 light_bounding_max;
uniform vec3 light_color;

vec3 world_pos_from_depth(vec2 coords, float depth)
{
	vec4 view_position = vec4(coords, depth, 1.0);

	// transform into [-1, 1] range, and unproject
	view_position = mat_view_proj_inverse * ((view_position * 2.0) - 1.0);

	// scale so w == 1
	view_position /= view_position.w;

	return view_position.xyz;
}

bool is_point_inside_light_volume(vec3 point)
{
	// Convert point to be shape-relative
	point = (light_transform_inverse * vec4(point, 1)).xyz;

	if(light_bounding_min.x <= point.x && light_bounding_max.x >= point.x &&
		light_bounding_min.y <= point.y && light_bounding_max.y >= point.y &&
		light_bounding_min.z <= point.z && light_bounding_max.z >= point.z)
	{
		return true;
	}
	else
	{
		return false;
	}
}

void main()
{
    vec2 tex_coord = (screen_pos_out.xy / screen_pos_out.w) * 0.5 + 0.5;

    vec3 surface_color = vec3(0.0);

    float depth = texture(gdepth, tex_coord).r;
    vec3 position = world_pos_from_depth(tex_coord, depth);

	if(is_point_inside_light_volume(position))
	{
	    // vec4 normal_light_factor = texture(gnormal, tex_coord);
	    // vec3 normal = normal_light_factor.xyz;
	    // float light_factor = normal_light_factor.w;
		vec3 diffuse_color = texture(gcolor, tex_coord).rgb;

		surface_color += light_color * diffuse_color;
	}

    color_out = vec4(surface_color, 1.0);
}
