in vec3 world_position_out;

out vec4 color_out;

uniform float clip_height;
uniform vec3 camera_pos;
uniform mat4 mat_view_proj_frag;

void main()
{
	if(world_position_out.y > clip_height)
	{
		discard;
	}

	vec3 eye_to_fragment_dir = normalize(world_position_out - camera_pos);
	float eye_to_clip_surface_distance = clip_height - camera_pos.y;
	vec3 clip_surface_pos = camera_pos + (eye_to_fragment_dir * (eye_to_clip_surface_distance / eye_to_fragment_dir.y));

	vec4 projected_position = mat_view_proj_frag * vec4(clip_surface_pos, 1.0);
	float ndc_depth = projected_position.z / projected_position.w;
	float camera_far = gl_DepthRange.far;
	float camera_near = gl_DepthRange.near;
	float depth = (((camera_far - camera_near) * ndc_depth) + camera_near + camera_far) / 2.0;
	gl_FragDepth = depth;
	color_out = vec4(depth);
}