in vec3 vertex_position_in;

out vec3 vertex_world_position_out;
out vec4 vertex_position_out;
out vec4 vertex_position_prev_out;

uniform mat4 mat_view_proj;
uniform mat4 mat_vp_orig; // Unjittered view-proj (so jitter is not counted as camera motion)
uniform mat4 mat_world;
uniform mat4 mat_view_proj_prev;
uniform mat4 mat_world_prev;
uniform vec3 main_light_color;

void main()
{
	vec4 world_pos = mat_world * vec4(vertex_position_in, 1.0);
	vertex_world_position_out = world_pos.xyz;

	vertex_position_out = mat_vp_orig * world_pos;
	vertex_position_prev_out = mat_view_proj_prev * (mat_world_prev * vec4(vertex_position_in, 1.0));

	gl_Position = mat_view_proj * world_pos;
}
