in vec3 vertex_position_in;
in vec3 vertex_color_in;
in vec3 vertex_normal_in;
in vec4 vertex_bone_weights_in;

out vec3 vertex_color_out;

uniform mat4 mat_view_proj;
uniform mat4 mat_vp_orig;
uniform mat4 mat_world;
uniform vec4 override_color;
uniform int is_preview;
uniform int is_override_color;
uniform mat4 bone_matrices[32];
uniform mat4 bone_matrices_prev[32];

void main()
{
	vec4 skinned_pos;
	vec4 skinned_pos_last_frame;
	vec4 skinned_normal;
	int bone_index;

	bone_index = int(vertex_bone_weights_in.x + 0.1);
	skinned_pos = (bone_matrices[bone_index] * vec4(vertex_position_in, 1)) * vertex_bone_weights_in.z;
	skinned_pos_last_frame = (bone_matrices_prev[bone_index] * vec4(vertex_position_in, 1)) * vertex_bone_weights_in.z;
	skinned_normal = (bone_matrices[bone_index] * vec4(vertex_normal_in, 0.0)) * vertex_bone_weights_in.z;

	bone_index = int(vertex_bone_weights_in.y + 0.1);
	skinned_pos = (bone_matrices[bone_index] * vec4(vertex_position_in, 1)) * vertex_bone_weights_in.w + skinned_pos;
	skinned_pos_last_frame = (bone_matrices_prev[bone_index] * vec4(vertex_position_in, 1)) * vertex_bone_weights_in.w + skinned_pos_last_frame;
	skinned_normal = (bone_matrices[bone_index] * vec4(vertex_normal_in, 0.0)) * vertex_bone_weights_in.w + skinned_normal;

	vec3 override_color_difference = vertex_color_in - vec3(1.0, 0.494, 0.0);
	vec3 preview_color_difference = vertex_color_in - vec3(1.0, 1.0, 1.0);
	if(dot(override_color_difference, override_color_difference) < 0.01 || ( is_preview == 1 && dot(preview_color_difference, preview_color_difference) < 0.01 ))
	{
		vertex_color_out = override_color.rgb;
	}
	else if(is_override_color == 1)
	{
		vertex_color_out = override_color.rgb;
	}
	else
	{
		vertex_color_out = vertex_color_in;
	}

	vec4 world_pos = mat_world * vec4(skinned_pos.xyz, 1.0);

	gl_Position = mat_view_proj * world_pos;
}
