/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding.policy;

import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.model.SEIModel;
import com.sun.xml.internal.ws.encoding.policy.EncodingConstants;
import com.sun.xml.internal.ws.policy.AssertionSet;
import com.sun.xml.internal.ws.policy.Policy;
import com.sun.xml.internal.ws.policy.PolicyAssertion;
import com.sun.xml.internal.ws.policy.PolicyException;
import com.sun.xml.internal.ws.policy.PolicyMap;
import com.sun.xml.internal.ws.policy.PolicySubject;
import com.sun.xml.internal.ws.policy.jaxws.spi.PolicyMapConfigurator;
import com.sun.xml.internal.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.internal.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.internal.ws.policy.subject.WsdlBindingSubject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.ws.soap.MTOMFeature;

public class MtomPolicyMapConfigurator
implements PolicyMapConfigurator {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(MtomPolicyMapConfigurator.class);

    @Override
    public Collection<PolicySubject> update(PolicyMap policyMap, SEIModel sEIModel, WSBinding wSBinding) throws PolicyException {
        LOGGER.entering(policyMap, sEIModel, wSBinding);
        ArrayList<PolicySubject> arrayList = new ArrayList<PolicySubject>();
        if (policyMap != null) {
            MTOMFeature mTOMFeature = wSBinding.getFeature(MTOMFeature.class);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("mtomFeature = " + mTOMFeature);
            }
            if (mTOMFeature != null && mTOMFeature.isEnabled()) {
                QName qName = sEIModel.getBoundPortTypeName();
                WsdlBindingSubject wsdlBindingSubject = WsdlBindingSubject.createBindingSubject(qName);
                Policy policy = this.createMtomPolicy(qName);
                PolicySubject policySubject = new PolicySubject((Object)wsdlBindingSubject, policy);
                arrayList.add(policySubject);
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.fine("Added MTOM policy with ID \"" + policy.getIdOrName() + "\" to binding element \"" + qName + "\"");
                }
            }
        }
        LOGGER.exiting(arrayList);
        return arrayList;
    }

    private Policy createMtomPolicy(QName qName) {
        ArrayList<AssertionSet> arrayList = new ArrayList<AssertionSet>(1);
        ArrayList<MtomAssertion> arrayList2 = new ArrayList<MtomAssertion>(1);
        arrayList2.add(new MtomAssertion());
        arrayList.add(AssertionSet.createAssertionSet(arrayList2));
        return Policy.createPolicy(null, qName.getLocalPart() + "_MTOM_Policy", arrayList);
    }

    static class MtomAssertion
    extends PolicyAssertion {
        private static final AssertionData mtomData = AssertionData.createAssertionData(EncodingConstants.OPTIMIZED_MIME_SERIALIZATION_ASSERTION);

        MtomAssertion() {
            super(mtomData, null, null);
        }

        static {
            mtomData.setOptionalAttribute(true);
        }
    }
}

